unit module Transit::Network::i8n:ver<0.0.3>;

my %i8n;

my @lang = <EN NO>;
my $lang = 'EN';

%i8n<NO> =
{
  "Cannot use undefined route"         => "Kan ikke bruke udefinert rute",
  "Cannot append"                      => "Kan ikke legge til",
  "direction"                          => "retning", 
  "Enter «exit» to exit"               => "Skriv «exit» for å avslutte",
  "File does not have the mandatory extension" => "Filen har ikke den obligatoriske endelsen",
  "not possible"                       => "ikke mulig",
  "Number of vehicles"                 => "Antall vognløp", 
  "Route"                              => "Rute",
  "The specified route does not exist" => "Angitt rute finnes ikke",
  "Total number of vehicles"           => "Totalt antall vognløp", 
  "Unable to read the file"            => "Kan ikke lese fra filen",
  "Unknown command"                    => "Ukjent kommando",
  "Unkown route"                       => "Ukjent rute",
  "Unsupported language"               => "Språket søttes ikke",
  "Use one of"                         => "Velg en av",
  "Wrong first row. Should be"         => "Feil første rad. Skulle ha vært",
};

our sub translate ($text) is export
{
  return %i8n{$lang}.{$text} if %i8n{$lang} && %i8n{$lang}.{$text};
  return $text;
}

our sub set-lang ($new-lang) is export
{
  $new-lang eq any(@lang)
    ?? ( $lang = $new-lang )
    !! say "{ translate("Unsupported language") } $new-lang. { translate("Use one of") }: { @lang.join(",") }.";
}

our sub get-lang is export
{
  return $lang // 'EN';
}
