package Shipment::Purolator::WSDLV2::Types::DutyInformation;
$Shipment::Purolator::WSDLV2::Types::DutyInformation::VERSION = '3.06';
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns {'http://purolator.com/pws/datatypes/v2'}

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{    # BLOCK to scope variables

    my %BillDutiesToParty_of : ATTR(:get<BillDutiesToParty>);
    my %BusinessRelationship_of : ATTR(:get<BusinessRelationship>);
    my %Currency_of : ATTR(:get<Currency>);

    __PACKAGE__->_factory(
        [   qw(        BillDutiesToParty
              BusinessRelationship
              Currency

            )
        ],
        {   'BillDutiesToParty'    => \%BillDutiesToParty_of,
            'BusinessRelationship' => \%BusinessRelationship_of,
            'Currency'             => \%Currency_of,
        },
        {   'BillDutiesToParty' =>
              'Shipment::Purolator::WSDLV2::Types::BillDutiesToParty',
            'BusinessRelationship' =>
              'Shipment::Purolator::WSDLV2::Types::BusinessRelationship',
            'Currency' => 'Shipment::Purolator::WSDLV2::Types::DutyCurrency',
        },
        {

            'BillDutiesToParty'    => 'BillDutiesToParty',
            'BusinessRelationship' => 'BusinessRelationship',
            'Currency'             => 'Currency',
        }
    );

}    # end BLOCK


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Shipment::Purolator::WSDLV2::Types::DutyInformation

=head1 VERSION

version 3.06

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
DutyInformation from the namespace http://purolator.com/pws/datatypes/v2.

DutyInformation

=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * BillDutiesToParty (min/maxOccurs: 1/1)

=item * BusinessRelationship (min/maxOccurs: 1/1)

=item * Currency (min/maxOccurs: 1/1)

=back

=head1 NAME

Shipment::Purolator::WSDLV2::Types::DutyInformation

=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Shipment::Purolator::WSDLV2::Types::DutyInformation
   BillDutiesToParty => $some_value, # BillDutiesToParty
   BusinessRelationship => $some_value, # BusinessRelationship
   Currency => $some_value, # DutyCurrency
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=head1 AUTHOR

Andrew Baerg <baergaj@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2018 by Andrew Baerg.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
