package Google::Ads::AdWords::v201109::ManualCPMAdGroupBids;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201109' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}


use base qw(Google::Ads::AdWords::v201109::AdGroupBids);
# Variety: sequence
use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %AdGroupBids__Type_of :ATTR(:get<AdGroupBids__Type>);
my %maxCpm_of :ATTR(:get<maxCpm>);

__PACKAGE__->_factory(
    [ qw(        AdGroupBids__Type
        maxCpm

    ) ],
    {
        'AdGroupBids__Type' => \%AdGroupBids__Type_of,
        'maxCpm' => \%maxCpm_of,
    },
    {
        'AdGroupBids__Type' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'maxCpm' => 'Google::Ads::AdWords::v201109::Bid',
    },
    {

        'AdGroupBids__Type' => 'AdGroupBids.Type',
        'maxCpm' => 'maxCpm',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201109::ManualCPMAdGroupBids

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
ManualCPMAdGroupBids from the namespace https://adwords.google.com/api/adwords/cm/v201109.

Adgroup level bids used in manual CPM bidding strategy. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * maxCpm




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Google::Ads::AdWords::v201109::ManualCPMAdGroupBids
   maxCpm =>  $a_reference_to, # see Google::Ads::AdWords::v201109::Bid
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

