/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.logging;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Comparator;
import org.openqa.selenium.logging.LogEntries;
import org.openqa.selenium.logging.LogEntry;

public class LogCombiner {
    private static final Comparator<LogEntry> LOG_ENTRY_TIMESTAMP_COMPARATOR = Comparator.comparingLong(LogEntry::getTimestamp);

    public static LogEntries combine(LogEntries ... entries) {
        return new LogEntries(Iterables.mergeSorted(Lists.newArrayList(entries), LOG_ENTRY_TIMESTAMP_COMPARATOR));
    }
}

