/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.transmitter;

import com.javonet.core.transmitter.TransmitterWrapper;
import com.javonet.utils.RuntimeName;

public class Transmitter {
    private static Boolean isNativeLibraryLoaded = false;

    public static synchronized byte[] sendCommand(byte[] messageByteArray) {
        int responseByteArrayLen;
        if (!isNativeLibraryLoaded.booleanValue()) {
            TransmitterWrapper.loadNativeLibrary();
            isNativeLibraryLoaded = true;
        }
        if ((responseByteArrayLen = TransmitterWrapper.sendCommand(messageByteArray)) > 0) {
            byte[] responseByteArray = new byte[responseByteArrayLen];
            TransmitterWrapper.readResponse(responseByteArray);
            return responseByteArray;
        }
        if (responseByteArrayLen == 0) {
            String errorMessage = "Response is empty";
            throw new RuntimeException(errorMessage);
        }
        String errorMessage = TransmitterWrapper.getNativeError();
        throw new RuntimeException("Javonet native error code: " + responseByteArrayLen + ". " + errorMessage);
    }

    public static boolean deployRuntime(byte[] byteArray, String path, byte channel) {
        if (!isNativeLibraryLoaded.booleanValue()) {
            TransmitterWrapper.loadNativeLibrary();
            isNativeLibraryLoaded = true;
        }
        return TransmitterWrapper.deployRuntime(byteArray, path, channel);
    }

    public static boolean setEmbeddedRuntime(byte calledRuntimeNumber, byte calledRuntimeVersion, String path) {
        if (!isNativeLibraryLoaded.booleanValue()) {
            TransmitterWrapper.loadNativeLibrary();
            isNativeLibraryLoaded = true;
        }
        return TransmitterWrapper.setEmbeddedRuntime((byte)RuntimeName.Jvm.ordinal(), calledRuntimeNumber, calledRuntimeVersion, path);
    }

    public static int activate(String licenseKey) {
        int activationResult;
        if (!isNativeLibraryLoaded.booleanValue()) {
            TransmitterWrapper.loadNativeLibrary();
            isNativeLibraryLoaded = true;
        }
        if ((activationResult = TransmitterWrapper.activate(licenseKey)) < 0) {
            String errorMessage = TransmitterWrapper.getNativeError();
            throw new RuntimeException("Javonet activation result: " + activationResult + ". Native error message: " + errorMessage);
        }
        return activationResult;
    }

    public static int setConfigSource(String configSource) {
        int setConfigResult;
        if (!isNativeLibraryLoaded.booleanValue()) {
            TransmitterWrapper.loadNativeLibrary();
            isNativeLibraryLoaded = true;
        }
        if ((setConfigResult = TransmitterWrapper.setConfigSource(configSource)) < 0) {
            String errorMessage = TransmitterWrapper.getNativeError();
            throw new RuntimeException("Javonet set config source result: " + setConfigResult + ". Native error message: " + errorMessage);
        }
        return setConfigResult;
    }

    public static int setJavonetWorkingDirectory(String path) {
        int setWorkingDirectoryResult;
        TransmitterWrapper.setWorkingDirectoryPath(path);
        if (!isNativeLibraryLoaded.booleanValue()) {
            TransmitterWrapper.loadNativeLibrary();
            isNativeLibraryLoaded = true;
        }
        if ((setWorkingDirectoryResult = TransmitterWrapper.setWorkingDirectory(path)) < 0) {
            String errorMessage = TransmitterWrapper.getNativeError();
            throw new RuntimeException("Javonet set working directory result: " + setWorkingDirectoryResult + ". Native error message: " + errorMessage);
        }
        return setWorkingDirectoryResult;
    }
}

