# Games::Checkers, Copyright (C) 1996-2012 Mikhael Goikhman, migo@cpan.org
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

package Games::Checkers::Board::_16x16;

use strict;
use warnings;

use base 'Games::Checkers::Board';
use Games::Checkers::Constants;

use constant size_x => 16;
use constant size_y => 16;
use constant locs => 128;
use constant default_rows => 7;

use constant loc_directions => [
	[ NL,  8, NL, NL ], [  8,  9, NL, NL ], [  9, 10, NL, NL ], [ 10, 11, NL, NL ], [ 11, 12, NL, NL ], [ 12, 13, NL, NL ], [ 13, 14, NL, NL ], [ 14, 15, NL, NL ],
	[ 16, 17,  0,  1 ], [ 17, 18,  1,  2 ], [ 18, 19,  2,  3 ], [ 19, 20,  3,  4 ], [ 20, 21,  4,  5 ], [ 21, 22,  5,  6 ], [ 22, 23,  6,  7 ], [ 23, NL,  7, NL ],
	[ NL, 24, NL,  8 ], [ 24, 25,  8,  9 ], [ 25, 26,  9, 10 ], [ 26, 27, 10, 11 ], [ 27, 28, 11, 12 ], [ 28, 29, 12, 13 ], [ 29, 30, 13, 14 ], [ 30, 31, 14, 15 ],
	[ 32, 33, 16, 17 ], [ 33, 34, 17, 18 ], [ 34, 35, 18, 19 ], [ 35, 36, 19, 20 ], [ 36, 37, 20, 21 ], [ 37, 38, 21, 22 ], [ 38, 39, 22, 23 ], [ 39, NL, 23, NL ],
	[ NL, 40, NL, 24 ], [ 40, 41, 24, 25 ], [ 41, 42, 25, 26 ], [ 42, 43, 26, 27 ], [ 43, 44, 27, 28 ], [ 44, 45, 28, 29 ], [ 45, 46, 29, 30 ], [ 46, 47, 30, 31 ],
	[ 48, 49, 32, 33 ], [ 49, 50, 33, 34 ], [ 50, 51, 34, 35 ], [ 51, 52, 35, 36 ], [ 52, 53, 36, 37 ], [ 53, 54, 37, 38 ], [ 54, 55, 38, 39 ], [ 55, NL, 39, NL ],
	[ NL, 56, NL, 40 ], [ 56, 57, 40, 41 ], [ 57, 58, 41, 42 ], [ 58, 59, 42, 43 ], [ 59, 60, 43, 44 ], [ 60, 61, 44, 45 ], [ 61, 62, 45, 46 ], [ 62, 63, 46, 47 ],
	[ 64, 65, 48, 49 ], [ 65, 66, 49, 50 ], [ 66, 67, 50, 51 ], [ 67, 68, 51, 52 ], [ 68, 69, 52, 53 ], [ 69, 70, 53, 54 ], [ 70, 71, 54, 55 ], [ 71, NL, 55, NL ],
	[ NL, 72, NL, 56 ], [ 72, 73, 56, 57 ], [ 73, 74, 57, 58 ], [ 74, 75, 58, 59 ], [ 75, 76, 59, 60 ], [ 76, 77, 60, 61 ], [ 77, 78, 61, 62 ], [ 78, 79, 62, 63 ],
	[ 80, 81, 64, 65 ], [ 81, 82, 65, 66 ], [ 82, 83, 66, 67 ], [ 83, 84, 67, 68 ], [ 84, 85, 68, 69 ], [ 85, 86, 69, 70 ], [ 86, 87, 70, 71 ], [ 87, NL, 71, NL ],
	[ NL, 88, NL, 72 ], [ 88, 89, 72, 73 ], [ 89, 90, 73, 74 ], [ 90, 91, 74, 75 ], [ 91, 92, 75, 76 ], [ 92, 93, 76, 77 ], [ 93, 94, 77, 78 ], [ 94, 95, 78, 79 ],
	[ 96, 97, 80, 81 ], [ 97, 98, 81, 82 ], [ 98, 99, 82, 83 ], [ 99, 100, 83, 84 ], [ 100, 101, 84, 85 ], [ 101, 102, 85, 86 ], [ 102, 103, 86, 87 ], [ 103, NL, 87, NL ],
	[ NL, 104, NL, 88 ], [ 104, 105, 88, 89 ], [ 105, 106, 89, 90 ], [ 106, 107, 90, 91 ], [ 107, 108, 91, 92 ], [ 108, 109, 92, 93 ], [ 109, 110, 93, 94 ], [ 110, 111, 94, 95 ],
	[ 112, 113, 96, 97 ], [ 113, 114, 97, 98 ], [ 114, 115, 98, 99 ], [ 115, 116, 99, 100 ], [ 116, 117, 100, 101 ], [ 117, 118, 101, 102 ], [ 118, 119, 102, 103 ], [ 119, NL, 103, NL ],
	[ NL, 120, NL, 104 ], [ 120, 121, 104, 105 ], [ 121, 122, 105, 106 ], [ 122, 123, 106, 107 ], [ 123, 124, 107, 108 ], [ 124, 125, 108, 109 ], [ 125, 126, 109, 110 ], [ 126, 127, 110, 111 ],
	[ NL, NL, 112, 113 ], [ NL, NL, 113, 114 ], [ NL, NL, 114, 115 ], [ NL, NL, 115, 116 ], [ NL, NL, 116, 117 ], [ NL, NL, 117, 118 ], [ NL, NL, 118, 119 ], [ NL, NL, 119, NL ],
];

use constant is_crowning => [
[
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	1, 1, 1, 1, 1, 1, 1, 1,
], [
	1, 1, 1, 1, 1, 1, 1, 1,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
]
];

use constant pawn_step => [
[
	[      8 ], [  8,  9 ], [  9, 10 ], [ 10, 11 ], [ 11, 12 ], [ 12, 13 ], [ 13, 14 ], [ 14, 15 ],
	[ 16, 17 ], [ 17, 18 ], [ 18, 19 ], [ 19, 20 ], [ 20, 21 ], [ 21, 22 ], [ 22, 23 ], [ 23     ],
	[     24 ], [ 24, 25 ], [ 25, 26 ], [ 26, 27 ], [ 27, 28 ], [ 28, 29 ], [ 29, 30 ], [ 30, 31 ],
	[ 32, 33 ], [ 33, 34 ], [ 34, 35 ], [ 35, 36 ], [ 36, 37 ], [ 37, 38 ], [ 38, 39 ], [ 39     ],
	[     40 ], [ 40, 41 ], [ 41, 42 ], [ 42, 43 ], [ 43, 44 ], [ 44, 45 ], [ 45, 46 ], [ 46, 47 ],
	[ 48, 49 ], [ 49, 50 ], [ 50, 51 ], [ 51, 52 ], [ 52, 53 ], [ 53, 54 ], [ 54, 55 ], [ 55     ],
	[     56 ], [ 56, 57 ], [ 57, 58 ], [ 58, 59 ], [ 59, 60 ], [ 60, 61 ], [ 61, 62 ], [ 62, 63 ],
	[ 64, 65 ], [ 65, 66 ], [ 66, 67 ], [ 67, 68 ], [ 68, 69 ], [ 69, 70 ], [ 70, 71 ], [ 71     ],
	[     72 ], [ 72, 73 ], [ 73, 74 ], [ 74, 75 ], [ 75, 76 ], [ 76, 77 ], [ 77, 78 ], [ 78, 79 ],
	[ 80, 81 ], [ 81, 82 ], [ 82, 83 ], [ 83, 84 ], [ 84, 85 ], [ 85, 86 ], [ 86, 87 ], [ 87     ],
	[     88 ], [ 88, 89 ], [ 89, 90 ], [ 90, 91 ], [ 91, 92 ], [ 92, 93 ], [ 93, 94 ], [ 94, 95 ],
	[ 96, 97 ], [ 97, 98 ], [ 98, 99 ], [ 99, 100 ], [ 100, 101 ], [ 101, 102 ], [ 102, 103 ], [ 103     ],
	[     104 ], [ 104, 105 ], [ 105, 106 ], [ 106, 107 ], [ 107, 108 ], [ 108, 109 ], [ 109, 110 ], [ 110, 111 ],
	[ 112, 113 ], [ 113, 114 ], [ 114, 115 ], [ 115, 116 ], [ 116, 117 ], [ 117, 118 ], [ 118, 119 ], [ 119     ],
	[     120 ], [ 120, 121 ], [ 121, 122 ], [ 122, 123 ], [ 123, 124 ], [ 124, 125 ], [ 125, 126 ], [ 126, 127 ],
	[        ], [        ], [        ], [        ], [        ], [        ], [        ], [        ],
], [
	[        ], [        ], [        ], [        ], [        ], [        ], [        ], [        ],
	[  0,  1 ], [  1,  2 ], [  2,  3 ], [  3,  4 ], [  4,  5 ], [  5,  6 ], [  6,  7 ], [  7     ],
	[      8 ], [  8,  9 ], [  9, 10 ], [ 10, 11 ], [ 11, 12 ], [ 12, 13 ], [ 13, 14 ], [ 14, 15 ],
	[ 16, 17 ], [ 17, 18 ], [ 18, 19 ], [ 19, 20 ], [ 20, 21 ], [ 21, 22 ], [ 22, 23 ], [ 23     ],
	[     24 ], [ 24, 25 ], [ 25, 26 ], [ 26, 27 ], [ 27, 28 ], [ 28, 29 ], [ 29, 30 ], [ 30, 31 ],
	[ 32, 33 ], [ 33, 34 ], [ 34, 35 ], [ 35, 36 ], [ 36, 37 ], [ 37, 38 ], [ 38, 39 ], [ 39     ],
	[     40 ], [ 40, 41 ], [ 41, 42 ], [ 42, 43 ], [ 43, 44 ], [ 44, 45 ], [ 45, 46 ], [ 46, 47 ],
	[ 48, 49 ], [ 49, 50 ], [ 50, 51 ], [ 51, 52 ], [ 52, 53 ], [ 53, 54 ], [ 54, 55 ], [ 55     ],
	[     56 ], [ 56, 57 ], [ 57, 58 ], [ 58, 59 ], [ 59, 60 ], [ 60, 61 ], [ 61, 62 ], [ 62, 63 ],
	[ 64, 65 ], [ 65, 66 ], [ 66, 67 ], [ 67, 68 ], [ 68, 69 ], [ 69, 70 ], [ 70, 71 ], [ 71     ],
	[     72 ], [ 72, 73 ], [ 73, 74 ], [ 74, 75 ], [ 75, 76 ], [ 76, 77 ], [ 77, 78 ], [ 78, 79 ],
	[ 80, 81 ], [ 81, 82 ], [ 82, 83 ], [ 83, 84 ], [ 84, 85 ], [ 85, 86 ], [ 86, 87 ], [ 87     ],
	[     88 ], [ 88, 89 ], [ 89, 90 ], [ 90, 91 ], [ 91, 92 ], [ 92, 93 ], [ 93, 94 ], [ 94, 95 ],
	[ 96, 97 ], [ 97, 98 ], [ 98, 99 ], [ 99, 100 ], [ 100, 101 ], [ 101, 102 ], [ 102, 103 ], [ 103     ],
	[     104 ], [ 104, 105 ], [ 105, 106 ], [ 106, 107 ], [ 107, 108 ], [ 108, 109 ], [ 109, 110 ], [ 110, 111 ],
	[ 112, 113 ], [ 113, 114 ], [ 114, 115 ], [ 115, 116 ], [ 116, 117 ], [ 117, 118 ], [ 118, 119 ], [ 119     ],
]
];

use constant pawn_beat => [
	[     17         ], [ 16, 18         ], [ 17, 19         ], [ 18, 20         ], [ 19, 21         ], [ 20, 22         ], [ 21, 23         ], [ 22             ],
	[     25         ], [ 24, 26         ], [ 25, 27         ], [ 26, 28         ], [ 27, 29         ], [ 28, 30         ], [ 29, 31         ], [ 30             ],
	[     33,      1 ], [ 32, 34,  0,  2 ], [ 33, 35,  1,  3 ], [ 34, 36,  2,  4 ], [ 35, 37,  3,  5 ], [ 36, 38,  4,  6 ], [ 37, 39,  5,  7 ], [ 38,      6     ],
	[     41,      9 ], [ 40, 42,  8, 10 ], [ 41, 43,  9, 11 ], [ 42, 44, 10, 12 ], [ 43, 45, 11, 13 ], [ 44, 46, 12, 14 ], [ 45, 47, 13, 15 ], [ 46,     14     ],
	[     49,     17 ], [ 48, 50, 16, 18 ], [ 49, 51, 17, 19 ], [ 50, 52, 18, 20 ], [ 51, 53, 19, 21 ], [ 52, 54, 20, 22 ], [ 53, 55, 21, 23 ], [ 54,     22     ],
	[     57,     25 ], [ 56, 58, 24, 26 ], [ 57, 59, 25, 27 ], [ 58, 60, 26, 28 ], [ 59, 61, 27, 29 ], [ 60, 62, 28, 30 ], [ 61, 63, 29, 31 ], [ 62,     30     ],
	[     65,     33 ], [ 64, 66, 32, 34 ], [ 65, 67, 33, 35 ], [ 66, 68, 34, 36 ], [ 67, 69, 35, 37 ], [ 68, 70, 36, 38 ], [ 69, 71, 37, 39 ], [ 70,     38     ],
	[     73,     41 ], [ 72, 74, 40, 42 ], [ 73, 75, 41, 43 ], [ 74, 76, 42, 44 ], [ 75, 77, 43, 45 ], [ 76, 78, 44, 46 ], [ 77, 79, 45, 47 ], [ 78,     46     ],
	[     81,     49 ], [ 80, 82, 48, 50 ], [ 81, 83, 49, 51 ], [ 82, 84, 50, 52 ], [ 83, 85, 51, 53 ], [ 84, 86, 52, 54 ], [ 85, 87, 53, 55 ], [ 86,     54     ],
	[     89,     57 ], [ 88, 90, 56, 58 ], [ 89, 91, 57, 59 ], [ 90, 92, 58, 60 ], [ 91, 93, 59, 61 ], [ 92, 94, 60, 62 ], [ 93, 95, 61, 63 ], [ 94,     62     ],
	[     97,     65 ], [ 96, 98, 64, 66 ], [ 97, 99, 65, 67 ], [ 98, 100, 66, 68 ], [ 99, 101, 67, 69 ], [ 100, 102, 68, 70 ], [ 101, 103, 69, 71 ], [ 102,     70     ],
	[     105,     73 ], [ 104, 106, 72, 74 ], [ 105, 107, 73, 75 ], [ 106, 108, 74, 76 ], [ 107, 109, 75, 77 ], [ 108, 110, 76, 78 ], [ 109, 111, 77, 79 ], [ 110,     78     ],
	[     113,     81 ], [ 112, 114, 80, 82 ], [ 113, 115, 81, 83 ], [ 114, 116, 82, 84 ], [ 115, 117, 83, 85 ], [ 116, 118, 84, 86 ], [ 117, 119, 85, 87 ], [ 118,     86     ],
	[     121,     89 ], [ 120, 122, 88, 90 ], [ 121, 123, 89, 91 ], [ 122, 124, 90, 92 ], [ 123, 125, 91, 93 ], [ 124, 126, 92, 94 ], [ 125, 127, 93, 95 ], [ 126,     94     ],
	[             97 ], [         96, 98 ], [         97, 99 ], [         98, 100 ], [         99, 101 ], [         100, 102 ], [         101, 103 ], [         102     ],
	[             105 ], [         104, 106 ], [         105, 107 ], [         106, 108 ], [         107, 109 ], [         108, 110 ], [         109, 111 ], [         110     ],
];

use constant pawn_beat_forward => [
[
	[     17 ], [ 16, 18 ], [ 17, 19 ], [ 18, 20 ], [ 19, 21 ], [ 20, 22 ], [ 21, 23 ], [ 22     ],
	[     25 ], [ 24, 26 ], [ 25, 27 ], [ 26, 28 ], [ 27, 29 ], [ 28, 30 ], [ 29, 31 ], [ 30     ],
	[     33 ], [ 32, 34 ], [ 33, 35 ], [ 34, 36 ], [ 35, 37 ], [ 36, 38 ], [ 37, 39 ], [ 38     ],
	[     41 ], [ 40, 42 ], [ 41, 43 ], [ 42, 44 ], [ 43, 45 ], [ 44, 46 ], [ 45, 47 ], [ 46     ],
	[     49 ], [ 48, 50 ], [ 49, 51 ], [ 50, 52 ], [ 51, 53 ], [ 52, 54 ], [ 53, 55 ], [ 54     ],
	[     57 ], [ 56, 58 ], [ 57, 59 ], [ 58, 60 ], [ 59, 61 ], [ 60, 62 ], [ 61, 63 ], [ 62     ],
	[     65 ], [ 64, 66 ], [ 65, 67 ], [ 66, 68 ], [ 67, 69 ], [ 68, 70 ], [ 69, 71 ], [ 70     ],
	[     73 ], [ 72, 74 ], [ 73, 75 ], [ 74, 76 ], [ 75, 77 ], [ 76, 78 ], [ 77, 79 ], [ 78     ],
	[     81 ], [ 80, 82 ], [ 81, 83 ], [ 82, 84 ], [ 83, 85 ], [ 84, 86 ], [ 85, 87 ], [ 86     ],
	[     89 ], [ 88, 90 ], [ 89, 91 ], [ 90, 92 ], [ 91, 93 ], [ 92, 94 ], [ 93, 95 ], [ 94     ],
	[     97 ], [ 96, 98 ], [ 97, 99 ], [ 98, 100 ], [ 99, 101 ], [ 100, 102 ], [ 101, 103 ], [ 102     ],
	[     105 ], [ 104, 106 ], [ 105, 107 ], [ 106, 108 ], [ 107, 109 ], [ 108, 110 ], [ 109, 111 ], [ 110     ],
	[     113 ], [ 112, 114 ], [ 113, 115 ], [ 114, 116 ], [ 115, 117 ], [ 116, 118 ], [ 117, 119 ], [ 118     ],
	[     121 ], [ 120, 122 ], [ 121, 123 ], [ 122, 124 ], [ 123, 125 ], [ 124, 126 ], [ 125, 127 ], [ 126     ],
	[        ], [        ], [        ], [        ], [        ], [        ], [        ], [        ],
	[        ], [        ], [        ], [        ], [        ], [        ], [        ], [        ],
], [
	[        ], [        ], [        ], [        ], [        ], [        ], [        ], [        ],
	[        ], [        ], [        ], [        ], [        ], [        ], [        ], [        ],
	[      1 ], [  0,  2 ], [  1,  3 ], [  2,  4 ], [  3,  5 ], [  4,  6 ], [  5,  7 ], [  6     ],
	[      9 ], [  8, 10 ], [  9, 11 ], [ 10, 12 ], [ 11, 13 ], [ 12, 14 ], [ 13, 15 ], [ 14     ],
	[     17 ], [ 16, 18 ], [ 17, 19 ], [ 18, 20 ], [ 19, 21 ], [ 20, 22 ], [ 21, 23 ], [ 22     ],
	[     25 ], [ 24, 26 ], [ 25, 27 ], [ 26, 28 ], [ 27, 29 ], [ 28, 30 ], [ 29, 31 ], [ 30     ],
	[     33 ], [ 32, 34 ], [ 33, 35 ], [ 34, 36 ], [ 35, 37 ], [ 36, 38 ], [ 37, 39 ], [ 38     ],
	[     41 ], [ 40, 42 ], [ 41, 43 ], [ 42, 44 ], [ 43, 45 ], [ 44, 46 ], [ 45, 47 ], [ 46     ],
	[     49 ], [ 48, 50 ], [ 49, 51 ], [ 50, 52 ], [ 51, 53 ], [ 52, 54 ], [ 53, 55 ], [ 54     ],
	[     57 ], [ 56, 58 ], [ 57, 59 ], [ 58, 60 ], [ 59, 61 ], [ 60, 62 ], [ 61, 63 ], [ 62     ],
	[     65 ], [ 64, 66 ], [ 65, 67 ], [ 66, 68 ], [ 67, 69 ], [ 68, 70 ], [ 69, 71 ], [ 70     ],
	[     73 ], [ 72, 74 ], [ 73, 75 ], [ 74, 76 ], [ 75, 77 ], [ 76, 78 ], [ 77, 79 ], [ 78     ],
	[     81 ], [ 80, 82 ], [ 81, 83 ], [ 82, 84 ], [ 83, 85 ], [ 84, 86 ], [ 85, 87 ], [ 86     ],
	[     89 ], [ 88, 90 ], [ 89, 91 ], [ 90, 92 ], [ 91, 93 ], [ 92, 94 ], [ 93, 95 ], [ 94     ],
	[     97 ], [ 96, 98 ], [ 97, 99 ], [ 98, 100 ], [ 99, 101 ], [ 100, 102 ], [ 101, 103 ], [ 102     ],
	[     105 ], [ 104, 106 ], [ 105, 107 ], [ 106, 108 ], [ 107, 109 ], [ 108, 110 ], [ 109, 111 ], [ 110     ],
]
];

use constant pawn_beat_8dirs => [
	[     17,                 32,  2 ], [ 16, 18,                 33,  3 ], [ 17, 19,              0, 34,  4 ], [ 18, 20,              1, 35,  5 ], [ 19, 21,              2, 36,  6 ], [ 20, 22,              3, 37,  7 ], [ 21, 23,              4, 38     ], [ 22,                  5, 39     ],
	[     25,                 40, 10 ], [ 24, 26,                 41, 11 ], [ 25, 27,              8, 42, 12 ], [ 26, 28,              9, 43, 13 ], [ 27, 29,             10, 44, 14 ], [ 28, 30,             11, 45, 15 ], [ 29, 31,             12, 46     ], [ 30,                 13, 47     ],
	[     33,      1,         48, 18 ], [ 32, 34,  0,  2,         49, 19 ], [ 33, 35,  1,  3,     16, 50, 20 ], [ 34, 36,  2,  4,     17, 51, 21 ], [ 35, 37,  3,  5,     18, 52, 22 ], [ 36, 38,  4,  6,     19, 53, 23 ], [ 37, 39,  5,  7,     20, 54     ], [ 38,      6,         21, 55     ],
	[     41,      9,         56, 26 ], [ 40, 42,  8, 10,         57, 27 ], [ 41, 43,  9, 11,     24, 58, 28 ], [ 42, 44, 10, 12,     25, 59, 29 ], [ 43, 45, 11, 13,     26, 60, 30 ], [ 44, 46, 12, 14,     27, 61, 31 ], [ 45, 47, 13, 15,     28, 62     ], [ 46,     14,         29, 63     ],
	[     49,     17,  0,     64, 34 ], [ 48, 50, 16, 18,  1,     65, 35 ], [ 49, 51, 17, 19,  2, 32, 66, 36 ], [ 50, 52, 18, 20,  3, 33, 67, 37 ], [ 51, 53, 19, 21,  4, 34, 68, 38 ], [ 52, 54, 20, 22,  5, 35, 69, 39 ], [ 53, 55, 21, 23,  6, 36, 70     ], [ 54,     22,      7, 37, 71     ],
	[     57,     25,  8,     72, 42 ], [ 56, 58, 24, 26,  9,     73, 43 ], [ 57, 59, 25, 27, 10, 40, 74, 44 ], [ 58, 60, 26, 28, 11, 41, 75, 45 ], [ 59, 61, 27, 29, 12, 42, 76, 46 ], [ 60, 62, 28, 30, 13, 43, 77, 47 ], [ 61, 63, 29, 31, 14, 44, 78     ], [ 62,     30,     15, 45, 79     ],
	[     65,     33, 16,     80, 50 ], [ 64, 66, 32, 34, 17,     81, 51 ], [ 65, 67, 33, 35, 18, 48, 82, 52 ], [ 66, 68, 34, 36, 19, 49, 83, 53 ], [ 67, 69, 35, 37, 20, 50, 84, 54 ], [ 68, 70, 36, 38, 21, 51, 85, 55 ], [ 69, 71, 37, 39, 22, 52, 86     ], [ 70,     38,     23, 53, 87     ],
	[     73,     41, 24,     88, 58 ], [ 72, 74, 40, 42, 25,     89, 59 ], [ 73, 75, 41, 43, 26, 56, 90, 60 ], [ 74, 76, 42, 44, 27, 57, 91, 61 ], [ 75, 77, 43, 45, 28, 58, 92, 62 ], [ 76, 78, 44, 46, 29, 59, 93, 63 ], [ 77, 79, 45, 47, 30, 60, 94     ], [ 78,     46,     31, 61, 95     ],
	[     81,     49, 32,     96, 66 ], [ 80, 82, 48, 50, 33,     97, 67 ], [ 81, 83, 49, 51, 34, 64, 98, 68 ], [ 82, 84, 50, 52, 35, 65, 99, 69 ], [ 83, 85, 51, 53, 36, 66, 100, 70 ], [ 84, 86, 52, 54, 37, 67, 101, 71 ], [ 85, 87, 53, 55, 38, 68, 102     ], [ 86,     54,     39, 69, 103     ],
	[     89,     57, 40,     104, 74 ], [ 88, 90, 56, 58, 41,     105, 75 ], [ 89, 91, 57, 59, 42, 72, 106, 76 ], [ 90, 92, 58, 60, 43, 73, 107, 77 ], [ 91, 93, 59, 61, 44, 74, 108, 78 ], [ 92, 94, 60, 62, 45, 75, 109, 79 ], [ 93, 95, 61, 63, 46, 76, 110     ], [ 94,     62,     47, 77, 111     ],
	[     97,     65, 48,     112, 82 ], [ 96, 98, 64, 66, 49,     113, 83 ], [ 97, 99, 65, 67, 50, 80, 114, 84 ], [ 98, 100, 66, 68, 51, 81, 115, 85 ], [ 99, 101, 67, 69, 52, 82, 116, 86 ], [ 100, 102, 68, 70, 53, 83, 117, 87 ], [ 101, 103, 69, 71, 54, 84, 118     ], [ 102,     70,     55, 85, 119     ],
	[     105,     73, 56,     120, 90 ], [ 104, 106, 72, 74, 57,     121, 91 ], [ 105, 107, 73, 75, 58, 88, 122, 92 ], [ 106, 108, 74, 76, 59, 89, 123, 93 ], [ 107, 109, 75, 77, 60, 90, 124, 94 ], [ 108, 110, 76, 78, 61, 91, 125, 95 ], [ 109, 111, 77, 79, 62, 92, 126     ], [ 110,     78,     63, 93, 127     ],
	[     113,     81, 64,         98 ], [ 112, 114, 80, 82, 65,         99 ], [ 113, 115, 81, 83, 66, 96,     100 ], [ 114, 116, 82, 84, 67, 97,     101 ], [ 115, 117, 83, 85, 68, 98,     102 ], [ 116, 118, 84, 86, 69, 99,     103 ], [ 117, 119, 85, 87, 70, 100         ], [ 118,     86,     71, 101         ],
	[     121,     89, 72,         106 ], [ 120, 122, 88, 90, 73,         107 ], [ 121, 123, 89, 91, 74, 104,     108 ], [ 122, 124, 90, 92, 75, 105,     109 ], [ 123, 125, 91, 93, 76, 106,     110 ], [ 124, 126, 92, 94, 77, 107,     111 ], [ 125, 127, 93, 95, 78, 108         ], [ 126,     94,     79, 109         ],
	[             97, 80,         114 ], [         96, 98, 81,         115 ], [         97, 99, 82, 112,     116 ], [         98, 100, 83, 113,     117 ], [         99, 101, 84, 114,     118 ], [         100, 102, 85, 115,     119 ], [         101, 103, 86, 116         ], [         102,     87, 117         ],
	[             105, 88,         122 ], [         104, 106, 89,         123 ], [         105, 107, 90, 120,     124 ], [         106, 108, 91, 121,     125 ], [         107, 109, 92, 122,     126 ], [         108, 110, 93, 123,     127 ], [         109, 111, 94, 124         ], [         110,     95, 125         ],
];

use constant king_step => [
	[      8,             17,             25,             34,             42,             51,             59,             68,             76,             85,             93,             102,             110,             119,             127         ],
	[  8,  9,         16, 18,             26,             35,             43,             52,             60,             69,             77,             86,             94,             103,             111                                         ],
	[  9, 10,         17, 19,         24, 27,         32, 36,             44,             53,             61,             70,             78,             87,             95                                                                         ],
	[ 10, 11,         18, 20,         25, 28,         33, 37,         40, 45,         48, 54,             62,             71,             79                                                                                                         ],
	[ 11, 12,         19, 21,         26, 29,         34, 38,         41, 46,         49, 55,         56, 63,         64                                                                                                                             ],
	[ 12, 13,         20, 22,         27, 30,         35, 39,         42, 47,         50,             57,             65,             72,             80                                                                                             ],
	[ 13, 14,         21, 23,         28, 31,         36,             43,             51,             58,             66,             73,             81,             88,             96                                                             ],
	[ 14, 15,         22,             29,             37,             44,             52,             59,             67,             74,             82,             89,             97,             104,             112                             ],
	[ 16, 17,  0,  1,     25,             34,             42,             51,             59,             68,             76,             85,             93,             102,             110,             119,             127                         ],
	[ 17, 18,  1,  2, 24, 26,         32, 35,             43,             52,             60,             69,             77,             86,             94,             103,             111                                                         ],
	[ 18, 19,  2,  3, 25, 27,         33, 36,         40, 44,         48, 53,             61,             70,             78,             87,             95                                                                                         ],
	[ 19, 20,  3,  4, 26, 28,         34, 37,         41, 45,         49, 54,         56, 62,         64, 71,             79                                                                                                                         ],
	[ 20, 21,  4,  5, 27, 29,         35, 38,         42, 46,         50, 55,         57, 63,         65,             72,             80                                                                                                             ],
	[ 21, 22,  5,  6, 28, 30,         36, 39,         43, 47,         51,             58,             66,             73,             81,             88,             96                                                                             ],
	[ 22, 23,  6,  7, 29, 31,         37,             44,             52,             59,             67,             74,             82,             89,             97,             104,             112                                             ],
	[ 23,      7,     30,             38,             45,             53,             60,             68,             75,             83,             90,             98,             105,             113,             120                             ],
	[     24,      8,     33,      1,     41,             50,             58,             67,             75,             84,             92,             101,             109,             118,             126                                         ],
	[ 24, 25,  8,  9, 32, 34,  0,  2,     42,             51,             59,             68,             76,             85,             93,             102,             110,             119,             127                                         ],
	[ 25, 26,  9, 10, 33, 35,  1,  3, 40, 43,         48, 52,             60,             69,             77,             86,             94,             103,             111                                                                         ],
	[ 26, 27, 10, 11, 34, 36,  2,  4, 41, 44,         49, 53,         56, 61,         64, 70,             78,             87,             95                                                                                                         ],
	[ 27, 28, 11, 12, 35, 37,  3,  5, 42, 45,         50, 54,         57, 62,         65, 71,         72, 79,         80                                                                                                                             ],
	[ 28, 29, 12, 13, 36, 38,  4,  6, 43, 46,         51, 55,         58, 63,         66,             73,             81,             88,             96                                                                                             ],
	[ 29, 30, 13, 14, 37, 39,  5,  7, 44, 47,         52,             59,             67,             74,             82,             89,             97,             104,             112                                                             ],
	[ 30, 31, 14, 15, 38,      6,     45,             53,             60,             68,             75,             83,             90,             98,             105,             113,             120                                             ],
	[ 32, 33, 16, 17,     41,      9,     50,      2,     58,             67,             75,             84,             92,             101,             109,             118,             126                                                         ],
	[ 33, 34, 17, 18, 40, 42,  8, 10, 48, 51,  0,  3,     59,             68,             76,             85,             93,             102,             110,             119,             127                                                         ],
	[ 34, 35, 18, 19, 41, 43,  9, 11, 49, 52,  1,  4, 56, 60,         64, 69,             77,             86,             94,             103,             111                                                                                         ],
	[ 35, 36, 19, 20, 42, 44, 10, 12, 50, 53,  2,  5, 57, 61,         65, 70,         72, 78,         80, 87,             95                                                                                                                         ],
	[ 36, 37, 20, 21, 43, 45, 11, 13, 51, 54,  3,  6, 58, 62,         66, 71,         73, 79,         81,             88,             96                                                                                                             ],
	[ 37, 38, 21, 22, 44, 46, 12, 14, 52, 55,  4,  7, 59, 63,         67,             74,             82,             89,             97,             104,             112                                                                             ],
	[ 38, 39, 22, 23, 45, 47, 13, 15, 53,      5,     60,             68,             75,             83,             90,             98,             105,             113,             120                                                             ],
	[ 39,     23,     46,     14,     54,      6,     61,             69,             76,             84,             91,             99,             106,             114,             121                                                             ],
	[     40,     24,     49,     17,     57,      9,     66,      2,     74,             83,             91,             100,             108,             117,             125                                                                         ],
	[ 40, 41, 24, 25, 48, 50, 16, 18,     58,     10,     67,      3,     75,             84,             92,             101,             109,             118,             126                                                                         ],
	[ 41, 42, 25, 26, 49, 51, 17, 19, 56, 59,  8, 11, 64, 68,  0,  4,     76,             85,             93,             102,             110,             119,             127                                                                         ],
	[ 42, 43, 26, 27, 50, 52, 18, 20, 57, 60,  9, 12, 65, 69,  1,  5, 72, 77,         80, 86,             94,             103,             111                                                                                                         ],
	[ 43, 44, 27, 28, 51, 53, 19, 21, 58, 61, 10, 13, 66, 70,  2,  6, 73, 78,         81, 87,         88, 95,         96                                                                                                                             ],
	[ 44, 45, 28, 29, 52, 54, 20, 22, 59, 62, 11, 14, 67, 71,  3,  7, 74, 79,         82,             89,             97,             104,             112                                                                                             ],
	[ 45, 46, 29, 30, 53, 55, 21, 23, 60, 63, 12, 15, 68,      4,     75,             83,             90,             98,             105,             113,             120                                                                             ],
	[ 46, 47, 30, 31, 54,     22,     61,     13,     69,      5,     76,             84,             91,             99,             106,             114,             121                                                                             ],
	[ 48, 49, 32, 33,     57,     25,     66,     18,     74,     10,     83,      3,     91,             100,             108,             117,             125                                                                                         ],
	[ 49, 50, 33, 34, 56, 58, 24, 26, 64, 67, 16, 19,     75,     11,     84,      4,     92,             101,             109,             118,             126                                                                                         ],
	[ 50, 51, 34, 35, 57, 59, 25, 27, 65, 68, 17, 20, 72, 76,  8, 12, 80, 85,  0,  5,     93,             102,             110,             119,             127                                                                                         ],
	[ 51, 52, 35, 36, 58, 60, 26, 28, 66, 69, 18, 21, 73, 77,  9, 13, 81, 86,  1,  6, 88, 94,         96, 103,             111                                                                                                                         ],
	[ 52, 53, 36, 37, 59, 61, 27, 29, 67, 70, 19, 22, 74, 78, 10, 14, 82, 87,  2,  7, 89, 95,         97,             104,             112                                                                                                             ],
	[ 53, 54, 37, 38, 60, 62, 28, 30, 68, 71, 20, 23, 75, 79, 11, 15, 83,      3,     90,             98,             105,             113,             120                                                                                             ],
	[ 54, 55, 38, 39, 61, 63, 29, 31, 69,     21,     76,     12,     84,      4,     91,             99,             106,             114,             121                                                                                             ],
	[ 55,     39,     62,     30,     70,     22,     77,     13,     85,      5,     92,             100,             107,             115,             122                                                                                             ],
	[     56,     40,     65,     33,     73,     25,     82,     18,     90,     10,     99,      3,     107,             116,             124                                                                                                         ],
	[ 56, 57, 40, 41, 64, 66, 32, 34,     74,     26,     83,     19,     91,     11,     100,      4,     108,             117,             125                                                                                                         ],
	[ 57, 58, 41, 42, 65, 67, 33, 35, 72, 75, 24, 27, 80, 84, 16, 20,     92,     12,     101,      5,     109,             118,             126                                                                                                         ],
	[ 58, 59, 42, 43, 66, 68, 34, 36, 73, 76, 25, 28, 81, 85, 17, 21, 88, 93,  8, 13, 96, 102,  0,  6,     110,             119,             127                                                                                                         ],
	[ 59, 60, 43, 44, 67, 69, 35, 37, 74, 77, 26, 29, 82, 86, 18, 22, 89, 94,  9, 14, 97, 103,  1,  7, 104, 111,         112                                                                                                                             ],
	[ 60, 61, 44, 45, 68, 70, 36, 38, 75, 78, 27, 30, 83, 87, 19, 23, 90, 95, 10, 15, 98,      2,     105,             113,             120                                                                                                             ],
	[ 61, 62, 45, 46, 69, 71, 37, 39, 76, 79, 28, 31, 84,     20,     91,     11,     99,      3,     106,             114,             121                                                                                                             ],
	[ 62, 63, 46, 47, 70,     38,     77,     29,     85,     21,     92,     12,     100,      4,     107,             115,             122                                                                                                             ],
	[ 64, 65, 48, 49,     73,     41,     82,     34,     90,     26,     99,     19,     107,     11,     116,      4,     124                                                                                                                         ],
	[ 65, 66, 49, 50, 72, 74, 40, 42, 80, 83, 32, 35,     91,     27,     100,     20,     108,     12,     117,      5,     125                                                                                                                         ],
	[ 66, 67, 50, 51, 73, 75, 41, 43, 81, 84, 33, 36, 88, 92, 24, 28, 96, 101, 16, 21,     109,     13,     118,      6,     126                                                                                                                         ],
	[ 67, 68, 51, 52, 74, 76, 42, 44, 82, 85, 34, 37, 89, 93, 25, 29, 97, 102, 17, 22, 104, 110,  8, 14, 112, 119,  0,  7,     127                                                                                                                         ],
	[ 68, 69, 52, 53, 75, 77, 43, 45, 83, 86, 35, 38, 90, 94, 26, 30, 98, 103, 18, 23, 105, 111,  9, 15, 113,      1,     120                                                                                                                             ],
	[ 69, 70, 53, 54, 76, 78, 44, 46, 84, 87, 36, 39, 91, 95, 27, 31, 99,     19,     106,     10,     114,      2,     121                                                                                                                             ],
	[ 70, 71, 54, 55, 77, 79, 45, 47, 85,     37,     92,     28,     100,     20,     107,     11,     115,      3,     122                                                                                                                             ],
	[ 71,     55,     78,     46,     86,     38,     93,     29,     101,     21,     108,     12,     116,      4,     123                                                                                                                             ],
	[     72,     56,     81,     49,     89,     41,     98,     34,     106,     26,     115,     19,     123,     11,              4                                                                                                                 ],
	[ 72, 73, 56, 57, 80, 82, 48, 50,     90,     42,     99,     35,     107,     27,     116,     20,     124,     12,              5                                                                                                                 ],
	[ 73, 74, 57, 58, 81, 83, 49, 51, 88, 91, 40, 43, 96, 100, 32, 36,     108,     28,     117,     21,     125,     13,              6                                                                                                                 ],
	[ 74, 75, 58, 59, 82, 84, 50, 52, 89, 92, 41, 44, 97, 101, 33, 37, 104, 109, 24, 29, 112, 118, 16, 22,     126,     14,              7                                                                                                                 ],
	[ 75, 76, 59, 60, 83, 85, 51, 53, 90, 93, 42, 45, 98, 102, 34, 38, 105, 110, 25, 30, 113, 119, 17, 23, 120, 127,  8, 15,          0                                                                                                                     ],
	[ 76, 77, 60, 61, 84, 86, 52, 54, 91, 94, 43, 46, 99, 103, 35, 39, 106, 111, 26, 31, 114,     18,     121,      9,              1                                                                                                                     ],
	[ 77, 78, 61, 62, 85, 87, 53, 55, 92, 95, 44, 47, 100,     36,     107,     27,     115,     19,     122,     10,              2                                                                                                                     ],
	[ 78, 79, 62, 63, 86,     54,     93,     45,     101,     37,     108,     28,     116,     20,     123,     11,              3                                                                                                                     ],
	[ 80, 81, 64, 65,     89,     57,     98,     50,     106,     42,     115,     35,     123,     27,             20,             12,              5                                                                                                 ],
	[ 81, 82, 65, 66, 88, 90, 56, 58, 96, 99, 48, 51,     107,     43,     116,     36,     124,     28,             21,             13,              6                                                                                                 ],
	[ 82, 83, 66, 67, 89, 91, 57, 59, 97, 100, 49, 52, 104, 108, 40, 44, 112, 117, 32, 37,     125,     29,             22,             14,              7                                                                                                 ],
	[ 83, 84, 67, 68, 90, 92, 58, 60, 98, 101, 50, 53, 105, 109, 41, 45, 113, 118, 33, 38, 120, 126, 24, 30,         16, 23,             15                                                                                                                 ],
	[ 84, 85, 68, 69, 91, 93, 59, 61, 99, 102, 51, 54, 106, 110, 42, 46, 114, 119, 34, 39, 121, 127, 25, 31,         17,              8,              0                                                                                                     ],
	[ 85, 86, 69, 70, 92, 94, 60, 62, 100, 103, 52, 55, 107, 111, 43, 47, 115,     35,     122,     26,             18,              9,              1                                                                                                     ],
	[ 86, 87, 70, 71, 93, 95, 61, 63, 101,     53,     108,     44,     116,     36,     123,     27,             19,             10,              2                                                                                                     ],
	[ 87,     71,     94,     62,     102,     54,     109,     45,     117,     37,     124,     28,             20,             11,              3                                                                                                     ],
	[     88,     72,     97,     65,     105,     57,     114,     50,     122,     42,             35,             27,             20,             12,              5                                                                                 ],
	[ 88, 89, 72, 73, 96, 98, 64, 66,     106,     58,     115,     51,     123,     43,             36,             28,             21,             13,              6                                                                                 ],
	[ 89, 90, 73, 74, 97, 99, 65, 67, 104, 107, 56, 59, 112, 116, 48, 52,     124,     44,             37,             29,             22,             14,              7                                                                                 ],
	[ 90, 91, 74, 75, 98, 100, 66, 68, 105, 108, 57, 60, 113, 117, 49, 53, 120, 125, 40, 45,         32, 38,             30,             23,             15                                                                                                 ],
	[ 91, 92, 75, 76, 99, 101, 67, 69, 106, 109, 58, 61, 114, 118, 50, 54, 121, 126, 41, 46,         33, 39,         24, 31,         16                                                                                                                     ],
	[ 92, 93, 76, 77, 100, 102, 68, 70, 107, 110, 59, 62, 115, 119, 51, 55, 122, 127, 42, 47,         34,             25,             17,              8,              0                                                                                     ],
	[ 93, 94, 77, 78, 101, 103, 69, 71, 108, 111, 60, 63, 116,     52,     123,     43,             35,             26,             18,              9,              1                                                                                     ],
	[ 94, 95, 78, 79, 102,     70,     109,     61,     117,     53,     124,     44,             36,             27,             19,             10,              2                                                                                     ],
	[ 96, 97, 80, 81,     105,     73,     114,     66,     122,     58,             51,             43,             36,             28,             21,             13,              6                                                                 ],
	[ 97, 98, 81, 82, 104, 106, 72, 74, 112, 115, 64, 67,     123,     59,             52,             44,             37,             29,             22,             14,              7                                                                 ],
	[ 98, 99, 82, 83, 105, 107, 73, 75, 113, 116, 65, 68, 120, 124, 56, 60,         48, 53,             45,             38,             30,             23,             15                                                                                 ],
	[ 99, 100, 83, 84, 106, 108, 74, 76, 114, 117, 66, 69, 121, 125, 57, 61,         49, 54,         40, 46,         32, 39,             31                                                                                                                 ],
	[ 100, 101, 84, 85, 107, 109, 75, 77, 115, 118, 67, 70, 122, 126, 58, 62,         50, 55,         41, 47,         33,             24,             16                                                                                                     ],
	[ 101, 102, 85, 86, 108, 110, 76, 78, 116, 119, 68, 71, 123, 127, 59, 63,         51,             42,             34,             25,             17,              8,              0                                                                     ],
	[ 102, 103, 86, 87, 109, 111, 77, 79, 117,     69,     124,     60,             52,             43,             35,             26,             18,              9,              1                                                                     ],
	[ 103,     87,     110,     78,     118,     70,     125,     61,             53,             44,             36,             27,             19,             10,              2                                                                     ],
	[     104,     88,     113,     81,     121,     73,             66,             58,             51,             43,             36,             28,             21,             13,              6                                                 ],
	[ 104, 105, 88, 89, 112, 114, 80, 82,     122,     74,             67,             59,             52,             44,             37,             29,             22,             14,              7                                                 ],
	[ 105, 106, 89, 90, 113, 115, 81, 83, 120, 123, 72, 75,         64, 68,             60,             53,             45,             38,             30,             23,             15                                                                 ],
	[ 106, 107, 90, 91, 114, 116, 82, 84, 121, 124, 73, 76,         65, 69,         56, 61,         48, 54,             46,             39,             31                                                                                                 ],
	[ 107, 108, 91, 92, 115, 117, 83, 85, 122, 125, 74, 77,         66, 70,         57, 62,         49, 55,         40, 47,         32                                                                                                                     ],
	[ 108, 109, 92, 93, 116, 118, 84, 86, 123, 126, 75, 78,         67, 71,         58, 63,         50,             41,             33,             24,             16                                                                                     ],
	[ 109, 110, 93, 94, 117, 119, 85, 87, 124, 127, 76, 79,         68,             59,             51,             42,             34,             25,             17,              8,              0                                                     ],
	[ 110, 111, 94, 95, 118,     86,     125,     77,             69,             60,             52,             43,             35,             26,             18,              9,              1                                                     ],
	[ 112, 113, 96, 97,     121,     89,             82,             74,             67,             59,             52,             44,             37,             29,             22,             14,              7                                 ],
	[ 113, 114, 97, 98, 120, 122, 88, 90,         80, 83,             75,             68,             60,             53,             45,             38,             30,             23,             15                                                 ],
	[ 114, 115, 98, 99, 121, 123, 89, 91,         81, 84,         72, 76,         64, 69,             61,             54,             46,             39,             31                                                                                 ],
	[ 115, 116, 99, 100, 122, 124, 90, 92,         82, 85,         73, 77,         65, 70,         56, 62,         48, 55,             47                                                                                                                 ],
	[ 116, 117, 100, 101, 123, 125, 91, 93,         83, 86,         74, 78,         66, 71,         57, 63,         49,             40,             32                                                                                                     ],
	[ 117, 118, 101, 102, 124, 126, 92, 94,         84, 87,         75, 79,         67,             58,             50,             41,             33,             24,             16                                                                     ],
	[ 118, 119, 102, 103, 125, 127, 93, 95,         85,             76,             68,             59,             51,             42,             34,             25,             17,              8,              0                                     ],
	[ 119,     103,     126,     94,             86,             77,             69,             60,             52,             43,             35,             26,             18,              9,              1                                     ],
	[     120,     104,             97,             89,             82,             74,             67,             59,             52,             44,             37,             29,             22,             14,              7                 ],
	[ 120, 121, 104, 105,         96, 98,             90,             83,             75,             68,             60,             53,             45,             38,             30,             23,             15                                 ],
	[ 121, 122, 105, 106,         97, 99,         88, 91,         80, 84,             76,             69,             61,             54,             46,             39,             31                                                                 ],
	[ 122, 123, 106, 107,         98, 100,         89, 92,         81, 85,         72, 77,         64, 70,             62,             55,             47                                                                                                 ],
	[ 123, 124, 107, 108,         99, 101,         90, 93,         82, 86,         73, 78,         65, 71,         56, 63,         48                                                                                                                     ],
	[ 124, 125, 108, 109,         100, 102,         91, 94,         83, 87,         74, 79,         66,             57,             49,             40,             32                                                                                     ],
	[ 125, 126, 109, 110,         101, 103,         92, 95,         84,             75,             67,             58,             50,             41,             33,             24,             16                                                     ],
	[ 126, 127, 110, 111,         102,             93,             85,             76,             68,             59,             51,             42,             34,             25,             17,              8,              0                     ],
	[         112, 113,             105,             98,             90,             83,             75,             68,             60,             53,             45,             38,             30,             23,             15                 ],
	[         113, 114,         104, 106,         96, 99,             91,             84,             76,             69,             61,             54,             46,             39,             31                                                 ],
	[         114, 115,         105, 107,         97, 100,         88, 92,         80, 85,             77,             70,             62,             55,             47                                                                                 ],
	[         115, 116,         106, 108,         98, 101,         89, 93,         81, 86,         72, 78,         64, 71,             63                                                                                                                 ],
	[         116, 117,         107, 109,         99, 102,         90, 94,         82, 87,         73, 79,         65,             56,             48                                                                                                     ],
	[         117, 118,         108, 110,         100, 103,         91, 95,         83,             74,             66,             57,             49,             40,             32                                                                     ],
	[         118, 119,         109, 111,         101,             92,             84,             75,             67,             58,             50,             41,             33,             24,             16                                     ],
	[         119,             110,             102,             93,             85,             76,             68,             59,             51,             42,             34,             25,             17,              8,              0     ],
];

use constant king_beat => [
	[     17,             25,             34,             42,             51,             59,             68,             76,             85,             93,             102,             110,             119,             127         ],
	[ 16, 18,             26,             35,             43,             52,             60,             69,             77,             86,             94,             103,             111                                         ],
	[ 17, 19,         24, 27,         32, 36,             44,             53,             61,             70,             78,             87,             95                                                                         ],
	[ 18, 20,         25, 28,         33, 37,         40, 45,         48, 54,             62,             71,             79                                                                                                         ],
	[ 19, 21,         26, 29,         34, 38,         41, 46,         49, 55,         56, 63,         64                                                                                                                             ],
	[ 20, 22,         27, 30,         35, 39,         42, 47,         50,             57,             65,             72,             80                                                                                             ],
	[ 21, 23,         28, 31,         36,             43,             51,             58,             66,             73,             81,             88,             96                                                             ],
	[ 22,             29,             37,             44,             52,             59,             67,             74,             82,             89,             97,             104,             112                             ],
	[     25,             34,             42,             51,             59,             68,             76,             85,             93,             102,             110,             119,             127                         ],
	[ 24, 26,         32, 35,             43,             52,             60,             69,             77,             86,             94,             103,             111                                                         ],
	[ 25, 27,         33, 36,         40, 44,         48, 53,             61,             70,             78,             87,             95                                                                                         ],
	[ 26, 28,         34, 37,         41, 45,         49, 54,         56, 62,         64, 71,             79                                                                                                                         ],
	[ 27, 29,         35, 38,         42, 46,         50, 55,         57, 63,         65,             72,             80                                                                                                             ],
	[ 28, 30,         36, 39,         43, 47,         51,             58,             66,             73,             81,             88,             96                                                                             ],
	[ 29, 31,         37,             44,             52,             59,             67,             74,             82,             89,             97,             104,             112                                             ],
	[ 30,             38,             45,             53,             60,             68,             75,             83,             90,             98,             105,             113,             120                             ],
	[     33,      1,     41,             50,             58,             67,             75,             84,             92,             101,             109,             118,             126                                         ],
	[ 32, 34,  0,  2,     42,             51,             59,             68,             76,             85,             93,             102,             110,             119,             127                                         ],
	[ 33, 35,  1,  3, 40, 43,         48, 52,             60,             69,             77,             86,             94,             103,             111                                                                         ],
	[ 34, 36,  2,  4, 41, 44,         49, 53,         56, 61,         64, 70,             78,             87,             95                                                                                                         ],
	[ 35, 37,  3,  5, 42, 45,         50, 54,         57, 62,         65, 71,         72, 79,         80                                                                                                                             ],
	[ 36, 38,  4,  6, 43, 46,         51, 55,         58, 63,         66,             73,             81,             88,             96                                                                                             ],
	[ 37, 39,  5,  7, 44, 47,         52,             59,             67,             74,             82,             89,             97,             104,             112                                                             ],
	[ 38,      6,     45,             53,             60,             68,             75,             83,             90,             98,             105,             113,             120                                             ],
	[     41,      9,     50,      2,     58,             67,             75,             84,             92,             101,             109,             118,             126                                                         ],
	[ 40, 42,  8, 10, 48, 51,  0,  3,     59,             68,             76,             85,             93,             102,             110,             119,             127                                                         ],
	[ 41, 43,  9, 11, 49, 52,  1,  4, 56, 60,         64, 69,             77,             86,             94,             103,             111                                                                                         ],
	[ 42, 44, 10, 12, 50, 53,  2,  5, 57, 61,         65, 70,         72, 78,         80, 87,             95                                                                                                                         ],
	[ 43, 45, 11, 13, 51, 54,  3,  6, 58, 62,         66, 71,         73, 79,         81,             88,             96                                                                                                             ],
	[ 44, 46, 12, 14, 52, 55,  4,  7, 59, 63,         67,             74,             82,             89,             97,             104,             112                                                                             ],
	[ 45, 47, 13, 15, 53,      5,     60,             68,             75,             83,             90,             98,             105,             113,             120                                                             ],
	[ 46,     14,     54,      6,     61,             69,             76,             84,             91,             99,             106,             114,             121                                                             ],
	[     49,     17,     57,      9,     66,      2,     74,             83,             91,             100,             108,             117,             125                                                                         ],
	[ 48, 50, 16, 18,     58,     10,     67,      3,     75,             84,             92,             101,             109,             118,             126                                                                         ],
	[ 49, 51, 17, 19, 56, 59,  8, 11, 64, 68,  0,  4,     76,             85,             93,             102,             110,             119,             127                                                                         ],
	[ 50, 52, 18, 20, 57, 60,  9, 12, 65, 69,  1,  5, 72, 77,         80, 86,             94,             103,             111                                                                                                         ],
	[ 51, 53, 19, 21, 58, 61, 10, 13, 66, 70,  2,  6, 73, 78,         81, 87,         88, 95,         96                                                                                                                             ],
	[ 52, 54, 20, 22, 59, 62, 11, 14, 67, 71,  3,  7, 74, 79,         82,             89,             97,             104,             112                                                                                             ],
	[ 53, 55, 21, 23, 60, 63, 12, 15, 68,      4,     75,             83,             90,             98,             105,             113,             120                                                                             ],
	[ 54,     22,     61,     13,     69,      5,     76,             84,             91,             99,             106,             114,             121                                                                             ],
	[     57,     25,     66,     18,     74,     10,     83,      3,     91,             100,             108,             117,             125                                                                                         ],
	[ 56, 58, 24, 26, 64, 67, 16, 19,     75,     11,     84,      4,     92,             101,             109,             118,             126                                                                                         ],
	[ 57, 59, 25, 27, 65, 68, 17, 20, 72, 76,  8, 12, 80, 85,  0,  5,     93,             102,             110,             119,             127                                                                                         ],
	[ 58, 60, 26, 28, 66, 69, 18, 21, 73, 77,  9, 13, 81, 86,  1,  6, 88, 94,         96, 103,             111                                                                                                                         ],
	[ 59, 61, 27, 29, 67, 70, 19, 22, 74, 78, 10, 14, 82, 87,  2,  7, 89, 95,         97,             104,             112                                                                                                             ],
	[ 60, 62, 28, 30, 68, 71, 20, 23, 75, 79, 11, 15, 83,      3,     90,             98,             105,             113,             120                                                                                             ],
	[ 61, 63, 29, 31, 69,     21,     76,     12,     84,      4,     91,             99,             106,             114,             121                                                                                             ],
	[ 62,     30,     70,     22,     77,     13,     85,      5,     92,             100,             107,             115,             122                                                                                             ],
	[     65,     33,     73,     25,     82,     18,     90,     10,     99,      3,     107,             116,             124                                                                                                         ],
	[ 64, 66, 32, 34,     74,     26,     83,     19,     91,     11,     100,      4,     108,             117,             125                                                                                                         ],
	[ 65, 67, 33, 35, 72, 75, 24, 27, 80, 84, 16, 20,     92,     12,     101,      5,     109,             118,             126                                                                                                         ],
	[ 66, 68, 34, 36, 73, 76, 25, 28, 81, 85, 17, 21, 88, 93,  8, 13, 96, 102,  0,  6,     110,             119,             127                                                                                                         ],
	[ 67, 69, 35, 37, 74, 77, 26, 29, 82, 86, 18, 22, 89, 94,  9, 14, 97, 103,  1,  7, 104, 111,         112                                                                                                                             ],
	[ 68, 70, 36, 38, 75, 78, 27, 30, 83, 87, 19, 23, 90, 95, 10, 15, 98,      2,     105,             113,             120                                                                                                             ],
	[ 69, 71, 37, 39, 76, 79, 28, 31, 84,     20,     91,     11,     99,      3,     106,             114,             121                                                                                                             ],
	[ 70,     38,     77,     29,     85,     21,     92,     12,     100,      4,     107,             115,             122                                                                                                             ],
	[     73,     41,     82,     34,     90,     26,     99,     19,     107,     11,     116,      4,     124                                                                                                                         ],
	[ 72, 74, 40, 42, 80, 83, 32, 35,     91,     27,     100,     20,     108,     12,     117,      5,     125                                                                                                                         ],
	[ 73, 75, 41, 43, 81, 84, 33, 36, 88, 92, 24, 28, 96, 101, 16, 21,     109,     13,     118,      6,     126                                                                                                                         ],
	[ 74, 76, 42, 44, 82, 85, 34, 37, 89, 93, 25, 29, 97, 102, 17, 22, 104, 110,  8, 14, 112, 119,  0,  7,     127                                                                                                                         ],
	[ 75, 77, 43, 45, 83, 86, 35, 38, 90, 94, 26, 30, 98, 103, 18, 23, 105, 111,  9, 15, 113,      1,     120                                                                                                                             ],
	[ 76, 78, 44, 46, 84, 87, 36, 39, 91, 95, 27, 31, 99,     19,     106,     10,     114,      2,     121                                                                                                                             ],
	[ 77, 79, 45, 47, 85,     37,     92,     28,     100,     20,     107,     11,     115,      3,     122                                                                                                                             ],
	[ 78,     46,     86,     38,     93,     29,     101,     21,     108,     12,     116,      4,     123                                                                                                                             ],
	[     81,     49,     89,     41,     98,     34,     106,     26,     115,     19,     123,     11,              4                                                                                                                 ],
	[ 80, 82, 48, 50,     90,     42,     99,     35,     107,     27,     116,     20,     124,     12,              5                                                                                                                 ],
	[ 81, 83, 49, 51, 88, 91, 40, 43, 96, 100, 32, 36,     108,     28,     117,     21,     125,     13,              6                                                                                                                 ],
	[ 82, 84, 50, 52, 89, 92, 41, 44, 97, 101, 33, 37, 104, 109, 24, 29, 112, 118, 16, 22,     126,     14,              7                                                                                                                 ],
	[ 83, 85, 51, 53, 90, 93, 42, 45, 98, 102, 34, 38, 105, 110, 25, 30, 113, 119, 17, 23, 120, 127,  8, 15,          0                                                                                                                     ],
	[ 84, 86, 52, 54, 91, 94, 43, 46, 99, 103, 35, 39, 106, 111, 26, 31, 114,     18,     121,      9,              1                                                                                                                     ],
	[ 85, 87, 53, 55, 92, 95, 44, 47, 100,     36,     107,     27,     115,     19,     122,     10,              2                                                                                                                     ],
	[ 86,     54,     93,     45,     101,     37,     108,     28,     116,     20,     123,     11,              3                                                                                                                     ],
	[     89,     57,     98,     50,     106,     42,     115,     35,     123,     27,             20,             12,              5                                                                                                 ],
	[ 88, 90, 56, 58, 96, 99, 48, 51,     107,     43,     116,     36,     124,     28,             21,             13,              6                                                                                                 ],
	[ 89, 91, 57, 59, 97, 100, 49, 52, 104, 108, 40, 44, 112, 117, 32, 37,     125,     29,             22,             14,              7                                                                                                 ],
	[ 90, 92, 58, 60, 98, 101, 50, 53, 105, 109, 41, 45, 113, 118, 33, 38, 120, 126, 24, 30,         16, 23,             15                                                                                                                 ],
	[ 91, 93, 59, 61, 99, 102, 51, 54, 106, 110, 42, 46, 114, 119, 34, 39, 121, 127, 25, 31,         17,              8,              0                                                                                                     ],
	[ 92, 94, 60, 62, 100, 103, 52, 55, 107, 111, 43, 47, 115,     35,     122,     26,             18,              9,              1                                                                                                     ],
	[ 93, 95, 61, 63, 101,     53,     108,     44,     116,     36,     123,     27,             19,             10,              2                                                                                                     ],
	[ 94,     62,     102,     54,     109,     45,     117,     37,     124,     28,             20,             11,              3                                                                                                     ],
	[     97,     65,     105,     57,     114,     50,     122,     42,             35,             27,             20,             12,              5                                                                                 ],
	[ 96, 98, 64, 66,     106,     58,     115,     51,     123,     43,             36,             28,             21,             13,              6                                                                                 ],
	[ 97, 99, 65, 67, 104, 107, 56, 59, 112, 116, 48, 52,     124,     44,             37,             29,             22,             14,              7                                                                                 ],
	[ 98, 100, 66, 68, 105, 108, 57, 60, 113, 117, 49, 53, 120, 125, 40, 45,         32, 38,             30,             23,             15                                                                                                 ],
	[ 99, 101, 67, 69, 106, 109, 58, 61, 114, 118, 50, 54, 121, 126, 41, 46,         33, 39,         24, 31,         16                                                                                                                     ],
	[ 100, 102, 68, 70, 107, 110, 59, 62, 115, 119, 51, 55, 122, 127, 42, 47,         34,             25,             17,              8,              0                                                                                     ],
	[ 101, 103, 69, 71, 108, 111, 60, 63, 116,     52,     123,     43,             35,             26,             18,              9,              1                                                                                     ],
	[ 102,     70,     109,     61,     117,     53,     124,     44,             36,             27,             19,             10,              2                                                                                     ],
	[     105,     73,     114,     66,     122,     58,             51,             43,             36,             28,             21,             13,              6                                                                 ],
	[ 104, 106, 72, 74, 112, 115, 64, 67,     123,     59,             52,             44,             37,             29,             22,             14,              7                                                                 ],
	[ 105, 107, 73, 75, 113, 116, 65, 68, 120, 124, 56, 60,         48, 53,             45,             38,             30,             23,             15                                                                                 ],
	[ 106, 108, 74, 76, 114, 117, 66, 69, 121, 125, 57, 61,         49, 54,         40, 46,         32, 39,             31                                                                                                                 ],
	[ 107, 109, 75, 77, 115, 118, 67, 70, 122, 126, 58, 62,         50, 55,         41, 47,         33,             24,             16                                                                                                     ],
	[ 108, 110, 76, 78, 116, 119, 68, 71, 123, 127, 59, 63,         51,             42,             34,             25,             17,              8,              0                                                                     ],
	[ 109, 111, 77, 79, 117,     69,     124,     60,             52,             43,             35,             26,             18,              9,              1                                                                     ],
	[ 110,     78,     118,     70,     125,     61,             53,             44,             36,             27,             19,             10,              2                                                                     ],
	[     113,     81,     121,     73,             66,             58,             51,             43,             36,             28,             21,             13,              6                                                 ],
	[ 112, 114, 80, 82,     122,     74,             67,             59,             52,             44,             37,             29,             22,             14,              7                                                 ],
	[ 113, 115, 81, 83, 120, 123, 72, 75,         64, 68,             60,             53,             45,             38,             30,             23,             15                                                                 ],
	[ 114, 116, 82, 84, 121, 124, 73, 76,         65, 69,         56, 61,         48, 54,             46,             39,             31                                                                                                 ],
	[ 115, 117, 83, 85, 122, 125, 74, 77,         66, 70,         57, 62,         49, 55,         40, 47,         32                                                                                                                     ],
	[ 116, 118, 84, 86, 123, 126, 75, 78,         67, 71,         58, 63,         50,             41,             33,             24,             16                                                                                     ],
	[ 117, 119, 85, 87, 124, 127, 76, 79,         68,             59,             51,             42,             34,             25,             17,              8,              0                                                     ],
	[ 118,     86,     125,     77,             69,             60,             52,             43,             35,             26,             18,              9,              1                                                     ],
	[     121,     89,             82,             74,             67,             59,             52,             44,             37,             29,             22,             14,              7                                 ],
	[ 120, 122, 88, 90,         80, 83,             75,             68,             60,             53,             45,             38,             30,             23,             15                                                 ],
	[ 121, 123, 89, 91,         81, 84,         72, 76,         64, 69,             61,             54,             46,             39,             31                                                                                 ],
	[ 122, 124, 90, 92,         82, 85,         73, 77,         65, 70,         56, 62,         48, 55,             47                                                                                                                 ],
	[ 123, 125, 91, 93,         83, 86,         74, 78,         66, 71,         57, 63,         49,             40,             32                                                                                                     ],
	[ 124, 126, 92, 94,         84, 87,         75, 79,         67,             58,             50,             41,             33,             24,             16                                                                     ],
	[ 125, 127, 93, 95,         85,             76,             68,             59,             51,             42,             34,             25,             17,              8,              0                                     ],
	[ 126,     94,             86,             77,             69,             60,             52,             43,             35,             26,             18,              9,              1                                     ],
	[             97,             89,             82,             74,             67,             59,             52,             44,             37,             29,             22,             14,              7                 ],
	[         96, 98,             90,             83,             75,             68,             60,             53,             45,             38,             30,             23,             15                                 ],
	[         97, 99,         88, 91,         80, 84,             76,             69,             61,             54,             46,             39,             31                                                                 ],
	[         98, 100,         89, 92,         81, 85,         72, 77,         64, 70,             62,             55,             47                                                                                                 ],
	[         99, 101,         90, 93,         82, 86,         73, 78,         65, 71,         56, 63,         48                                                                                                                     ],
	[         100, 102,         91, 94,         83, 87,         74, 79,         66,             57,             49,             40,             32                                                                                     ],
	[         101, 103,         92, 95,         84,             75,             67,             58,             50,             41,             33,             24,             16                                                     ],
	[         102,             93,             85,             76,             68,             59,             51,             42,             34,             25,             17,              8,              0                     ],
	[             105,             98,             90,             83,             75,             68,             60,             53,             45,             38,             30,             23,             15                 ],
	[         104, 106,         96, 99,             91,             84,             76,             69,             61,             54,             46,             39,             31                                                 ],
	[         105, 107,         97, 100,         88, 92,         80, 85,             77,             70,             62,             55,             47                                                                                 ],
	[         106, 108,         98, 101,         89, 93,         81, 86,         72, 78,         64, 71,             63                                                                                                                 ],
	[         107, 109,         99, 102,         90, 94,         82, 87,         73, 79,         65,             56,             48                                                                                                     ],
	[         108, 110,         100, 103,         91, 95,         83,             74,             66,             57,             49,             40,             32                                                                     ],
	[         109, 111,         101,             92,             84,             75,             67,             58,             50,             41,             33,             24,             16                                     ],
	[         110,             102,             93,             85,             76,             68,             59,             51,             42,             34,             25,             17,              8,              0     ],
];

use constant king_step_short => [
	[      8         ], [  8,  9         ], [  9, 10         ], [ 10, 11         ], [ 11, 12         ], [ 12, 13         ], [ 13, 14         ], [ 14, 15         ],
	[ 16, 17,  0,  1 ], [ 17, 18,  1,  2 ], [ 18, 19,  2,  3 ], [ 19, 20,  3,  4 ], [ 20, 21,  4,  5 ], [ 21, 22,  5,  6 ], [ 22, 23,  6,  7 ], [ 23,      7     ],
	[     24,      8 ], [ 24, 25,  8,  9 ], [ 25, 26,  9, 10 ], [ 26, 27, 10, 11 ], [ 27, 28, 11, 12 ], [ 28, 29, 12, 13 ], [ 29, 30, 13, 14 ], [ 30, 31, 14, 15 ],
	[ 32, 33, 16, 17 ], [ 33, 34, 17, 18 ], [ 34, 35, 18, 19 ], [ 35, 36, 19, 20 ], [ 36, 37, 20, 21 ], [ 37, 38, 21, 22 ], [ 38, 39, 22, 23 ], [ 39,     23     ],
	[     40,     24 ], [ 40, 41, 24, 25 ], [ 41, 42, 25, 26 ], [ 42, 43, 26, 27 ], [ 43, 44, 27, 28 ], [ 44, 45, 28, 29 ], [ 45, 46, 29, 30 ], [ 46, 47, 30, 31 ],
	[ 48, 49, 32, 33 ], [ 49, 50, 33, 34 ], [ 50, 51, 34, 35 ], [ 51, 52, 35, 36 ], [ 52, 53, 36, 37 ], [ 53, 54, 37, 38 ], [ 54, 55, 38, 39 ], [ 55,     39     ],
	[     56,     40 ], [ 56, 57, 40, 41 ], [ 57, 58, 41, 42 ], [ 58, 59, 42, 43 ], [ 59, 60, 43, 44 ], [ 60, 61, 44, 45 ], [ 61, 62, 45, 46 ], [ 62, 63, 46, 47 ],
	[ 64, 65, 48, 49 ], [ 65, 66, 49, 50 ], [ 66, 67, 50, 51 ], [ 67, 68, 51, 52 ], [ 68, 69, 52, 53 ], [ 69, 70, 53, 54 ], [ 70, 71, 54, 55 ], [ 71,     55     ],
	[     72,     56 ], [ 72, 73, 56, 57 ], [ 73, 74, 57, 58 ], [ 74, 75, 58, 59 ], [ 75, 76, 59, 60 ], [ 76, 77, 60, 61 ], [ 77, 78, 61, 62 ], [ 78, 79, 62, 63 ],
	[ 80, 81, 64, 65 ], [ 81, 82, 65, 66 ], [ 82, 83, 66, 67 ], [ 83, 84, 67, 68 ], [ 84, 85, 68, 69 ], [ 85, 86, 69, 70 ], [ 86, 87, 70, 71 ], [ 87,     71     ],
	[     88,     72 ], [ 88, 89, 72, 73 ], [ 89, 90, 73, 74 ], [ 90, 91, 74, 75 ], [ 91, 92, 75, 76 ], [ 92, 93, 76, 77 ], [ 93, 94, 77, 78 ], [ 94, 95, 78, 79 ],
	[ 96, 97, 80, 81 ], [ 97, 98, 81, 82 ], [ 98, 99, 82, 83 ], [ 99, 100, 83, 84 ], [ 100, 101, 84, 85 ], [ 101, 102, 85, 86 ], [ 102, 103, 86, 87 ], [ 103,     87     ],
	[     104,     88 ], [ 104, 105, 88, 89 ], [ 105, 106, 89, 90 ], [ 106, 107, 90, 91 ], [ 107, 108, 91, 92 ], [ 108, 109, 92, 93 ], [ 109, 110, 93, 94 ], [ 110, 111, 94, 95 ],
	[ 112, 113, 96, 97 ], [ 113, 114, 97, 98 ], [ 114, 115, 98, 99 ], [ 115, 116, 99, 100 ], [ 116, 117, 100, 101 ], [ 117, 118, 101, 102 ], [ 118, 119, 102, 103 ], [ 119,     103     ],
	[     120,     104 ], [ 120, 121, 104, 105 ], [ 121, 122, 105, 106 ], [ 122, 123, 106, 107 ], [ 123, 124, 107, 108 ], [ 124, 125, 108, 109 ], [ 125, 126, 109, 110 ], [ 126, 127, 110, 111 ],
	[         112, 113 ], [         113, 114 ], [         114, 115 ], [         115, 116 ], [         116, 117 ], [         117, 118 ], [         118, 119 ], [         119     ],
];

use constant king_beat_short => [
	[     17         ], [ 16, 18         ], [ 17, 19         ], [ 18, 20         ], [ 19, 21         ], [ 20, 22         ], [ 21, 23         ], [ 22             ],
	[     25         ], [ 24, 26         ], [ 25, 27         ], [ 26, 28         ], [ 27, 29         ], [ 28, 30         ], [ 29, 31         ], [ 30             ],
	[     33,      1 ], [ 32, 34,  0,  2 ], [ 33, 35,  1,  3 ], [ 34, 36,  2,  4 ], [ 35, 37,  3,  5 ], [ 36, 38,  4,  6 ], [ 37, 39,  5,  7 ], [ 38,      6     ],
	[     41,      9 ], [ 40, 42,  8, 10 ], [ 41, 43,  9, 11 ], [ 42, 44, 10, 12 ], [ 43, 45, 11, 13 ], [ 44, 46, 12, 14 ], [ 45, 47, 13, 15 ], [ 46,     14     ],
	[     49,     17 ], [ 48, 50, 16, 18 ], [ 49, 51, 17, 19 ], [ 50, 52, 18, 20 ], [ 51, 53, 19, 21 ], [ 52, 54, 20, 22 ], [ 53, 55, 21, 23 ], [ 54,     22     ],
	[     57,     25 ], [ 56, 58, 24, 26 ], [ 57, 59, 25, 27 ], [ 58, 60, 26, 28 ], [ 59, 61, 27, 29 ], [ 60, 62, 28, 30 ], [ 61, 63, 29, 31 ], [ 62,     30     ],
	[     65,     33 ], [ 64, 66, 32, 34 ], [ 65, 67, 33, 35 ], [ 66, 68, 34, 36 ], [ 67, 69, 35, 37 ], [ 68, 70, 36, 38 ], [ 69, 71, 37, 39 ], [ 70,     38     ],
	[     73,     41 ], [ 72, 74, 40, 42 ], [ 73, 75, 41, 43 ], [ 74, 76, 42, 44 ], [ 75, 77, 43, 45 ], [ 76, 78, 44, 46 ], [ 77, 79, 45, 47 ], [ 78,     46     ],
	[     81,     49 ], [ 80, 82, 48, 50 ], [ 81, 83, 49, 51 ], [ 82, 84, 50, 52 ], [ 83, 85, 51, 53 ], [ 84, 86, 52, 54 ], [ 85, 87, 53, 55 ], [ 86,     54     ],
	[     89,     57 ], [ 88, 90, 56, 58 ], [ 89, 91, 57, 59 ], [ 90, 92, 58, 60 ], [ 91, 93, 59, 61 ], [ 92, 94, 60, 62 ], [ 93, 95, 61, 63 ], [ 94,     62     ],
	[     97,     65 ], [ 96, 98, 64, 66 ], [ 97, 99, 65, 67 ], [ 98, 100, 66, 68 ], [ 99, 101, 67, 69 ], [ 100, 102, 68, 70 ], [ 101, 103, 69, 71 ], [ 102,     70     ],
	[     105,     73 ], [ 104, 106, 72, 74 ], [ 105, 107, 73, 75 ], [ 106, 108, 74, 76 ], [ 107, 109, 75, 77 ], [ 108, 110, 76, 78 ], [ 109, 111, 77, 79 ], [ 110,     78     ],
	[     113,     81 ], [ 112, 114, 80, 82 ], [ 113, 115, 81, 83 ], [ 114, 116, 82, 84 ], [ 115, 117, 83, 85 ], [ 116, 118, 84, 86 ], [ 117, 119, 85, 87 ], [ 118,     86     ],
	[     121,     89 ], [ 120, 122, 88, 90 ], [ 121, 123, 89, 91 ], [ 122, 124, 90, 92 ], [ 123, 125, 91, 93 ], [ 124, 126, 92, 94 ], [ 125, 127, 93, 95 ], [ 126,     94     ],
	[             97 ], [         96, 98 ], [         97, 99 ], [         98, 100 ], [         99, 101 ], [         100, 102 ], [         101, 103 ], [         102     ],
	[             105 ], [         104, 106 ], [         105, 107 ], [         106, 108 ], [         107, 109 ], [         108, 110 ], [         109, 111 ], [         110     ],
];

use constant king_beat_8dirs => [
	[     17,                 32,  2,     25,                 48,  3,     34,                 64,  4,     42,                 80,  5,     51,                 96,  6,     59,                 112,  7,     68,                             76,                             85,                             93,                             102,                             110,                             119,                             127                         ],
	[ 16, 18,                 33,  3,     26,                 49,  4,     35,                 65,  5,     43,                 81,  6,     52,                 97,  7,     60,                 113,         69,                             77,                             86,                             94,                             103,                             111                                                                                         ],
	[ 17, 19,              0, 34,  4, 24, 27,                 50,  5, 32, 36,                 66,  6,     44,                 82,  7,     53,                 98,         61,                 114,         70,                             78,                             87,                             95                                                                                                                                                         ],
	[ 18, 20,              1, 35,  5, 25, 28,              0, 51,  6, 33, 37,                 67,  7, 40, 45,                 83,     48, 54,                 99,         62,                 115,         71,                             79                                                                                                                                                                                                                         ],
	[ 19, 21,              2, 36,  6, 26, 29,              1, 52,  7, 34, 38,              0, 68,     41, 46,                 84,     49, 55,                 100,     56, 63,                 116,     64                                                                                                                                                                                                                                                             ],
	[ 20, 22,              3, 37,  7, 27, 30,              2, 53,     35, 39,              1, 69,     42, 47,              0, 85,     50,                     101,     57,                     117,     65,                             72,                             80                                                                                                                                                                                             ],
	[ 21, 23,              4, 38,     28, 31,              3, 54,     36,                  2, 70,     43,                  1, 86,     51,                  0, 102,     58,                     118,     66,                             73,                             81,                             88,                             96                                                                                                                             ],
	[ 22,                  5, 39,     29,                  4, 55,     37,                  3, 71,     44,                  2, 87,     52,                  1, 103,     59,                  0, 119,     67,                             74,                             82,                             89,                             97,                             104,                             112                                                             ],
	[     25,                 40, 10,     34,                 56, 11,     42,                 72, 12,     51,                 88, 13,     59,                 104, 14,     68,                 120, 15,     76,                             85,                             93,                             102,                             110,                             119,                             127                                                         ],
	[ 24, 26,                 41, 11, 32, 35,                 57, 12,     43,                 73, 13,     52,                 89, 14,     60,                 105, 15,     69,                 121,         77,                             86,                             94,                             103,                             111                                                                                                                         ],
	[ 25, 27,              8, 42, 12, 33, 36,                 58, 13, 40, 44,                 74, 14, 48, 53,                 90, 15,     61,                 106,         70,                 122,         78,                             87,                             95                                                                                                                                                                                         ],
	[ 26, 28,              9, 43, 13, 34, 37,              8, 59, 14, 41, 45,                 75, 15, 49, 54,                 91,     56, 62,                 107,     64, 71,                 123,         79                                                                                                                                                                                                                                                         ],
	[ 27, 29,             10, 44, 14, 35, 38,              9, 60, 15, 42, 46,              8, 76,     50, 55,                 92,     57, 63,                 108,     65,                     124,     72,                             80                                                                                                                                                                                                                             ],
	[ 28, 30,             11, 45, 15, 36, 39,             10, 61,     43, 47,              9, 77,     51,                  8, 93,     58,                     109,     66,                     125,     73,                             81,                             88,                             96                                                                                                                                                             ],
	[ 29, 31,             12, 46,     37,                 11, 62,     44,                 10, 78,     52,                  9, 94,     59,                  8, 110,     67,                     126,     74,                             82,                             89,                             97,                             104,                             112                                                                                             ],
	[ 30,                 13, 47,     38,                 12, 63,     45,                 11, 79,     53,                 10, 95,     60,                  9, 111,     68,                  8, 127,     75,                             83,                             90,                             98,                             105,                             113,                             120                                                             ],
	[     33,      1,         48, 18,     41,                 64, 19,     50,                 80, 20,     58,                 96, 21,     67,                 112, 22,     75,                     23,     84,                             92,                             101,                             109,                             118,                             126                                                                                         ],
	[ 32, 34,  0,  2,         49, 19,     42,                 65, 20,     51,                 81, 21,     59,                 97, 22,     68,                 113, 23,     76,                             85,                             93,                             102,                             110,                             119,                             127                                                                                         ],
	[ 33, 35,  1,  3,     16, 50, 20, 40, 43,                 66, 21, 48, 52,                 82, 22,     60,                 98, 23,     69,                 114,         77,                             86,                             94,                             103,                             111                                                                                                                                                         ],
	[ 34, 36,  2,  4,     17, 51, 21, 41, 44,             16, 67, 22, 49, 53,                 83, 23, 56, 61,                 99,     64, 70,                 115,         78,                             87,                             95                                                                                                                                                                                                                         ],
	[ 35, 37,  3,  5,     18, 52, 22, 42, 45,             17, 68, 23, 50, 54,             16, 84,     57, 62,                 100,     65, 71,                 116,     72, 79,                         80                                                                                                                                                                                                                                                             ],
	[ 36, 38,  4,  6,     19, 53, 23, 43, 46,             18, 69,     51, 55,             17, 85,     58, 63,             16, 101,     66,                     117,     73,                             81,                             88,                             96                                                                                                                                                                                             ],
	[ 37, 39,  5,  7,     20, 54,     44, 47,             19, 70,     52,                 18, 86,     59,                 17, 102,     67,                 16, 118,     74,                             82,                             89,                             97,                             104,                             112                                                                                                                             ],
	[ 38,      6,         21, 55,     45,                 20, 71,     53,                 19, 87,     60,                 18, 103,     68,                 17, 119,     75,                 16,         83,                             90,                             98,                             105,                             113,                             120                                                                                             ],
	[     41,      9,         56, 26,     50,      2,         72, 27,     58,                 88, 28,     67,                 104, 29,     75,                 120, 30,     84,                     31,     92,                             101,                             109,                             118,                             126                                                                                                                         ],
	[ 40, 42,  8, 10,         57, 27, 48, 51,  0,  3,         73, 28,     59,                 89, 29,     68,                 105, 30,     76,                 121, 31,     85,                             93,                             102,                             110,                             119,                             127                                                                                                                         ],
	[ 41, 43,  9, 11,     24, 58, 28, 49, 52,  1,  4,         74, 29, 56, 60,                 90, 30, 64, 69,                 106, 31,     77,                 122,         86,                             94,                             103,                             111                                                                                                                                                                                         ],
	[ 42, 44, 10, 12,     25, 59, 29, 50, 53,  2,  5,     24, 75, 30, 57, 61,                 91, 31, 65, 70,                 107,     72, 78,                 123,     80, 87,                             95                                                                                                                                                                                                                                                         ],
	[ 43, 45, 11, 13,     26, 60, 30, 51, 54,  3,  6,     25, 76, 31, 58, 62,             24, 92,     66, 71,                 108,     73, 79,                 124,     81,                             88,                             96                                                                                                                                                                                                                             ],
	[ 44, 46, 12, 14,     27, 61, 31, 52, 55,  4,  7,     26, 77,     59, 63,             25, 93,     67,                 24, 109,     74,                     125,     82,                             89,                             97,                             104,                             112                                                                                                                                                             ],
	[ 45, 47, 13, 15,     28, 62,     53,      5,         27, 78,     60,                 26, 94,     68,                 25, 110,     75,                 24, 126,     83,                             90,                             98,                             105,                             113,                             120                                                                                                                             ],
	[ 46,     14,         29, 63,     54,      6,         28, 79,     61,                 27, 95,     69,                 26, 111,     76,                 25, 127,     84,                 24,         91,                             99,                             106,                             114,                             121                                                                                                                             ],
	[     49,     17,  0,     64, 34,     57,      9,         80, 35,     66,      2,         96, 36,     74,                 112, 37,     83,                     38,     91,                     39,     100,                             108,                             117,                             125                                                                                                                                                         ],
	[ 48, 50, 16, 18,  1,     65, 35,     58,     10,         81, 36,     67,      3,         97, 37,     75,                 113, 38,     84,                     39,     92,                             101,                             109,                             118,                             126                                                                                                                                                         ],
	[ 49, 51, 17, 19,  2, 32, 66, 36, 56, 59,  8, 11,         82, 37, 64, 68,  0,  4,         98, 38,     76,                 114, 39,     85,                             93,                             102,                             110,                             119,                             127                                                                                                                                                         ],
	[ 50, 52, 18, 20,  3, 33, 67, 37, 57, 60,  9, 12,     32, 83, 38, 65, 69,  1,  5,         99, 39, 72, 77,                 115,     80, 86,                             94,                             103,                             111                                                                                                                                                                                                                         ],
	[ 51, 53, 19, 21,  4, 34, 68, 38, 58, 61, 10, 13,     33, 84, 39, 66, 70,  2,  6,     32, 100,     73, 78,                 116,     81, 87,                         88, 95,                         96                                                                                                                                                                                                                                                             ],
	[ 52, 54, 20, 22,  5, 35, 69, 39, 59, 62, 11, 14,     34, 85,     67, 71,  3,  7,     33, 101,     74, 79,             32, 117,     82,                             89,                             97,                             104,                             112                                                                                                                                                                                             ],
	[ 53, 55, 21, 23,  6, 36, 70,     60, 63, 12, 15,     35, 86,     68,      4,         34, 102,     75,                 33, 118,     83,                 32,         90,                             98,                             105,                             113,                             120                                                                                                                                                             ],
	[ 54,     22,      7, 37, 71,     61,     13,         36, 87,     69,      5,         35, 103,     76,                 34, 119,     84,                 33,         91,                 32,         99,                             106,                             114,                             121                                                                                                                                                             ],
	[     57,     25,  8,     72, 42,     66,     18,         88, 43,     74,     10,         104, 44,     83,      3,         120, 45,     91,                     46,     100,                     47,     108,                             117,                             125                                                                                                                                                                                         ],
	[ 56, 58, 24, 26,  9,     73, 43, 64, 67, 16, 19,         89, 44,     75,     11,         105, 45,     84,      4,         121, 46,     92,                     47,     101,                             109,                             118,                             126                                                                                                                                                                                         ],
	[ 57, 59, 25, 27, 10, 40, 74, 44, 65, 68, 17, 20,         90, 45, 72, 76,  8, 12,         106, 46, 80, 85,  0,  5,         122, 47,     93,                             102,                             110,                             119,                             127                                                                                                                                                                                         ],
	[ 58, 60, 26, 28, 11, 41, 75, 45, 66, 69, 18, 21,     40, 91, 46, 73, 77,  9, 13,         107, 47, 81, 86,  1,  6,         123,     88, 94,                         96, 103,                             111                                                                                                                                                                                                                                                         ],
	[ 59, 61, 27, 29, 12, 42, 76, 46, 67, 70, 19, 22,     41, 92, 47, 74, 78, 10, 14,     40, 108,     82, 87,  2,  7,         124,     89, 95,                         97,                             104,                             112                                                                                                                                                                                                                             ],
	[ 60, 62, 28, 30, 13, 43, 77, 47, 68, 71, 20, 23,     42, 93,     75, 79, 11, 15,     41, 109,     83,      3,         40, 125,     90,                             98,                             105,                             113,                             120                                                                                                                                                                                             ],
	[ 61, 63, 29, 31, 14, 44, 78,     69,     21,         43, 94,     76,     12,         42, 110,     84,      4,         41, 126,     91,                 40,         99,                             106,                             114,                             121                                                                                                                                                                                             ],
	[ 62,     30,     15, 45, 79,     70,     22,         44, 95,     77,     13,         43, 111,     85,      5,         42, 127,     92,                 41,         100,                 40,         107,                             115,                             122                                                                                                                                                                                             ],
	[     65,     33, 16,     80, 50,     73,     25,  0,     96, 51,     82,     18,         112, 52,     90,     10,             53,     99,      3,             54,     107,                     55,     116,                             124                                                                                                                                                                                                                         ],
	[ 64, 66, 32, 34, 17,     81, 51,     74,     26,  1,     97, 52,     83,     19,         113, 53,     91,     11,             54,     100,      4,             55,     108,                             117,                             125                                                                                                                                                                                                                         ],
	[ 65, 67, 33, 35, 18, 48, 82, 52, 72, 75, 24, 27,  2,     98, 53, 80, 84, 16, 20,         114, 54,     92,     12,             55,     101,      5,                     109,                             118,                             126                                                                                                                                                                                                                         ],
	[ 66, 68, 34, 36, 19, 49, 83, 53, 73, 76, 25, 28,  3, 48, 99, 54, 81, 85, 17, 21,         115, 55, 88, 93,  8, 13,                 96, 102,  0,  6,                     110,                             119,                             127                                                                                                                                                                                                                         ],
	[ 67, 69, 35, 37, 20, 50, 84, 54, 74, 77, 26, 29,  4, 49, 100, 55, 82, 86, 18, 22,     48, 116,     89, 94,  9, 14,                 97, 103,  1,  7,                 104, 111,                         112                                                                                                                                                                                                                                                             ],
	[ 68, 70, 36, 38, 21, 51, 85, 55, 75, 78, 27, 30,  5, 50, 101,     83, 87, 19, 23,     49, 117,     90, 95, 10, 15,     48,         98,      2,                     105,                             113,                             120                                                                                                                                                                                                                             ],
	[ 69, 71, 37, 39, 22, 52, 86,     76, 79, 28, 31,  6, 51, 102,     84,     20,         50, 118,     91,     11,         49,         99,      3,         48,         106,                             114,                             121                                                                                                                                                                                                                             ],
	[ 70,     38,     23, 53, 87,     77,     29,      7, 52, 103,     85,     21,         51, 119,     92,     12,         50,         100,      4,         49,         107,                 48,         115,                             122                                                                                                                                                                                                                             ],
	[     73,     41, 24,     88, 58,     82,     34,  8,     104, 59,     90,     26,         120, 60,     99,     19,             61,     107,     11,             62,     116,      4,             63,     124                                                                                                                                                                                                                                                         ],
	[ 72, 74, 40, 42, 25,     89, 59, 80, 83, 32, 35,  9,     105, 60,     91,     27,         121, 61,     100,     20,             62,     108,     12,             63,     117,      5,                     125                                                                                                                                                                                                                                                         ],
	[ 73, 75, 41, 43, 26, 56, 90, 60, 81, 84, 33, 36, 10,     106, 61, 88, 92, 24, 28,         122, 62, 96, 101, 16, 21,             63,     109,     13,                     118,      6,                     126                                                                                                                                                                                                                                                         ],
	[ 74, 76, 42, 44, 27, 57, 91, 61, 82, 85, 34, 37, 11, 56, 107, 62, 89, 93, 25, 29,         123, 63, 97, 102, 17, 22,                 104, 110,  8, 14,                 112, 119,  0,  7,                     127                                                                                                                                                                                                                                                         ],
	[ 75, 77, 43, 45, 28, 58, 92, 62, 83, 86, 35, 38, 12, 57, 108, 63, 90, 94, 26, 30,     56, 124,     98, 103, 18, 23,                 105, 111,  9, 15,                 113,      1,                     120                                                                                                                                                                                                                                                             ],
	[ 76, 78, 44, 46, 29, 59, 93, 63, 84, 87, 36, 39, 13, 58, 109,     91, 95, 27, 31,     57, 125,     99,     19,         56,         106,     10,                     114,      2,                     121                                                                                                                                                                                                                                                             ],
	[ 77, 79, 45, 47, 30, 60, 94,     85,     37,     14, 59, 110,     92,     28,         58, 126,     100,     20,         57,         107,     11,         56,         115,      3,                     122                                                                                                                                                                                                                                                             ],
	[ 78,     46,     31, 61, 95,     86,     38,     15, 60, 111,     93,     29,         59, 127,     101,     21,         58,         108,     12,         57,         116,      4,         56,         123                                                                                                                                                                                                                                                             ],
	[     81,     49, 32,     96, 66,     89,     41, 16,     112, 67,     98,     34,  0,         68,     106,     26,             69,     115,     19,             70,     123,     11,             71,              4                                                                                                                                                                                                                                                 ],
	[ 80, 82, 48, 50, 33,     97, 67,     90,     42, 17,     113, 68,     99,     35,  1,         69,     107,     27,             70,     116,     20,             71,     124,     12,                              5                                                                                                                                                                                                                                                 ],
	[ 81, 83, 49, 51, 34, 64, 98, 68, 88, 91, 40, 43, 18,     114, 69, 96, 100, 32, 36,  2,         70,     108,     28,             71,     117,     21,                     125,     13,                              6                                                                                                                                                                                                                                                 ],
	[ 82, 84, 50, 52, 35, 65, 99, 69, 89, 92, 41, 44, 19, 64, 115, 70, 97, 101, 33, 37,  3,         71, 104, 109, 24, 29,                 112, 118, 16, 22,                     126,     14,                              7                                                                                                                                                                                                                                                 ],
	[ 83, 85, 51, 53, 36, 66, 100, 70, 90, 93, 42, 45, 20, 65, 116, 71, 98, 102, 34, 38,  4, 64,         105, 110, 25, 30,                 113, 119, 17, 23,                 120, 127,  8, 15,                          0                                                                                                                                                                                                                                                     ],
	[ 84, 86, 52, 54, 37, 67, 101, 71, 91, 94, 43, 46, 21, 66, 117,     99, 103, 35, 39,  5, 65,         106, 111, 26, 31,     64,         114,     18,                     121,      9,                              1                                                                                                                                                                                                                                                     ],
	[ 85, 87, 53, 55, 38, 68, 102,     92, 95, 44, 47, 22, 67, 118,     100,     36,      6, 66,         107,     27,         65,         115,     19,         64,         122,     10,                              2                                                                                                                                                                                                                                                     ],
	[ 86,     54,     39, 69, 103,     93,     45,     23, 68, 119,     101,     37,      7, 67,         108,     28,         66,         116,     20,         65,         123,     11,         64,                  3                                                                                                                                                                                                                                                     ],
	[     89,     57, 40,     104, 74,     98,     50, 24,     120, 75,     106,     42,  8,         76,     115,     35,             77,     123,     27,             78,             20,             79,             12,                              5                                                                                                                                                                                                                 ],
	[ 88, 90, 56, 58, 41,     105, 75, 96, 99, 48, 51, 25,     121, 76,     107,     43,  9,         77,     116,     36,             78,     124,     28,             79,             21,                             13,                              6                                                                                                                                                                                                                 ],
	[ 89, 91, 57, 59, 42, 72, 106, 76, 97, 100, 49, 52, 26,     122, 77, 104, 108, 40, 44, 10,         78, 112, 117, 32, 37,             79,     125,     29,                             22,                             14,                              7                                                                                                                                                                                                                 ],
	[ 90, 92, 58, 60, 43, 73, 107, 77, 98, 101, 50, 53, 27, 72, 123, 78, 105, 109, 41, 45, 11,         79, 113, 118, 33, 38,                 120, 126, 24, 30,                         16, 23,                             15                                                                                                                                                                                                                                                 ],
	[ 91, 93, 59, 61, 44, 74, 108, 78, 99, 102, 51, 54, 28, 73, 124, 79, 106, 110, 42, 46, 12, 72,         114, 119, 34, 39,                 121, 127, 25, 31,                         17,                              8,                              0                                                                                                                                                                                                                     ],
	[ 92, 94, 60, 62, 45, 75, 109, 79, 100, 103, 52, 55, 29, 74, 125,     107, 111, 43, 47, 13, 73,         115,     35,         72,         122,     26,                             18,                              9,                              1                                                                                                                                                                                                                     ],
	[ 93, 95, 61, 63, 46, 76, 110,     101,     53,     30, 75, 126,     108,     44,     14, 74,         116,     36,         73,         123,     27,         72,                 19,                             10,                              2                                                                                                                                                                                                                     ],
	[ 94,     62,     47, 77, 111,     102,     54,     31, 76, 127,     109,     45,     15, 75,         117,     37,         74,         124,     28,         73,                 20,         72,                 11,                              3                                                                                                                                                                                                                     ],
	[     97,     65, 48,     112, 82,     105,     57, 32,         83,     114,     50, 16,         84,     122,     42,  0,         85,             35,             86,             27,             87,             20,                             12,                              5                                                                                                                                                                                 ],
	[ 96, 98, 64, 66, 49,     113, 83,     106,     58, 33,         84,     115,     51, 17,         85,     123,     43,  1,         86,             36,             87,             28,                             21,                             13,                              6                                                                                                                                                                                 ],
	[ 97, 99, 65, 67, 50, 80, 114, 84, 104, 107, 56, 59, 34,         85, 112, 116, 48, 52, 18,         86,     124,     44,  2,         87,             37,                             29,                             22,                             14,                              7                                                                                                                                                                                 ],
	[ 98, 100, 66, 68, 51, 81, 115, 85, 105, 108, 57, 60, 35, 80,     86, 113, 117, 49, 53, 19,         87, 120, 125, 40, 45,  3,                     32, 38,                             30,                             23,                             15                                                                                                                                                                                                                 ],
	[ 99, 101, 67, 69, 52, 82, 116, 86, 106, 109, 58, 61, 36, 81,     87, 114, 118, 50, 54, 20, 80,         121, 126, 41, 46,  4,                     33, 39,                         24, 31,                         16                                                                                                                                                                                                                                                     ],
	[ 100, 102, 68, 70, 53, 83, 117, 87, 107, 110, 59, 62, 37, 82,         115, 119, 51, 55, 21, 81,         122, 127, 42, 47,  5, 80,                 34,                             25,                             17,                              8,                              0                                                                                                                                                                                     ],
	[ 101, 103, 69, 71, 54, 84, 118,     108, 111, 60, 63, 38, 83,         116,     52,     22, 82,         123,     43,      6, 81,                 35,         80,                 26,                             18,                              9,                              1                                                                                                                                                                                     ],
	[ 102,     70,     55, 85, 119,     109,     61,     39, 84,         117,     53,     23, 83,         124,     44,      7, 82,                 36,         81,                 27,         80,                 19,                             10,                              2                                                                                                                                                                                     ],
	[     105,     73, 56,     120, 90,     114,     66, 40,         91,     122,     58, 24,         92,             51,  8,         93,             43,             94,             36,             95,             28,                             21,                             13,                              6                                                                                                                                                 ],
	[ 104, 106, 72, 74, 57,     121, 91, 112, 115, 64, 67, 41,         92,     123,     59, 25,         93,             52,  9,         94,             44,             95,             37,                             29,                             22,                             14,                              7                                                                                                                                                 ],
	[ 105, 107, 73, 75, 58, 88, 122, 92, 113, 116, 65, 68, 42,         93, 120, 124, 56, 60, 26,         94,         48, 53, 10,         95,             45,                             38,                             30,                             23,                             15                                                                                                                                                                                 ],
	[ 106, 108, 74, 76, 59, 89, 123, 93, 114, 117, 66, 69, 43, 88,     94, 121, 125, 57, 61, 27,         95,         49, 54, 11,                     40, 46,                         32, 39,                             31                                                                                                                                                                                                                                                 ],
	[ 107, 109, 75, 77, 60, 90, 124, 94, 115, 118, 67, 70, 44, 89,     95, 122, 126, 58, 62, 28, 88,                 50, 55, 12,                     41, 47,                         33,                             24,                             16                                                                                                                                                                                                                     ],
	[ 108, 110, 76, 78, 61, 91, 125, 95, 116, 119, 68, 71, 45, 90,         123, 127, 59, 63, 29, 89,                 51,     13, 88,                 42,                             34,                             25,                             17,                              8,                              0                                                                                                                                                     ],
	[ 109, 111, 77, 79, 62, 92, 126,     117,     69,     46, 91,         124,     60,     30, 90,                 52,     14, 89,                 43,         88,                 35,                             26,                             18,                              9,                              1                                                                                                                                                     ],
	[ 110,     78,     63, 93, 127,     118,     70,     47, 92,         125,     61,     31, 91,                 53,     15, 90,                 44,         89,                 36,         88,                 27,                             19,                             10,                              2                                                                                                                                                     ],
	[     113,     81, 64,         98,     121,     73, 48,         99,             66, 32,         100,             58, 16,         101,             51,  0,         102,             43,             103,             36,                             28,                             21,                             13,                              6                                                                                                                 ],
	[ 112, 114, 80, 82, 65,         99,     122,     74, 49,         100,             67, 33,         101,             59, 17,         102,             52,  1,         103,             44,                             37,                             29,                             22,                             14,                              7                                                                                                                 ],
	[ 113, 115, 81, 83, 66, 96,     100, 120, 123, 72, 75, 50,         101,         64, 68, 34,         102,             60, 18,         103,             53,  2,                         45,                             38,                             30,                             23,                             15                                                                                                                                                 ],
	[ 114, 116, 82, 84, 67, 97,     101, 121, 124, 73, 76, 51, 96,     102,         65, 69, 35,         103,         56, 61, 19,                     48, 54,  3,                         46,                             39,                             31                                                                                                                                                                                                                 ],
	[ 115, 117, 83, 85, 68, 98,     102, 122, 125, 74, 77, 52, 97,     103,         66, 70, 36, 96,                 57, 62, 20,                     49, 55,  4,                     40, 47,                         32                                                                                                                                                                                                                                                     ],
	[ 116, 118, 84, 86, 69, 99,     103, 123, 126, 75, 78, 53, 98,                 67, 71, 37, 97,                 58, 63, 21, 96,                 50,      5,                     41,                             33,                             24,                             16                                                                                                                                                                                     ],
	[ 117, 119, 85, 87, 70, 100,         124, 127, 76, 79, 54, 99,                 68,     38, 98,                 59,     22, 97,                 51,      6, 96,                 42,                             34,                             25,                             17,                              8,                              0                                                                                                                     ],
	[ 118,     86,     71, 101,         125,     77,     55, 100,                 69,     39, 99,                 60,     23, 98,                 52,      7, 97,                 43,         96,                 35,                             26,                             18,                              9,                              1                                                                                                                     ],
	[     121,     89, 72,         106,             82, 56,         107,             74, 40,         108,             67, 24,         109,             59,  8,         110,             52,             111,             44,                             37,                             29,                             22,                             14,                              7                                                                                 ],
	[ 120, 122, 88, 90, 73,         107,         80, 83, 57,         108,             75, 41,         109,             68, 25,         110,             60,  9,         111,             53,                             45,                             38,                             30,                             23,                             15                                                                                                                 ],
	[ 121, 123, 89, 91, 74, 104,     108,         81, 84, 58,         109,         72, 76, 42,         110,         64, 69, 26,         111,             61, 10,                         54,                             46,                             39,                             31                                                                                                                                                                                 ],
	[ 122, 124, 90, 92, 75, 105,     109,         82, 85, 59, 104,     110,         73, 77, 43,         111,         65, 70, 27,                     56, 62, 11,                     48, 55,                             47                                                                                                                                                                                                                                                 ],
	[ 123, 125, 91, 93, 76, 106,     110,         83, 86, 60, 105,     111,         74, 78, 44, 104,                 66, 71, 28,                     57, 63, 12,                     49,                             40,                             32                                                                                                                                                                                                                     ],
	[ 124, 126, 92, 94, 77, 107,     111,         84, 87, 61, 106,                 75, 79, 45, 105,                 67,     29, 104,                 58,     13,                     50,                             41,                             33,                             24,                             16                                                                                                                                                     ],
	[ 125, 127, 93, 95, 78, 108,                 85,     62, 107,                 76,     46, 106,                 68,     30, 105,                 59,     14, 104,                 51,                             42,                             34,                             25,                             17,                              8,                              0                                                                                     ],
	[ 126,     94,     79, 109,                 86,     63, 108,                 77,     47, 107,                 69,     31, 106,                 60,     15, 105,                 52,         104,                 43,                             35,                             26,                             18,                              9,                              1                                                                                     ],
	[             97, 80,         114,             89, 64,         115,             82, 48,         116,             74, 32,         117,             67, 16,         118,             59,  0,         119,             52,                             44,                             37,                             29,                             22,                             14,                              7                                                 ],
	[         96, 98, 81,         115,             90, 65,         116,             83, 49,         117,             75, 33,         118,             68, 17,         119,             60,  1,                         53,                             45,                             38,                             30,                             23,                             15                                                                                 ],
	[         97, 99, 82, 112,     116,         88, 91, 66,         117,         80, 84, 50,         118,             76, 34,         119,             69, 18,                         61,  2,                         54,                             46,                             39,                             31                                                                                                                                                 ],
	[         98, 100, 83, 113,     117,         89, 92, 67, 112,     118,         81, 85, 51,         119,         72, 77, 35,                     64, 70, 19,                         62,  3,                         55,                             47                                                                                                                                                                                                                 ],
	[         99, 101, 84, 114,     118,         90, 93, 68, 113,     119,         82, 86, 52, 112,                 73, 78, 36,                     65, 71, 20,                     56, 63,  4,                     48                                                                                                                                                                                                                                                     ],
	[         100, 102, 85, 115,     119,         91, 94, 69, 114,                 83, 87, 53, 113,                 74, 79, 37, 112,                 66,     21,                     57,      5,                     49,                             40,                             32                                                                                                                                                                                     ],
	[         101, 103, 86, 116,                 92, 95, 70, 115,                 84,     54, 114,                 75,     38, 113,                 67,     22, 112,                 58,      6,                     50,                             41,                             33,                             24,                             16                                                                                                                     ],
	[         102,     87, 117,                 93,     71, 116,                 85,     55, 115,                 76,     39, 114,                 68,     23, 113,                 59,      7, 112,                 51,                             42,                             34,                             25,                             17,                              8,                              0                                                     ],
	[             105, 88,         122,             98, 72,         123,             90, 56,         124,             83, 40,         125,             75, 24,         126,             68,  8,         127,             60,                             53,                             45,                             38,                             30,                             23,                             15                                                 ],
	[         104, 106, 89,         123,         96, 99, 73,         124,             91, 57,         125,             84, 41,         126,             76, 25,         127,             69,  9,                         61,                             54,                             46,                             39,                             31                                                                                                                 ],
	[         105, 107, 90, 120,     124,         97, 100, 74,         125,         88, 92, 58,         126,         80, 85, 42,         127,             77, 26,                         70, 10,                         62,                             55,                             47                                                                                                                                                                                 ],
	[         106, 108, 91, 121,     125,         98, 101, 75, 120,     126,         89, 93, 59,         127,         81, 86, 43,                     72, 78, 27,                     64, 71, 11,                         63                                                                                                                                                                                                                                                 ],
	[         107, 109, 92, 122,     126,         99, 102, 76, 121,     127,         90, 94, 60, 120,                 82, 87, 44,                     73, 79, 28,                     65,     12,                     56,                             48                                                                                                                                                                                                                     ],
	[         108, 110, 93, 123,     127,         100, 103, 77, 122,                 91, 95, 61, 121,                 83,     45, 120,                 74,     29,                     66,     13,                     57,                             49,                             40,                             32                                                                                                                                                     ],
	[         109, 111, 94, 124,                 101,     78, 123,                 92,     62, 122,                 84,     46, 121,                 75,     30, 120,                 67,     14,                     58,                             50,                             41,                             33,                             24,                             16                                                                                     ],
	[         110,     95, 125,                 102,     79, 124,                 93,     63, 123,                 85,     47, 122,                 76,     31, 121,                 68,     15, 120,                 59,                             51,                             42,                             34,                             25,                             17,                              8,                              0                     ],
];

use constant enclosed_locs => [
	{ 17 => [  8 ], 25 => [  8, 17 ], 34 => [  8, 17, 25 ], 42 => [  8, 17, 25, 34 ], 51 => [  8, 17, 25, 34, 42 ], 59 => [  8, 17, 25, 34, 42, 51 ], 68 => [  8, 17, 25, 34, 42, 51, 59 ], 76 => [  8, 17, 25, 34, 42, 51, 59, 68 ], 85 => [  8, 17, 25, 34, 42, 51, 59, 68, 76 ], 93 => [  8, 17, 25, 34, 42, 51, 59, 68, 76, 85 ], 102 => [  8, 17, 25, 34, 42, 51, 59, 68, 76, 85, 93 ], 110 => [  8, 17, 25, 34, 42, 51, 59, 68, 76, 85, 93, 102 ], 119 => [  8, 17, 25, 34, 42, 51, 59, 68, 76, 85, 93, 102, 110 ], 127 => [  8, 17, 25, 34, 42, 51, 59, 68, 76, 85, 93, 102, 110, 119 ] },
	{ 16 => [  8 ], 18 => [  9 ], 26 => [  9, 18 ], 35 => [  9, 18, 26 ], 43 => [  9, 18, 26, 35 ], 52 => [  9, 18, 26, 35, 43 ], 60 => [  9, 18, 26, 35, 43, 52 ], 69 => [  9, 18, 26, 35, 43, 52, 60 ], 77 => [  9, 18, 26, 35, 43, 52, 60, 69 ], 86 => [  9, 18, 26, 35, 43, 52, 60, 69, 77 ], 94 => [  9, 18, 26, 35, 43, 52, 60, 69, 77, 86 ], 103 => [  9, 18, 26, 35, 43, 52, 60, 69, 77, 86, 94 ], 111 => [  9, 18, 26, 35, 43, 52, 60, 69, 77, 86, 94, 103 ] },
	{ 17 => [  9 ], 19 => [ 10 ], 24 => [  9, 17 ], 27 => [ 10, 19 ], 32 => [  9, 17, 24 ], 36 => [ 10, 19, 27 ], 44 => [ 10, 19, 27, 36 ], 53 => [ 10, 19, 27, 36, 44 ], 61 => [ 10, 19, 27, 36, 44, 53 ], 70 => [ 10, 19, 27, 36, 44, 53, 61 ], 78 => [ 10, 19, 27, 36, 44, 53, 61, 70 ], 87 => [ 10, 19, 27, 36, 44, 53, 61, 70, 78 ], 95 => [ 10, 19, 27, 36, 44, 53, 61, 70, 78, 87 ] },
	{ 18 => [ 10 ], 20 => [ 11 ], 25 => [ 10, 18 ], 28 => [ 11, 20 ], 33 => [ 10, 18, 25 ], 37 => [ 11, 20, 28 ], 40 => [ 10, 18, 25, 33 ], 45 => [ 11, 20, 28, 37 ], 48 => [ 10, 18, 25, 33, 40 ], 54 => [ 11, 20, 28, 37, 45 ], 62 => [ 11, 20, 28, 37, 45, 54 ], 71 => [ 11, 20, 28, 37, 45, 54, 62 ], 79 => [ 11, 20, 28, 37, 45, 54, 62, 71 ] },
	{ 19 => [ 11 ], 21 => [ 12 ], 26 => [ 11, 19 ], 29 => [ 12, 21 ], 34 => [ 11, 19, 26 ], 38 => [ 12, 21, 29 ], 41 => [ 11, 19, 26, 34 ], 46 => [ 12, 21, 29, 38 ], 49 => [ 11, 19, 26, 34, 41 ], 55 => [ 12, 21, 29, 38, 46 ], 56 => [ 11, 19, 26, 34, 41, 49 ], 63 => [ 12, 21, 29, 38, 46, 55 ], 64 => [ 11, 19, 26, 34, 41, 49, 56 ] },
	{ 20 => [ 12 ], 22 => [ 13 ], 27 => [ 12, 20 ], 30 => [ 13, 22 ], 35 => [ 12, 20, 27 ], 39 => [ 13, 22, 30 ], 42 => [ 12, 20, 27, 35 ], 47 => [ 13, 22, 30, 39 ], 50 => [ 12, 20, 27, 35, 42 ], 57 => [ 12, 20, 27, 35, 42, 50 ], 65 => [ 12, 20, 27, 35, 42, 50, 57 ], 72 => [ 12, 20, 27, 35, 42, 50, 57, 65 ], 80 => [ 12, 20, 27, 35, 42, 50, 57, 65, 72 ] },
	{ 21 => [ 13 ], 23 => [ 14 ], 28 => [ 13, 21 ], 31 => [ 14, 23 ], 36 => [ 13, 21, 28 ], 43 => [ 13, 21, 28, 36 ], 51 => [ 13, 21, 28, 36, 43 ], 58 => [ 13, 21, 28, 36, 43, 51 ], 66 => [ 13, 21, 28, 36, 43, 51, 58 ], 73 => [ 13, 21, 28, 36, 43, 51, 58, 66 ], 81 => [ 13, 21, 28, 36, 43, 51, 58, 66, 73 ], 88 => [ 13, 21, 28, 36, 43, 51, 58, 66, 73, 81 ], 96 => [ 13, 21, 28, 36, 43, 51, 58, 66, 73, 81, 88 ] },
	{ 22 => [ 14 ], 29 => [ 14, 22 ], 37 => [ 14, 22, 29 ], 44 => [ 14, 22, 29, 37 ], 52 => [ 14, 22, 29, 37, 44 ], 59 => [ 14, 22, 29, 37, 44, 52 ], 67 => [ 14, 22, 29, 37, 44, 52, 59 ], 74 => [ 14, 22, 29, 37, 44, 52, 59, 67 ], 82 => [ 14, 22, 29, 37, 44, 52, 59, 67, 74 ], 89 => [ 14, 22, 29, 37, 44, 52, 59, 67, 74, 82 ], 97 => [ 14, 22, 29, 37, 44, 52, 59, 67, 74, 82, 89 ], 104 => [ 14, 22, 29, 37, 44, 52, 59, 67, 74, 82, 89, 97 ], 112 => [ 14, 22, 29, 37, 44, 52, 59, 67, 74, 82, 89, 97, 104 ] },
	{ 25 => [ 17 ], 34 => [ 17, 25 ], 42 => [ 17, 25, 34 ], 51 => [ 17, 25, 34, 42 ], 59 => [ 17, 25, 34, 42, 51 ], 68 => [ 17, 25, 34, 42, 51, 59 ], 76 => [ 17, 25, 34, 42, 51, 59, 68 ], 85 => [ 17, 25, 34, 42, 51, 59, 68, 76 ], 93 => [ 17, 25, 34, 42, 51, 59, 68, 76, 85 ], 102 => [ 17, 25, 34, 42, 51, 59, 68, 76, 85, 93 ], 110 => [ 17, 25, 34, 42, 51, 59, 68, 76, 85, 93, 102 ], 119 => [ 17, 25, 34, 42, 51, 59, 68, 76, 85, 93, 102, 110 ], 127 => [ 17, 25, 34, 42, 51, 59, 68, 76, 85, 93, 102, 110, 119 ] },
	{ 24 => [ 17 ], 26 => [ 18 ], 32 => [ 17, 24 ], 35 => [ 18, 26 ], 43 => [ 18, 26, 35 ], 52 => [ 18, 26, 35, 43 ], 60 => [ 18, 26, 35, 43, 52 ], 69 => [ 18, 26, 35, 43, 52, 60 ], 77 => [ 18, 26, 35, 43, 52, 60, 69 ], 86 => [ 18, 26, 35, 43, 52, 60, 69, 77 ], 94 => [ 18, 26, 35, 43, 52, 60, 69, 77, 86 ], 103 => [ 18, 26, 35, 43, 52, 60, 69, 77, 86, 94 ], 111 => [ 18, 26, 35, 43, 52, 60, 69, 77, 86, 94, 103 ] },
	{ 25 => [ 18 ], 27 => [ 19 ], 33 => [ 18, 25 ], 36 => [ 19, 27 ], 40 => [ 18, 25, 33 ], 44 => [ 19, 27, 36 ], 48 => [ 18, 25, 33, 40 ], 53 => [ 19, 27, 36, 44 ], 61 => [ 19, 27, 36, 44, 53 ], 70 => [ 19, 27, 36, 44, 53, 61 ], 78 => [ 19, 27, 36, 44, 53, 61, 70 ], 87 => [ 19, 27, 36, 44, 53, 61, 70, 78 ], 95 => [ 19, 27, 36, 44, 53, 61, 70, 78, 87 ] },
	{ 26 => [ 19 ], 28 => [ 20 ], 34 => [ 19, 26 ], 37 => [ 20, 28 ], 41 => [ 19, 26, 34 ], 45 => [ 20, 28, 37 ], 49 => [ 19, 26, 34, 41 ], 54 => [ 20, 28, 37, 45 ], 56 => [ 19, 26, 34, 41, 49 ], 62 => [ 20, 28, 37, 45, 54 ], 64 => [ 19, 26, 34, 41, 49, 56 ], 71 => [ 20, 28, 37, 45, 54, 62 ], 79 => [ 20, 28, 37, 45, 54, 62, 71 ] },
	{ 27 => [ 20 ], 29 => [ 21 ], 35 => [ 20, 27 ], 38 => [ 21, 29 ], 42 => [ 20, 27, 35 ], 46 => [ 21, 29, 38 ], 50 => [ 20, 27, 35, 42 ], 55 => [ 21, 29, 38, 46 ], 57 => [ 20, 27, 35, 42, 50 ], 63 => [ 21, 29, 38, 46, 55 ], 65 => [ 20, 27, 35, 42, 50, 57 ], 72 => [ 20, 27, 35, 42, 50, 57, 65 ], 80 => [ 20, 27, 35, 42, 50, 57, 65, 72 ] },
	{ 28 => [ 21 ], 30 => [ 22 ], 36 => [ 21, 28 ], 39 => [ 22, 30 ], 43 => [ 21, 28, 36 ], 47 => [ 22, 30, 39 ], 51 => [ 21, 28, 36, 43 ], 58 => [ 21, 28, 36, 43, 51 ], 66 => [ 21, 28, 36, 43, 51, 58 ], 73 => [ 21, 28, 36, 43, 51, 58, 66 ], 81 => [ 21, 28, 36, 43, 51, 58, 66, 73 ], 88 => [ 21, 28, 36, 43, 51, 58, 66, 73, 81 ], 96 => [ 21, 28, 36, 43, 51, 58, 66, 73, 81, 88 ] },
	{ 29 => [ 22 ], 31 => [ 23 ], 37 => [ 22, 29 ], 44 => [ 22, 29, 37 ], 52 => [ 22, 29, 37, 44 ], 59 => [ 22, 29, 37, 44, 52 ], 67 => [ 22, 29, 37, 44, 52, 59 ], 74 => [ 22, 29, 37, 44, 52, 59, 67 ], 82 => [ 22, 29, 37, 44, 52, 59, 67, 74 ], 89 => [ 22, 29, 37, 44, 52, 59, 67, 74, 82 ], 97 => [ 22, 29, 37, 44, 52, 59, 67, 74, 82, 89 ], 104 => [ 22, 29, 37, 44, 52, 59, 67, 74, 82, 89, 97 ], 112 => [ 22, 29, 37, 44, 52, 59, 67, 74, 82, 89, 97, 104 ] },
	{ 30 => [ 23 ], 38 => [ 23, 30 ], 45 => [ 23, 30, 38 ], 53 => [ 23, 30, 38, 45 ], 60 => [ 23, 30, 38, 45, 53 ], 68 => [ 23, 30, 38, 45, 53, 60 ], 75 => [ 23, 30, 38, 45, 53, 60, 68 ], 83 => [ 23, 30, 38, 45, 53, 60, 68, 75 ], 90 => [ 23, 30, 38, 45, 53, 60, 68, 75, 83 ], 98 => [ 23, 30, 38, 45, 53, 60, 68, 75, 83, 90 ], 105 => [ 23, 30, 38, 45, 53, 60, 68, 75, 83, 90, 98 ], 113 => [ 23, 30, 38, 45, 53, 60, 68, 75, 83, 90, 98, 105 ], 120 => [ 23, 30, 38, 45, 53, 60, 68, 75, 83, 90, 98, 105, 113 ] },
	{  1 => [  8 ], 33 => [ 24 ], 41 => [ 24, 33 ], 50 => [ 24, 33, 41 ], 58 => [ 24, 33, 41, 50 ], 67 => [ 24, 33, 41, 50, 58 ], 75 => [ 24, 33, 41, 50, 58, 67 ], 84 => [ 24, 33, 41, 50, 58, 67, 75 ], 92 => [ 24, 33, 41, 50, 58, 67, 75, 84 ], 101 => [ 24, 33, 41, 50, 58, 67, 75, 84, 92 ], 109 => [ 24, 33, 41, 50, 58, 67, 75, 84, 92, 101 ], 118 => [ 24, 33, 41, 50, 58, 67, 75, 84, 92, 101, 109 ], 126 => [ 24, 33, 41, 50, 58, 67, 75, 84, 92, 101, 109, 118 ] },
	{  0 => [  8 ],  2 => [  9 ], 32 => [ 24 ], 34 => [ 25 ], 42 => [ 25, 34 ], 51 => [ 25, 34, 42 ], 59 => [ 25, 34, 42, 51 ], 68 => [ 25, 34, 42, 51, 59 ], 76 => [ 25, 34, 42, 51, 59, 68 ], 85 => [ 25, 34, 42, 51, 59, 68, 76 ], 93 => [ 25, 34, 42, 51, 59, 68, 76, 85 ], 102 => [ 25, 34, 42, 51, 59, 68, 76, 85, 93 ], 110 => [ 25, 34, 42, 51, 59, 68, 76, 85, 93, 102 ], 119 => [ 25, 34, 42, 51, 59, 68, 76, 85, 93, 102, 110 ], 127 => [ 25, 34, 42, 51, 59, 68, 76, 85, 93, 102, 110, 119 ] },
	{  1 => [  9 ],  3 => [ 10 ], 33 => [ 25 ], 35 => [ 26 ], 40 => [ 25, 33 ], 43 => [ 26, 35 ], 48 => [ 25, 33, 40 ], 52 => [ 26, 35, 43 ], 60 => [ 26, 35, 43, 52 ], 69 => [ 26, 35, 43, 52, 60 ], 77 => [ 26, 35, 43, 52, 60, 69 ], 86 => [ 26, 35, 43, 52, 60, 69, 77 ], 94 => [ 26, 35, 43, 52, 60, 69, 77, 86 ], 103 => [ 26, 35, 43, 52, 60, 69, 77, 86, 94 ], 111 => [ 26, 35, 43, 52, 60, 69, 77, 86, 94, 103 ] },
	{  2 => [ 10 ],  4 => [ 11 ], 34 => [ 26 ], 36 => [ 27 ], 41 => [ 26, 34 ], 44 => [ 27, 36 ], 49 => [ 26, 34, 41 ], 53 => [ 27, 36, 44 ], 56 => [ 26, 34, 41, 49 ], 61 => [ 27, 36, 44, 53 ], 64 => [ 26, 34, 41, 49, 56 ], 70 => [ 27, 36, 44, 53, 61 ], 78 => [ 27, 36, 44, 53, 61, 70 ], 87 => [ 27, 36, 44, 53, 61, 70, 78 ], 95 => [ 27, 36, 44, 53, 61, 70, 78, 87 ] },
	{  3 => [ 11 ],  5 => [ 12 ], 35 => [ 27 ], 37 => [ 28 ], 42 => [ 27, 35 ], 45 => [ 28, 37 ], 50 => [ 27, 35, 42 ], 54 => [ 28, 37, 45 ], 57 => [ 27, 35, 42, 50 ], 62 => [ 28, 37, 45, 54 ], 65 => [ 27, 35, 42, 50, 57 ], 71 => [ 28, 37, 45, 54, 62 ], 72 => [ 27, 35, 42, 50, 57, 65 ], 79 => [ 28, 37, 45, 54, 62, 71 ], 80 => [ 27, 35, 42, 50, 57, 65, 72 ] },
	{  4 => [ 12 ],  6 => [ 13 ], 36 => [ 28 ], 38 => [ 29 ], 43 => [ 28, 36 ], 46 => [ 29, 38 ], 51 => [ 28, 36, 43 ], 55 => [ 29, 38, 46 ], 58 => [ 28, 36, 43, 51 ], 63 => [ 29, 38, 46, 55 ], 66 => [ 28, 36, 43, 51, 58 ], 73 => [ 28, 36, 43, 51, 58, 66 ], 81 => [ 28, 36, 43, 51, 58, 66, 73 ], 88 => [ 28, 36, 43, 51, 58, 66, 73, 81 ], 96 => [ 28, 36, 43, 51, 58, 66, 73, 81, 88 ] },
	{  5 => [ 13 ],  7 => [ 14 ], 37 => [ 29 ], 39 => [ 30 ], 44 => [ 29, 37 ], 47 => [ 30, 39 ], 52 => [ 29, 37, 44 ], 59 => [ 29, 37, 44, 52 ], 67 => [ 29, 37, 44, 52, 59 ], 74 => [ 29, 37, 44, 52, 59, 67 ], 82 => [ 29, 37, 44, 52, 59, 67, 74 ], 89 => [ 29, 37, 44, 52, 59, 67, 74, 82 ], 97 => [ 29, 37, 44, 52, 59, 67, 74, 82, 89 ], 104 => [ 29, 37, 44, 52, 59, 67, 74, 82, 89, 97 ], 112 => [ 29, 37, 44, 52, 59, 67, 74, 82, 89, 97, 104 ] },
	{  6 => [ 14 ], 38 => [ 30 ], 45 => [ 30, 38 ], 53 => [ 30, 38, 45 ], 60 => [ 30, 38, 45, 53 ], 68 => [ 30, 38, 45, 53, 60 ], 75 => [ 30, 38, 45, 53, 60, 68 ], 83 => [ 30, 38, 45, 53, 60, 68, 75 ], 90 => [ 30, 38, 45, 53, 60, 68, 75, 83 ], 98 => [ 30, 38, 45, 53, 60, 68, 75, 83, 90 ], 105 => [ 30, 38, 45, 53, 60, 68, 75, 83, 90, 98 ], 113 => [ 30, 38, 45, 53, 60, 68, 75, 83, 90, 98, 105 ], 120 => [ 30, 38, 45, 53, 60, 68, 75, 83, 90, 98, 105, 113 ] },
	{  2 => [ 17,  9 ],  9 => [ 17 ], 41 => [ 33 ], 50 => [ 33, 41 ], 58 => [ 33, 41, 50 ], 67 => [ 33, 41, 50, 58 ], 75 => [ 33, 41, 50, 58, 67 ], 84 => [ 33, 41, 50, 58, 67, 75 ], 92 => [ 33, 41, 50, 58, 67, 75, 84 ], 101 => [ 33, 41, 50, 58, 67, 75, 84, 92 ], 109 => [ 33, 41, 50, 58, 67, 75, 84, 92, 101 ], 118 => [ 33, 41, 50, 58, 67, 75, 84, 92, 101, 109 ], 126 => [ 33, 41, 50, 58, 67, 75, 84, 92, 101, 109, 118 ] },
	{  0 => [ 17,  8 ],  3 => [ 18, 10 ],  8 => [ 17 ], 10 => [ 18 ], 40 => [ 33 ], 42 => [ 34 ], 48 => [ 33, 40 ], 51 => [ 34, 42 ], 59 => [ 34, 42, 51 ], 68 => [ 34, 42, 51, 59 ], 76 => [ 34, 42, 51, 59, 68 ], 85 => [ 34, 42, 51, 59, 68, 76 ], 93 => [ 34, 42, 51, 59, 68, 76, 85 ], 102 => [ 34, 42, 51, 59, 68, 76, 85, 93 ], 110 => [ 34, 42, 51, 59, 68, 76, 85, 93, 102 ], 119 => [ 34, 42, 51, 59, 68, 76, 85, 93, 102, 110 ], 127 => [ 34, 42, 51, 59, 68, 76, 85, 93, 102, 110, 119 ] },
	{  1 => [ 18,  9 ],  4 => [ 19, 11 ],  9 => [ 18 ], 11 => [ 19 ], 41 => [ 34 ], 43 => [ 35 ], 49 => [ 34, 41 ], 52 => [ 35, 43 ], 56 => [ 34, 41, 49 ], 60 => [ 35, 43, 52 ], 64 => [ 34, 41, 49, 56 ], 69 => [ 35, 43, 52, 60 ], 77 => [ 35, 43, 52, 60, 69 ], 86 => [ 35, 43, 52, 60, 69, 77 ], 94 => [ 35, 43, 52, 60, 69, 77, 86 ], 103 => [ 35, 43, 52, 60, 69, 77, 86, 94 ], 111 => [ 35, 43, 52, 60, 69, 77, 86, 94, 103 ] },
	{  2 => [ 19, 10 ],  5 => [ 20, 12 ], 10 => [ 19 ], 12 => [ 20 ], 42 => [ 35 ], 44 => [ 36 ], 50 => [ 35, 42 ], 53 => [ 36, 44 ], 57 => [ 35, 42, 50 ], 61 => [ 36, 44, 53 ], 65 => [ 35, 42, 50, 57 ], 70 => [ 36, 44, 53, 61 ], 72 => [ 35, 42, 50, 57, 65 ], 78 => [ 36, 44, 53, 61, 70 ], 80 => [ 35, 42, 50, 57, 65, 72 ], 87 => [ 36, 44, 53, 61, 70, 78 ], 95 => [ 36, 44, 53, 61, 70, 78, 87 ] },
	{  3 => [ 20, 11 ],  6 => [ 21, 13 ], 11 => [ 20 ], 13 => [ 21 ], 43 => [ 36 ], 45 => [ 37 ], 51 => [ 36, 43 ], 54 => [ 37, 45 ], 58 => [ 36, 43, 51 ], 62 => [ 37, 45, 54 ], 66 => [ 36, 43, 51, 58 ], 71 => [ 37, 45, 54, 62 ], 73 => [ 36, 43, 51, 58, 66 ], 79 => [ 37, 45, 54, 62, 71 ], 81 => [ 36, 43, 51, 58, 66, 73 ], 88 => [ 36, 43, 51, 58, 66, 73, 81 ], 96 => [ 36, 43, 51, 58, 66, 73, 81, 88 ] },
	{  4 => [ 21, 12 ],  7 => [ 22, 14 ], 12 => [ 21 ], 14 => [ 22 ], 44 => [ 37 ], 46 => [ 38 ], 52 => [ 37, 44 ], 55 => [ 38, 46 ], 59 => [ 37, 44, 52 ], 63 => [ 38, 46, 55 ], 67 => [ 37, 44, 52, 59 ], 74 => [ 37, 44, 52, 59, 67 ], 82 => [ 37, 44, 52, 59, 67, 74 ], 89 => [ 37, 44, 52, 59, 67, 74, 82 ], 97 => [ 37, 44, 52, 59, 67, 74, 82, 89 ], 104 => [ 37, 44, 52, 59, 67, 74, 82, 89, 97 ], 112 => [ 37, 44, 52, 59, 67, 74, 82, 89, 97, 104 ] },
	{  5 => [ 22, 13 ], 13 => [ 22 ], 15 => [ 23 ], 45 => [ 38 ], 47 => [ 39 ], 53 => [ 38, 45 ], 60 => [ 38, 45, 53 ], 68 => [ 38, 45, 53, 60 ], 75 => [ 38, 45, 53, 60, 68 ], 83 => [ 38, 45, 53, 60, 68, 75 ], 90 => [ 38, 45, 53, 60, 68, 75, 83 ], 98 => [ 38, 45, 53, 60, 68, 75, 83, 90 ], 105 => [ 38, 45, 53, 60, 68, 75, 83, 90, 98 ], 113 => [ 38, 45, 53, 60, 68, 75, 83, 90, 98, 105 ], 120 => [ 38, 45, 53, 60, 68, 75, 83, 90, 98, 105, 113 ] },
	{  6 => [ 23, 14 ], 14 => [ 23 ], 46 => [ 39 ], 54 => [ 39, 46 ], 61 => [ 39, 46, 54 ], 69 => [ 39, 46, 54, 61 ], 76 => [ 39, 46, 54, 61, 69 ], 84 => [ 39, 46, 54, 61, 69, 76 ], 91 => [ 39, 46, 54, 61, 69, 76, 84 ], 99 => [ 39, 46, 54, 61, 69, 76, 84, 91 ], 106 => [ 39, 46, 54, 61, 69, 76, 84, 91, 99 ], 114 => [ 39, 46, 54, 61, 69, 76, 84, 91, 99, 106 ], 121 => [ 39, 46, 54, 61, 69, 76, 84, 91, 99, 106, 114 ] },
	{  2 => [ 24, 17,  9 ],  9 => [ 24, 17 ], 17 => [ 24 ], 49 => [ 40 ], 57 => [ 40, 49 ], 66 => [ 40, 49, 57 ], 74 => [ 40, 49, 57, 66 ], 83 => [ 40, 49, 57, 66, 74 ], 91 => [ 40, 49, 57, 66, 74, 83 ], 100 => [ 40, 49, 57, 66, 74, 83, 91 ], 108 => [ 40, 49, 57, 66, 74, 83, 91, 100 ], 117 => [ 40, 49, 57, 66, 74, 83, 91, 100, 108 ], 125 => [ 40, 49, 57, 66, 74, 83, 91, 100, 108, 117 ] },
	{  3 => [ 25, 18, 10 ], 10 => [ 25, 18 ], 16 => [ 24 ], 18 => [ 25 ], 48 => [ 40 ], 50 => [ 41 ], 58 => [ 41, 50 ], 67 => [ 41, 50, 58 ], 75 => [ 41, 50, 58, 67 ], 84 => [ 41, 50, 58, 67, 75 ], 92 => [ 41, 50, 58, 67, 75, 84 ], 101 => [ 41, 50, 58, 67, 75, 84, 92 ], 109 => [ 41, 50, 58, 67, 75, 84, 92, 101 ], 118 => [ 41, 50, 58, 67, 75, 84, 92, 101, 109 ], 126 => [ 41, 50, 58, 67, 75, 84, 92, 101, 109, 118 ] },
	{  0 => [ 25, 17,  8 ],  4 => [ 26, 19, 11 ],  8 => [ 25, 17 ], 11 => [ 26, 19 ], 17 => [ 25 ], 19 => [ 26 ], 49 => [ 41 ], 51 => [ 42 ], 56 => [ 41, 49 ], 59 => [ 42, 51 ], 64 => [ 41, 49, 56 ], 68 => [ 42, 51, 59 ], 76 => [ 42, 51, 59, 68 ], 85 => [ 42, 51, 59, 68, 76 ], 93 => [ 42, 51, 59, 68, 76, 85 ], 102 => [ 42, 51, 59, 68, 76, 85, 93 ], 110 => [ 42, 51, 59, 68, 76, 85, 93, 102 ], 119 => [ 42, 51, 59, 68, 76, 85, 93, 102, 110 ], 127 => [ 42, 51, 59, 68, 76, 85, 93, 102, 110, 119 ] },
	{  1 => [ 26, 18,  9 ],  5 => [ 27, 20, 12 ],  9 => [ 26, 18 ], 12 => [ 27, 20 ], 18 => [ 26 ], 20 => [ 27 ], 50 => [ 42 ], 52 => [ 43 ], 57 => [ 42, 50 ], 60 => [ 43, 52 ], 65 => [ 42, 50, 57 ], 69 => [ 43, 52, 60 ], 72 => [ 42, 50, 57, 65 ], 77 => [ 43, 52, 60, 69 ], 80 => [ 42, 50, 57, 65, 72 ], 86 => [ 43, 52, 60, 69, 77 ], 94 => [ 43, 52, 60, 69, 77, 86 ], 103 => [ 43, 52, 60, 69, 77, 86, 94 ], 111 => [ 43, 52, 60, 69, 77, 86, 94, 103 ] },
	{  2 => [ 27, 19, 10 ],  6 => [ 28, 21, 13 ], 10 => [ 27, 19 ], 13 => [ 28, 21 ], 19 => [ 27 ], 21 => [ 28 ], 51 => [ 43 ], 53 => [ 44 ], 58 => [ 43, 51 ], 61 => [ 44, 53 ], 66 => [ 43, 51, 58 ], 70 => [ 44, 53, 61 ], 73 => [ 43, 51, 58, 66 ], 78 => [ 44, 53, 61, 70 ], 81 => [ 43, 51, 58, 66, 73 ], 87 => [ 44, 53, 61, 70, 78 ], 88 => [ 43, 51, 58, 66, 73, 81 ], 95 => [ 44, 53, 61, 70, 78, 87 ], 96 => [ 43, 51, 58, 66, 73, 81, 88 ] },
	{  3 => [ 28, 20, 11 ],  7 => [ 29, 22, 14 ], 11 => [ 28, 20 ], 14 => [ 29, 22 ], 20 => [ 28 ], 22 => [ 29 ], 52 => [ 44 ], 54 => [ 45 ], 59 => [ 44, 52 ], 62 => [ 45, 54 ], 67 => [ 44, 52, 59 ], 71 => [ 45, 54, 62 ], 74 => [ 44, 52, 59, 67 ], 79 => [ 45, 54, 62, 71 ], 82 => [ 44, 52, 59, 67, 74 ], 89 => [ 44, 52, 59, 67, 74, 82 ], 97 => [ 44, 52, 59, 67, 74, 82, 89 ], 104 => [ 44, 52, 59, 67, 74, 82, 89, 97 ], 112 => [ 44, 52, 59, 67, 74, 82, 89, 97, 104 ] },
	{  4 => [ 29, 21, 12 ], 12 => [ 29, 21 ], 15 => [ 30, 23 ], 21 => [ 29 ], 23 => [ 30 ], 53 => [ 45 ], 55 => [ 46 ], 60 => [ 45, 53 ], 63 => [ 46, 55 ], 68 => [ 45, 53, 60 ], 75 => [ 45, 53, 60, 68 ], 83 => [ 45, 53, 60, 68, 75 ], 90 => [ 45, 53, 60, 68, 75, 83 ], 98 => [ 45, 53, 60, 68, 75, 83, 90 ], 105 => [ 45, 53, 60, 68, 75, 83, 90, 98 ], 113 => [ 45, 53, 60, 68, 75, 83, 90, 98, 105 ], 120 => [ 45, 53, 60, 68, 75, 83, 90, 98, 105, 113 ] },
	{  5 => [ 30, 22, 13 ], 13 => [ 30, 22 ], 22 => [ 30 ], 54 => [ 46 ], 61 => [ 46, 54 ], 69 => [ 46, 54, 61 ], 76 => [ 46, 54, 61, 69 ], 84 => [ 46, 54, 61, 69, 76 ], 91 => [ 46, 54, 61, 69, 76, 84 ], 99 => [ 46, 54, 61, 69, 76, 84, 91 ], 106 => [ 46, 54, 61, 69, 76, 84, 91, 99 ], 114 => [ 46, 54, 61, 69, 76, 84, 91, 99, 106 ], 121 => [ 46, 54, 61, 69, 76, 84, 91, 99, 106, 114 ] },
	{  3 => [ 33, 25, 18, 10 ], 10 => [ 33, 25, 18 ], 18 => [ 33, 25 ], 25 => [ 33 ], 57 => [ 49 ], 66 => [ 49, 57 ], 74 => [ 49, 57, 66 ], 83 => [ 49, 57, 66, 74 ], 91 => [ 49, 57, 66, 74, 83 ], 100 => [ 49, 57, 66, 74, 83, 91 ], 108 => [ 49, 57, 66, 74, 83, 91, 100 ], 117 => [ 49, 57, 66, 74, 83, 91, 100, 108 ], 125 => [ 49, 57, 66, 74, 83, 91, 100, 108, 117 ] },
	{  4 => [ 34, 26, 19, 11 ], 11 => [ 34, 26, 19 ], 16 => [ 33, 24 ], 19 => [ 34, 26 ], 24 => [ 33 ], 26 => [ 34 ], 56 => [ 49 ], 58 => [ 50 ], 64 => [ 49, 56 ], 67 => [ 50, 58 ], 75 => [ 50, 58, 67 ], 84 => [ 50, 58, 67, 75 ], 92 => [ 50, 58, 67, 75, 84 ], 101 => [ 50, 58, 67, 75, 84, 92 ], 109 => [ 50, 58, 67, 75, 84, 92, 101 ], 118 => [ 50, 58, 67, 75, 84, 92, 101, 109 ], 126 => [ 50, 58, 67, 75, 84, 92, 101, 109, 118 ] },
	{  0 => [ 34, 25, 17,  8 ],  5 => [ 35, 27, 20, 12 ],  8 => [ 34, 25, 17 ], 12 => [ 35, 27, 20 ], 17 => [ 34, 25 ], 20 => [ 35, 27 ], 25 => [ 34 ], 27 => [ 35 ], 57 => [ 50 ], 59 => [ 51 ], 65 => [ 50, 57 ], 68 => [ 51, 59 ], 72 => [ 50, 57, 65 ], 76 => [ 51, 59, 68 ], 80 => [ 50, 57, 65, 72 ], 85 => [ 51, 59, 68, 76 ], 93 => [ 51, 59, 68, 76, 85 ], 102 => [ 51, 59, 68, 76, 85, 93 ], 110 => [ 51, 59, 68, 76, 85, 93, 102 ], 119 => [ 51, 59, 68, 76, 85, 93, 102, 110 ], 127 => [ 51, 59, 68, 76, 85, 93, 102, 110, 119 ] },
	{  1 => [ 35, 26, 18,  9 ],  6 => [ 36, 28, 21, 13 ],  9 => [ 35, 26, 18 ], 13 => [ 36, 28, 21 ], 18 => [ 35, 26 ], 21 => [ 36, 28 ], 26 => [ 35 ], 28 => [ 36 ], 58 => [ 51 ], 60 => [ 52 ], 66 => [ 51, 58 ], 69 => [ 52, 60 ], 73 => [ 51, 58, 66 ], 77 => [ 52, 60, 69 ], 81 => [ 51, 58, 66, 73 ], 86 => [ 52, 60, 69, 77 ], 88 => [ 51, 58, 66, 73, 81 ], 94 => [ 52, 60, 69, 77, 86 ], 96 => [ 51, 58, 66, 73, 81, 88 ], 103 => [ 52, 60, 69, 77, 86, 94 ], 111 => [ 52, 60, 69, 77, 86, 94, 103 ] },
	{  2 => [ 36, 27, 19, 10 ],  7 => [ 37, 29, 22, 14 ], 10 => [ 36, 27, 19 ], 14 => [ 37, 29, 22 ], 19 => [ 36, 27 ], 22 => [ 37, 29 ], 27 => [ 36 ], 29 => [ 37 ], 59 => [ 52 ], 61 => [ 53 ], 67 => [ 52, 59 ], 70 => [ 53, 61 ], 74 => [ 52, 59, 67 ], 78 => [ 53, 61, 70 ], 82 => [ 52, 59, 67, 74 ], 87 => [ 53, 61, 70, 78 ], 89 => [ 52, 59, 67, 74, 82 ], 95 => [ 53, 61, 70, 78, 87 ], 97 => [ 52, 59, 67, 74, 82, 89 ], 104 => [ 52, 59, 67, 74, 82, 89, 97 ], 112 => [ 52, 59, 67, 74, 82, 89, 97, 104 ] },
	{  3 => [ 37, 28, 20, 11 ], 11 => [ 37, 28, 20 ], 15 => [ 38, 30, 23 ], 20 => [ 37, 28 ], 23 => [ 38, 30 ], 28 => [ 37 ], 30 => [ 38 ], 60 => [ 53 ], 62 => [ 54 ], 68 => [ 53, 60 ], 71 => [ 54, 62 ], 75 => [ 53, 60, 68 ], 79 => [ 54, 62, 71 ], 83 => [ 53, 60, 68, 75 ], 90 => [ 53, 60, 68, 75, 83 ], 98 => [ 53, 60, 68, 75, 83, 90 ], 105 => [ 53, 60, 68, 75, 83, 90, 98 ], 113 => [ 53, 60, 68, 75, 83, 90, 98, 105 ], 120 => [ 53, 60, 68, 75, 83, 90, 98, 105, 113 ] },
	{  4 => [ 38, 29, 21, 12 ], 12 => [ 38, 29, 21 ], 21 => [ 38, 29 ], 29 => [ 38 ], 31 => [ 39 ], 61 => [ 54 ], 63 => [ 55 ], 69 => [ 54, 61 ], 76 => [ 54, 61, 69 ], 84 => [ 54, 61, 69, 76 ], 91 => [ 54, 61, 69, 76, 84 ], 99 => [ 54, 61, 69, 76, 84, 91 ], 106 => [ 54, 61, 69, 76, 84, 91, 99 ], 114 => [ 54, 61, 69, 76, 84, 91, 99, 106 ], 121 => [ 54, 61, 69, 76, 84, 91, 99, 106, 114 ] },
	{  5 => [ 39, 30, 22, 13 ], 13 => [ 39, 30, 22 ], 22 => [ 39, 30 ], 30 => [ 39 ], 62 => [ 55 ], 70 => [ 55, 62 ], 77 => [ 55, 62, 70 ], 85 => [ 55, 62, 70, 77 ], 92 => [ 55, 62, 70, 77, 85 ], 100 => [ 55, 62, 70, 77, 85, 92 ], 107 => [ 55, 62, 70, 77, 85, 92, 100 ], 115 => [ 55, 62, 70, 77, 85, 92, 100, 107 ], 122 => [ 55, 62, 70, 77, 85, 92, 100, 107, 115 ] },
	{  3 => [ 40, 33, 25, 18, 10 ], 10 => [ 40, 33, 25, 18 ], 18 => [ 40, 33, 25 ], 25 => [ 40, 33 ], 33 => [ 40 ], 65 => [ 56 ], 73 => [ 56, 65 ], 82 => [ 56, 65, 73 ], 90 => [ 56, 65, 73, 82 ], 99 => [ 56, 65, 73, 82, 90 ], 107 => [ 56, 65, 73, 82, 90, 99 ], 116 => [ 56, 65, 73, 82, 90, 99, 107 ], 124 => [ 56, 65, 73, 82, 90, 99, 107, 116 ] },
	{  4 => [ 41, 34, 26, 19, 11 ], 11 => [ 41, 34, 26, 19 ], 19 => [ 41, 34, 26 ], 26 => [ 41, 34 ], 32 => [ 40 ], 34 => [ 41 ], 64 => [ 56 ], 66 => [ 57 ], 74 => [ 57, 66 ], 83 => [ 57, 66, 74 ], 91 => [ 57, 66, 74, 83 ], 100 => [ 57, 66, 74, 83, 91 ], 108 => [ 57, 66, 74, 83, 91, 100 ], 117 => [ 57, 66, 74, 83, 91, 100, 108 ], 125 => [ 57, 66, 74, 83, 91, 100, 108, 117 ] },
	{  5 => [ 42, 35, 27, 20, 12 ], 12 => [ 42, 35, 27, 20 ], 16 => [ 41, 33, 24 ], 20 => [ 42, 35, 27 ], 24 => [ 41, 33 ], 27 => [ 42, 35 ], 33 => [ 41 ], 35 => [ 42 ], 65 => [ 57 ], 67 => [ 58 ], 72 => [ 57, 65 ], 75 => [ 58, 67 ], 80 => [ 57, 65, 72 ], 84 => [ 58, 67, 75 ], 92 => [ 58, 67, 75, 84 ], 101 => [ 58, 67, 75, 84, 92 ], 109 => [ 58, 67, 75, 84, 92, 101 ], 118 => [ 58, 67, 75, 84, 92, 101, 109 ], 126 => [ 58, 67, 75, 84, 92, 101, 109, 118 ] },
	{  0 => [ 42, 34, 25, 17,  8 ],  6 => [ 43, 36, 28, 21, 13 ],  8 => [ 42, 34, 25, 17 ], 13 => [ 43, 36, 28, 21 ], 17 => [ 42, 34, 25 ], 21 => [ 43, 36, 28 ], 25 => [ 42, 34 ], 28 => [ 43, 36 ], 34 => [ 42 ], 36 => [ 43 ], 66 => [ 58 ], 68 => [ 59 ], 73 => [ 58, 66 ], 76 => [ 59, 68 ], 81 => [ 58, 66, 73 ], 85 => [ 59, 68, 76 ], 88 => [ 58, 66, 73, 81 ], 93 => [ 59, 68, 76, 85 ], 96 => [ 58, 66, 73, 81, 88 ], 102 => [ 59, 68, 76, 85, 93 ], 110 => [ 59, 68, 76, 85, 93, 102 ], 119 => [ 59, 68, 76, 85, 93, 102, 110 ], 127 => [ 59, 68, 76, 85, 93, 102, 110, 119 ] },
	{  1 => [ 43, 35, 26, 18,  9 ],  7 => [ 44, 37, 29, 22, 14 ],  9 => [ 43, 35, 26, 18 ], 14 => [ 44, 37, 29, 22 ], 18 => [ 43, 35, 26 ], 22 => [ 44, 37, 29 ], 26 => [ 43, 35 ], 29 => [ 44, 37 ], 35 => [ 43 ], 37 => [ 44 ], 67 => [ 59 ], 69 => [ 60 ], 74 => [ 59, 67 ], 77 => [ 60, 69 ], 82 => [ 59, 67, 74 ], 86 => [ 60, 69, 77 ], 89 => [ 59, 67, 74, 82 ], 94 => [ 60, 69, 77, 86 ], 97 => [ 59, 67, 74, 82, 89 ], 103 => [ 60, 69, 77, 86, 94 ], 104 => [ 59, 67, 74, 82, 89, 97 ], 111 => [ 60, 69, 77, 86, 94, 103 ], 112 => [ 59, 67, 74, 82, 89, 97, 104 ] },
	{  2 => [ 44, 36, 27, 19, 10 ], 10 => [ 44, 36, 27, 19 ], 15 => [ 45, 38, 30, 23 ], 19 => [ 44, 36, 27 ], 23 => [ 45, 38, 30 ], 27 => [ 44, 36 ], 30 => [ 45, 38 ], 36 => [ 44 ], 38 => [ 45 ], 68 => [ 60 ], 70 => [ 61 ], 75 => [ 60, 68 ], 78 => [ 61, 70 ], 83 => [ 60, 68, 75 ], 87 => [ 61, 70, 78 ], 90 => [ 60, 68, 75, 83 ], 95 => [ 61, 70, 78, 87 ], 98 => [ 60, 68, 75, 83, 90 ], 105 => [ 60, 68, 75, 83, 90, 98 ], 113 => [ 60, 68, 75, 83, 90, 98, 105 ], 120 => [ 60, 68, 75, 83, 90, 98, 105, 113 ] },
	{  3 => [ 45, 37, 28, 20, 11 ], 11 => [ 45, 37, 28, 20 ], 20 => [ 45, 37, 28 ], 28 => [ 45, 37 ], 31 => [ 46, 39 ], 37 => [ 45 ], 39 => [ 46 ], 69 => [ 61 ], 71 => [ 62 ], 76 => [ 61, 69 ], 79 => [ 62, 71 ], 84 => [ 61, 69, 76 ], 91 => [ 61, 69, 76, 84 ], 99 => [ 61, 69, 76, 84, 91 ], 106 => [ 61, 69, 76, 84, 91, 99 ], 114 => [ 61, 69, 76, 84, 91, 99, 106 ], 121 => [ 61, 69, 76, 84, 91, 99, 106, 114 ] },
	{  4 => [ 46, 38, 29, 21, 12 ], 12 => [ 46, 38, 29, 21 ], 21 => [ 46, 38, 29 ], 29 => [ 46, 38 ], 38 => [ 46 ], 70 => [ 62 ], 77 => [ 62, 70 ], 85 => [ 62, 70, 77 ], 92 => [ 62, 70, 77, 85 ], 100 => [ 62, 70, 77, 85, 92 ], 107 => [ 62, 70, 77, 85, 92, 100 ], 115 => [ 62, 70, 77, 85, 92, 100, 107 ], 122 => [ 62, 70, 77, 85, 92, 100, 107, 115 ] },
	{  4 => [ 49, 41, 34, 26, 19, 11 ], 11 => [ 49, 41, 34, 26, 19 ], 19 => [ 49, 41, 34, 26 ], 26 => [ 49, 41, 34 ], 34 => [ 49, 41 ], 41 => [ 49 ], 73 => [ 65 ], 82 => [ 65, 73 ], 90 => [ 65, 73, 82 ], 99 => [ 65, 73, 82, 90 ], 107 => [ 65, 73, 82, 90, 99 ], 116 => [ 65, 73, 82, 90, 99, 107 ], 124 => [ 65, 73, 82, 90, 99, 107, 116 ] },
	{  5 => [ 50, 42, 35, 27, 20, 12 ], 12 => [ 50, 42, 35, 27, 20 ], 20 => [ 50, 42, 35, 27 ], 27 => [ 50, 42, 35 ], 32 => [ 49, 40 ], 35 => [ 50, 42 ], 40 => [ 49 ], 42 => [ 50 ], 72 => [ 65 ], 74 => [ 66 ], 80 => [ 65, 72 ], 83 => [ 66, 74 ], 91 => [ 66, 74, 83 ], 100 => [ 66, 74, 83, 91 ], 108 => [ 66, 74, 83, 91, 100 ], 117 => [ 66, 74, 83, 91, 100, 108 ], 125 => [ 66, 74, 83, 91, 100, 108, 117 ] },
	{  6 => [ 51, 43, 36, 28, 21, 13 ], 13 => [ 51, 43, 36, 28, 21 ], 16 => [ 50, 41, 33, 24 ], 21 => [ 51, 43, 36, 28 ], 24 => [ 50, 41, 33 ], 28 => [ 51, 43, 36 ], 33 => [ 50, 41 ], 36 => [ 51, 43 ], 41 => [ 50 ], 43 => [ 51 ], 73 => [ 66 ], 75 => [ 67 ], 81 => [ 66, 73 ], 84 => [ 67, 75 ], 88 => [ 66, 73, 81 ], 92 => [ 67, 75, 84 ], 96 => [ 66, 73, 81, 88 ], 101 => [ 67, 75, 84, 92 ], 109 => [ 67, 75, 84, 92, 101 ], 118 => [ 67, 75, 84, 92, 101, 109 ], 126 => [ 67, 75, 84, 92, 101, 109, 118 ] },
	{  0 => [ 51, 42, 34, 25, 17,  8 ],  7 => [ 52, 44, 37, 29, 22, 14 ],  8 => [ 51, 42, 34, 25, 17 ], 14 => [ 52, 44, 37, 29, 22 ], 17 => [ 51, 42, 34, 25 ], 22 => [ 52, 44, 37, 29 ], 25 => [ 51, 42, 34 ], 29 => [ 52, 44, 37 ], 34 => [ 51, 42 ], 37 => [ 52, 44 ], 42 => [ 51 ], 44 => [ 52 ], 74 => [ 67 ], 76 => [ 68 ], 82 => [ 67, 74 ], 85 => [ 68, 76 ], 89 => [ 67, 74, 82 ], 93 => [ 68, 76, 85 ], 97 => [ 67, 74, 82, 89 ], 102 => [ 68, 76, 85, 93 ], 104 => [ 67, 74, 82, 89, 97 ], 110 => [ 68, 76, 85, 93, 102 ], 112 => [ 67, 74, 82, 89, 97, 104 ], 119 => [ 68, 76, 85, 93, 102, 110 ], 127 => [ 68, 76, 85, 93, 102, 110, 119 ] },
	{  1 => [ 52, 43, 35, 26, 18,  9 ],  9 => [ 52, 43, 35, 26, 18 ], 15 => [ 53, 45, 38, 30, 23 ], 18 => [ 52, 43, 35, 26 ], 23 => [ 53, 45, 38, 30 ], 26 => [ 52, 43, 35 ], 30 => [ 53, 45, 38 ], 35 => [ 52, 43 ], 38 => [ 53, 45 ], 43 => [ 52 ], 45 => [ 53 ], 75 => [ 68 ], 77 => [ 69 ], 83 => [ 68, 75 ], 86 => [ 69, 77 ], 90 => [ 68, 75, 83 ], 94 => [ 69, 77, 86 ], 98 => [ 68, 75, 83, 90 ], 103 => [ 69, 77, 86, 94 ], 105 => [ 68, 75, 83, 90, 98 ], 111 => [ 69, 77, 86, 94, 103 ], 113 => [ 68, 75, 83, 90, 98, 105 ], 120 => [ 68, 75, 83, 90, 98, 105, 113 ] },
	{  2 => [ 53, 44, 36, 27, 19, 10 ], 10 => [ 53, 44, 36, 27, 19 ], 19 => [ 53, 44, 36, 27 ], 27 => [ 53, 44, 36 ], 31 => [ 54, 46, 39 ], 36 => [ 53, 44 ], 39 => [ 54, 46 ], 44 => [ 53 ], 46 => [ 54 ], 76 => [ 69 ], 78 => [ 70 ], 84 => [ 69, 76 ], 87 => [ 70, 78 ], 91 => [ 69, 76, 84 ], 95 => [ 70, 78, 87 ], 99 => [ 69, 76, 84, 91 ], 106 => [ 69, 76, 84, 91, 99 ], 114 => [ 69, 76, 84, 91, 99, 106 ], 121 => [ 69, 76, 84, 91, 99, 106, 114 ] },
	{  3 => [ 54, 45, 37, 28, 20, 11 ], 11 => [ 54, 45, 37, 28, 20 ], 20 => [ 54, 45, 37, 28 ], 28 => [ 54, 45, 37 ], 37 => [ 54, 45 ], 45 => [ 54 ], 47 => [ 55 ], 77 => [ 70 ], 79 => [ 71 ], 85 => [ 70, 77 ], 92 => [ 70, 77, 85 ], 100 => [ 70, 77, 85, 92 ], 107 => [ 70, 77, 85, 92, 100 ], 115 => [ 70, 77, 85, 92, 100, 107 ], 122 => [ 70, 77, 85, 92, 100, 107, 115 ] },
	{  4 => [ 55, 46, 38, 29, 21, 12 ], 12 => [ 55, 46, 38, 29, 21 ], 21 => [ 55, 46, 38, 29 ], 29 => [ 55, 46, 38 ], 38 => [ 55, 46 ], 46 => [ 55 ], 78 => [ 71 ], 86 => [ 71, 78 ], 93 => [ 71, 78, 86 ], 101 => [ 71, 78, 86, 93 ], 108 => [ 71, 78, 86, 93, 101 ], 116 => [ 71, 78, 86, 93, 101, 108 ], 123 => [ 71, 78, 86, 93, 101, 108, 116 ] },
	{  4 => [ 56, 49, 41, 34, 26, 19, 11 ], 11 => [ 56, 49, 41, 34, 26, 19 ], 19 => [ 56, 49, 41, 34, 26 ], 26 => [ 56, 49, 41, 34 ], 34 => [ 56, 49, 41 ], 41 => [ 56, 49 ], 49 => [ 56 ], 81 => [ 72 ], 89 => [ 72, 81 ], 98 => [ 72, 81, 89 ], 106 => [ 72, 81, 89, 98 ], 115 => [ 72, 81, 89, 98, 106 ], 123 => [ 72, 81, 89, 98, 106, 115 ] },
	{  5 => [ 57, 50, 42, 35, 27, 20, 12 ], 12 => [ 57, 50, 42, 35, 27, 20 ], 20 => [ 57, 50, 42, 35, 27 ], 27 => [ 57, 50, 42, 35 ], 35 => [ 57, 50, 42 ], 42 => [ 57, 50 ], 48 => [ 56 ], 50 => [ 57 ], 80 => [ 72 ], 82 => [ 73 ], 90 => [ 73, 82 ], 99 => [ 73, 82, 90 ], 107 => [ 73, 82, 90, 99 ], 116 => [ 73, 82, 90, 99, 107 ], 124 => [ 73, 82, 90, 99, 107, 116 ] },
	{  6 => [ 58, 51, 43, 36, 28, 21, 13 ], 13 => [ 58, 51, 43, 36, 28, 21 ], 21 => [ 58, 51, 43, 36, 28 ], 28 => [ 58, 51, 43, 36 ], 32 => [ 57, 49, 40 ], 36 => [ 58, 51, 43 ], 40 => [ 57, 49 ], 43 => [ 58, 51 ], 49 => [ 57 ], 51 => [ 58 ], 81 => [ 73 ], 83 => [ 74 ], 88 => [ 73, 81 ], 91 => [ 74, 83 ], 96 => [ 73, 81, 88 ], 100 => [ 74, 83, 91 ], 108 => [ 74, 83, 91, 100 ], 117 => [ 74, 83, 91, 100, 108 ], 125 => [ 74, 83, 91, 100, 108, 117 ] },
	{  7 => [ 59, 52, 44, 37, 29, 22, 14 ], 14 => [ 59, 52, 44, 37, 29, 22 ], 16 => [ 58, 50, 41, 33, 24 ], 22 => [ 59, 52, 44, 37, 29 ], 24 => [ 58, 50, 41, 33 ], 29 => [ 59, 52, 44, 37 ], 33 => [ 58, 50, 41 ], 37 => [ 59, 52, 44 ], 41 => [ 58, 50 ], 44 => [ 59, 52 ], 50 => [ 58 ], 52 => [ 59 ], 82 => [ 74 ], 84 => [ 75 ], 89 => [ 74, 82 ], 92 => [ 75, 84 ], 97 => [ 74, 82, 89 ], 101 => [ 75, 84, 92 ], 104 => [ 74, 82, 89, 97 ], 109 => [ 75, 84, 92, 101 ], 112 => [ 74, 82, 89, 97, 104 ], 118 => [ 75, 84, 92, 101, 109 ], 126 => [ 75, 84, 92, 101, 109, 118 ] },
	{  0 => [ 59, 51, 42, 34, 25, 17,  8 ],  8 => [ 59, 51, 42, 34, 25, 17 ], 15 => [ 60, 53, 45, 38, 30, 23 ], 17 => [ 59, 51, 42, 34, 25 ], 23 => [ 60, 53, 45, 38, 30 ], 25 => [ 59, 51, 42, 34 ], 30 => [ 60, 53, 45, 38 ], 34 => [ 59, 51, 42 ], 38 => [ 60, 53, 45 ], 42 => [ 59, 51 ], 45 => [ 60, 53 ], 51 => [ 59 ], 53 => [ 60 ], 83 => [ 75 ], 85 => [ 76 ], 90 => [ 75, 83 ], 93 => [ 76, 85 ], 98 => [ 75, 83, 90 ], 102 => [ 76, 85, 93 ], 105 => [ 75, 83, 90, 98 ], 110 => [ 76, 85, 93, 102 ], 113 => [ 75, 83, 90, 98, 105 ], 119 => [ 76, 85, 93, 102, 110 ], 120 => [ 75, 83, 90, 98, 105, 113 ], 127 => [ 76, 85, 93, 102, 110, 119 ] },
	{  1 => [ 60, 52, 43, 35, 26, 18,  9 ],  9 => [ 60, 52, 43, 35, 26, 18 ], 18 => [ 60, 52, 43, 35, 26 ], 26 => [ 60, 52, 43, 35 ], 31 => [ 61, 54, 46, 39 ], 35 => [ 60, 52, 43 ], 39 => [ 61, 54, 46 ], 43 => [ 60, 52 ], 46 => [ 61, 54 ], 52 => [ 60 ], 54 => [ 61 ], 84 => [ 76 ], 86 => [ 77 ], 91 => [ 76, 84 ], 94 => [ 77, 86 ], 99 => [ 76, 84, 91 ], 103 => [ 77, 86, 94 ], 106 => [ 76, 84, 91, 99 ], 111 => [ 77, 86, 94, 103 ], 114 => [ 76, 84, 91, 99, 106 ], 121 => [ 76, 84, 91, 99, 106, 114 ] },
	{  2 => [ 61, 53, 44, 36, 27, 19, 10 ], 10 => [ 61, 53, 44, 36, 27, 19 ], 19 => [ 61, 53, 44, 36, 27 ], 27 => [ 61, 53, 44, 36 ], 36 => [ 61, 53, 44 ], 44 => [ 61, 53 ], 47 => [ 62, 55 ], 53 => [ 61 ], 55 => [ 62 ], 85 => [ 77 ], 87 => [ 78 ], 92 => [ 77, 85 ], 95 => [ 78, 87 ], 100 => [ 77, 85, 92 ], 107 => [ 77, 85, 92, 100 ], 115 => [ 77, 85, 92, 100, 107 ], 122 => [ 77, 85, 92, 100, 107, 115 ] },
	{  3 => [ 62, 54, 45, 37, 28, 20, 11 ], 11 => [ 62, 54, 45, 37, 28, 20 ], 20 => [ 62, 54, 45, 37, 28 ], 28 => [ 62, 54, 45, 37 ], 37 => [ 62, 54, 45 ], 45 => [ 62, 54 ], 54 => [ 62 ], 86 => [ 78 ], 93 => [ 78, 86 ], 101 => [ 78, 86, 93 ], 108 => [ 78, 86, 93, 101 ], 116 => [ 78, 86, 93, 101, 108 ], 123 => [ 78, 86, 93, 101, 108, 116 ] },
	{  5 => [ 65, 57, 50, 42, 35, 27, 20, 12 ], 12 => [ 65, 57, 50, 42, 35, 27, 20 ], 20 => [ 65, 57, 50, 42, 35, 27 ], 27 => [ 65, 57, 50, 42, 35 ], 35 => [ 65, 57, 50, 42 ], 42 => [ 65, 57, 50 ], 50 => [ 65, 57 ], 57 => [ 65 ], 89 => [ 81 ], 98 => [ 81, 89 ], 106 => [ 81, 89, 98 ], 115 => [ 81, 89, 98, 106 ], 123 => [ 81, 89, 98, 106, 115 ] },
	{  6 => [ 66, 58, 51, 43, 36, 28, 21, 13 ], 13 => [ 66, 58, 51, 43, 36, 28, 21 ], 21 => [ 66, 58, 51, 43, 36, 28 ], 28 => [ 66, 58, 51, 43, 36 ], 36 => [ 66, 58, 51, 43 ], 43 => [ 66, 58, 51 ], 48 => [ 65, 56 ], 51 => [ 66, 58 ], 56 => [ 65 ], 58 => [ 66 ], 88 => [ 81 ], 90 => [ 82 ], 96 => [ 81, 88 ], 99 => [ 82, 90 ], 107 => [ 82, 90, 99 ], 116 => [ 82, 90, 99, 107 ], 124 => [ 82, 90, 99, 107, 116 ] },
	{  7 => [ 67, 59, 52, 44, 37, 29, 22, 14 ], 14 => [ 67, 59, 52, 44, 37, 29, 22 ], 22 => [ 67, 59, 52, 44, 37, 29 ], 29 => [ 67, 59, 52, 44, 37 ], 32 => [ 66, 57, 49, 40 ], 37 => [ 67, 59, 52, 44 ], 40 => [ 66, 57, 49 ], 44 => [ 67, 59, 52 ], 49 => [ 66, 57 ], 52 => [ 67, 59 ], 57 => [ 66 ], 59 => [ 67 ], 89 => [ 82 ], 91 => [ 83 ], 97 => [ 82, 89 ], 100 => [ 83, 91 ], 104 => [ 82, 89, 97 ], 108 => [ 83, 91, 100 ], 112 => [ 82, 89, 97, 104 ], 117 => [ 83, 91, 100, 108 ], 125 => [ 83, 91, 100, 108, 117 ] },
	{ 15 => [ 68, 60, 53, 45, 38, 30, 23 ], 16 => [ 67, 58, 50, 41, 33, 24 ], 23 => [ 68, 60, 53, 45, 38, 30 ], 24 => [ 67, 58, 50, 41, 33 ], 30 => [ 68, 60, 53, 45, 38 ], 33 => [ 67, 58, 50, 41 ], 38 => [ 68, 60, 53, 45 ], 41 => [ 67, 58, 50 ], 45 => [ 68, 60, 53 ], 50 => [ 67, 58 ], 53 => [ 68, 60 ], 58 => [ 67 ], 60 => [ 68 ], 90 => [ 83 ], 92 => [ 84 ], 98 => [ 83, 90 ], 101 => [ 84, 92 ], 105 => [ 83, 90, 98 ], 109 => [ 84, 92, 101 ], 113 => [ 83, 90, 98, 105 ], 118 => [ 84, 92, 101, 109 ], 120 => [ 83, 90, 98, 105, 113 ], 126 => [ 84, 92, 101, 109, 118 ] },
	{  0 => [ 68, 59, 51, 42, 34, 25, 17,  8 ],  8 => [ 68, 59, 51, 42, 34, 25, 17 ], 17 => [ 68, 59, 51, 42, 34, 25 ], 25 => [ 68, 59, 51, 42, 34 ], 31 => [ 69, 61, 54, 46, 39 ], 34 => [ 68, 59, 51, 42 ], 39 => [ 69, 61, 54, 46 ], 42 => [ 68, 59, 51 ], 46 => [ 69, 61, 54 ], 51 => [ 68, 59 ], 54 => [ 69, 61 ], 59 => [ 68 ], 61 => [ 69 ], 91 => [ 84 ], 93 => [ 85 ], 99 => [ 84, 91 ], 102 => [ 85, 93 ], 106 => [ 84, 91, 99 ], 110 => [ 85, 93, 102 ], 114 => [ 84, 91, 99, 106 ], 119 => [ 85, 93, 102, 110 ], 121 => [ 84, 91, 99, 106, 114 ], 127 => [ 85, 93, 102, 110, 119 ] },
	{  1 => [ 69, 60, 52, 43, 35, 26, 18,  9 ],  9 => [ 69, 60, 52, 43, 35, 26, 18 ], 18 => [ 69, 60, 52, 43, 35, 26 ], 26 => [ 69, 60, 52, 43, 35 ], 35 => [ 69, 60, 52, 43 ], 43 => [ 69, 60, 52 ], 47 => [ 70, 62, 55 ], 52 => [ 69, 60 ], 55 => [ 70, 62 ], 60 => [ 69 ], 62 => [ 70 ], 92 => [ 85 ], 94 => [ 86 ], 100 => [ 85, 92 ], 103 => [ 86, 94 ], 107 => [ 85, 92, 100 ], 111 => [ 86, 94, 103 ], 115 => [ 85, 92, 100, 107 ], 122 => [ 85, 92, 100, 107, 115 ] },
	{  2 => [ 70, 61, 53, 44, 36, 27, 19, 10 ], 10 => [ 70, 61, 53, 44, 36, 27, 19 ], 19 => [ 70, 61, 53, 44, 36, 27 ], 27 => [ 70, 61, 53, 44, 36 ], 36 => [ 70, 61, 53, 44 ], 44 => [ 70, 61, 53 ], 53 => [ 70, 61 ], 61 => [ 70 ], 63 => [ 71 ], 93 => [ 86 ], 95 => [ 87 ], 101 => [ 86, 93 ], 108 => [ 86, 93, 101 ], 116 => [ 86, 93, 101, 108 ], 123 => [ 86, 93, 101, 108, 116 ] },
	{  3 => [ 71, 62, 54, 45, 37, 28, 20, 11 ], 11 => [ 71, 62, 54, 45, 37, 28, 20 ], 20 => [ 71, 62, 54, 45, 37, 28 ], 28 => [ 71, 62, 54, 45, 37 ], 37 => [ 71, 62, 54, 45 ], 45 => [ 71, 62, 54 ], 54 => [ 71, 62 ], 62 => [ 71 ], 94 => [ 87 ], 102 => [ 87, 94 ], 109 => [ 87, 94, 102 ], 117 => [ 87, 94, 102, 109 ], 124 => [ 87, 94, 102, 109, 117 ] },
	{  5 => [ 72, 65, 57, 50, 42, 35, 27, 20, 12 ], 12 => [ 72, 65, 57, 50, 42, 35, 27, 20 ], 20 => [ 72, 65, 57, 50, 42, 35, 27 ], 27 => [ 72, 65, 57, 50, 42, 35 ], 35 => [ 72, 65, 57, 50, 42 ], 42 => [ 72, 65, 57, 50 ], 50 => [ 72, 65, 57 ], 57 => [ 72, 65 ], 65 => [ 72 ], 97 => [ 88 ], 105 => [ 88, 97 ], 114 => [ 88, 97, 105 ], 122 => [ 88, 97, 105, 114 ] },
	{  6 => [ 73, 66, 58, 51, 43, 36, 28, 21, 13 ], 13 => [ 73, 66, 58, 51, 43, 36, 28, 21 ], 21 => [ 73, 66, 58, 51, 43, 36, 28 ], 28 => [ 73, 66, 58, 51, 43, 36 ], 36 => [ 73, 66, 58, 51, 43 ], 43 => [ 73, 66, 58, 51 ], 51 => [ 73, 66, 58 ], 58 => [ 73, 66 ], 64 => [ 72 ], 66 => [ 73 ], 96 => [ 88 ], 98 => [ 89 ], 106 => [ 89, 98 ], 115 => [ 89, 98, 106 ], 123 => [ 89, 98, 106, 115 ] },
	{  7 => [ 74, 67, 59, 52, 44, 37, 29, 22, 14 ], 14 => [ 74, 67, 59, 52, 44, 37, 29, 22 ], 22 => [ 74, 67, 59, 52, 44, 37, 29 ], 29 => [ 74, 67, 59, 52, 44, 37 ], 37 => [ 74, 67, 59, 52, 44 ], 44 => [ 74, 67, 59, 52 ], 48 => [ 73, 65, 56 ], 52 => [ 74, 67, 59 ], 56 => [ 73, 65 ], 59 => [ 74, 67 ], 65 => [ 73 ], 67 => [ 74 ], 97 => [ 89 ], 99 => [ 90 ], 104 => [ 89, 97 ], 107 => [ 90, 99 ], 112 => [ 89, 97, 104 ], 116 => [ 90, 99, 107 ], 124 => [ 90, 99, 107, 116 ] },
	{ 15 => [ 75, 68, 60, 53, 45, 38, 30, 23 ], 23 => [ 75, 68, 60, 53, 45, 38, 30 ], 30 => [ 75, 68, 60, 53, 45, 38 ], 32 => [ 74, 66, 57, 49, 40 ], 38 => [ 75, 68, 60, 53, 45 ], 40 => [ 74, 66, 57, 49 ], 45 => [ 75, 68, 60, 53 ], 49 => [ 74, 66, 57 ], 53 => [ 75, 68, 60 ], 57 => [ 74, 66 ], 60 => [ 75, 68 ], 66 => [ 74 ], 68 => [ 75 ], 98 => [ 90 ], 100 => [ 91 ], 105 => [ 90, 98 ], 108 => [ 91, 100 ], 113 => [ 90, 98, 105 ], 117 => [ 91, 100, 108 ], 120 => [ 90, 98, 105, 113 ], 125 => [ 91, 100, 108, 117 ] },
	{ 16 => [ 75, 67, 58, 50, 41, 33, 24 ], 24 => [ 75, 67, 58, 50, 41, 33 ], 31 => [ 76, 69, 61, 54, 46, 39 ], 33 => [ 75, 67, 58, 50, 41 ], 39 => [ 76, 69, 61, 54, 46 ], 41 => [ 75, 67, 58, 50 ], 46 => [ 76, 69, 61, 54 ], 50 => [ 75, 67, 58 ], 54 => [ 76, 69, 61 ], 58 => [ 75, 67 ], 61 => [ 76, 69 ], 67 => [ 75 ], 69 => [ 76 ], 99 => [ 91 ], 101 => [ 92 ], 106 => [ 91, 99 ], 109 => [ 92, 101 ], 114 => [ 91, 99, 106 ], 118 => [ 92, 101, 109 ], 121 => [ 91, 99, 106, 114 ], 126 => [ 92, 101, 109, 118 ] },
	{  0 => [ 76, 68, 59, 51, 42, 34, 25, 17,  8 ],  8 => [ 76, 68, 59, 51, 42, 34, 25, 17 ], 17 => [ 76, 68, 59, 51, 42, 34, 25 ], 25 => [ 76, 68, 59, 51, 42, 34 ], 34 => [ 76, 68, 59, 51, 42 ], 42 => [ 76, 68, 59, 51 ], 47 => [ 77, 70, 62, 55 ], 51 => [ 76, 68, 59 ], 55 => [ 77, 70, 62 ], 59 => [ 76, 68 ], 62 => [ 77, 70 ], 68 => [ 76 ], 70 => [ 77 ], 100 => [ 92 ], 102 => [ 93 ], 107 => [ 92, 100 ], 110 => [ 93, 102 ], 115 => [ 92, 100, 107 ], 119 => [ 93, 102, 110 ], 122 => [ 92, 100, 107, 115 ], 127 => [ 93, 102, 110, 119 ] },
	{  1 => [ 77, 69, 60, 52, 43, 35, 26, 18,  9 ],  9 => [ 77, 69, 60, 52, 43, 35, 26, 18 ], 18 => [ 77, 69, 60, 52, 43, 35, 26 ], 26 => [ 77, 69, 60, 52, 43, 35 ], 35 => [ 77, 69, 60, 52, 43 ], 43 => [ 77, 69, 60, 52 ], 52 => [ 77, 69, 60 ], 60 => [ 77, 69 ], 63 => [ 78, 71 ], 69 => [ 77 ], 71 => [ 78 ], 101 => [ 93 ], 103 => [ 94 ], 108 => [ 93, 101 ], 111 => [ 94, 103 ], 116 => [ 93, 101, 108 ], 123 => [ 93, 101, 108, 116 ] },
	{  2 => [ 78, 70, 61, 53, 44, 36, 27, 19, 10 ], 10 => [ 78, 70, 61, 53, 44, 36, 27, 19 ], 19 => [ 78, 70, 61, 53, 44, 36, 27 ], 27 => [ 78, 70, 61, 53, 44, 36 ], 36 => [ 78, 70, 61, 53, 44 ], 44 => [ 78, 70, 61, 53 ], 53 => [ 78, 70, 61 ], 61 => [ 78, 70 ], 70 => [ 78 ], 102 => [ 94 ], 109 => [ 94, 102 ], 117 => [ 94, 102, 109 ], 124 => [ 94, 102, 109, 117 ] },
	{  6 => [ 81, 73, 66, 58, 51, 43, 36, 28, 21, 13 ], 13 => [ 81, 73, 66, 58, 51, 43, 36, 28, 21 ], 21 => [ 81, 73, 66, 58, 51, 43, 36, 28 ], 28 => [ 81, 73, 66, 58, 51, 43, 36 ], 36 => [ 81, 73, 66, 58, 51, 43 ], 43 => [ 81, 73, 66, 58, 51 ], 51 => [ 81, 73, 66, 58 ], 58 => [ 81, 73, 66 ], 66 => [ 81, 73 ], 73 => [ 81 ], 105 => [ 97 ], 114 => [ 97, 105 ], 122 => [ 97, 105, 114 ] },
	{  7 => [ 82, 74, 67, 59, 52, 44, 37, 29, 22, 14 ], 14 => [ 82, 74, 67, 59, 52, 44, 37, 29, 22 ], 22 => [ 82, 74, 67, 59, 52, 44, 37, 29 ], 29 => [ 82, 74, 67, 59, 52, 44, 37 ], 37 => [ 82, 74, 67, 59, 52, 44 ], 44 => [ 82, 74, 67, 59, 52 ], 52 => [ 82, 74, 67, 59 ], 59 => [ 82, 74, 67 ], 64 => [ 81, 72 ], 67 => [ 82, 74 ], 72 => [ 81 ], 74 => [ 82 ], 104 => [ 97 ], 106 => [ 98 ], 112 => [ 97, 104 ], 115 => [ 98, 106 ], 123 => [ 98, 106, 115 ] },
	{ 15 => [ 83, 75, 68, 60, 53, 45, 38, 30, 23 ], 23 => [ 83, 75, 68, 60, 53, 45, 38, 30 ], 30 => [ 83, 75, 68, 60, 53, 45, 38 ], 38 => [ 83, 75, 68, 60, 53, 45 ], 45 => [ 83, 75, 68, 60, 53 ], 48 => [ 82, 73, 65, 56 ], 53 => [ 83, 75, 68, 60 ], 56 => [ 82, 73, 65 ], 60 => [ 83, 75, 68 ], 65 => [ 82, 73 ], 68 => [ 83, 75 ], 73 => [ 82 ], 75 => [ 83 ], 105 => [ 98 ], 107 => [ 99 ], 113 => [ 98, 105 ], 116 => [ 99, 107 ], 120 => [ 98, 105, 113 ], 124 => [ 99, 107, 116 ] },
	{ 31 => [ 84, 76, 69, 61, 54, 46, 39 ], 32 => [ 83, 74, 66, 57, 49, 40 ], 39 => [ 84, 76, 69, 61, 54, 46 ], 40 => [ 83, 74, 66, 57, 49 ], 46 => [ 84, 76, 69, 61, 54 ], 49 => [ 83, 74, 66, 57 ], 54 => [ 84, 76, 69, 61 ], 57 => [ 83, 74, 66 ], 61 => [ 84, 76, 69 ], 66 => [ 83, 74 ], 69 => [ 84, 76 ], 74 => [ 83 ], 76 => [ 84 ], 106 => [ 99 ], 108 => [ 100 ], 114 => [ 99, 106 ], 117 => [ 100, 108 ], 121 => [ 99, 106, 114 ], 125 => [ 100, 108, 117 ] },
	{ 16 => [ 84, 75, 67, 58, 50, 41, 33, 24 ], 24 => [ 84, 75, 67, 58, 50, 41, 33 ], 33 => [ 84, 75, 67, 58, 50, 41 ], 41 => [ 84, 75, 67, 58, 50 ], 47 => [ 85, 77, 70, 62, 55 ], 50 => [ 84, 75, 67, 58 ], 55 => [ 85, 77, 70, 62 ], 58 => [ 84, 75, 67 ], 62 => [ 85, 77, 70 ], 67 => [ 84, 75 ], 70 => [ 85, 77 ], 75 => [ 84 ], 77 => [ 85 ], 107 => [ 100 ], 109 => [ 101 ], 115 => [ 100, 107 ], 118 => [ 101, 109 ], 122 => [ 100, 107, 115 ], 126 => [ 101, 109, 118 ] },
	{  0 => [ 85, 76, 68, 59, 51, 42, 34, 25, 17,  8 ],  8 => [ 85, 76, 68, 59, 51, 42, 34, 25, 17 ], 17 => [ 85, 76, 68, 59, 51, 42, 34, 25 ], 25 => [ 85, 76, 68, 59, 51, 42, 34 ], 34 => [ 85, 76, 68, 59, 51, 42 ], 42 => [ 85, 76, 68, 59, 51 ], 51 => [ 85, 76, 68, 59 ], 59 => [ 85, 76, 68 ], 63 => [ 86, 78, 71 ], 68 => [ 85, 76 ], 71 => [ 86, 78 ], 76 => [ 85 ], 78 => [ 86 ], 108 => [ 101 ], 110 => [ 102 ], 116 => [ 101, 108 ], 119 => [ 102, 110 ], 123 => [ 101, 108, 116 ], 127 => [ 102, 110, 119 ] },
	{  1 => [ 86, 77, 69, 60, 52, 43, 35, 26, 18,  9 ],  9 => [ 86, 77, 69, 60, 52, 43, 35, 26, 18 ], 18 => [ 86, 77, 69, 60, 52, 43, 35, 26 ], 26 => [ 86, 77, 69, 60, 52, 43, 35 ], 35 => [ 86, 77, 69, 60, 52, 43 ], 43 => [ 86, 77, 69, 60, 52 ], 52 => [ 86, 77, 69, 60 ], 60 => [ 86, 77, 69 ], 69 => [ 86, 77 ], 77 => [ 86 ], 79 => [ 87 ], 109 => [ 102 ], 111 => [ 103 ], 117 => [ 102, 109 ], 124 => [ 102, 109, 117 ] },
	{  2 => [ 87, 78, 70, 61, 53, 44, 36, 27, 19, 10 ], 10 => [ 87, 78, 70, 61, 53, 44, 36, 27, 19 ], 19 => [ 87, 78, 70, 61, 53, 44, 36, 27 ], 27 => [ 87, 78, 70, 61, 53, 44, 36 ], 36 => [ 87, 78, 70, 61, 53, 44 ], 44 => [ 87, 78, 70, 61, 53 ], 53 => [ 87, 78, 70, 61 ], 61 => [ 87, 78, 70 ], 70 => [ 87, 78 ], 78 => [ 87 ], 110 => [ 103 ], 118 => [ 103, 110 ], 125 => [ 103, 110, 118 ] },
	{  6 => [ 88, 81, 73, 66, 58, 51, 43, 36, 28, 21, 13 ], 13 => [ 88, 81, 73, 66, 58, 51, 43, 36, 28, 21 ], 21 => [ 88, 81, 73, 66, 58, 51, 43, 36, 28 ], 28 => [ 88, 81, 73, 66, 58, 51, 43, 36 ], 36 => [ 88, 81, 73, 66, 58, 51, 43 ], 43 => [ 88, 81, 73, 66, 58, 51 ], 51 => [ 88, 81, 73, 66, 58 ], 58 => [ 88, 81, 73, 66 ], 66 => [ 88, 81, 73 ], 73 => [ 88, 81 ], 81 => [ 88 ], 113 => [ 104 ], 121 => [ 104, 113 ] },
	{  7 => [ 89, 82, 74, 67, 59, 52, 44, 37, 29, 22, 14 ], 14 => [ 89, 82, 74, 67, 59, 52, 44, 37, 29, 22 ], 22 => [ 89, 82, 74, 67, 59, 52, 44, 37, 29 ], 29 => [ 89, 82, 74, 67, 59, 52, 44, 37 ], 37 => [ 89, 82, 74, 67, 59, 52, 44 ], 44 => [ 89, 82, 74, 67, 59, 52 ], 52 => [ 89, 82, 74, 67, 59 ], 59 => [ 89, 82, 74, 67 ], 67 => [ 89, 82, 74 ], 74 => [ 89, 82 ], 80 => [ 88 ], 82 => [ 89 ], 112 => [ 104 ], 114 => [ 105 ], 122 => [ 105, 114 ] },
	{ 15 => [ 90, 83, 75, 68, 60, 53, 45, 38, 30, 23 ], 23 => [ 90, 83, 75, 68, 60, 53, 45, 38, 30 ], 30 => [ 90, 83, 75, 68, 60, 53, 45, 38 ], 38 => [ 90, 83, 75, 68, 60, 53, 45 ], 45 => [ 90, 83, 75, 68, 60, 53 ], 53 => [ 90, 83, 75, 68, 60 ], 60 => [ 90, 83, 75, 68 ], 64 => [ 89, 81, 72 ], 68 => [ 90, 83, 75 ], 72 => [ 89, 81 ], 75 => [ 90, 83 ], 81 => [ 89 ], 83 => [ 90 ], 113 => [ 105 ], 115 => [ 106 ], 120 => [ 105, 113 ], 123 => [ 106, 115 ] },
	{ 31 => [ 91, 84, 76, 69, 61, 54, 46, 39 ], 39 => [ 91, 84, 76, 69, 61, 54, 46 ], 46 => [ 91, 84, 76, 69, 61, 54 ], 48 => [ 90, 82, 73, 65, 56 ], 54 => [ 91, 84, 76, 69, 61 ], 56 => [ 90, 82, 73, 65 ], 61 => [ 91, 84, 76, 69 ], 65 => [ 90, 82, 73 ], 69 => [ 91, 84, 76 ], 73 => [ 90, 82 ], 76 => [ 91, 84 ], 82 => [ 90 ], 84 => [ 91 ], 114 => [ 106 ], 116 => [ 107 ], 121 => [ 106, 114 ], 124 => [ 107, 116 ] },
	{ 32 => [ 91, 83, 74, 66, 57, 49, 40 ], 40 => [ 91, 83, 74, 66, 57, 49 ], 47 => [ 92, 85, 77, 70, 62, 55 ], 49 => [ 91, 83, 74, 66, 57 ], 55 => [ 92, 85, 77, 70, 62 ], 57 => [ 91, 83, 74, 66 ], 62 => [ 92, 85, 77, 70 ], 66 => [ 91, 83, 74 ], 70 => [ 92, 85, 77 ], 74 => [ 91, 83 ], 77 => [ 92, 85 ], 83 => [ 91 ], 85 => [ 92 ], 115 => [ 107 ], 117 => [ 108 ], 122 => [ 107, 115 ], 125 => [ 108, 117 ] },
	{ 16 => [ 92, 84, 75, 67, 58, 50, 41, 33, 24 ], 24 => [ 92, 84, 75, 67, 58, 50, 41, 33 ], 33 => [ 92, 84, 75, 67, 58, 50, 41 ], 41 => [ 92, 84, 75, 67, 58, 50 ], 50 => [ 92, 84, 75, 67, 58 ], 58 => [ 92, 84, 75, 67 ], 63 => [ 93, 86, 78, 71 ], 67 => [ 92, 84, 75 ], 71 => [ 93, 86, 78 ], 75 => [ 92, 84 ], 78 => [ 93, 86 ], 84 => [ 92 ], 86 => [ 93 ], 116 => [ 108 ], 118 => [ 109 ], 123 => [ 108, 116 ], 126 => [ 109, 118 ] },
	{  0 => [ 93, 85, 76, 68, 59, 51, 42, 34, 25, 17,  8 ],  8 => [ 93, 85, 76, 68, 59, 51, 42, 34, 25, 17 ], 17 => [ 93, 85, 76, 68, 59, 51, 42, 34, 25 ], 25 => [ 93, 85, 76, 68, 59, 51, 42, 34 ], 34 => [ 93, 85, 76, 68, 59, 51, 42 ], 42 => [ 93, 85, 76, 68, 59, 51 ], 51 => [ 93, 85, 76, 68, 59 ], 59 => [ 93, 85, 76, 68 ], 68 => [ 93, 85, 76 ], 76 => [ 93, 85 ], 79 => [ 94, 87 ], 85 => [ 93 ], 87 => [ 94 ], 117 => [ 109 ], 119 => [ 110 ], 124 => [ 109, 117 ], 127 => [ 110, 119 ] },
	{  1 => [ 94, 86, 77, 69, 60, 52, 43, 35, 26, 18,  9 ],  9 => [ 94, 86, 77, 69, 60, 52, 43, 35, 26, 18 ], 18 => [ 94, 86, 77, 69, 60, 52, 43, 35, 26 ], 26 => [ 94, 86, 77, 69, 60, 52, 43, 35 ], 35 => [ 94, 86, 77, 69, 60, 52, 43 ], 43 => [ 94, 86, 77, 69, 60, 52 ], 52 => [ 94, 86, 77, 69, 60 ], 60 => [ 94, 86, 77, 69 ], 69 => [ 94, 86, 77 ], 77 => [ 94, 86 ], 86 => [ 94 ], 118 => [ 110 ], 125 => [ 110, 118 ] },
	{  7 => [ 97, 89, 82, 74, 67, 59, 52, 44, 37, 29, 22, 14 ], 14 => [ 97, 89, 82, 74, 67, 59, 52, 44, 37, 29, 22 ], 22 => [ 97, 89, 82, 74, 67, 59, 52, 44, 37, 29 ], 29 => [ 97, 89, 82, 74, 67, 59, 52, 44, 37 ], 37 => [ 97, 89, 82, 74, 67, 59, 52, 44 ], 44 => [ 97, 89, 82, 74, 67, 59, 52 ], 52 => [ 97, 89, 82, 74, 67, 59 ], 59 => [ 97, 89, 82, 74, 67 ], 67 => [ 97, 89, 82, 74 ], 74 => [ 97, 89, 82 ], 82 => [ 97, 89 ], 89 => [ 97 ], 121 => [ 113 ] },
	{ 15 => [ 98, 90, 83, 75, 68, 60, 53, 45, 38, 30, 23 ], 23 => [ 98, 90, 83, 75, 68, 60, 53, 45, 38, 30 ], 30 => [ 98, 90, 83, 75, 68, 60, 53, 45, 38 ], 38 => [ 98, 90, 83, 75, 68, 60, 53, 45 ], 45 => [ 98, 90, 83, 75, 68, 60, 53 ], 53 => [ 98, 90, 83, 75, 68, 60 ], 60 => [ 98, 90, 83, 75, 68 ], 68 => [ 98, 90, 83, 75 ], 75 => [ 98, 90, 83 ], 80 => [ 97, 88 ], 83 => [ 98, 90 ], 88 => [ 97 ], 90 => [ 98 ], 120 => [ 113 ], 122 => [ 114 ] },
	{ 31 => [ 99, 91, 84, 76, 69, 61, 54, 46, 39 ], 39 => [ 99, 91, 84, 76, 69, 61, 54, 46 ], 46 => [ 99, 91, 84, 76, 69, 61, 54 ], 54 => [ 99, 91, 84, 76, 69, 61 ], 61 => [ 99, 91, 84, 76, 69 ], 64 => [ 98, 89, 81, 72 ], 69 => [ 99, 91, 84, 76 ], 72 => [ 98, 89, 81 ], 76 => [ 99, 91, 84 ], 81 => [ 98, 89 ], 84 => [ 99, 91 ], 89 => [ 98 ], 91 => [ 99 ], 121 => [ 114 ], 123 => [ 115 ] },
	{ 47 => [ 100, 92, 85, 77, 70, 62, 55 ], 48 => [ 99, 90, 82, 73, 65, 56 ], 55 => [ 100, 92, 85, 77, 70, 62 ], 56 => [ 99, 90, 82, 73, 65 ], 62 => [ 100, 92, 85, 77, 70 ], 65 => [ 99, 90, 82, 73 ], 70 => [ 100, 92, 85, 77 ], 73 => [ 99, 90, 82 ], 77 => [ 100, 92, 85 ], 82 => [ 99, 90 ], 85 => [ 100, 92 ], 90 => [ 99 ], 92 => [ 100 ], 122 => [ 115 ], 124 => [ 116 ] },
	{ 32 => [ 100, 91, 83, 74, 66, 57, 49, 40 ], 40 => [ 100, 91, 83, 74, 66, 57, 49 ], 49 => [ 100, 91, 83, 74, 66, 57 ], 57 => [ 100, 91, 83, 74, 66 ], 63 => [ 101, 93, 86, 78, 71 ], 66 => [ 100, 91, 83, 74 ], 71 => [ 101, 93, 86, 78 ], 74 => [ 100, 91, 83 ], 78 => [ 101, 93, 86 ], 83 => [ 100, 91 ], 86 => [ 101, 93 ], 91 => [ 100 ], 93 => [ 101 ], 123 => [ 116 ], 125 => [ 117 ] },
	{ 16 => [ 101, 92, 84, 75, 67, 58, 50, 41, 33, 24 ], 24 => [ 101, 92, 84, 75, 67, 58, 50, 41, 33 ], 33 => [ 101, 92, 84, 75, 67, 58, 50, 41 ], 41 => [ 101, 92, 84, 75, 67, 58, 50 ], 50 => [ 101, 92, 84, 75, 67, 58 ], 58 => [ 101, 92, 84, 75, 67 ], 67 => [ 101, 92, 84, 75 ], 75 => [ 101, 92, 84 ], 79 => [ 102, 94, 87 ], 84 => [ 101, 92 ], 87 => [ 102, 94 ], 92 => [ 101 ], 94 => [ 102 ], 124 => [ 117 ], 126 => [ 118 ] },
	{  0 => [ 102, 93, 85, 76, 68, 59, 51, 42, 34, 25, 17,  8 ],  8 => [ 102, 93, 85, 76, 68, 59, 51, 42, 34, 25, 17 ], 17 => [ 102, 93, 85, 76, 68, 59, 51, 42, 34, 25 ], 25 => [ 102, 93, 85, 76, 68, 59, 51, 42, 34 ], 34 => [ 102, 93, 85, 76, 68, 59, 51, 42 ], 42 => [ 102, 93, 85, 76, 68, 59, 51 ], 51 => [ 102, 93, 85, 76, 68, 59 ], 59 => [ 102, 93, 85, 76, 68 ], 68 => [ 102, 93, 85, 76 ], 76 => [ 102, 93, 85 ], 85 => [ 102, 93 ], 93 => [ 102 ], 95 => [ 103 ], 125 => [ 118 ], 127 => [ 119 ] },
	{  1 => [ 103, 94, 86, 77, 69, 60, 52, 43, 35, 26, 18,  9 ],  9 => [ 103, 94, 86, 77, 69, 60, 52, 43, 35, 26, 18 ], 18 => [ 103, 94, 86, 77, 69, 60, 52, 43, 35, 26 ], 26 => [ 103, 94, 86, 77, 69, 60, 52, 43, 35 ], 35 => [ 103, 94, 86, 77, 69, 60, 52, 43 ], 43 => [ 103, 94, 86, 77, 69, 60, 52 ], 52 => [ 103, 94, 86, 77, 69, 60 ], 60 => [ 103, 94, 86, 77, 69 ], 69 => [ 103, 94, 86, 77 ], 77 => [ 103, 94, 86 ], 86 => [ 103, 94 ], 94 => [ 103 ], 126 => [ 119 ] },
	{  7 => [ 104, 97, 89, 82, 74, 67, 59, 52, 44, 37, 29, 22, 14 ], 14 => [ 104, 97, 89, 82, 74, 67, 59, 52, 44, 37, 29, 22 ], 22 => [ 104, 97, 89, 82, 74, 67, 59, 52, 44, 37, 29 ], 29 => [ 104, 97, 89, 82, 74, 67, 59, 52, 44, 37 ], 37 => [ 104, 97, 89, 82, 74, 67, 59, 52, 44 ], 44 => [ 104, 97, 89, 82, 74, 67, 59, 52 ], 52 => [ 104, 97, 89, 82, 74, 67, 59 ], 59 => [ 104, 97, 89, 82, 74, 67 ], 67 => [ 104, 97, 89, 82, 74 ], 74 => [ 104, 97, 89, 82 ], 82 => [ 104, 97, 89 ], 89 => [ 104, 97 ], 97 => [ 104 ] },
	{ 15 => [ 105, 98, 90, 83, 75, 68, 60, 53, 45, 38, 30, 23 ], 23 => [ 105, 98, 90, 83, 75, 68, 60, 53, 45, 38, 30 ], 30 => [ 105, 98, 90, 83, 75, 68, 60, 53, 45, 38 ], 38 => [ 105, 98, 90, 83, 75, 68, 60, 53, 45 ], 45 => [ 105, 98, 90, 83, 75, 68, 60, 53 ], 53 => [ 105, 98, 90, 83, 75, 68, 60 ], 60 => [ 105, 98, 90, 83, 75, 68 ], 68 => [ 105, 98, 90, 83, 75 ], 75 => [ 105, 98, 90, 83 ], 83 => [ 105, 98, 90 ], 90 => [ 105, 98 ], 96 => [ 104 ], 98 => [ 105 ] },
	{ 31 => [ 106, 99, 91, 84, 76, 69, 61, 54, 46, 39 ], 39 => [ 106, 99, 91, 84, 76, 69, 61, 54, 46 ], 46 => [ 106, 99, 91, 84, 76, 69, 61, 54 ], 54 => [ 106, 99, 91, 84, 76, 69, 61 ], 61 => [ 106, 99, 91, 84, 76, 69 ], 69 => [ 106, 99, 91, 84, 76 ], 76 => [ 106, 99, 91, 84 ], 80 => [ 105, 97, 88 ], 84 => [ 106, 99, 91 ], 88 => [ 105, 97 ], 91 => [ 106, 99 ], 97 => [ 105 ], 99 => [ 106 ] },
	{ 47 => [ 107, 100, 92, 85, 77, 70, 62, 55 ], 55 => [ 107, 100, 92, 85, 77, 70, 62 ], 62 => [ 107, 100, 92, 85, 77, 70 ], 64 => [ 106, 98, 89, 81, 72 ], 70 => [ 107, 100, 92, 85, 77 ], 72 => [ 106, 98, 89, 81 ], 77 => [ 107, 100, 92, 85 ], 81 => [ 106, 98, 89 ], 85 => [ 107, 100, 92 ], 89 => [ 106, 98 ], 92 => [ 107, 100 ], 98 => [ 106 ], 100 => [ 107 ] },
	{ 48 => [ 107, 99, 90, 82, 73, 65, 56 ], 56 => [ 107, 99, 90, 82, 73, 65 ], 63 => [ 108, 101, 93, 86, 78, 71 ], 65 => [ 107, 99, 90, 82, 73 ], 71 => [ 108, 101, 93, 86, 78 ], 73 => [ 107, 99, 90, 82 ], 78 => [ 108, 101, 93, 86 ], 82 => [ 107, 99, 90 ], 86 => [ 108, 101, 93 ], 90 => [ 107, 99 ], 93 => [ 108, 101 ], 99 => [ 107 ], 101 => [ 108 ] },
	{ 32 => [ 108, 100, 91, 83, 74, 66, 57, 49, 40 ], 40 => [ 108, 100, 91, 83, 74, 66, 57, 49 ], 49 => [ 108, 100, 91, 83, 74, 66, 57 ], 57 => [ 108, 100, 91, 83, 74, 66 ], 66 => [ 108, 100, 91, 83, 74 ], 74 => [ 108, 100, 91, 83 ], 79 => [ 109, 102, 94, 87 ], 83 => [ 108, 100, 91 ], 87 => [ 109, 102, 94 ], 91 => [ 108, 100 ], 94 => [ 109, 102 ], 100 => [ 108 ], 102 => [ 109 ] },
	{ 16 => [ 109, 101, 92, 84, 75, 67, 58, 50, 41, 33, 24 ], 24 => [ 109, 101, 92, 84, 75, 67, 58, 50, 41, 33 ], 33 => [ 109, 101, 92, 84, 75, 67, 58, 50, 41 ], 41 => [ 109, 101, 92, 84, 75, 67, 58, 50 ], 50 => [ 109, 101, 92, 84, 75, 67, 58 ], 58 => [ 109, 101, 92, 84, 75, 67 ], 67 => [ 109, 101, 92, 84, 75 ], 75 => [ 109, 101, 92, 84 ], 84 => [ 109, 101, 92 ], 92 => [ 109, 101 ], 95 => [ 110, 103 ], 101 => [ 109 ], 103 => [ 110 ] },
	{  0 => [ 110, 102, 93, 85, 76, 68, 59, 51, 42, 34, 25, 17,  8 ],  8 => [ 110, 102, 93, 85, 76, 68, 59, 51, 42, 34, 25, 17 ], 17 => [ 110, 102, 93, 85, 76, 68, 59, 51, 42, 34, 25 ], 25 => [ 110, 102, 93, 85, 76, 68, 59, 51, 42, 34 ], 34 => [ 110, 102, 93, 85, 76, 68, 59, 51, 42 ], 42 => [ 110, 102, 93, 85, 76, 68, 59, 51 ], 51 => [ 110, 102, 93, 85, 76, 68, 59 ], 59 => [ 110, 102, 93, 85, 76, 68 ], 68 => [ 110, 102, 93, 85, 76 ], 76 => [ 110, 102, 93, 85 ], 85 => [ 110, 102, 93 ], 93 => [ 110, 102 ], 102 => [ 110 ] },
	{ 15 => [ 113, 105, 98, 90, 83, 75, 68, 60, 53, 45, 38, 30, 23 ], 23 => [ 113, 105, 98, 90, 83, 75, 68, 60, 53, 45, 38, 30 ], 30 => [ 113, 105, 98, 90, 83, 75, 68, 60, 53, 45, 38 ], 38 => [ 113, 105, 98, 90, 83, 75, 68, 60, 53, 45 ], 45 => [ 113, 105, 98, 90, 83, 75, 68, 60, 53 ], 53 => [ 113, 105, 98, 90, 83, 75, 68, 60 ], 60 => [ 113, 105, 98, 90, 83, 75, 68 ], 68 => [ 113, 105, 98, 90, 83, 75 ], 75 => [ 113, 105, 98, 90, 83 ], 83 => [ 113, 105, 98, 90 ], 90 => [ 113, 105, 98 ], 98 => [ 113, 105 ], 105 => [ 113 ] },
	{ 31 => [ 114, 106, 99, 91, 84, 76, 69, 61, 54, 46, 39 ], 39 => [ 114, 106, 99, 91, 84, 76, 69, 61, 54, 46 ], 46 => [ 114, 106, 99, 91, 84, 76, 69, 61, 54 ], 54 => [ 114, 106, 99, 91, 84, 76, 69, 61 ], 61 => [ 114, 106, 99, 91, 84, 76, 69 ], 69 => [ 114, 106, 99, 91, 84, 76 ], 76 => [ 114, 106, 99, 91, 84 ], 84 => [ 114, 106, 99, 91 ], 91 => [ 114, 106, 99 ], 96 => [ 113, 104 ], 99 => [ 114, 106 ], 104 => [ 113 ], 106 => [ 114 ] },
	{ 47 => [ 115, 107, 100, 92, 85, 77, 70, 62, 55 ], 55 => [ 115, 107, 100, 92, 85, 77, 70, 62 ], 62 => [ 115, 107, 100, 92, 85, 77, 70 ], 70 => [ 115, 107, 100, 92, 85, 77 ], 77 => [ 115, 107, 100, 92, 85 ], 80 => [ 114, 105, 97, 88 ], 85 => [ 115, 107, 100, 92 ], 88 => [ 114, 105, 97 ], 92 => [ 115, 107, 100 ], 97 => [ 114, 105 ], 100 => [ 115, 107 ], 105 => [ 114 ], 107 => [ 115 ] },
	{ 63 => [ 116, 108, 101, 93, 86, 78, 71 ], 64 => [ 115, 106, 98, 89, 81, 72 ], 71 => [ 116, 108, 101, 93, 86, 78 ], 72 => [ 115, 106, 98, 89, 81 ], 78 => [ 116, 108, 101, 93, 86 ], 81 => [ 115, 106, 98, 89 ], 86 => [ 116, 108, 101, 93 ], 89 => [ 115, 106, 98 ], 93 => [ 116, 108, 101 ], 98 => [ 115, 106 ], 101 => [ 116, 108 ], 106 => [ 115 ], 108 => [ 116 ] },
	{ 48 => [ 116, 107, 99, 90, 82, 73, 65, 56 ], 56 => [ 116, 107, 99, 90, 82, 73, 65 ], 65 => [ 116, 107, 99, 90, 82, 73 ], 73 => [ 116, 107, 99, 90, 82 ], 79 => [ 117, 109, 102, 94, 87 ], 82 => [ 116, 107, 99, 90 ], 87 => [ 117, 109, 102, 94 ], 90 => [ 116, 107, 99 ], 94 => [ 117, 109, 102 ], 99 => [ 116, 107 ], 102 => [ 117, 109 ], 107 => [ 116 ], 109 => [ 117 ] },
	{ 32 => [ 117, 108, 100, 91, 83, 74, 66, 57, 49, 40 ], 40 => [ 117, 108, 100, 91, 83, 74, 66, 57, 49 ], 49 => [ 117, 108, 100, 91, 83, 74, 66, 57 ], 57 => [ 117, 108, 100, 91, 83, 74, 66 ], 66 => [ 117, 108, 100, 91, 83, 74 ], 74 => [ 117, 108, 100, 91, 83 ], 83 => [ 117, 108, 100, 91 ], 91 => [ 117, 108, 100 ], 95 => [ 118, 110, 103 ], 100 => [ 117, 108 ], 103 => [ 118, 110 ], 108 => [ 117 ], 110 => [ 118 ] },
	{ 16 => [ 118, 109, 101, 92, 84, 75, 67, 58, 50, 41, 33, 24 ], 24 => [ 118, 109, 101, 92, 84, 75, 67, 58, 50, 41, 33 ], 33 => [ 118, 109, 101, 92, 84, 75, 67, 58, 50, 41 ], 41 => [ 118, 109, 101, 92, 84, 75, 67, 58, 50 ], 50 => [ 118, 109, 101, 92, 84, 75, 67, 58 ], 58 => [ 118, 109, 101, 92, 84, 75, 67 ], 67 => [ 118, 109, 101, 92, 84, 75 ], 75 => [ 118, 109, 101, 92, 84 ], 84 => [ 118, 109, 101, 92 ], 92 => [ 118, 109, 101 ], 101 => [ 118, 109 ], 109 => [ 118 ], 111 => [ 119 ] },
	{  0 => [ 119, 110, 102, 93, 85, 76, 68, 59, 51, 42, 34, 25, 17,  8 ],  8 => [ 119, 110, 102, 93, 85, 76, 68, 59, 51, 42, 34, 25, 17 ], 17 => [ 119, 110, 102, 93, 85, 76, 68, 59, 51, 42, 34, 25 ], 25 => [ 119, 110, 102, 93, 85, 76, 68, 59, 51, 42, 34 ], 34 => [ 119, 110, 102, 93, 85, 76, 68, 59, 51, 42 ], 42 => [ 119, 110, 102, 93, 85, 76, 68, 59, 51 ], 51 => [ 119, 110, 102, 93, 85, 76, 68, 59 ], 59 => [ 119, 110, 102, 93, 85, 76, 68 ], 68 => [ 119, 110, 102, 93, 85, 76 ], 76 => [ 119, 110, 102, 93, 85 ], 85 => [ 119, 110, 102, 93 ], 93 => [ 119, 110, 102 ], 102 => [ 119, 110 ], 110 => [ 119 ] },
];

use constant enclosed_8dirs_locs => [
	{  2 => [  1 ],  3 => [  1,  2 ],  4 => [  1,  2,  3 ],  5 => [  1,  2,  3,  4 ],  6 => [  1,  2,  3,  4,  5 ],  7 => [  1,  2,  3,  4,  5,  6 ], 17 => [  8 ], 25 => [  8, 17 ], 32 => [ 16 ], 34 => [  8, 17, 25 ], 42 => [  8, 17, 25, 34 ], 48 => [ 16, 32 ], 51 => [  8, 17, 25, 34, 42 ], 59 => [  8, 17, 25, 34, 42, 51 ], 64 => [ 16, 32, 48 ], 68 => [  8, 17, 25, 34, 42, 51, 59 ], 76 => [  8, 17, 25, 34, 42, 51, 59, 68 ], 80 => [ 16, 32, 48, 64 ], 85 => [  8, 17, 25, 34, 42, 51, 59, 68, 76 ], 93 => [  8, 17, 25, 34, 42, 51, 59, 68, 76, 85 ], 96 => [ 16, 32, 48, 64, 80 ], 102 => [  8, 17, 25, 34, 42, 51, 59, 68, 76, 85, 93 ], 110 => [  8, 17, 25, 34, 42, 51, 59, 68, 76, 85, 93, 102 ], 112 => [ 16, 32, 48, 64, 80, 96 ], 119 => [  8, 17, 25, 34, 42, 51, 59, 68, 76, 85, 93, 102, 110 ], 127 => [  8, 17, 25, 34, 42, 51, 59, 68, 76, 85, 93, 102, 110, 119 ] },
	{  3 => [  2 ],  4 => [  2,  3 ],  5 => [  2,  3,  4 ],  6 => [  2,  3,  4,  5 ],  7 => [  2,  3,  4,  5,  6 ], 16 => [  8 ], 18 => [  9 ], 26 => [  9, 18 ], 33 => [ 17 ], 35 => [  9, 18, 26 ], 43 => [  9, 18, 26, 35 ], 49 => [ 17, 33 ], 52 => [  9, 18, 26, 35, 43 ], 60 => [  9, 18, 26, 35, 43, 52 ], 65 => [ 17, 33, 49 ], 69 => [  9, 18, 26, 35, 43, 52, 60 ], 77 => [  9, 18, 26, 35, 43, 52, 60, 69 ], 81 => [ 17, 33, 49, 65 ], 86 => [  9, 18, 26, 35, 43, 52, 60, 69, 77 ], 94 => [  9, 18, 26, 35, 43, 52, 60, 69, 77, 86 ], 97 => [ 17, 33, 49, 65, 81 ], 103 => [  9, 18, 26, 35, 43, 52, 60, 69, 77, 86, 94 ], 111 => [  9, 18, 26, 35, 43, 52, 60, 69, 77, 86, 94, 103 ], 113 => [ 17, 33, 49, 65, 81, 97 ] },
	{  0 => [  1 ],  4 => [  3 ],  5 => [  3,  4 ],  6 => [  3,  4,  5 ],  7 => [  3,  4,  5,  6 ], 17 => [  9 ], 19 => [ 10 ], 24 => [  9, 17 ], 27 => [ 10, 19 ], 32 => [  9, 17, 24 ], 34 => [ 18 ], 36 => [ 10, 19, 27 ], 44 => [ 10, 19, 27, 36 ], 50 => [ 18, 34 ], 53 => [ 10, 19, 27, 36, 44 ], 61 => [ 10, 19, 27, 36, 44, 53 ], 66 => [ 18, 34, 50 ], 70 => [ 10, 19, 27, 36, 44, 53, 61 ], 78 => [ 10, 19, 27, 36, 44, 53, 61, 70 ], 82 => [ 18, 34, 50, 66 ], 87 => [ 10, 19, 27, 36, 44, 53, 61, 70, 78 ], 95 => [ 10, 19, 27, 36, 44, 53, 61, 70, 78, 87 ], 98 => [ 18, 34, 50, 66, 82 ], 114 => [ 18, 34, 50, 66, 82, 98 ] },
	{  0 => [  2,  1 ],  1 => [  2 ],  5 => [  4 ],  6 => [  4,  5 ],  7 => [  4,  5,  6 ], 18 => [ 10 ], 20 => [ 11 ], 25 => [ 10, 18 ], 28 => [ 11, 20 ], 33 => [ 10, 18, 25 ], 35 => [ 19 ], 37 => [ 11, 20, 28 ], 40 => [ 10, 18, 25, 33 ], 45 => [ 11, 20, 28, 37 ], 48 => [ 10, 18, 25, 33, 40 ], 51 => [ 19, 35 ], 54 => [ 11, 20, 28, 37, 45 ], 62 => [ 11, 20, 28, 37, 45, 54 ], 67 => [ 19, 35, 51 ], 71 => [ 11, 20, 28, 37, 45, 54, 62 ], 79 => [ 11, 20, 28, 37, 45, 54, 62, 71 ], 83 => [ 19, 35, 51, 67 ], 99 => [ 19, 35, 51, 67, 83 ], 115 => [ 19, 35, 51, 67, 83, 99 ] },
	{  0 => [  3,  2,  1 ],  1 => [  3,  2 ],  2 => [  3 ],  6 => [  5 ],  7 => [  5,  6 ], 19 => [ 11 ], 21 => [ 12 ], 26 => [ 11, 19 ], 29 => [ 12, 21 ], 34 => [ 11, 19, 26 ], 36 => [ 20 ], 38 => [ 12, 21, 29 ], 41 => [ 11, 19, 26, 34 ], 46 => [ 12, 21, 29, 38 ], 49 => [ 11, 19, 26, 34, 41 ], 52 => [ 20, 36 ], 55 => [ 12, 21, 29, 38, 46 ], 56 => [ 11, 19, 26, 34, 41, 49 ], 63 => [ 12, 21, 29, 38, 46, 55 ], 64 => [ 11, 19, 26, 34, 41, 49, 56 ], 68 => [ 20, 36, 52 ], 84 => [ 20, 36, 52, 68 ], 100 => [ 20, 36, 52, 68, 84 ], 116 => [ 20, 36, 52, 68, 84, 100 ] },
	{  0 => [  4,  3,  2,  1 ],  1 => [  4,  3,  2 ],  2 => [  4,  3 ],  3 => [  4 ],  7 => [  6 ], 20 => [ 12 ], 22 => [ 13 ], 27 => [ 12, 20 ], 30 => [ 13, 22 ], 35 => [ 12, 20, 27 ], 37 => [ 21 ], 39 => [ 13, 22, 30 ], 42 => [ 12, 20, 27, 35 ], 47 => [ 13, 22, 30, 39 ], 50 => [ 12, 20, 27, 35, 42 ], 53 => [ 21, 37 ], 57 => [ 12, 20, 27, 35, 42, 50 ], 65 => [ 12, 20, 27, 35, 42, 50, 57 ], 69 => [ 21, 37, 53 ], 72 => [ 12, 20, 27, 35, 42, 50, 57, 65 ], 80 => [ 12, 20, 27, 35, 42, 50, 57, 65, 72 ], 85 => [ 21, 37, 53, 69 ], 101 => [ 21, 37, 53, 69, 85 ], 117 => [ 21, 37, 53, 69, 85, 101 ] },
	{  0 => [  5,  4,  3,  2,  1 ],  1 => [  5,  4,  3,  2 ],  2 => [  5,  4,  3 ],  3 => [  5,  4 ],  4 => [  5 ], 21 => [ 13 ], 23 => [ 14 ], 28 => [ 13, 21 ], 31 => [ 14, 23 ], 36 => [ 13, 21, 28 ], 38 => [ 22 ], 43 => [ 13, 21, 28, 36 ], 51 => [ 13, 21, 28, 36, 43 ], 54 => [ 22, 38 ], 58 => [ 13, 21, 28, 36, 43, 51 ], 66 => [ 13, 21, 28, 36, 43, 51, 58 ], 70 => [ 22, 38, 54 ], 73 => [ 13, 21, 28, 36, 43, 51, 58, 66 ], 81 => [ 13, 21, 28, 36, 43, 51, 58, 66, 73 ], 86 => [ 22, 38, 54, 70 ], 88 => [ 13, 21, 28, 36, 43, 51, 58, 66, 73, 81 ], 96 => [ 13, 21, 28, 36, 43, 51, 58, 66, 73, 81, 88 ], 102 => [ 22, 38, 54, 70, 86 ], 118 => [ 22, 38, 54, 70, 86, 102 ] },
	{  0 => [  6,  5,  4,  3,  2,  1 ],  1 => [  6,  5,  4,  3,  2 ],  2 => [  6,  5,  4,  3 ],  3 => [  6,  5,  4 ],  4 => [  6,  5 ],  5 => [  6 ], 22 => [ 14 ], 29 => [ 14, 22 ], 37 => [ 14, 22, 29 ], 39 => [ 23 ], 44 => [ 14, 22, 29, 37 ], 52 => [ 14, 22, 29, 37, 44 ], 55 => [ 23, 39 ], 59 => [ 14, 22, 29, 37, 44, 52 ], 67 => [ 14, 22, 29, 37, 44, 52, 59 ], 71 => [ 23, 39, 55 ], 74 => [ 14, 22, 29, 37, 44, 52, 59, 67 ], 82 => [ 14, 22, 29, 37, 44, 52, 59, 67, 74 ], 87 => [ 23, 39, 55, 71 ], 89 => [ 14, 22, 29, 37, 44, 52, 59, 67, 74, 82 ], 97 => [ 14, 22, 29, 37, 44, 52, 59, 67, 74, 82, 89 ], 103 => [ 23, 39, 55, 71, 87 ], 104 => [ 14, 22, 29, 37, 44, 52, 59, 67, 74, 82, 89, 97 ], 112 => [ 14, 22, 29, 37, 44, 52, 59, 67, 74, 82, 89, 97, 104 ], 119 => [ 23, 39, 55, 71, 87, 103 ] },
	{ 10 => [  9 ], 11 => [  9, 10 ], 12 => [  9, 10, 11 ], 13 => [  9, 10, 11, 12 ], 14 => [  9, 10, 11, 12, 13 ], 15 => [  9, 10, 11, 12, 13, 14 ], 25 => [ 17 ], 34 => [ 17, 25 ], 40 => [ 24 ], 42 => [ 17, 25, 34 ], 51 => [ 17, 25, 34, 42 ], 56 => [ 24, 40 ], 59 => [ 17, 25, 34, 42, 51 ], 68 => [ 17, 25, 34, 42, 51, 59 ], 72 => [ 24, 40, 56 ], 76 => [ 17, 25, 34, 42, 51, 59, 68 ], 85 => [ 17, 25, 34, 42, 51, 59, 68, 76 ], 88 => [ 24, 40, 56, 72 ], 93 => [ 17, 25, 34, 42, 51, 59, 68, 76, 85 ], 102 => [ 17, 25, 34, 42, 51, 59, 68, 76, 85, 93 ], 104 => [ 24, 40, 56, 72, 88 ], 110 => [ 17, 25, 34, 42, 51, 59, 68, 76, 85, 93, 102 ], 119 => [ 17, 25, 34, 42, 51, 59, 68, 76, 85, 93, 102, 110 ], 120 => [ 24, 40, 56, 72, 88, 104 ], 127 => [ 17, 25, 34, 42, 51, 59, 68, 76, 85, 93, 102, 110, 119 ] },
	{ 11 => [ 10 ], 12 => [ 10, 11 ], 13 => [ 10, 11, 12 ], 14 => [ 10, 11, 12, 13 ], 15 => [ 10, 11, 12, 13, 14 ], 24 => [ 17 ], 26 => [ 18 ], 32 => [ 17, 24 ], 35 => [ 18, 26 ], 41 => [ 25 ], 43 => [ 18, 26, 35 ], 52 => [ 18, 26, 35, 43 ], 57 => [ 25, 41 ], 60 => [ 18, 26, 35, 43, 52 ], 69 => [ 18, 26, 35, 43, 52, 60 ], 73 => [ 25, 41, 57 ], 77 => [ 18, 26, 35, 43, 52, 60, 69 ], 86 => [ 18, 26, 35, 43, 52, 60, 69, 77 ], 89 => [ 25, 41, 57, 73 ], 94 => [ 18, 26, 35, 43, 52, 60, 69, 77, 86 ], 103 => [ 18, 26, 35, 43, 52, 60, 69, 77, 86, 94 ], 105 => [ 25, 41, 57, 73, 89 ], 111 => [ 18, 26, 35, 43, 52, 60, 69, 77, 86, 94, 103 ], 121 => [ 25, 41, 57, 73, 89, 105 ] },
	{  8 => [  9 ], 12 => [ 11 ], 13 => [ 11, 12 ], 14 => [ 11, 12, 13 ], 15 => [ 11, 12, 13, 14 ], 25 => [ 18 ], 27 => [ 19 ], 33 => [ 18, 25 ], 36 => [ 19, 27 ], 40 => [ 18, 25, 33 ], 42 => [ 26 ], 44 => [ 19, 27, 36 ], 48 => [ 18, 25, 33, 40 ], 53 => [ 19, 27, 36, 44 ], 58 => [ 26, 42 ], 61 => [ 19, 27, 36, 44, 53 ], 70 => [ 19, 27, 36, 44, 53, 61 ], 74 => [ 26, 42, 58 ], 78 => [ 19, 27, 36, 44, 53, 61, 70 ], 87 => [ 19, 27, 36, 44, 53, 61, 70, 78 ], 90 => [ 26, 42, 58, 74 ], 95 => [ 19, 27, 36, 44, 53, 61, 70, 78, 87 ], 106 => [ 26, 42, 58, 74, 90 ], 122 => [ 26, 42, 58, 74, 90, 106 ] },
	{  8 => [ 10,  9 ],  9 => [ 10 ], 13 => [ 12 ], 14 => [ 12, 13 ], 15 => [ 12, 13, 14 ], 26 => [ 19 ], 28 => [ 20 ], 34 => [ 19, 26 ], 37 => [ 20, 28 ], 41 => [ 19, 26, 34 ], 43 => [ 27 ], 45 => [ 20, 28, 37 ], 49 => [ 19, 26, 34, 41 ], 54 => [ 20, 28, 37, 45 ], 56 => [ 19, 26, 34, 41, 49 ], 59 => [ 27, 43 ], 62 => [ 20, 28, 37, 45, 54 ], 64 => [ 19, 26, 34, 41, 49, 56 ], 71 => [ 20, 28, 37, 45, 54, 62 ], 75 => [ 27, 43, 59 ], 79 => [ 20, 28, 37, 45, 54, 62, 71 ], 91 => [ 27, 43, 59, 75 ], 107 => [ 27, 43, 59, 75, 91 ], 123 => [ 27, 43, 59, 75, 91, 107 ] },
	{  8 => [ 11, 10,  9 ],  9 => [ 11, 10 ], 10 => [ 11 ], 14 => [ 13 ], 15 => [ 13, 14 ], 27 => [ 20 ], 29 => [ 21 ], 35 => [ 20, 27 ], 38 => [ 21, 29 ], 42 => [ 20, 27, 35 ], 44 => [ 28 ], 46 => [ 21, 29, 38 ], 50 => [ 20, 27, 35, 42 ], 55 => [ 21, 29, 38, 46 ], 57 => [ 20, 27, 35, 42, 50 ], 60 => [ 28, 44 ], 63 => [ 21, 29, 38, 46, 55 ], 65 => [ 20, 27, 35, 42, 50, 57 ], 72 => [ 20, 27, 35, 42, 50, 57, 65 ], 76 => [ 28, 44, 60 ], 80 => [ 20, 27, 35, 42, 50, 57, 65, 72 ], 92 => [ 28, 44, 60, 76 ], 108 => [ 28, 44, 60, 76, 92 ], 124 => [ 28, 44, 60, 76, 92, 108 ] },
	{  8 => [ 12, 11, 10,  9 ],  9 => [ 12, 11, 10 ], 10 => [ 12, 11 ], 11 => [ 12 ], 15 => [ 14 ], 28 => [ 21 ], 30 => [ 22 ], 36 => [ 21, 28 ], 39 => [ 22, 30 ], 43 => [ 21, 28, 36 ], 45 => [ 29 ], 47 => [ 22, 30, 39 ], 51 => [ 21, 28, 36, 43 ], 58 => [ 21, 28, 36, 43, 51 ], 61 => [ 29, 45 ], 66 => [ 21, 28, 36, 43, 51, 58 ], 73 => [ 21, 28, 36, 43, 51, 58, 66 ], 77 => [ 29, 45, 61 ], 81 => [ 21, 28, 36, 43, 51, 58, 66, 73 ], 88 => [ 21, 28, 36, 43, 51, 58, 66, 73, 81 ], 93 => [ 29, 45, 61, 77 ], 96 => [ 21, 28, 36, 43, 51, 58, 66, 73, 81, 88 ], 109 => [ 29, 45, 61, 77, 93 ], 125 => [ 29, 45, 61, 77, 93, 109 ] },
	{  8 => [ 13, 12, 11, 10,  9 ],  9 => [ 13, 12, 11, 10 ], 10 => [ 13, 12, 11 ], 11 => [ 13, 12 ], 12 => [ 13 ], 29 => [ 22 ], 31 => [ 23 ], 37 => [ 22, 29 ], 44 => [ 22, 29, 37 ], 46 => [ 30 ], 52 => [ 22, 29, 37, 44 ], 59 => [ 22, 29, 37, 44, 52 ], 62 => [ 30, 46 ], 67 => [ 22, 29, 37, 44, 52, 59 ], 74 => [ 22, 29, 37, 44, 52, 59, 67 ], 78 => [ 30, 46, 62 ], 82 => [ 22, 29, 37, 44, 52, 59, 67, 74 ], 89 => [ 22, 29, 37, 44, 52, 59, 67, 74, 82 ], 94 => [ 30, 46, 62, 78 ], 97 => [ 22, 29, 37, 44, 52, 59, 67, 74, 82, 89 ], 104 => [ 22, 29, 37, 44, 52, 59, 67, 74, 82, 89, 97 ], 110 => [ 30, 46, 62, 78, 94 ], 112 => [ 22, 29, 37, 44, 52, 59, 67, 74, 82, 89, 97, 104 ], 126 => [ 30, 46, 62, 78, 94, 110 ] },
	{  8 => [ 14, 13, 12, 11, 10,  9 ],  9 => [ 14, 13, 12, 11, 10 ], 10 => [ 14, 13, 12, 11 ], 11 => [ 14, 13, 12 ], 12 => [ 14, 13 ], 13 => [ 14 ], 30 => [ 23 ], 38 => [ 23, 30 ], 45 => [ 23, 30, 38 ], 47 => [ 31 ], 53 => [ 23, 30, 38, 45 ], 60 => [ 23, 30, 38, 45, 53 ], 63 => [ 31, 47 ], 68 => [ 23, 30, 38, 45, 53, 60 ], 75 => [ 23, 30, 38, 45, 53, 60, 68 ], 79 => [ 31, 47, 63 ], 83 => [ 23, 30, 38, 45, 53, 60, 68, 75 ], 90 => [ 23, 30, 38, 45, 53, 60, 68, 75, 83 ], 95 => [ 31, 47, 63, 79 ], 98 => [ 23, 30, 38, 45, 53, 60, 68, 75, 83, 90 ], 105 => [ 23, 30, 38, 45, 53, 60, 68, 75, 83, 90, 98 ], 111 => [ 31, 47, 63, 79, 95 ], 113 => [ 23, 30, 38, 45, 53, 60, 68, 75, 83, 90, 98, 105 ], 120 => [ 23, 30, 38, 45, 53, 60, 68, 75, 83, 90, 98, 105, 113 ], 127 => [ 31, 47, 63, 79, 95, 111 ] },
	{  1 => [  8 ], 18 => [ 17 ], 19 => [ 17, 18 ], 20 => [ 17, 18, 19 ], 21 => [ 17, 18, 19, 20 ], 22 => [ 17, 18, 19, 20, 21 ], 23 => [ 17, 18, 19, 20, 21, 22 ], 33 => [ 24 ], 41 => [ 24, 33 ], 48 => [ 32 ], 50 => [ 24, 33, 41 ], 58 => [ 24, 33, 41, 50 ], 64 => [ 32, 48 ], 67 => [ 24, 33, 41, 50, 58 ], 75 => [ 24, 33, 41, 50, 58, 67 ], 80 => [ 32, 48, 64 ], 84 => [ 24, 33, 41, 50, 58, 67, 75 ], 92 => [ 24, 33, 41, 50, 58, 67, 75, 84 ], 96 => [ 32, 48, 64, 80 ], 101 => [ 24, 33, 41, 50, 58, 67, 75, 84, 92 ], 109 => [ 24, 33, 41, 50, 58, 67, 75, 84, 92, 101 ], 112 => [ 32, 48, 64, 80, 96 ], 118 => [ 24, 33, 41, 50, 58, 67, 75, 84, 92, 101, 109 ], 126 => [ 24, 33, 41, 50, 58, 67, 75, 84, 92, 101, 109, 118 ] },
	{  0 => [  8 ],  2 => [  9 ], 19 => [ 18 ], 20 => [ 18, 19 ], 21 => [ 18, 19, 20 ], 22 => [ 18, 19, 20, 21 ], 23 => [ 18, 19, 20, 21, 22 ], 32 => [ 24 ], 34 => [ 25 ], 42 => [ 25, 34 ], 49 => [ 33 ], 51 => [ 25, 34, 42 ], 59 => [ 25, 34, 42, 51 ], 65 => [ 33, 49 ], 68 => [ 25, 34, 42, 51, 59 ], 76 => [ 25, 34, 42, 51, 59, 68 ], 81 => [ 33, 49, 65 ], 85 => [ 25, 34, 42, 51, 59, 68, 76 ], 93 => [ 25, 34, 42, 51, 59, 68, 76, 85 ], 97 => [ 33, 49, 65, 81 ], 102 => [ 25, 34, 42, 51, 59, 68, 76, 85, 93 ], 110 => [ 25, 34, 42, 51, 59, 68, 76, 85, 93, 102 ], 113 => [ 33, 49, 65, 81, 97 ], 119 => [ 25, 34, 42, 51, 59, 68, 76, 85, 93, 102, 110 ], 127 => [ 25, 34, 42, 51, 59, 68, 76, 85, 93, 102, 110, 119 ] },
	{  1 => [  9 ],  3 => [ 10 ], 16 => [ 17 ], 20 => [ 19 ], 21 => [ 19, 20 ], 22 => [ 19, 20, 21 ], 23 => [ 19, 20, 21, 22 ], 33 => [ 25 ], 35 => [ 26 ], 40 => [ 25, 33 ], 43 => [ 26, 35 ], 48 => [ 25, 33, 40 ], 50 => [ 34 ], 52 => [ 26, 35, 43 ], 60 => [ 26, 35, 43, 52 ], 66 => [ 34, 50 ], 69 => [ 26, 35, 43, 52, 60 ], 77 => [ 26, 35, 43, 52, 60, 69 ], 82 => [ 34, 50, 66 ], 86 => [ 26, 35, 43, 52, 60, 69, 77 ], 94 => [ 26, 35, 43, 52, 60, 69, 77, 86 ], 98 => [ 34, 50, 66, 82 ], 103 => [ 26, 35, 43, 52, 60, 69, 77, 86, 94 ], 111 => [ 26, 35, 43, 52, 60, 69, 77, 86, 94, 103 ], 114 => [ 34, 50, 66, 82, 98 ] },
	{  2 => [ 10 ],  4 => [ 11 ], 16 => [ 18, 17 ], 17 => [ 18 ], 21 => [ 20 ], 22 => [ 20, 21 ], 23 => [ 20, 21, 22 ], 34 => [ 26 ], 36 => [ 27 ], 41 => [ 26, 34 ], 44 => [ 27, 36 ], 49 => [ 26, 34, 41 ], 51 => [ 35 ], 53 => [ 27, 36, 44 ], 56 => [ 26, 34, 41, 49 ], 61 => [ 27, 36, 44, 53 ], 64 => [ 26, 34, 41, 49, 56 ], 67 => [ 35, 51 ], 70 => [ 27, 36, 44, 53, 61 ], 78 => [ 27, 36, 44, 53, 61, 70 ], 83 => [ 35, 51, 67 ], 87 => [ 27, 36, 44, 53, 61, 70, 78 ], 95 => [ 27, 36, 44, 53, 61, 70, 78, 87 ], 99 => [ 35, 51, 67, 83 ], 115 => [ 35, 51, 67, 83, 99 ] },
	{  3 => [ 11 ],  5 => [ 12 ], 16 => [ 19, 18, 17 ], 17 => [ 19, 18 ], 18 => [ 19 ], 22 => [ 21 ], 23 => [ 21, 22 ], 35 => [ 27 ], 37 => [ 28 ], 42 => [ 27, 35 ], 45 => [ 28, 37 ], 50 => [ 27, 35, 42 ], 52 => [ 36 ], 54 => [ 28, 37, 45 ], 57 => [ 27, 35, 42, 50 ], 62 => [ 28, 37, 45, 54 ], 65 => [ 27, 35, 42, 50, 57 ], 68 => [ 36, 52 ], 71 => [ 28, 37, 45, 54, 62 ], 72 => [ 27, 35, 42, 50, 57, 65 ], 79 => [ 28, 37, 45, 54, 62, 71 ], 80 => [ 27, 35, 42, 50, 57, 65, 72 ], 84 => [ 36, 52, 68 ], 100 => [ 36, 52, 68, 84 ], 116 => [ 36, 52, 68, 84, 100 ] },
	{  4 => [ 12 ],  6 => [ 13 ], 16 => [ 20, 19, 18, 17 ], 17 => [ 20, 19, 18 ], 18 => [ 20, 19 ], 19 => [ 20 ], 23 => [ 22 ], 36 => [ 28 ], 38 => [ 29 ], 43 => [ 28, 36 ], 46 => [ 29, 38 ], 51 => [ 28, 36, 43 ], 53 => [ 37 ], 55 => [ 29, 38, 46 ], 58 => [ 28, 36, 43, 51 ], 63 => [ 29, 38, 46, 55 ], 66 => [ 28, 36, 43, 51, 58 ], 69 => [ 37, 53 ], 73 => [ 28, 36, 43, 51, 58, 66 ], 81 => [ 28, 36, 43, 51, 58, 66, 73 ], 85 => [ 37, 53, 69 ], 88 => [ 28, 36, 43, 51, 58, 66, 73, 81 ], 96 => [ 28, 36, 43, 51, 58, 66, 73, 81, 88 ], 101 => [ 37, 53, 69, 85 ], 117 => [ 37, 53, 69, 85, 101 ] },
	{  5 => [ 13 ],  7 => [ 14 ], 16 => [ 21, 20, 19, 18, 17 ], 17 => [ 21, 20, 19, 18 ], 18 => [ 21, 20, 19 ], 19 => [ 21, 20 ], 20 => [ 21 ], 37 => [ 29 ], 39 => [ 30 ], 44 => [ 29, 37 ], 47 => [ 30, 39 ], 52 => [ 29, 37, 44 ], 54 => [ 38 ], 59 => [ 29, 37, 44, 52 ], 67 => [ 29, 37, 44, 52, 59 ], 70 => [ 38, 54 ], 74 => [ 29, 37, 44, 52, 59, 67 ], 82 => [ 29, 37, 44, 52, 59, 67, 74 ], 86 => [ 38, 54, 70 ], 89 => [ 29, 37, 44, 52, 59, 67, 74, 82 ], 97 => [ 29, 37, 44, 52, 59, 67, 74, 82, 89 ], 102 => [ 38, 54, 70, 86 ], 104 => [ 29, 37, 44, 52, 59, 67, 74, 82, 89, 97 ], 112 => [ 29, 37, 44, 52, 59, 67, 74, 82, 89, 97, 104 ], 118 => [ 38, 54, 70, 86, 102 ] },
	{  6 => [ 14 ], 16 => [ 22, 21, 20, 19, 18, 17 ], 17 => [ 22, 21, 20, 19, 18 ], 18 => [ 22, 21, 20, 19 ], 19 => [ 22, 21, 20 ], 20 => [ 22, 21 ], 21 => [ 22 ], 38 => [ 30 ], 45 => [ 30, 38 ], 53 => [ 30, 38, 45 ], 55 => [ 39 ], 60 => [ 30, 38, 45, 53 ], 68 => [ 30, 38, 45, 53, 60 ], 71 => [ 39, 55 ], 75 => [ 30, 38, 45, 53, 60, 68 ], 83 => [ 30, 38, 45, 53, 60, 68, 75 ], 87 => [ 39, 55, 71 ], 90 => [ 30, 38, 45, 53, 60, 68, 75, 83 ], 98 => [ 30, 38, 45, 53, 60, 68, 75, 83, 90 ], 103 => [ 39, 55, 71, 87 ], 105 => [ 30, 38, 45, 53, 60, 68, 75, 83, 90, 98 ], 113 => [ 30, 38, 45, 53, 60, 68, 75, 83, 90, 98, 105 ], 119 => [ 39, 55, 71, 87, 103 ], 120 => [ 30, 38, 45, 53, 60, 68, 75, 83, 90, 98, 105, 113 ] },
	{  2 => [ 17,  9 ],  9 => [ 17 ], 26 => [ 25 ], 27 => [ 25, 26 ], 28 => [ 25, 26, 27 ], 29 => [ 25, 26, 27, 28 ], 30 => [ 25, 26, 27, 28, 29 ], 31 => [ 25, 26, 27, 28, 29, 30 ], 41 => [ 33 ], 50 => [ 33, 41 ], 56 => [ 40 ], 58 => [ 33, 41, 50 ], 67 => [ 33, 41, 50, 58 ], 72 => [ 40, 56 ], 75 => [ 33, 41, 50, 58, 67 ], 84 => [ 33, 41, 50, 58, 67, 75 ], 88 => [ 40, 56, 72 ], 92 => [ 33, 41, 50, 58, 67, 75, 84 ], 101 => [ 33, 41, 50, 58, 67, 75, 84, 92 ], 104 => [ 40, 56, 72, 88 ], 109 => [ 33, 41, 50, 58, 67, 75, 84, 92, 101 ], 118 => [ 33, 41, 50, 58, 67, 75, 84, 92, 101, 109 ], 120 => [ 40, 56, 72, 88, 104 ], 126 => [ 33, 41, 50, 58, 67, 75, 84, 92, 101, 109, 118 ] },
	{  0 => [ 17,  8 ],  3 => [ 18, 10 ],  8 => [ 17 ], 10 => [ 18 ], 27 => [ 26 ], 28 => [ 26, 27 ], 29 => [ 26, 27, 28 ], 30 => [ 26, 27, 28, 29 ], 31 => [ 26, 27, 28, 29, 30 ], 40 => [ 33 ], 42 => [ 34 ], 48 => [ 33, 40 ], 51 => [ 34, 42 ], 57 => [ 41 ], 59 => [ 34, 42, 51 ], 68 => [ 34, 42, 51, 59 ], 73 => [ 41, 57 ], 76 => [ 34, 42, 51, 59, 68 ], 85 => [ 34, 42, 51, 59, 68, 76 ], 89 => [ 41, 57, 73 ], 93 => [ 34, 42, 51, 59, 68, 76, 85 ], 102 => [ 34, 42, 51, 59, 68, 76, 85, 93 ], 105 => [ 41, 57, 73, 89 ], 110 => [ 34, 42, 51, 59, 68, 76, 85, 93, 102 ], 119 => [ 34, 42, 51, 59, 68, 76, 85, 93, 102, 110 ], 121 => [ 41, 57, 73, 89, 105 ], 127 => [ 34, 42, 51, 59, 68, 76, 85, 93, 102, 110, 119 ] },
	{  1 => [ 18,  9 ],  4 => [ 19, 11 ],  9 => [ 18 ], 11 => [ 19 ], 24 => [ 25 ], 28 => [ 27 ], 29 => [ 27, 28 ], 30 => [ 27, 28, 29 ], 31 => [ 27, 28, 29, 30 ], 41 => [ 34 ], 43 => [ 35 ], 49 => [ 34, 41 ], 52 => [ 35, 43 ], 56 => [ 34, 41, 49 ], 58 => [ 42 ], 60 => [ 35, 43, 52 ], 64 => [ 34, 41, 49, 56 ], 69 => [ 35, 43, 52, 60 ], 74 => [ 42, 58 ], 77 => [ 35, 43, 52, 60, 69 ], 86 => [ 35, 43, 52, 60, 69, 77 ], 90 => [ 42, 58, 74 ], 94 => [ 35, 43, 52, 60, 69, 77, 86 ], 103 => [ 35, 43, 52, 60, 69, 77, 86, 94 ], 106 => [ 42, 58, 74, 90 ], 111 => [ 35, 43, 52, 60, 69, 77, 86, 94, 103 ], 122 => [ 42, 58, 74, 90, 106 ] },
	{  2 => [ 19, 10 ],  5 => [ 20, 12 ], 10 => [ 19 ], 12 => [ 20 ], 24 => [ 26, 25 ], 25 => [ 26 ], 29 => [ 28 ], 30 => [ 28, 29 ], 31 => [ 28, 29, 30 ], 42 => [ 35 ], 44 => [ 36 ], 50 => [ 35, 42 ], 53 => [ 36, 44 ], 57 => [ 35, 42, 50 ], 59 => [ 43 ], 61 => [ 36, 44, 53 ], 65 => [ 35, 42, 50, 57 ], 70 => [ 36, 44, 53, 61 ], 72 => [ 35, 42, 50, 57, 65 ], 75 => [ 43, 59 ], 78 => [ 36, 44, 53, 61, 70 ], 80 => [ 35, 42, 50, 57, 65, 72 ], 87 => [ 36, 44, 53, 61, 70, 78 ], 91 => [ 43, 59, 75 ], 95 => [ 36, 44, 53, 61, 70, 78, 87 ], 107 => [ 43, 59, 75, 91 ], 123 => [ 43, 59, 75, 91, 107 ] },
	{  3 => [ 20, 11 ],  6 => [ 21, 13 ], 11 => [ 20 ], 13 => [ 21 ], 24 => [ 27, 26, 25 ], 25 => [ 27, 26 ], 26 => [ 27 ], 30 => [ 29 ], 31 => [ 29, 30 ], 43 => [ 36 ], 45 => [ 37 ], 51 => [ 36, 43 ], 54 => [ 37, 45 ], 58 => [ 36, 43, 51 ], 60 => [ 44 ], 62 => [ 37, 45, 54 ], 66 => [ 36, 43, 51, 58 ], 71 => [ 37, 45, 54, 62 ], 73 => [ 36, 43, 51, 58, 66 ], 76 => [ 44, 60 ], 79 => [ 37, 45, 54, 62, 71 ], 81 => [ 36, 43, 51, 58, 66, 73 ], 88 => [ 36, 43, 51, 58, 66, 73, 81 ], 92 => [ 44, 60, 76 ], 96 => [ 36, 43, 51, 58, 66, 73, 81, 88 ], 108 => [ 44, 60, 76, 92 ], 124 => [ 44, 60, 76, 92, 108 ] },
	{  4 => [ 21, 12 ],  7 => [ 22, 14 ], 12 => [ 21 ], 14 => [ 22 ], 24 => [ 28, 27, 26, 25 ], 25 => [ 28, 27, 26 ], 26 => [ 28, 27 ], 27 => [ 28 ], 31 => [ 30 ], 44 => [ 37 ], 46 => [ 38 ], 52 => [ 37, 44 ], 55 => [ 38, 46 ], 59 => [ 37, 44, 52 ], 61 => [ 45 ], 63 => [ 38, 46, 55 ], 67 => [ 37, 44, 52, 59 ], 74 => [ 37, 44, 52, 59, 67 ], 77 => [ 45, 61 ], 82 => [ 37, 44, 52, 59, 67, 74 ], 89 => [ 37, 44, 52, 59, 67, 74, 82 ], 93 => [ 45, 61, 77 ], 97 => [ 37, 44, 52, 59, 67, 74, 82, 89 ], 104 => [ 37, 44, 52, 59, 67, 74, 82, 89, 97 ], 109 => [ 45, 61, 77, 93 ], 112 => [ 37, 44, 52, 59, 67, 74, 82, 89, 97, 104 ], 125 => [ 45, 61, 77, 93, 109 ] },
	{  5 => [ 22, 13 ], 13 => [ 22 ], 15 => [ 23 ], 24 => [ 29, 28, 27, 26, 25 ], 25 => [ 29, 28, 27, 26 ], 26 => [ 29, 28, 27 ], 27 => [ 29, 28 ], 28 => [ 29 ], 45 => [ 38 ], 47 => [ 39 ], 53 => [ 38, 45 ], 60 => [ 38, 45, 53 ], 62 => [ 46 ], 68 => [ 38, 45, 53, 60 ], 75 => [ 38, 45, 53, 60, 68 ], 78 => [ 46, 62 ], 83 => [ 38, 45, 53, 60, 68, 75 ], 90 => [ 38, 45, 53, 60, 68, 75, 83 ], 94 => [ 46, 62, 78 ], 98 => [ 38, 45, 53, 60, 68, 75, 83, 90 ], 105 => [ 38, 45, 53, 60, 68, 75, 83, 90, 98 ], 110 => [ 46, 62, 78, 94 ], 113 => [ 38, 45, 53, 60, 68, 75, 83, 90, 98, 105 ], 120 => [ 38, 45, 53, 60, 68, 75, 83, 90, 98, 105, 113 ], 126 => [ 46, 62, 78, 94, 110 ] },
	{  6 => [ 23, 14 ], 14 => [ 23 ], 24 => [ 30, 29, 28, 27, 26, 25 ], 25 => [ 30, 29, 28, 27, 26 ], 26 => [ 30, 29, 28, 27 ], 27 => [ 30, 29, 28 ], 28 => [ 30, 29 ], 29 => [ 30 ], 46 => [ 39 ], 54 => [ 39, 46 ], 61 => [ 39, 46, 54 ], 63 => [ 47 ], 69 => [ 39, 46, 54, 61 ], 76 => [ 39, 46, 54, 61, 69 ], 79 => [ 47, 63 ], 84 => [ 39, 46, 54, 61, 69, 76 ], 91 => [ 39, 46, 54, 61, 69, 76, 84 ], 95 => [ 47, 63, 79 ], 99 => [ 39, 46, 54, 61, 69, 76, 84, 91 ], 106 => [ 39, 46, 54, 61, 69, 76, 84, 91, 99 ], 111 => [ 47, 63, 79, 95 ], 114 => [ 39, 46, 54, 61, 69, 76, 84, 91, 99, 106 ], 121 => [ 39, 46, 54, 61, 69, 76, 84, 91, 99, 106, 114 ], 127 => [ 47, 63, 79, 95, 111 ] },
	{  0 => [ 16 ],  2 => [ 24, 17,  9 ],  9 => [ 24, 17 ], 17 => [ 24 ], 34 => [ 33 ], 35 => [ 33, 34 ], 36 => [ 33, 34, 35 ], 37 => [ 33, 34, 35, 36 ], 38 => [ 33, 34, 35, 36, 37 ], 39 => [ 33, 34, 35, 36, 37, 38 ], 49 => [ 40 ], 57 => [ 40, 49 ], 64 => [ 48 ], 66 => [ 40, 49, 57 ], 74 => [ 40, 49, 57, 66 ], 80 => [ 48, 64 ], 83 => [ 40, 49, 57, 66, 74 ], 91 => [ 40, 49, 57, 66, 74, 83 ], 96 => [ 48, 64, 80 ], 100 => [ 40, 49, 57, 66, 74, 83, 91 ], 108 => [ 40, 49, 57, 66, 74, 83, 91, 100 ], 112 => [ 48, 64, 80, 96 ], 117 => [ 40, 49, 57, 66, 74, 83, 91, 100, 108 ], 125 => [ 40, 49, 57, 66, 74, 83, 91, 100, 108, 117 ] },
	{  1 => [ 17 ],  3 => [ 25, 18, 10 ], 10 => [ 25, 18 ], 16 => [ 24 ], 18 => [ 25 ], 35 => [ 34 ], 36 => [ 34, 35 ], 37 => [ 34, 35, 36 ], 38 => [ 34, 35, 36, 37 ], 39 => [ 34, 35, 36, 37, 38 ], 48 => [ 40 ], 50 => [ 41 ], 58 => [ 41, 50 ], 65 => [ 49 ], 67 => [ 41, 50, 58 ], 75 => [ 41, 50, 58, 67 ], 81 => [ 49, 65 ], 84 => [ 41, 50, 58, 67, 75 ], 92 => [ 41, 50, 58, 67, 75, 84 ], 97 => [ 49, 65, 81 ], 101 => [ 41, 50, 58, 67, 75, 84, 92 ], 109 => [ 41, 50, 58, 67, 75, 84, 92, 101 ], 113 => [ 49, 65, 81, 97 ], 118 => [ 41, 50, 58, 67, 75, 84, 92, 101, 109 ], 126 => [ 41, 50, 58, 67, 75, 84, 92, 101, 109, 118 ] },
	{  0 => [ 25, 17,  8 ],  2 => [ 18 ],  4 => [ 26, 19, 11 ],  8 => [ 25, 17 ], 11 => [ 26, 19 ], 17 => [ 25 ], 19 => [ 26 ], 32 => [ 33 ], 36 => [ 35 ], 37 => [ 35, 36 ], 38 => [ 35, 36, 37 ], 39 => [ 35, 36, 37, 38 ], 49 => [ 41 ], 51 => [ 42 ], 56 => [ 41, 49 ], 59 => [ 42, 51 ], 64 => [ 41, 49, 56 ], 66 => [ 50 ], 68 => [ 42, 51, 59 ], 76 => [ 42, 51, 59, 68 ], 82 => [ 50, 66 ], 85 => [ 42, 51, 59, 68, 76 ], 93 => [ 42, 51, 59, 68, 76, 85 ], 98 => [ 50, 66, 82 ], 102 => [ 42, 51, 59, 68, 76, 85, 93 ], 110 => [ 42, 51, 59, 68, 76, 85, 93, 102 ], 114 => [ 50, 66, 82, 98 ], 119 => [ 42, 51, 59, 68, 76, 85, 93, 102, 110 ], 127 => [ 42, 51, 59, 68, 76, 85, 93, 102, 110, 119 ] },
	{  1 => [ 26, 18,  9 ],  3 => [ 19 ],  5 => [ 27, 20, 12 ],  9 => [ 26, 18 ], 12 => [ 27, 20 ], 18 => [ 26 ], 20 => [ 27 ], 32 => [ 34, 33 ], 33 => [ 34 ], 37 => [ 36 ], 38 => [ 36, 37 ], 39 => [ 36, 37, 38 ], 50 => [ 42 ], 52 => [ 43 ], 57 => [ 42, 50 ], 60 => [ 43, 52 ], 65 => [ 42, 50, 57 ], 67 => [ 51 ], 69 => [ 43, 52, 60 ], 72 => [ 42, 50, 57, 65 ], 77 => [ 43, 52, 60, 69 ], 80 => [ 42, 50, 57, 65, 72 ], 83 => [ 51, 67 ], 86 => [ 43, 52, 60, 69, 77 ], 94 => [ 43, 52, 60, 69, 77, 86 ], 99 => [ 51, 67, 83 ], 103 => [ 43, 52, 60, 69, 77, 86, 94 ], 111 => [ 43, 52, 60, 69, 77, 86, 94, 103 ], 115 => [ 51, 67, 83, 99 ] },
	{  2 => [ 27, 19, 10 ],  4 => [ 20 ],  6 => [ 28, 21, 13 ], 10 => [ 27, 19 ], 13 => [ 28, 21 ], 19 => [ 27 ], 21 => [ 28 ], 32 => [ 35, 34, 33 ], 33 => [ 35, 34 ], 34 => [ 35 ], 38 => [ 37 ], 39 => [ 37, 38 ], 51 => [ 43 ], 53 => [ 44 ], 58 => [ 43, 51 ], 61 => [ 44, 53 ], 66 => [ 43, 51, 58 ], 68 => [ 52 ], 70 => [ 44, 53, 61 ], 73 => [ 43, 51, 58, 66 ], 78 => [ 44, 53, 61, 70 ], 81 => [ 43, 51, 58, 66, 73 ], 84 => [ 52, 68 ], 87 => [ 44, 53, 61, 70, 78 ], 88 => [ 43, 51, 58, 66, 73, 81 ], 95 => [ 44, 53, 61, 70, 78, 87 ], 96 => [ 43, 51, 58, 66, 73, 81, 88 ], 100 => [ 52, 68, 84 ], 116 => [ 52, 68, 84, 100 ] },
	{  3 => [ 28, 20, 11 ],  5 => [ 21 ],  7 => [ 29, 22, 14 ], 11 => [ 28, 20 ], 14 => [ 29, 22 ], 20 => [ 28 ], 22 => [ 29 ], 32 => [ 36, 35, 34, 33 ], 33 => [ 36, 35, 34 ], 34 => [ 36, 35 ], 35 => [ 36 ], 39 => [ 38 ], 52 => [ 44 ], 54 => [ 45 ], 59 => [ 44, 52 ], 62 => [ 45, 54 ], 67 => [ 44, 52, 59 ], 69 => [ 53 ], 71 => [ 45, 54, 62 ], 74 => [ 44, 52, 59, 67 ], 79 => [ 45, 54, 62, 71 ], 82 => [ 44, 52, 59, 67, 74 ], 85 => [ 53, 69 ], 89 => [ 44, 52, 59, 67, 74, 82 ], 97 => [ 44, 52, 59, 67, 74, 82, 89 ], 101 => [ 53, 69, 85 ], 104 => [ 44, 52, 59, 67, 74, 82, 89, 97 ], 112 => [ 44, 52, 59, 67, 74, 82, 89, 97, 104 ], 117 => [ 53, 69, 85, 101 ] },
	{  4 => [ 29, 21, 12 ],  6 => [ 22 ], 12 => [ 29, 21 ], 15 => [ 30, 23 ], 21 => [ 29 ], 23 => [ 30 ], 32 => [ 37, 36, 35, 34, 33 ], 33 => [ 37, 36, 35, 34 ], 34 => [ 37, 36, 35 ], 35 => [ 37, 36 ], 36 => [ 37 ], 53 => [ 45 ], 55 => [ 46 ], 60 => [ 45, 53 ], 63 => [ 46, 55 ], 68 => [ 45, 53, 60 ], 70 => [ 54 ], 75 => [ 45, 53, 60, 68 ], 83 => [ 45, 53, 60, 68, 75 ], 86 => [ 54, 70 ], 90 => [ 45, 53, 60, 68, 75, 83 ], 98 => [ 45, 53, 60, 68, 75, 83, 90 ], 102 => [ 54, 70, 86 ], 105 => [ 45, 53, 60, 68, 75, 83, 90, 98 ], 113 => [ 45, 53, 60, 68, 75, 83, 90, 98, 105 ], 118 => [ 54, 70, 86, 102 ], 120 => [ 45, 53, 60, 68, 75, 83, 90, 98, 105, 113 ] },
	{  5 => [ 30, 22, 13 ],  7 => [ 23 ], 13 => [ 30, 22 ], 22 => [ 30 ], 32 => [ 38, 37, 36, 35, 34, 33 ], 33 => [ 38, 37, 36, 35, 34 ], 34 => [ 38, 37, 36, 35 ], 35 => [ 38, 37, 36 ], 36 => [ 38, 37 ], 37 => [ 38 ], 54 => [ 46 ], 61 => [ 46, 54 ], 69 => [ 46, 54, 61 ], 71 => [ 55 ], 76 => [ 46, 54, 61, 69 ], 84 => [ 46, 54, 61, 69, 76 ], 87 => [ 55, 71 ], 91 => [ 46, 54, 61, 69, 76, 84 ], 99 => [ 46, 54, 61, 69, 76, 84, 91 ], 103 => [ 55, 71, 87 ], 106 => [ 46, 54, 61, 69, 76, 84, 91, 99 ], 114 => [ 46, 54, 61, 69, 76, 84, 91, 99, 106 ], 119 => [ 55, 71, 87, 103 ], 121 => [ 46, 54, 61, 69, 76, 84, 91, 99, 106, 114 ] },
	{  3 => [ 33, 25, 18, 10 ],  8 => [ 24 ], 10 => [ 33, 25, 18 ], 18 => [ 33, 25 ], 25 => [ 33 ], 42 => [ 41 ], 43 => [ 41, 42 ], 44 => [ 41, 42, 43 ], 45 => [ 41, 42, 43, 44 ], 46 => [ 41, 42, 43, 44, 45 ], 47 => [ 41, 42, 43, 44, 45, 46 ], 57 => [ 49 ], 66 => [ 49, 57 ], 72 => [ 56 ], 74 => [ 49, 57, 66 ], 83 => [ 49, 57, 66, 74 ], 88 => [ 56, 72 ], 91 => [ 49, 57, 66, 74, 83 ], 100 => [ 49, 57, 66, 74, 83, 91 ], 104 => [ 56, 72, 88 ], 108 => [ 49, 57, 66, 74, 83, 91, 100 ], 117 => [ 49, 57, 66, 74, 83, 91, 100, 108 ], 120 => [ 56, 72, 88, 104 ], 125 => [ 49, 57, 66, 74, 83, 91, 100, 108, 117 ] },
	{  4 => [ 34, 26, 19, 11 ],  9 => [ 25 ], 11 => [ 34, 26, 19 ], 16 => [ 33, 24 ], 19 => [ 34, 26 ], 24 => [ 33 ], 26 => [ 34 ], 43 => [ 42 ], 44 => [ 42, 43 ], 45 => [ 42, 43, 44 ], 46 => [ 42, 43, 44, 45 ], 47 => [ 42, 43, 44, 45, 46 ], 56 => [ 49 ], 58 => [ 50 ], 64 => [ 49, 56 ], 67 => [ 50, 58 ], 73 => [ 57 ], 75 => [ 50, 58, 67 ], 84 => [ 50, 58, 67, 75 ], 89 => [ 57, 73 ], 92 => [ 50, 58, 67, 75, 84 ], 101 => [ 50, 58, 67, 75, 84, 92 ], 105 => [ 57, 73, 89 ], 109 => [ 50, 58, 67, 75, 84, 92, 101 ], 118 => [ 50, 58, 67, 75, 84, 92, 101, 109 ], 121 => [ 57, 73, 89, 105 ], 126 => [ 50, 58, 67, 75, 84, 92, 101, 109, 118 ] },
	{  0 => [ 34, 25, 17,  8 ],  5 => [ 35, 27, 20, 12 ],  8 => [ 34, 25, 17 ], 10 => [ 26 ], 12 => [ 35, 27, 20 ], 17 => [ 34, 25 ], 20 => [ 35, 27 ], 25 => [ 34 ], 27 => [ 35 ], 40 => [ 41 ], 44 => [ 43 ], 45 => [ 43, 44 ], 46 => [ 43, 44, 45 ], 47 => [ 43, 44, 45, 46 ], 57 => [ 50 ], 59 => [ 51 ], 65 => [ 50, 57 ], 68 => [ 51, 59 ], 72 => [ 50, 57, 65 ], 74 => [ 58 ], 76 => [ 51, 59, 68 ], 80 => [ 50, 57, 65, 72 ], 85 => [ 51, 59, 68, 76 ], 90 => [ 58, 74 ], 93 => [ 51, 59, 68, 76, 85 ], 102 => [ 51, 59, 68, 76, 85, 93 ], 106 => [ 58, 74, 90 ], 110 => [ 51, 59, 68, 76, 85, 93, 102 ], 119 => [ 51, 59, 68, 76, 85, 93, 102, 110 ], 122 => [ 58, 74, 90, 106 ], 127 => [ 51, 59, 68, 76, 85, 93, 102, 110, 119 ] },
	{  1 => [ 35, 26, 18,  9 ],  6 => [ 36, 28, 21, 13 ],  9 => [ 35, 26, 18 ], 11 => [ 27 ], 13 => [ 36, 28, 21 ], 18 => [ 35, 26 ], 21 => [ 36, 28 ], 26 => [ 35 ], 28 => [ 36 ], 40 => [ 42, 41 ], 41 => [ 42 ], 45 => [ 44 ], 46 => [ 44, 45 ], 47 => [ 44, 45, 46 ], 58 => [ 51 ], 60 => [ 52 ], 66 => [ 51, 58 ], 69 => [ 52, 60 ], 73 => [ 51, 58, 66 ], 75 => [ 59 ], 77 => [ 52, 60, 69 ], 81 => [ 51, 58, 66, 73 ], 86 => [ 52, 60, 69, 77 ], 88 => [ 51, 58, 66, 73, 81 ], 91 => [ 59, 75 ], 94 => [ 52, 60, 69, 77, 86 ], 96 => [ 51, 58, 66, 73, 81, 88 ], 103 => [ 52, 60, 69, 77, 86, 94 ], 107 => [ 59, 75, 91 ], 111 => [ 52, 60, 69, 77, 86, 94, 103 ], 123 => [ 59, 75, 91, 107 ] },
	{  2 => [ 36, 27, 19, 10 ],  7 => [ 37, 29, 22, 14 ], 10 => [ 36, 27, 19 ], 12 => [ 28 ], 14 => [ 37, 29, 22 ], 19 => [ 36, 27 ], 22 => [ 37, 29 ], 27 => [ 36 ], 29 => [ 37 ], 40 => [ 43, 42, 41 ], 41 => [ 43, 42 ], 42 => [ 43 ], 46 => [ 45 ], 47 => [ 45, 46 ], 59 => [ 52 ], 61 => [ 53 ], 67 => [ 52, 59 ], 70 => [ 53, 61 ], 74 => [ 52, 59, 67 ], 76 => [ 60 ], 78 => [ 53, 61, 70 ], 82 => [ 52, 59, 67, 74 ], 87 => [ 53, 61, 70, 78 ], 89 => [ 52, 59, 67, 74, 82 ], 92 => [ 60, 76 ], 95 => [ 53, 61, 70, 78, 87 ], 97 => [ 52, 59, 67, 74, 82, 89 ], 104 => [ 52, 59, 67, 74, 82, 89, 97 ], 108 => [ 60, 76, 92 ], 112 => [ 52, 59, 67, 74, 82, 89, 97, 104 ], 124 => [ 60, 76, 92, 108 ] },
	{  3 => [ 37, 28, 20, 11 ], 11 => [ 37, 28, 20 ], 13 => [ 29 ], 15 => [ 38, 30, 23 ], 20 => [ 37, 28 ], 23 => [ 38, 30 ], 28 => [ 37 ], 30 => [ 38 ], 40 => [ 44, 43, 42, 41 ], 41 => [ 44, 43, 42 ], 42 => [ 44, 43 ], 43 => [ 44 ], 47 => [ 46 ], 60 => [ 53 ], 62 => [ 54 ], 68 => [ 53, 60 ], 71 => [ 54, 62 ], 75 => [ 53, 60, 68 ], 77 => [ 61 ], 79 => [ 54, 62, 71 ], 83 => [ 53, 60, 68, 75 ], 90 => [ 53, 60, 68, 75, 83 ], 93 => [ 61, 77 ], 98 => [ 53, 60, 68, 75, 83, 90 ], 105 => [ 53, 60, 68, 75, 83, 90, 98 ], 109 => [ 61, 77, 93 ], 113 => [ 53, 60, 68, 75, 83, 90, 98, 105 ], 120 => [ 53, 60, 68, 75, 83, 90, 98, 105, 113 ], 125 => [ 61, 77, 93, 109 ] },
	{  4 => [ 38, 29, 21, 12 ], 12 => [ 38, 29, 21 ], 14 => [ 30 ], 21 => [ 38, 29 ], 29 => [ 38 ], 31 => [ 39 ], 40 => [ 45, 44, 43, 42, 41 ], 41 => [ 45, 44, 43, 42 ], 42 => [ 45, 44, 43 ], 43 => [ 45, 44 ], 44 => [ 45 ], 61 => [ 54 ], 63 => [ 55 ], 69 => [ 54, 61 ], 76 => [ 54, 61, 69 ], 78 => [ 62 ], 84 => [ 54, 61, 69, 76 ], 91 => [ 54, 61, 69, 76, 84 ], 94 => [ 62, 78 ], 99 => [ 54, 61, 69, 76, 84, 91 ], 106 => [ 54, 61, 69, 76, 84, 91, 99 ], 110 => [ 62, 78, 94 ], 114 => [ 54, 61, 69, 76, 84, 91, 99, 106 ], 121 => [ 54, 61, 69, 76, 84, 91, 99, 106, 114 ], 126 => [ 62, 78, 94, 110 ] },
	{  5 => [ 39, 30, 22, 13 ], 13 => [ 39, 30, 22 ], 15 => [ 31 ], 22 => [ 39, 30 ], 30 => [ 39 ], 40 => [ 46, 45, 44, 43, 42, 41 ], 41 => [ 46, 45, 44, 43, 42 ], 42 => [ 46, 45, 44, 43 ], 43 => [ 46, 45, 44 ], 44 => [ 46, 45 ], 45 => [ 46 ], 62 => [ 55 ], 70 => [ 55, 62 ], 77 => [ 55, 62, 70 ], 79 => [ 63 ], 85 => [ 55, 62, 70, 77 ], 92 => [ 55, 62, 70, 77, 85 ], 95 => [ 63, 79 ], 100 => [ 55, 62, 70, 77, 85, 92 ], 107 => [ 55, 62, 70, 77, 85, 92, 100 ], 111 => [ 63, 79, 95 ], 115 => [ 55, 62, 70, 77, 85, 92, 100, 107 ], 122 => [ 55, 62, 70, 77, 85, 92, 100, 107, 115 ], 127 => [ 63, 79, 95, 111 ] },
	{  0 => [ 32, 16 ],  3 => [ 40, 33, 25, 18, 10 ], 10 => [ 40, 33, 25, 18 ], 16 => [ 32 ], 18 => [ 40, 33, 25 ], 25 => [ 40, 33 ], 33 => [ 40 ], 50 => [ 49 ], 51 => [ 49, 50 ], 52 => [ 49, 50, 51 ], 53 => [ 49, 50, 51, 52 ], 54 => [ 49, 50, 51, 52, 53 ], 55 => [ 49, 50, 51, 52, 53, 54 ], 65 => [ 56 ], 73 => [ 56, 65 ], 80 => [ 64 ], 82 => [ 56, 65, 73 ], 90 => [ 56, 65, 73, 82 ], 96 => [ 64, 80 ], 99 => [ 56, 65, 73, 82, 90 ], 107 => [ 56, 65, 73, 82, 90, 99 ], 112 => [ 64, 80, 96 ], 116 => [ 56, 65, 73, 82, 90, 99, 107 ], 124 => [ 56, 65, 73, 82, 90, 99, 107, 116 ] },
	{  1 => [ 33, 17 ],  4 => [ 41, 34, 26, 19, 11 ], 11 => [ 41, 34, 26, 19 ], 17 => [ 33 ], 19 => [ 41, 34, 26 ], 26 => [ 41, 34 ], 32 => [ 40 ], 34 => [ 41 ], 51 => [ 50 ], 52 => [ 50, 51 ], 53 => [ 50, 51, 52 ], 54 => [ 50, 51, 52, 53 ], 55 => [ 50, 51, 52, 53, 54 ], 64 => [ 56 ], 66 => [ 57 ], 74 => [ 57, 66 ], 81 => [ 65 ], 83 => [ 57, 66, 74 ], 91 => [ 57, 66, 74, 83 ], 97 => [ 65, 81 ], 100 => [ 57, 66, 74, 83, 91 ], 108 => [ 57, 66, 74, 83, 91, 100 ], 113 => [ 65, 81, 97 ], 117 => [ 57, 66, 74, 83, 91, 100, 108 ], 125 => [ 57, 66, 74, 83, 91, 100, 108, 117 ] },
	{  2 => [ 34, 18 ],  5 => [ 42, 35, 27, 20, 12 ], 12 => [ 42, 35, 27, 20 ], 16 => [ 41, 33, 24 ], 18 => [ 34 ], 20 => [ 42, 35, 27 ], 24 => [ 41, 33 ], 27 => [ 42, 35 ], 33 => [ 41 ], 35 => [ 42 ], 48 => [ 49 ], 52 => [ 51 ], 53 => [ 51, 52 ], 54 => [ 51, 52, 53 ], 55 => [ 51, 52, 53, 54 ], 65 => [ 57 ], 67 => [ 58 ], 72 => [ 57, 65 ], 75 => [ 58, 67 ], 80 => [ 57, 65, 72 ], 82 => [ 66 ], 84 => [ 58, 67, 75 ], 92 => [ 58, 67, 75, 84 ], 98 => [ 66, 82 ], 101 => [ 58, 67, 75, 84, 92 ], 109 => [ 58, 67, 75, 84, 92, 101 ], 114 => [ 66, 82, 98 ], 118 => [ 58, 67, 75, 84, 92, 101, 109 ], 126 => [ 58, 67, 75, 84, 92, 101, 109, 118 ] },
	{  0 => [ 42, 34, 25, 17,  8 ],  3 => [ 35, 19 ],  6 => [ 43, 36, 28, 21, 13 ],  8 => [ 42, 34, 25, 17 ], 13 => [ 43, 36, 28, 21 ], 17 => [ 42, 34, 25 ], 19 => [ 35 ], 21 => [ 43, 36, 28 ], 25 => [ 42, 34 ], 28 => [ 43, 36 ], 34 => [ 42 ], 36 => [ 43 ], 48 => [ 50, 49 ], 49 => [ 50 ], 53 => [ 52 ], 54 => [ 52, 53 ], 55 => [ 52, 53, 54 ], 66 => [ 58 ], 68 => [ 59 ], 73 => [ 58, 66 ], 76 => [ 59, 68 ], 81 => [ 58, 66, 73 ], 83 => [ 67 ], 85 => [ 59, 68, 76 ], 88 => [ 58, 66, 73, 81 ], 93 => [ 59, 68, 76, 85 ], 96 => [ 58, 66, 73, 81, 88 ], 99 => [ 67, 83 ], 102 => [ 59, 68, 76, 85, 93 ], 110 => [ 59, 68, 76, 85, 93, 102 ], 115 => [ 67, 83, 99 ], 119 => [ 59, 68, 76, 85, 93, 102, 110 ], 127 => [ 59, 68, 76, 85, 93, 102, 110, 119 ] },
	{  1 => [ 43, 35, 26, 18,  9 ],  4 => [ 36, 20 ],  7 => [ 44, 37, 29, 22, 14 ],  9 => [ 43, 35, 26, 18 ], 14 => [ 44, 37, 29, 22 ], 18 => [ 43, 35, 26 ], 20 => [ 36 ], 22 => [ 44, 37, 29 ], 26 => [ 43, 35 ], 29 => [ 44, 37 ], 35 => [ 43 ], 37 => [ 44 ], 48 => [ 51, 50, 49 ], 49 => [ 51, 50 ], 50 => [ 51 ], 54 => [ 53 ], 55 => [ 53, 54 ], 67 => [ 59 ], 69 => [ 60 ], 74 => [ 59, 67 ], 77 => [ 60, 69 ], 82 => [ 59, 67, 74 ], 84 => [ 68 ], 86 => [ 60, 69, 77 ], 89 => [ 59, 67, 74, 82 ], 94 => [ 60, 69, 77, 86 ], 97 => [ 59, 67, 74, 82, 89 ], 100 => [ 68, 84 ], 103 => [ 60, 69, 77, 86, 94 ], 104 => [ 59, 67, 74, 82, 89, 97 ], 111 => [ 60, 69, 77, 86, 94, 103 ], 112 => [ 59, 67, 74, 82, 89, 97, 104 ], 116 => [ 68, 84, 100 ] },
	{  2 => [ 44, 36, 27, 19, 10 ],  5 => [ 37, 21 ], 10 => [ 44, 36, 27, 19 ], 15 => [ 45, 38, 30, 23 ], 19 => [ 44, 36, 27 ], 21 => [ 37 ], 23 => [ 45, 38, 30 ], 27 => [ 44, 36 ], 30 => [ 45, 38 ], 36 => [ 44 ], 38 => [ 45 ], 48 => [ 52, 51, 50, 49 ], 49 => [ 52, 51, 50 ], 50 => [ 52, 51 ], 51 => [ 52 ], 55 => [ 54 ], 68 => [ 60 ], 70 => [ 61 ], 75 => [ 60, 68 ], 78 => [ 61, 70 ], 83 => [ 60, 68, 75 ], 85 => [ 69 ], 87 => [ 61, 70, 78 ], 90 => [ 60, 68, 75, 83 ], 95 => [ 61, 70, 78, 87 ], 98 => [ 60, 68, 75, 83, 90 ], 101 => [ 69, 85 ], 105 => [ 60, 68, 75, 83, 90, 98 ], 113 => [ 60, 68, 75, 83, 90, 98, 105 ], 117 => [ 69, 85, 101 ], 120 => [ 60, 68, 75, 83, 90, 98, 105, 113 ] },
	{  3 => [ 45, 37, 28, 20, 11 ],  6 => [ 38, 22 ], 11 => [ 45, 37, 28, 20 ], 20 => [ 45, 37, 28 ], 22 => [ 38 ], 28 => [ 45, 37 ], 31 => [ 46, 39 ], 37 => [ 45 ], 39 => [ 46 ], 48 => [ 53, 52, 51, 50, 49 ], 49 => [ 53, 52, 51, 50 ], 50 => [ 53, 52, 51 ], 51 => [ 53, 52 ], 52 => [ 53 ], 69 => [ 61 ], 71 => [ 62 ], 76 => [ 61, 69 ], 79 => [ 62, 71 ], 84 => [ 61, 69, 76 ], 86 => [ 70 ], 91 => [ 61, 69, 76, 84 ], 99 => [ 61, 69, 76, 84, 91 ], 102 => [ 70, 86 ], 106 => [ 61, 69, 76, 84, 91, 99 ], 114 => [ 61, 69, 76, 84, 91, 99, 106 ], 118 => [ 70, 86, 102 ], 121 => [ 61, 69, 76, 84, 91, 99, 106, 114 ] },
	{  4 => [ 46, 38, 29, 21, 12 ],  7 => [ 39, 23 ], 12 => [ 46, 38, 29, 21 ], 21 => [ 46, 38, 29 ], 23 => [ 39 ], 29 => [ 46, 38 ], 38 => [ 46 ], 48 => [ 54, 53, 52, 51, 50, 49 ], 49 => [ 54, 53, 52, 51, 50 ], 50 => [ 54, 53, 52, 51 ], 51 => [ 54, 53, 52 ], 52 => [ 54, 53 ], 53 => [ 54 ], 70 => [ 62 ], 77 => [ 62, 70 ], 85 => [ 62, 70, 77 ], 87 => [ 71 ], 92 => [ 62, 70, 77, 85 ], 100 => [ 62, 70, 77, 85, 92 ], 103 => [ 71, 87 ], 107 => [ 62, 70, 77, 85, 92, 100 ], 115 => [ 62, 70, 77, 85, 92, 100, 107 ], 119 => [ 71, 87, 103 ], 122 => [ 62, 70, 77, 85, 92, 100, 107, 115 ] },
	{  4 => [ 49, 41, 34, 26, 19, 11 ],  8 => [ 40, 24 ], 11 => [ 49, 41, 34, 26, 19 ], 19 => [ 49, 41, 34, 26 ], 24 => [ 40 ], 26 => [ 49, 41, 34 ], 34 => [ 49, 41 ], 41 => [ 49 ], 58 => [ 57 ], 59 => [ 57, 58 ], 60 => [ 57, 58, 59 ], 61 => [ 57, 58, 59, 60 ], 62 => [ 57, 58, 59, 60, 61 ], 63 => [ 57, 58, 59, 60, 61, 62 ], 73 => [ 65 ], 82 => [ 65, 73 ], 88 => [ 72 ], 90 => [ 65, 73, 82 ], 99 => [ 65, 73, 82, 90 ], 104 => [ 72, 88 ], 107 => [ 65, 73, 82, 90, 99 ], 116 => [ 65, 73, 82, 90, 99, 107 ], 120 => [ 72, 88, 104 ], 124 => [ 65, 73, 82, 90, 99, 107, 116 ] },
	{  5 => [ 50, 42, 35, 27, 20, 12 ],  9 => [ 41, 25 ], 12 => [ 50, 42, 35, 27, 20 ], 20 => [ 50, 42, 35, 27 ], 25 => [ 41 ], 27 => [ 50, 42, 35 ], 32 => [ 49, 40 ], 35 => [ 50, 42 ], 40 => [ 49 ], 42 => [ 50 ], 59 => [ 58 ], 60 => [ 58, 59 ], 61 => [ 58, 59, 60 ], 62 => [ 58, 59, 60, 61 ], 63 => [ 58, 59, 60, 61, 62 ], 72 => [ 65 ], 74 => [ 66 ], 80 => [ 65, 72 ], 83 => [ 66, 74 ], 89 => [ 73 ], 91 => [ 66, 74, 83 ], 100 => [ 66, 74, 83, 91 ], 105 => [ 73, 89 ], 108 => [ 66, 74, 83, 91, 100 ], 117 => [ 66, 74, 83, 91, 100, 108 ], 121 => [ 73, 89, 105 ], 125 => [ 66, 74, 83, 91, 100, 108, 117 ] },
	{  6 => [ 51, 43, 36, 28, 21, 13 ], 10 => [ 42, 26 ], 13 => [ 51, 43, 36, 28, 21 ], 16 => [ 50, 41, 33, 24 ], 21 => [ 51, 43, 36, 28 ], 24 => [ 50, 41, 33 ], 26 => [ 42 ], 28 => [ 51, 43, 36 ], 33 => [ 50, 41 ], 36 => [ 51, 43 ], 41 => [ 50 ], 43 => [ 51 ], 56 => [ 57 ], 60 => [ 59 ], 61 => [ 59, 60 ], 62 => [ 59, 60, 61 ], 63 => [ 59, 60, 61, 62 ], 73 => [ 66 ], 75 => [ 67 ], 81 => [ 66, 73 ], 84 => [ 67, 75 ], 88 => [ 66, 73, 81 ], 90 => [ 74 ], 92 => [ 67, 75, 84 ], 96 => [ 66, 73, 81, 88 ], 101 => [ 67, 75, 84, 92 ], 106 => [ 74, 90 ], 109 => [ 67, 75, 84, 92, 101 ], 118 => [ 67, 75, 84, 92, 101, 109 ], 122 => [ 74, 90, 106 ], 126 => [ 67, 75, 84, 92, 101, 109, 118 ] },
	{  0 => [ 51, 42, 34, 25, 17,  8 ],  7 => [ 52, 44, 37, 29, 22, 14 ],  8 => [ 51, 42, 34, 25, 17 ], 11 => [ 43, 27 ], 14 => [ 52, 44, 37, 29, 22 ], 17 => [ 51, 42, 34, 25 ], 22 => [ 52, 44, 37, 29 ], 25 => [ 51, 42, 34 ], 27 => [ 43 ], 29 => [ 52, 44, 37 ], 34 => [ 51, 42 ], 37 => [ 52, 44 ], 42 => [ 51 ], 44 => [ 52 ], 56 => [ 58, 57 ], 57 => [ 58 ], 61 => [ 60 ], 62 => [ 60, 61 ], 63 => [ 60, 61, 62 ], 74 => [ 67 ], 76 => [ 68 ], 82 => [ 67, 74 ], 85 => [ 68, 76 ], 89 => [ 67, 74, 82 ], 91 => [ 75 ], 93 => [ 68, 76, 85 ], 97 => [ 67, 74, 82, 89 ], 102 => [ 68, 76, 85, 93 ], 104 => [ 67, 74, 82, 89, 97 ], 107 => [ 75, 91 ], 110 => [ 68, 76, 85, 93, 102 ], 112 => [ 67, 74, 82, 89, 97, 104 ], 119 => [ 68, 76, 85, 93, 102, 110 ], 123 => [ 75, 91, 107 ], 127 => [ 68, 76, 85, 93, 102, 110, 119 ] },
	{  1 => [ 52, 43, 35, 26, 18,  9 ],  9 => [ 52, 43, 35, 26, 18 ], 12 => [ 44, 28 ], 15 => [ 53, 45, 38, 30, 23 ], 18 => [ 52, 43, 35, 26 ], 23 => [ 53, 45, 38, 30 ], 26 => [ 52, 43, 35 ], 28 => [ 44 ], 30 => [ 53, 45, 38 ], 35 => [ 52, 43 ], 38 => [ 53, 45 ], 43 => [ 52 ], 45 => [ 53 ], 56 => [ 59, 58, 57 ], 57 => [ 59, 58 ], 58 => [ 59 ], 62 => [ 61 ], 63 => [ 61, 62 ], 75 => [ 68 ], 77 => [ 69 ], 83 => [ 68, 75 ], 86 => [ 69, 77 ], 90 => [ 68, 75, 83 ], 92 => [ 76 ], 94 => [ 69, 77, 86 ], 98 => [ 68, 75, 83, 90 ], 103 => [ 69, 77, 86, 94 ], 105 => [ 68, 75, 83, 90, 98 ], 108 => [ 76, 92 ], 111 => [ 69, 77, 86, 94, 103 ], 113 => [ 68, 75, 83, 90, 98, 105 ], 120 => [ 68, 75, 83, 90, 98, 105, 113 ], 124 => [ 76, 92, 108 ] },
	{  2 => [ 53, 44, 36, 27, 19, 10 ], 10 => [ 53, 44, 36, 27, 19 ], 13 => [ 45, 29 ], 19 => [ 53, 44, 36, 27 ], 27 => [ 53, 44, 36 ], 29 => [ 45 ], 31 => [ 54, 46, 39 ], 36 => [ 53, 44 ], 39 => [ 54, 46 ], 44 => [ 53 ], 46 => [ 54 ], 56 => [ 60, 59, 58, 57 ], 57 => [ 60, 59, 58 ], 58 => [ 60, 59 ], 59 => [ 60 ], 63 => [ 62 ], 76 => [ 69 ], 78 => [ 70 ], 84 => [ 69, 76 ], 87 => [ 70, 78 ], 91 => [ 69, 76, 84 ], 93 => [ 77 ], 95 => [ 70, 78, 87 ], 99 => [ 69, 76, 84, 91 ], 106 => [ 69, 76, 84, 91, 99 ], 109 => [ 77, 93 ], 114 => [ 69, 76, 84, 91, 99, 106 ], 121 => [ 69, 76, 84, 91, 99, 106, 114 ], 125 => [ 77, 93, 109 ] },
	{  3 => [ 54, 45, 37, 28, 20, 11 ], 11 => [ 54, 45, 37, 28, 20 ], 14 => [ 46, 30 ], 20 => [ 54, 45, 37, 28 ], 28 => [ 54, 45, 37 ], 30 => [ 46 ], 37 => [ 54, 45 ], 45 => [ 54 ], 47 => [ 55 ], 56 => [ 61, 60, 59, 58, 57 ], 57 => [ 61, 60, 59, 58 ], 58 => [ 61, 60, 59 ], 59 => [ 61, 60 ], 60 => [ 61 ], 77 => [ 70 ], 79 => [ 71 ], 85 => [ 70, 77 ], 92 => [ 70, 77, 85 ], 94 => [ 78 ], 100 => [ 70, 77, 85, 92 ], 107 => [ 70, 77, 85, 92, 100 ], 110 => [ 78, 94 ], 115 => [ 70, 77, 85, 92, 100, 107 ], 122 => [ 70, 77, 85, 92, 100, 107, 115 ], 126 => [ 78, 94, 110 ] },
	{  4 => [ 55, 46, 38, 29, 21, 12 ], 12 => [ 55, 46, 38, 29, 21 ], 15 => [ 47, 31 ], 21 => [ 55, 46, 38, 29 ], 29 => [ 55, 46, 38 ], 31 => [ 47 ], 38 => [ 55, 46 ], 46 => [ 55 ], 56 => [ 62, 61, 60, 59, 58, 57 ], 57 => [ 62, 61, 60, 59, 58 ], 58 => [ 62, 61, 60, 59 ], 59 => [ 62, 61, 60 ], 60 => [ 62, 61 ], 61 => [ 62 ], 78 => [ 71 ], 86 => [ 71, 78 ], 93 => [ 71, 78, 86 ], 95 => [ 79 ], 101 => [ 71, 78, 86, 93 ], 108 => [ 71, 78, 86, 93, 101 ], 111 => [ 79, 95 ], 116 => [ 71, 78, 86, 93, 101, 108 ], 123 => [ 71, 78, 86, 93, 101, 108, 116 ], 127 => [ 79, 95, 111 ] },
	{  0 => [ 48, 32, 16 ],  4 => [ 56, 49, 41, 34, 26, 19, 11 ], 11 => [ 56, 49, 41, 34, 26, 19 ], 16 => [ 48, 32 ], 19 => [ 56, 49, 41, 34, 26 ], 26 => [ 56, 49, 41, 34 ], 32 => [ 48 ], 34 => [ 56, 49, 41 ], 41 => [ 56, 49 ], 49 => [ 56 ], 66 => [ 65 ], 67 => [ 65, 66 ], 68 => [ 65, 66, 67 ], 69 => [ 65, 66, 67, 68 ], 70 => [ 65, 66, 67, 68, 69 ], 71 => [ 65, 66, 67, 68, 69, 70 ], 81 => [ 72 ], 89 => [ 72, 81 ], 96 => [ 80 ], 98 => [ 72, 81, 89 ], 106 => [ 72, 81, 89, 98 ], 112 => [ 80, 96 ], 115 => [ 72, 81, 89, 98, 106 ], 123 => [ 72, 81, 89, 98, 106, 115 ] },
	{  1 => [ 49, 33, 17 ],  5 => [ 57, 50, 42, 35, 27, 20, 12 ], 12 => [ 57, 50, 42, 35, 27, 20 ], 17 => [ 49, 33 ], 20 => [ 57, 50, 42, 35, 27 ], 27 => [ 57, 50, 42, 35 ], 33 => [ 49 ], 35 => [ 57, 50, 42 ], 42 => [ 57, 50 ], 48 => [ 56 ], 50 => [ 57 ], 67 => [ 66 ], 68 => [ 66, 67 ], 69 => [ 66, 67, 68 ], 70 => [ 66, 67, 68, 69 ], 71 => [ 66, 67, 68, 69, 70 ], 80 => [ 72 ], 82 => [ 73 ], 90 => [ 73, 82 ], 97 => [ 81 ], 99 => [ 73, 82, 90 ], 107 => [ 73, 82, 90, 99 ], 113 => [ 81, 97 ], 116 => [ 73, 82, 90, 99, 107 ], 124 => [ 73, 82, 90, 99, 107, 116 ] },
	{  2 => [ 50, 34, 18 ],  6 => [ 58, 51, 43, 36, 28, 21, 13 ], 13 => [ 58, 51, 43, 36, 28, 21 ], 18 => [ 50, 34 ], 21 => [ 58, 51, 43, 36, 28 ], 28 => [ 58, 51, 43, 36 ], 32 => [ 57, 49, 40 ], 34 => [ 50 ], 36 => [ 58, 51, 43 ], 40 => [ 57, 49 ], 43 => [ 58, 51 ], 49 => [ 57 ], 51 => [ 58 ], 64 => [ 65 ], 68 => [ 67 ], 69 => [ 67, 68 ], 70 => [ 67, 68, 69 ], 71 => [ 67, 68, 69, 70 ], 81 => [ 73 ], 83 => [ 74 ], 88 => [ 73, 81 ], 91 => [ 74, 83 ], 96 => [ 73, 81, 88 ], 98 => [ 82 ], 100 => [ 74, 83, 91 ], 108 => [ 74, 83, 91, 100 ], 114 => [ 82, 98 ], 117 => [ 74, 83, 91, 100, 108 ], 125 => [ 74, 83, 91, 100, 108, 117 ] },
	{  3 => [ 51, 35, 19 ],  7 => [ 59, 52, 44, 37, 29, 22, 14 ], 14 => [ 59, 52, 44, 37, 29, 22 ], 16 => [ 58, 50, 41, 33, 24 ], 19 => [ 51, 35 ], 22 => [ 59, 52, 44, 37, 29 ], 24 => [ 58, 50, 41, 33 ], 29 => [ 59, 52, 44, 37 ], 33 => [ 58, 50, 41 ], 35 => [ 51 ], 37 => [ 59, 52, 44 ], 41 => [ 58, 50 ], 44 => [ 59, 52 ], 50 => [ 58 ], 52 => [ 59 ], 64 => [ 66, 65 ], 65 => [ 66 ], 69 => [ 68 ], 70 => [ 68, 69 ], 71 => [ 68, 69, 70 ], 82 => [ 74 ], 84 => [ 75 ], 89 => [ 74, 82 ], 92 => [ 75, 84 ], 97 => [ 74, 82, 89 ], 99 => [ 83 ], 101 => [ 75, 84, 92 ], 104 => [ 74, 82, 89, 97 ], 109 => [ 75, 84, 92, 101 ], 112 => [ 74, 82, 89, 97, 104 ], 115 => [ 83, 99 ], 118 => [ 75, 84, 92, 101, 109 ], 126 => [ 75, 84, 92, 101, 109, 118 ] },
	{  0 => [ 59, 51, 42, 34, 25, 17,  8 ],  4 => [ 52, 36, 20 ],  8 => [ 59, 51, 42, 34, 25, 17 ], 15 => [ 60, 53, 45, 38, 30, 23 ], 17 => [ 59, 51, 42, 34, 25 ], 20 => [ 52, 36 ], 23 => [ 60, 53, 45, 38, 30 ], 25 => [ 59, 51, 42, 34 ], 30 => [ 60, 53, 45, 38 ], 34 => [ 59, 51, 42 ], 36 => [ 52 ], 38 => [ 60, 53, 45 ], 42 => [ 59, 51 ], 45 => [ 60, 53 ], 51 => [ 59 ], 53 => [ 60 ], 64 => [ 67, 66, 65 ], 65 => [ 67, 66 ], 66 => [ 67 ], 70 => [ 69 ], 71 => [ 69, 70 ], 83 => [ 75 ], 85 => [ 76 ], 90 => [ 75, 83 ], 93 => [ 76, 85 ], 98 => [ 75, 83, 90 ], 100 => [ 84 ], 102 => [ 76, 85, 93 ], 105 => [ 75, 83, 90, 98 ], 110 => [ 76, 85, 93, 102 ], 113 => [ 75, 83, 90, 98, 105 ], 116 => [ 84, 100 ], 119 => [ 76, 85, 93, 102, 110 ], 120 => [ 75, 83, 90, 98, 105, 113 ], 127 => [ 76, 85, 93, 102, 110, 119 ] },
	{  1 => [ 60, 52, 43, 35, 26, 18,  9 ],  5 => [ 53, 37, 21 ],  9 => [ 60, 52, 43, 35, 26, 18 ], 18 => [ 60, 52, 43, 35, 26 ], 21 => [ 53, 37 ], 26 => [ 60, 52, 43, 35 ], 31 => [ 61, 54, 46, 39 ], 35 => [ 60, 52, 43 ], 37 => [ 53 ], 39 => [ 61, 54, 46 ], 43 => [ 60, 52 ], 46 => [ 61, 54 ], 52 => [ 60 ], 54 => [ 61 ], 64 => [ 68, 67, 66, 65 ], 65 => [ 68, 67, 66 ], 66 => [ 68, 67 ], 67 => [ 68 ], 71 => [ 70 ], 84 => [ 76 ], 86 => [ 77 ], 91 => [ 76, 84 ], 94 => [ 77, 86 ], 99 => [ 76, 84, 91 ], 101 => [ 85 ], 103 => [ 77, 86, 94 ], 106 => [ 76, 84, 91, 99 ], 111 => [ 77, 86, 94, 103 ], 114 => [ 76, 84, 91, 99, 106 ], 117 => [ 85, 101 ], 121 => [ 76, 84, 91, 99, 106, 114 ] },
	{  2 => [ 61, 53, 44, 36, 27, 19, 10 ],  6 => [ 54, 38, 22 ], 10 => [ 61, 53, 44, 36, 27, 19 ], 19 => [ 61, 53, 44, 36, 27 ], 22 => [ 54, 38 ], 27 => [ 61, 53, 44, 36 ], 36 => [ 61, 53, 44 ], 38 => [ 54 ], 44 => [ 61, 53 ], 47 => [ 62, 55 ], 53 => [ 61 ], 55 => [ 62 ], 64 => [ 69, 68, 67, 66, 65 ], 65 => [ 69, 68, 67, 66 ], 66 => [ 69, 68, 67 ], 67 => [ 69, 68 ], 68 => [ 69 ], 85 => [ 77 ], 87 => [ 78 ], 92 => [ 77, 85 ], 95 => [ 78, 87 ], 100 => [ 77, 85, 92 ], 102 => [ 86 ], 107 => [ 77, 85, 92, 100 ], 115 => [ 77, 85, 92, 100, 107 ], 118 => [ 86, 102 ], 122 => [ 77, 85, 92, 100, 107, 115 ] },
	{  3 => [ 62, 54, 45, 37, 28, 20, 11 ],  7 => [ 55, 39, 23 ], 11 => [ 62, 54, 45, 37, 28, 20 ], 20 => [ 62, 54, 45, 37, 28 ], 23 => [ 55, 39 ], 28 => [ 62, 54, 45, 37 ], 37 => [ 62, 54, 45 ], 39 => [ 55 ], 45 => [ 62, 54 ], 54 => [ 62 ], 64 => [ 70, 69, 68, 67, 66, 65 ], 65 => [ 70, 69, 68, 67, 66 ], 66 => [ 70, 69, 68, 67 ], 67 => [ 70, 69, 68 ], 68 => [ 70, 69 ], 69 => [ 70 ], 86 => [ 78 ], 93 => [ 78, 86 ], 101 => [ 78, 86, 93 ], 103 => [ 87 ], 108 => [ 78, 86, 93, 101 ], 116 => [ 78, 86, 93, 101, 108 ], 119 => [ 87, 103 ], 123 => [ 78, 86, 93, 101, 108, 116 ] },
	{  5 => [ 65, 57, 50, 42, 35, 27, 20, 12 ],  8 => [ 56, 40, 24 ], 12 => [ 65, 57, 50, 42, 35, 27, 20 ], 20 => [ 65, 57, 50, 42, 35, 27 ], 24 => [ 56, 40 ], 27 => [ 65, 57, 50, 42, 35 ], 35 => [ 65, 57, 50, 42 ], 40 => [ 56 ], 42 => [ 65, 57, 50 ], 50 => [ 65, 57 ], 57 => [ 65 ], 74 => [ 73 ], 75 => [ 73, 74 ], 76 => [ 73, 74, 75 ], 77 => [ 73, 74, 75, 76 ], 78 => [ 73, 74, 75, 76, 77 ], 79 => [ 73, 74, 75, 76, 77, 78 ], 89 => [ 81 ], 98 => [ 81, 89 ], 104 => [ 88 ], 106 => [ 81, 89, 98 ], 115 => [ 81, 89, 98, 106 ], 120 => [ 88, 104 ], 123 => [ 81, 89, 98, 106, 115 ] },
	{  6 => [ 66, 58, 51, 43, 36, 28, 21, 13 ],  9 => [ 57, 41, 25 ], 13 => [ 66, 58, 51, 43, 36, 28, 21 ], 21 => [ 66, 58, 51, 43, 36, 28 ], 25 => [ 57, 41 ], 28 => [ 66, 58, 51, 43, 36 ], 36 => [ 66, 58, 51, 43 ], 41 => [ 57 ], 43 => [ 66, 58, 51 ], 48 => [ 65, 56 ], 51 => [ 66, 58 ], 56 => [ 65 ], 58 => [ 66 ], 75 => [ 74 ], 76 => [ 74, 75 ], 77 => [ 74, 75, 76 ], 78 => [ 74, 75, 76, 77 ], 79 => [ 74, 75, 76, 77, 78 ], 88 => [ 81 ], 90 => [ 82 ], 96 => [ 81, 88 ], 99 => [ 82, 90 ], 105 => [ 89 ], 107 => [ 82, 90, 99 ], 116 => [ 82, 90, 99, 107 ], 121 => [ 89, 105 ], 124 => [ 82, 90, 99, 107, 116 ] },
	{  7 => [ 67, 59, 52, 44, 37, 29, 22, 14 ], 10 => [ 58, 42, 26 ], 14 => [ 67, 59, 52, 44, 37, 29, 22 ], 22 => [ 67, 59, 52, 44, 37, 29 ], 26 => [ 58, 42 ], 29 => [ 67, 59, 52, 44, 37 ], 32 => [ 66, 57, 49, 40 ], 37 => [ 67, 59, 52, 44 ], 40 => [ 66, 57, 49 ], 42 => [ 58 ], 44 => [ 67, 59, 52 ], 49 => [ 66, 57 ], 52 => [ 67, 59 ], 57 => [ 66 ], 59 => [ 67 ], 72 => [ 73 ], 76 => [ 75 ], 77 => [ 75, 76 ], 78 => [ 75, 76, 77 ], 79 => [ 75, 76, 77, 78 ], 89 => [ 82 ], 91 => [ 83 ], 97 => [ 82, 89 ], 100 => [ 83, 91 ], 104 => [ 82, 89, 97 ], 106 => [ 90 ], 108 => [ 83, 91, 100 ], 112 => [ 82, 89, 97, 104 ], 117 => [ 83, 91, 100, 108 ], 122 => [ 90, 106 ], 125 => [ 83, 91, 100, 108, 117 ] },
	{ 11 => [ 59, 43, 27 ], 15 => [ 68, 60, 53, 45, 38, 30, 23 ], 16 => [ 67, 58, 50, 41, 33, 24 ], 23 => [ 68, 60, 53, 45, 38, 30 ], 24 => [ 67, 58, 50, 41, 33 ], 27 => [ 59, 43 ], 30 => [ 68, 60, 53, 45, 38 ], 33 => [ 67, 58, 50, 41 ], 38 => [ 68, 60, 53, 45 ], 41 => [ 67, 58, 50 ], 43 => [ 59 ], 45 => [ 68, 60, 53 ], 50 => [ 67, 58 ], 53 => [ 68, 60 ], 58 => [ 67 ], 60 => [ 68 ], 72 => [ 74, 73 ], 73 => [ 74 ], 77 => [ 76 ], 78 => [ 76, 77 ], 79 => [ 76, 77, 78 ], 90 => [ 83 ], 92 => [ 84 ], 98 => [ 83, 90 ], 101 => [ 84, 92 ], 105 => [ 83, 90, 98 ], 107 => [ 91 ], 109 => [ 84, 92, 101 ], 113 => [ 83, 90, 98, 105 ], 118 => [ 84, 92, 101, 109 ], 120 => [ 83, 90, 98, 105, 113 ], 123 => [ 91, 107 ], 126 => [ 84, 92, 101, 109, 118 ] },
	{  0 => [ 68, 59, 51, 42, 34, 25, 17,  8 ],  8 => [ 68, 59, 51, 42, 34, 25, 17 ], 12 => [ 60, 44, 28 ], 17 => [ 68, 59, 51, 42, 34, 25 ], 25 => [ 68, 59, 51, 42, 34 ], 28 => [ 60, 44 ], 31 => [ 69, 61, 54, 46, 39 ], 34 => [ 68, 59, 51, 42 ], 39 => [ 69, 61, 54, 46 ], 42 => [ 68, 59, 51 ], 44 => [ 60 ], 46 => [ 69, 61, 54 ], 51 => [ 68, 59 ], 54 => [ 69, 61 ], 59 => [ 68 ], 61 => [ 69 ], 72 => [ 75, 74, 73 ], 73 => [ 75, 74 ], 74 => [ 75 ], 78 => [ 77 ], 79 => [ 77, 78 ], 91 => [ 84 ], 93 => [ 85 ], 99 => [ 84, 91 ], 102 => [ 85, 93 ], 106 => [ 84, 91, 99 ], 108 => [ 92 ], 110 => [ 85, 93, 102 ], 114 => [ 84, 91, 99, 106 ], 119 => [ 85, 93, 102, 110 ], 121 => [ 84, 91, 99, 106, 114 ], 124 => [ 92, 108 ], 127 => [ 85, 93, 102, 110, 119 ] },
	{  1 => [ 69, 60, 52, 43, 35, 26, 18,  9 ],  9 => [ 69, 60, 52, 43, 35, 26, 18 ], 13 => [ 61, 45, 29 ], 18 => [ 69, 60, 52, 43, 35, 26 ], 26 => [ 69, 60, 52, 43, 35 ], 29 => [ 61, 45 ], 35 => [ 69, 60, 52, 43 ], 43 => [ 69, 60, 52 ], 45 => [ 61 ], 47 => [ 70, 62, 55 ], 52 => [ 69, 60 ], 55 => [ 70, 62 ], 60 => [ 69 ], 62 => [ 70 ], 72 => [ 76, 75, 74, 73 ], 73 => [ 76, 75, 74 ], 74 => [ 76, 75 ], 75 => [ 76 ], 79 => [ 78 ], 92 => [ 85 ], 94 => [ 86 ], 100 => [ 85, 92 ], 103 => [ 86, 94 ], 107 => [ 85, 92, 100 ], 109 => [ 93 ], 111 => [ 86, 94, 103 ], 115 => [ 85, 92, 100, 107 ], 122 => [ 85, 92, 100, 107, 115 ], 125 => [ 93, 109 ] },
	{  2 => [ 70, 61, 53, 44, 36, 27, 19, 10 ], 10 => [ 70, 61, 53, 44, 36, 27, 19 ], 14 => [ 62, 46, 30 ], 19 => [ 70, 61, 53, 44, 36, 27 ], 27 => [ 70, 61, 53, 44, 36 ], 30 => [ 62, 46 ], 36 => [ 70, 61, 53, 44 ], 44 => [ 70, 61, 53 ], 46 => [ 62 ], 53 => [ 70, 61 ], 61 => [ 70 ], 63 => [ 71 ], 72 => [ 77, 76, 75, 74, 73 ], 73 => [ 77, 76, 75, 74 ], 74 => [ 77, 76, 75 ], 75 => [ 77, 76 ], 76 => [ 77 ], 93 => [ 86 ], 95 => [ 87 ], 101 => [ 86, 93 ], 108 => [ 86, 93, 101 ], 110 => [ 94 ], 116 => [ 86, 93, 101, 108 ], 123 => [ 86, 93, 101, 108, 116 ], 126 => [ 94, 110 ] },
	{  3 => [ 71, 62, 54, 45, 37, 28, 20, 11 ], 11 => [ 71, 62, 54, 45, 37, 28, 20 ], 15 => [ 63, 47, 31 ], 20 => [ 71, 62, 54, 45, 37, 28 ], 28 => [ 71, 62, 54, 45, 37 ], 31 => [ 63, 47 ], 37 => [ 71, 62, 54, 45 ], 45 => [ 71, 62, 54 ], 47 => [ 63 ], 54 => [ 71, 62 ], 62 => [ 71 ], 72 => [ 78, 77, 76, 75, 74, 73 ], 73 => [ 78, 77, 76, 75, 74 ], 74 => [ 78, 77, 76, 75 ], 75 => [ 78, 77, 76 ], 76 => [ 78, 77 ], 77 => [ 78 ], 94 => [ 87 ], 102 => [ 87, 94 ], 109 => [ 87, 94, 102 ], 111 => [ 95 ], 117 => [ 87, 94, 102, 109 ], 124 => [ 87, 94, 102, 109, 117 ], 127 => [ 95, 111 ] },
	{  0 => [ 64, 48, 32, 16 ],  5 => [ 72, 65, 57, 50, 42, 35, 27, 20, 12 ], 12 => [ 72, 65, 57, 50, 42, 35, 27, 20 ], 16 => [ 64, 48, 32 ], 20 => [ 72, 65, 57, 50, 42, 35, 27 ], 27 => [ 72, 65, 57, 50, 42, 35 ], 32 => [ 64, 48 ], 35 => [ 72, 65, 57, 50, 42 ], 42 => [ 72, 65, 57, 50 ], 48 => [ 64 ], 50 => [ 72, 65, 57 ], 57 => [ 72, 65 ], 65 => [ 72 ], 82 => [ 81 ], 83 => [ 81, 82 ], 84 => [ 81, 82, 83 ], 85 => [ 81, 82, 83, 84 ], 86 => [ 81, 82, 83, 84, 85 ], 87 => [ 81, 82, 83, 84, 85, 86 ], 97 => [ 88 ], 105 => [ 88, 97 ], 112 => [ 96 ], 114 => [ 88, 97, 105 ], 122 => [ 88, 97, 105, 114 ] },
	{  1 => [ 65, 49, 33, 17 ],  6 => [ 73, 66, 58, 51, 43, 36, 28, 21, 13 ], 13 => [ 73, 66, 58, 51, 43, 36, 28, 21 ], 17 => [ 65, 49, 33 ], 21 => [ 73, 66, 58, 51, 43, 36, 28 ], 28 => [ 73, 66, 58, 51, 43, 36 ], 33 => [ 65, 49 ], 36 => [ 73, 66, 58, 51, 43 ], 43 => [ 73, 66, 58, 51 ], 49 => [ 65 ], 51 => [ 73, 66, 58 ], 58 => [ 73, 66 ], 64 => [ 72 ], 66 => [ 73 ], 83 => [ 82 ], 84 => [ 82, 83 ], 85 => [ 82, 83, 84 ], 86 => [ 82, 83, 84, 85 ], 87 => [ 82, 83, 84, 85, 86 ], 96 => [ 88 ], 98 => [ 89 ], 106 => [ 89, 98 ], 113 => [ 97 ], 115 => [ 89, 98, 106 ], 123 => [ 89, 98, 106, 115 ] },
	{  2 => [ 66, 50, 34, 18 ],  7 => [ 74, 67, 59, 52, 44, 37, 29, 22, 14 ], 14 => [ 74, 67, 59, 52, 44, 37, 29, 22 ], 18 => [ 66, 50, 34 ], 22 => [ 74, 67, 59, 52, 44, 37, 29 ], 29 => [ 74, 67, 59, 52, 44, 37 ], 34 => [ 66, 50 ], 37 => [ 74, 67, 59, 52, 44 ], 44 => [ 74, 67, 59, 52 ], 48 => [ 73, 65, 56 ], 50 => [ 66 ], 52 => [ 74, 67, 59 ], 56 => [ 73, 65 ], 59 => [ 74, 67 ], 65 => [ 73 ], 67 => [ 74 ], 80 => [ 81 ], 84 => [ 83 ], 85 => [ 83, 84 ], 86 => [ 83, 84, 85 ], 87 => [ 83, 84, 85, 86 ], 97 => [ 89 ], 99 => [ 90 ], 104 => [ 89, 97 ], 107 => [ 90, 99 ], 112 => [ 89, 97, 104 ], 114 => [ 98 ], 116 => [ 90, 99, 107 ], 124 => [ 90, 99, 107, 116 ] },
	{  3 => [ 67, 51, 35, 19 ], 15 => [ 75, 68, 60, 53, 45, 38, 30, 23 ], 19 => [ 67, 51, 35 ], 23 => [ 75, 68, 60, 53, 45, 38, 30 ], 30 => [ 75, 68, 60, 53, 45, 38 ], 32 => [ 74, 66, 57, 49, 40 ], 35 => [ 67, 51 ], 38 => [ 75, 68, 60, 53, 45 ], 40 => [ 74, 66, 57, 49 ], 45 => [ 75, 68, 60, 53 ], 49 => [ 74, 66, 57 ], 51 => [ 67 ], 53 => [ 75, 68, 60 ], 57 => [ 74, 66 ], 60 => [ 75, 68 ], 66 => [ 74 ], 68 => [ 75 ], 80 => [ 82, 81 ], 81 => [ 82 ], 85 => [ 84 ], 86 => [ 84, 85 ], 87 => [ 84, 85, 86 ], 98 => [ 90 ], 100 => [ 91 ], 105 => [ 90, 98 ], 108 => [ 91, 100 ], 113 => [ 90, 98, 105 ], 115 => [ 99 ], 117 => [ 91, 100, 108 ], 120 => [ 90, 98, 105, 113 ], 125 => [ 91, 100, 108, 117 ] },
	{  4 => [ 68, 52, 36, 20 ], 16 => [ 75, 67, 58, 50, 41, 33, 24 ], 20 => [ 68, 52, 36 ], 24 => [ 75, 67, 58, 50, 41, 33 ], 31 => [ 76, 69, 61, 54, 46, 39 ], 33 => [ 75, 67, 58, 50, 41 ], 36 => [ 68, 52 ], 39 => [ 76, 69, 61, 54, 46 ], 41 => [ 75, 67, 58, 50 ], 46 => [ 76, 69, 61, 54 ], 50 => [ 75, 67, 58 ], 52 => [ 68 ], 54 => [ 76, 69, 61 ], 58 => [ 75, 67 ], 61 => [ 76, 69 ], 67 => [ 75 ], 69 => [ 76 ], 80 => [ 83, 82, 81 ], 81 => [ 83, 82 ], 82 => [ 83 ], 86 => [ 85 ], 87 => [ 85, 86 ], 99 => [ 91 ], 101 => [ 92 ], 106 => [ 91, 99 ], 109 => [ 92, 101 ], 114 => [ 91, 99, 106 ], 116 => [ 100 ], 118 => [ 92, 101, 109 ], 121 => [ 91, 99, 106, 114 ], 126 => [ 92, 101, 109, 118 ] },
	{  0 => [ 76, 68, 59, 51, 42, 34, 25, 17,  8 ],  5 => [ 69, 53, 37, 21 ],  8 => [ 76, 68, 59, 51, 42, 34, 25, 17 ], 17 => [ 76, 68, 59, 51, 42, 34, 25 ], 21 => [ 69, 53, 37 ], 25 => [ 76, 68, 59, 51, 42, 34 ], 34 => [ 76, 68, 59, 51, 42 ], 37 => [ 69, 53 ], 42 => [ 76, 68, 59, 51 ], 47 => [ 77, 70, 62, 55 ], 51 => [ 76, 68, 59 ], 53 => [ 69 ], 55 => [ 77, 70, 62 ], 59 => [ 76, 68 ], 62 => [ 77, 70 ], 68 => [ 76 ], 70 => [ 77 ], 80 => [ 84, 83, 82, 81 ], 81 => [ 84, 83, 82 ], 82 => [ 84, 83 ], 83 => [ 84 ], 87 => [ 86 ], 100 => [ 92 ], 102 => [ 93 ], 107 => [ 92, 100 ], 110 => [ 93, 102 ], 115 => [ 92, 100, 107 ], 117 => [ 101 ], 119 => [ 93, 102, 110 ], 122 => [ 92, 100, 107, 115 ], 127 => [ 93, 102, 110, 119 ] },
	{  1 => [ 77, 69, 60, 52, 43, 35, 26, 18,  9 ],  6 => [ 70, 54, 38, 22 ],  9 => [ 77, 69, 60, 52, 43, 35, 26, 18 ], 18 => [ 77, 69, 60, 52, 43, 35, 26 ], 22 => [ 70, 54, 38 ], 26 => [ 77, 69, 60, 52, 43, 35 ], 35 => [ 77, 69, 60, 52, 43 ], 38 => [ 70, 54 ], 43 => [ 77, 69, 60, 52 ], 52 => [ 77, 69, 60 ], 54 => [ 70 ], 60 => [ 77, 69 ], 63 => [ 78, 71 ], 69 => [ 77 ], 71 => [ 78 ], 80 => [ 85, 84, 83, 82, 81 ], 81 => [ 85, 84, 83, 82 ], 82 => [ 85, 84, 83 ], 83 => [ 85, 84 ], 84 => [ 85 ], 101 => [ 93 ], 103 => [ 94 ], 108 => [ 93, 101 ], 111 => [ 94, 103 ], 116 => [ 93, 101, 108 ], 118 => [ 102 ], 123 => [ 93, 101, 108, 116 ] },
	{  2 => [ 78, 70, 61, 53, 44, 36, 27, 19, 10 ],  7 => [ 71, 55, 39, 23 ], 10 => [ 78, 70, 61, 53, 44, 36, 27, 19 ], 19 => [ 78, 70, 61, 53, 44, 36, 27 ], 23 => [ 71, 55, 39 ], 27 => [ 78, 70, 61, 53, 44, 36 ], 36 => [ 78, 70, 61, 53, 44 ], 39 => [ 71, 55 ], 44 => [ 78, 70, 61, 53 ], 53 => [ 78, 70, 61 ], 55 => [ 71 ], 61 => [ 78, 70 ], 70 => [ 78 ], 80 => [ 86, 85, 84, 83, 82, 81 ], 81 => [ 86, 85, 84, 83, 82 ], 82 => [ 86, 85, 84, 83 ], 83 => [ 86, 85, 84 ], 84 => [ 86, 85 ], 85 => [ 86 ], 102 => [ 94 ], 109 => [ 94, 102 ], 117 => [ 94, 102, 109 ], 119 => [ 103 ], 124 => [ 94, 102, 109, 117 ] },
	{  6 => [ 81, 73, 66, 58, 51, 43, 36, 28, 21, 13 ],  8 => [ 72, 56, 40, 24 ], 13 => [ 81, 73, 66, 58, 51, 43, 36, 28, 21 ], 21 => [ 81, 73, 66, 58, 51, 43, 36, 28 ], 24 => [ 72, 56, 40 ], 28 => [ 81, 73, 66, 58, 51, 43, 36 ], 36 => [ 81, 73, 66, 58, 51, 43 ], 40 => [ 72, 56 ], 43 => [ 81, 73, 66, 58, 51 ], 51 => [ 81, 73, 66, 58 ], 56 => [ 72 ], 58 => [ 81, 73, 66 ], 66 => [ 81, 73 ], 73 => [ 81 ], 90 => [ 89 ], 91 => [ 89, 90 ], 92 => [ 89, 90, 91 ], 93 => [ 89, 90, 91, 92 ], 94 => [ 89, 90, 91, 92, 93 ], 95 => [ 89, 90, 91, 92, 93, 94 ], 105 => [ 97 ], 114 => [ 97, 105 ], 120 => [ 104 ], 122 => [ 97, 105, 114 ] },
	{  7 => [ 82, 74, 67, 59, 52, 44, 37, 29, 22, 14 ],  9 => [ 73, 57, 41, 25 ], 14 => [ 82, 74, 67, 59, 52, 44, 37, 29, 22 ], 22 => [ 82, 74, 67, 59, 52, 44, 37, 29 ], 25 => [ 73, 57, 41 ], 29 => [ 82, 74, 67, 59, 52, 44, 37 ], 37 => [ 82, 74, 67, 59, 52, 44 ], 41 => [ 73, 57 ], 44 => [ 82, 74, 67, 59, 52 ], 52 => [ 82, 74, 67, 59 ], 57 => [ 73 ], 59 => [ 82, 74, 67 ], 64 => [ 81, 72 ], 67 => [ 82, 74 ], 72 => [ 81 ], 74 => [ 82 ], 91 => [ 90 ], 92 => [ 90, 91 ], 93 => [ 90, 91, 92 ], 94 => [ 90, 91, 92, 93 ], 95 => [ 90, 91, 92, 93, 94 ], 104 => [ 97 ], 106 => [ 98 ], 112 => [ 97, 104 ], 115 => [ 98, 106 ], 121 => [ 105 ], 123 => [ 98, 106, 115 ] },
	{ 10 => [ 74, 58, 42, 26 ], 15 => [ 83, 75, 68, 60, 53, 45, 38, 30, 23 ], 23 => [ 83, 75, 68, 60, 53, 45, 38, 30 ], 26 => [ 74, 58, 42 ], 30 => [ 83, 75, 68, 60, 53, 45, 38 ], 38 => [ 83, 75, 68, 60, 53, 45 ], 42 => [ 74, 58 ], 45 => [ 83, 75, 68, 60, 53 ], 48 => [ 82, 73, 65, 56 ], 53 => [ 83, 75, 68, 60 ], 56 => [ 82, 73, 65 ], 58 => [ 74 ], 60 => [ 83, 75, 68 ], 65 => [ 82, 73 ], 68 => [ 83, 75 ], 73 => [ 82 ], 75 => [ 83 ], 88 => [ 89 ], 92 => [ 91 ], 93 => [ 91, 92 ], 94 => [ 91, 92, 93 ], 95 => [ 91, 92, 93, 94 ], 105 => [ 98 ], 107 => [ 99 ], 113 => [ 98, 105 ], 116 => [ 99, 107 ], 120 => [ 98, 105, 113 ], 122 => [ 106 ], 124 => [ 99, 107, 116 ] },
	{ 11 => [ 75, 59, 43, 27 ], 27 => [ 75, 59, 43 ], 31 => [ 84, 76, 69, 61, 54, 46, 39 ], 32 => [ 83, 74, 66, 57, 49, 40 ], 39 => [ 84, 76, 69, 61, 54, 46 ], 40 => [ 83, 74, 66, 57, 49 ], 43 => [ 75, 59 ], 46 => [ 84, 76, 69, 61, 54 ], 49 => [ 83, 74, 66, 57 ], 54 => [ 84, 76, 69, 61 ], 57 => [ 83, 74, 66 ], 59 => [ 75 ], 61 => [ 84, 76, 69 ], 66 => [ 83, 74 ], 69 => [ 84, 76 ], 74 => [ 83 ], 76 => [ 84 ], 88 => [ 90, 89 ], 89 => [ 90 ], 93 => [ 92 ], 94 => [ 92, 93 ], 95 => [ 92, 93, 94 ], 106 => [ 99 ], 108 => [ 100 ], 114 => [ 99, 106 ], 117 => [ 100, 108 ], 121 => [ 99, 106, 114 ], 123 => [ 107 ], 125 => [ 100, 108, 117 ] },
	{ 12 => [ 76, 60, 44, 28 ], 16 => [ 84, 75, 67, 58, 50, 41, 33, 24 ], 24 => [ 84, 75, 67, 58, 50, 41, 33 ], 28 => [ 76, 60, 44 ], 33 => [ 84, 75, 67, 58, 50, 41 ], 41 => [ 84, 75, 67, 58, 50 ], 44 => [ 76, 60 ], 47 => [ 85, 77, 70, 62, 55 ], 50 => [ 84, 75, 67, 58 ], 55 => [ 85, 77, 70, 62 ], 58 => [ 84, 75, 67 ], 60 => [ 76 ], 62 => [ 85, 77, 70 ], 67 => [ 84, 75 ], 70 => [ 85, 77 ], 75 => [ 84 ], 77 => [ 85 ], 88 => [ 91, 90, 89 ], 89 => [ 91, 90 ], 90 => [ 91 ], 94 => [ 93 ], 95 => [ 93, 94 ], 107 => [ 100 ], 109 => [ 101 ], 115 => [ 100, 107 ], 118 => [ 101, 109 ], 122 => [ 100, 107, 115 ], 124 => [ 108 ], 126 => [ 101, 109, 118 ] },
	{  0 => [ 85, 76, 68, 59, 51, 42, 34, 25, 17,  8 ],  8 => [ 85, 76, 68, 59, 51, 42, 34, 25, 17 ], 13 => [ 77, 61, 45, 29 ], 17 => [ 85, 76, 68, 59, 51, 42, 34, 25 ], 25 => [ 85, 76, 68, 59, 51, 42, 34 ], 29 => [ 77, 61, 45 ], 34 => [ 85, 76, 68, 59, 51, 42 ], 42 => [ 85, 76, 68, 59, 51 ], 45 => [ 77, 61 ], 51 => [ 85, 76, 68, 59 ], 59 => [ 85, 76, 68 ], 61 => [ 77 ], 63 => [ 86, 78, 71 ], 68 => [ 85, 76 ], 71 => [ 86, 78 ], 76 => [ 85 ], 78 => [ 86 ], 88 => [ 92, 91, 90, 89 ], 89 => [ 92, 91, 90 ], 90 => [ 92, 91 ], 91 => [ 92 ], 95 => [ 94 ], 108 => [ 101 ], 110 => [ 102 ], 116 => [ 101, 108 ], 119 => [ 102, 110 ], 123 => [ 101, 108, 116 ], 125 => [ 109 ], 127 => [ 102, 110, 119 ] },
	{  1 => [ 86, 77, 69, 60, 52, 43, 35, 26, 18,  9 ],  9 => [ 86, 77, 69, 60, 52, 43, 35, 26, 18 ], 14 => [ 78, 62, 46, 30 ], 18 => [ 86, 77, 69, 60, 52, 43, 35, 26 ], 26 => [ 86, 77, 69, 60, 52, 43, 35 ], 30 => [ 78, 62, 46 ], 35 => [ 86, 77, 69, 60, 52, 43 ], 43 => [ 86, 77, 69, 60, 52 ], 46 => [ 78, 62 ], 52 => [ 86, 77, 69, 60 ], 60 => [ 86, 77, 69 ], 62 => [ 78 ], 69 => [ 86, 77 ], 77 => [ 86 ], 79 => [ 87 ], 88 => [ 93, 92, 91, 90, 89 ], 89 => [ 93, 92, 91, 90 ], 90 => [ 93, 92, 91 ], 91 => [ 93, 92 ], 92 => [ 93 ], 109 => [ 102 ], 111 => [ 103 ], 117 => [ 102, 109 ], 124 => [ 102, 109, 117 ], 126 => [ 110 ] },
	{  2 => [ 87, 78, 70, 61, 53, 44, 36, 27, 19, 10 ], 10 => [ 87, 78, 70, 61, 53, 44, 36, 27, 19 ], 15 => [ 79, 63, 47, 31 ], 19 => [ 87, 78, 70, 61, 53, 44, 36, 27 ], 27 => [ 87, 78, 70, 61, 53, 44, 36 ], 31 => [ 79, 63, 47 ], 36 => [ 87, 78, 70, 61, 53, 44 ], 44 => [ 87, 78, 70, 61, 53 ], 47 => [ 79, 63 ], 53 => [ 87, 78, 70, 61 ], 61 => [ 87, 78, 70 ], 63 => [ 79 ], 70 => [ 87, 78 ], 78 => [ 87 ], 88 => [ 94, 93, 92, 91, 90, 89 ], 89 => [ 94, 93, 92, 91, 90 ], 90 => [ 94, 93, 92, 91 ], 91 => [ 94, 93, 92 ], 92 => [ 94, 93 ], 93 => [ 94 ], 110 => [ 103 ], 118 => [ 103, 110 ], 125 => [ 103, 110, 118 ], 127 => [ 111 ] },
	{  0 => [ 80, 64, 48, 32, 16 ],  6 => [ 88, 81, 73, 66, 58, 51, 43, 36, 28, 21, 13 ], 13 => [ 88, 81, 73, 66, 58, 51, 43, 36, 28, 21 ], 16 => [ 80, 64, 48, 32 ], 21 => [ 88, 81, 73, 66, 58, 51, 43, 36, 28 ], 28 => [ 88, 81, 73, 66, 58, 51, 43, 36 ], 32 => [ 80, 64, 48 ], 36 => [ 88, 81, 73, 66, 58, 51, 43 ], 43 => [ 88, 81, 73, 66, 58, 51 ], 48 => [ 80, 64 ], 51 => [ 88, 81, 73, 66, 58 ], 58 => [ 88, 81, 73, 66 ], 64 => [ 80 ], 66 => [ 88, 81, 73 ], 73 => [ 88, 81 ], 81 => [ 88 ], 98 => [ 97 ], 99 => [ 97, 98 ], 100 => [ 97, 98, 99 ], 101 => [ 97, 98, 99, 100 ], 102 => [ 97, 98, 99, 100, 101 ], 103 => [ 97, 98, 99, 100, 101, 102 ], 113 => [ 104 ], 121 => [ 104, 113 ] },
	{  1 => [ 81, 65, 49, 33, 17 ],  7 => [ 89, 82, 74, 67, 59, 52, 44, 37, 29, 22, 14 ], 14 => [ 89, 82, 74, 67, 59, 52, 44, 37, 29, 22 ], 17 => [ 81, 65, 49, 33 ], 22 => [ 89, 82, 74, 67, 59, 52, 44, 37, 29 ], 29 => [ 89, 82, 74, 67, 59, 52, 44, 37 ], 33 => [ 81, 65, 49 ], 37 => [ 89, 82, 74, 67, 59, 52, 44 ], 44 => [ 89, 82, 74, 67, 59, 52 ], 49 => [ 81, 65 ], 52 => [ 89, 82, 74, 67, 59 ], 59 => [ 89, 82, 74, 67 ], 65 => [ 81 ], 67 => [ 89, 82, 74 ], 74 => [ 89, 82 ], 80 => [ 88 ], 82 => [ 89 ], 99 => [ 98 ], 100 => [ 98, 99 ], 101 => [ 98, 99, 100 ], 102 => [ 98, 99, 100, 101 ], 103 => [ 98, 99, 100, 101, 102 ], 112 => [ 104 ], 114 => [ 105 ], 122 => [ 105, 114 ] },
	{  2 => [ 82, 66, 50, 34, 18 ], 15 => [ 90, 83, 75, 68, 60, 53, 45, 38, 30, 23 ], 18 => [ 82, 66, 50, 34 ], 23 => [ 90, 83, 75, 68, 60, 53, 45, 38, 30 ], 30 => [ 90, 83, 75, 68, 60, 53, 45, 38 ], 34 => [ 82, 66, 50 ], 38 => [ 90, 83, 75, 68, 60, 53, 45 ], 45 => [ 90, 83, 75, 68, 60, 53 ], 50 => [ 82, 66 ], 53 => [ 90, 83, 75, 68, 60 ], 60 => [ 90, 83, 75, 68 ], 64 => [ 89, 81, 72 ], 66 => [ 82 ], 68 => [ 90, 83, 75 ], 72 => [ 89, 81 ], 75 => [ 90, 83 ], 81 => [ 89 ], 83 => [ 90 ], 96 => [ 97 ], 100 => [ 99 ], 101 => [ 99, 100 ], 102 => [ 99, 100, 101 ], 103 => [ 99, 100, 101, 102 ], 113 => [ 105 ], 115 => [ 106 ], 120 => [ 105, 113 ], 123 => [ 106, 115 ] },
	{  3 => [ 83, 67, 51, 35, 19 ], 19 => [ 83, 67, 51, 35 ], 31 => [ 91, 84, 76, 69, 61, 54, 46, 39 ], 35 => [ 83, 67, 51 ], 39 => [ 91, 84, 76, 69, 61, 54, 46 ], 46 => [ 91, 84, 76, 69, 61, 54 ], 48 => [ 90, 82, 73, 65, 56 ], 51 => [ 83, 67 ], 54 => [ 91, 84, 76, 69, 61 ], 56 => [ 90, 82, 73, 65 ], 61 => [ 91, 84, 76, 69 ], 65 => [ 90, 82, 73 ], 67 => [ 83 ], 69 => [ 91, 84, 76 ], 73 => [ 90, 82 ], 76 => [ 91, 84 ], 82 => [ 90 ], 84 => [ 91 ], 96 => [ 98, 97 ], 97 => [ 98 ], 101 => [ 100 ], 102 => [ 100, 101 ], 103 => [ 100, 101, 102 ], 114 => [ 106 ], 116 => [ 107 ], 121 => [ 106, 114 ], 124 => [ 107, 116 ] },
	{  4 => [ 84, 68, 52, 36, 20 ], 20 => [ 84, 68, 52, 36 ], 32 => [ 91, 83, 74, 66, 57, 49, 40 ], 36 => [ 84, 68, 52 ], 40 => [ 91, 83, 74, 66, 57, 49 ], 47 => [ 92, 85, 77, 70, 62, 55 ], 49 => [ 91, 83, 74, 66, 57 ], 52 => [ 84, 68 ], 55 => [ 92, 85, 77, 70, 62 ], 57 => [ 91, 83, 74, 66 ], 62 => [ 92, 85, 77, 70 ], 66 => [ 91, 83, 74 ], 68 => [ 84 ], 70 => [ 92, 85, 77 ], 74 => [ 91, 83 ], 77 => [ 92, 85 ], 83 => [ 91 ], 85 => [ 92 ], 96 => [ 99, 98, 97 ], 97 => [ 99, 98 ], 98 => [ 99 ], 102 => [ 101 ], 103 => [ 101, 102 ], 115 => [ 107 ], 117 => [ 108 ], 122 => [ 107, 115 ], 125 => [ 108, 117 ] },
	{  5 => [ 85, 69, 53, 37, 21 ], 16 => [ 92, 84, 75, 67, 58, 50, 41, 33, 24 ], 21 => [ 85, 69, 53, 37 ], 24 => [ 92, 84, 75, 67, 58, 50, 41, 33 ], 33 => [ 92, 84, 75, 67, 58, 50, 41 ], 37 => [ 85, 69, 53 ], 41 => [ 92, 84, 75, 67, 58, 50 ], 50 => [ 92, 84, 75, 67, 58 ], 53 => [ 85, 69 ], 58 => [ 92, 84, 75, 67 ], 63 => [ 93, 86, 78, 71 ], 67 => [ 92, 84, 75 ], 69 => [ 85 ], 71 => [ 93, 86, 78 ], 75 => [ 92, 84 ], 78 => [ 93, 86 ], 84 => [ 92 ], 86 => [ 93 ], 96 => [ 100, 99, 98, 97 ], 97 => [ 100, 99, 98 ], 98 => [ 100, 99 ], 99 => [ 100 ], 103 => [ 102 ], 116 => [ 108 ], 118 => [ 109 ], 123 => [ 108, 116 ], 126 => [ 109, 118 ] },
	{  0 => [ 93, 85, 76, 68, 59, 51, 42, 34, 25, 17,  8 ],  6 => [ 86, 70, 54, 38, 22 ],  8 => [ 93, 85, 76, 68, 59, 51, 42, 34, 25, 17 ], 17 => [ 93, 85, 76, 68, 59, 51, 42, 34, 25 ], 22 => [ 86, 70, 54, 38 ], 25 => [ 93, 85, 76, 68, 59, 51, 42, 34 ], 34 => [ 93, 85, 76, 68, 59, 51, 42 ], 38 => [ 86, 70, 54 ], 42 => [ 93, 85, 76, 68, 59, 51 ], 51 => [ 93, 85, 76, 68, 59 ], 54 => [ 86, 70 ], 59 => [ 93, 85, 76, 68 ], 68 => [ 93, 85, 76 ], 70 => [ 86 ], 76 => [ 93, 85 ], 79 => [ 94, 87 ], 85 => [ 93 ], 87 => [ 94 ], 96 => [ 101, 100, 99, 98, 97 ], 97 => [ 101, 100, 99, 98 ], 98 => [ 101, 100, 99 ], 99 => [ 101, 100 ], 100 => [ 101 ], 117 => [ 109 ], 119 => [ 110 ], 124 => [ 109, 117 ], 127 => [ 110, 119 ] },
	{  1 => [ 94, 86, 77, 69, 60, 52, 43, 35, 26, 18,  9 ],  7 => [ 87, 71, 55, 39, 23 ],  9 => [ 94, 86, 77, 69, 60, 52, 43, 35, 26, 18 ], 18 => [ 94, 86, 77, 69, 60, 52, 43, 35, 26 ], 23 => [ 87, 71, 55, 39 ], 26 => [ 94, 86, 77, 69, 60, 52, 43, 35 ], 35 => [ 94, 86, 77, 69, 60, 52, 43 ], 39 => [ 87, 71, 55 ], 43 => [ 94, 86, 77, 69, 60, 52 ], 52 => [ 94, 86, 77, 69, 60 ], 55 => [ 87, 71 ], 60 => [ 94, 86, 77, 69 ], 69 => [ 94, 86, 77 ], 71 => [ 87 ], 77 => [ 94, 86 ], 86 => [ 94 ], 96 => [ 102, 101, 100, 99, 98, 97 ], 97 => [ 102, 101, 100, 99, 98 ], 98 => [ 102, 101, 100, 99 ], 99 => [ 102, 101, 100 ], 100 => [ 102, 101 ], 101 => [ 102 ], 118 => [ 110 ], 125 => [ 110, 118 ] },
	{  7 => [ 97, 89, 82, 74, 67, 59, 52, 44, 37, 29, 22, 14 ],  8 => [ 88, 72, 56, 40, 24 ], 14 => [ 97, 89, 82, 74, 67, 59, 52, 44, 37, 29, 22 ], 22 => [ 97, 89, 82, 74, 67, 59, 52, 44, 37, 29 ], 24 => [ 88, 72, 56, 40 ], 29 => [ 97, 89, 82, 74, 67, 59, 52, 44, 37 ], 37 => [ 97, 89, 82, 74, 67, 59, 52, 44 ], 40 => [ 88, 72, 56 ], 44 => [ 97, 89, 82, 74, 67, 59, 52 ], 52 => [ 97, 89, 82, 74, 67, 59 ], 56 => [ 88, 72 ], 59 => [ 97, 89, 82, 74, 67 ], 67 => [ 97, 89, 82, 74 ], 72 => [ 88 ], 74 => [ 97, 89, 82 ], 82 => [ 97, 89 ], 89 => [ 97 ], 106 => [ 105 ], 107 => [ 105, 106 ], 108 => [ 105, 106, 107 ], 109 => [ 105, 106, 107, 108 ], 110 => [ 105, 106, 107, 108, 109 ], 111 => [ 105, 106, 107, 108, 109, 110 ], 121 => [ 113 ] },
	{  9 => [ 89, 73, 57, 41, 25 ], 15 => [ 98, 90, 83, 75, 68, 60, 53, 45, 38, 30, 23 ], 23 => [ 98, 90, 83, 75, 68, 60, 53, 45, 38, 30 ], 25 => [ 89, 73, 57, 41 ], 30 => [ 98, 90, 83, 75, 68, 60, 53, 45, 38 ], 38 => [ 98, 90, 83, 75, 68, 60, 53, 45 ], 41 => [ 89, 73, 57 ], 45 => [ 98, 90, 83, 75, 68, 60, 53 ], 53 => [ 98, 90, 83, 75, 68, 60 ], 57 => [ 89, 73 ], 60 => [ 98, 90, 83, 75, 68 ], 68 => [ 98, 90, 83, 75 ], 73 => [ 89 ], 75 => [ 98, 90, 83 ], 80 => [ 97, 88 ], 83 => [ 98, 90 ], 88 => [ 97 ], 90 => [ 98 ], 107 => [ 106 ], 108 => [ 106, 107 ], 109 => [ 106, 107, 108 ], 110 => [ 106, 107, 108, 109 ], 111 => [ 106, 107, 108, 109, 110 ], 120 => [ 113 ], 122 => [ 114 ] },
	{ 10 => [ 90, 74, 58, 42, 26 ], 26 => [ 90, 74, 58, 42 ], 31 => [ 99, 91, 84, 76, 69, 61, 54, 46, 39 ], 39 => [ 99, 91, 84, 76, 69, 61, 54, 46 ], 42 => [ 90, 74, 58 ], 46 => [ 99, 91, 84, 76, 69, 61, 54 ], 54 => [ 99, 91, 84, 76, 69, 61 ], 58 => [ 90, 74 ], 61 => [ 99, 91, 84, 76, 69 ], 64 => [ 98, 89, 81, 72 ], 69 => [ 99, 91, 84, 76 ], 72 => [ 98, 89, 81 ], 74 => [ 90 ], 76 => [ 99, 91, 84 ], 81 => [ 98, 89 ], 84 => [ 99, 91 ], 89 => [ 98 ], 91 => [ 99 ], 104 => [ 105 ], 108 => [ 107 ], 109 => [ 107, 108 ], 110 => [ 107, 108, 109 ], 111 => [ 107, 108, 109, 110 ], 121 => [ 114 ], 123 => [ 115 ] },
	{ 11 => [ 91, 75, 59, 43, 27 ], 27 => [ 91, 75, 59, 43 ], 43 => [ 91, 75, 59 ], 47 => [ 100, 92, 85, 77, 70, 62, 55 ], 48 => [ 99, 90, 82, 73, 65, 56 ], 55 => [ 100, 92, 85, 77, 70, 62 ], 56 => [ 99, 90, 82, 73, 65 ], 59 => [ 91, 75 ], 62 => [ 100, 92, 85, 77, 70 ], 65 => [ 99, 90, 82, 73 ], 70 => [ 100, 92, 85, 77 ], 73 => [ 99, 90, 82 ], 75 => [ 91 ], 77 => [ 100, 92, 85 ], 82 => [ 99, 90 ], 85 => [ 100, 92 ], 90 => [ 99 ], 92 => [ 100 ], 104 => [ 106, 105 ], 105 => [ 106 ], 109 => [ 108 ], 110 => [ 108, 109 ], 111 => [ 108, 109, 110 ], 122 => [ 115 ], 124 => [ 116 ] },
	{ 12 => [ 92, 76, 60, 44, 28 ], 28 => [ 92, 76, 60, 44 ], 32 => [ 100, 91, 83, 74, 66, 57, 49, 40 ], 40 => [ 100, 91, 83, 74, 66, 57, 49 ], 44 => [ 92, 76, 60 ], 49 => [ 100, 91, 83, 74, 66, 57 ], 57 => [ 100, 91, 83, 74, 66 ], 60 => [ 92, 76 ], 63 => [ 101, 93, 86, 78, 71 ], 66 => [ 100, 91, 83, 74 ], 71 => [ 101, 93, 86, 78 ], 74 => [ 100, 91, 83 ], 76 => [ 92 ], 78 => [ 101, 93, 86 ], 83 => [ 100, 91 ], 86 => [ 101, 93 ], 91 => [ 100 ], 93 => [ 101 ], 104 => [ 107, 106, 105 ], 105 => [ 107, 106 ], 106 => [ 107 ], 110 => [ 109 ], 111 => [ 109, 110 ], 123 => [ 116 ], 125 => [ 117 ] },
	{ 13 => [ 93, 77, 61, 45, 29 ], 16 => [ 101, 92, 84, 75, 67, 58, 50, 41, 33, 24 ], 24 => [ 101, 92, 84, 75, 67, 58, 50, 41, 33 ], 29 => [ 93, 77, 61, 45 ], 33 => [ 101, 92, 84, 75, 67, 58, 50, 41 ], 41 => [ 101, 92, 84, 75, 67, 58, 50 ], 45 => [ 93, 77, 61 ], 50 => [ 101, 92, 84, 75, 67, 58 ], 58 => [ 101, 92, 84, 75, 67 ], 61 => [ 93, 77 ], 67 => [ 101, 92, 84, 75 ], 75 => [ 101, 92, 84 ], 77 => [ 93 ], 79 => [ 102, 94, 87 ], 84 => [ 101, 92 ], 87 => [ 102, 94 ], 92 => [ 101 ], 94 => [ 102 ], 104 => [ 108, 107, 106, 105 ], 105 => [ 108, 107, 106 ], 106 => [ 108, 107 ], 107 => [ 108 ], 111 => [ 110 ], 124 => [ 117 ], 126 => [ 118 ] },
	{  0 => [ 102, 93, 85, 76, 68, 59, 51, 42, 34, 25, 17,  8 ],  8 => [ 102, 93, 85, 76, 68, 59, 51, 42, 34, 25, 17 ], 14 => [ 94, 78, 62, 46, 30 ], 17 => [ 102, 93, 85, 76, 68, 59, 51, 42, 34, 25 ], 25 => [ 102, 93, 85, 76, 68, 59, 51, 42, 34 ], 30 => [ 94, 78, 62, 46 ], 34 => [ 102, 93, 85, 76, 68, 59, 51, 42 ], 42 => [ 102, 93, 85, 76, 68, 59, 51 ], 46 => [ 94, 78, 62 ], 51 => [ 102, 93, 85, 76, 68, 59 ], 59 => [ 102, 93, 85, 76, 68 ], 62 => [ 94, 78 ], 68 => [ 102, 93, 85, 76 ], 76 => [ 102, 93, 85 ], 78 => [ 94 ], 85 => [ 102, 93 ], 93 => [ 102 ], 95 => [ 103 ], 104 => [ 109, 108, 107, 106, 105 ], 105 => [ 109, 108, 107, 106 ], 106 => [ 109, 108, 107 ], 107 => [ 109, 108 ], 108 => [ 109 ], 125 => [ 118 ], 127 => [ 119 ] },
	{  1 => [ 103, 94, 86, 77, 69, 60, 52, 43, 35, 26, 18,  9 ],  9 => [ 103, 94, 86, 77, 69, 60, 52, 43, 35, 26, 18 ], 15 => [ 95, 79, 63, 47, 31 ], 18 => [ 103, 94, 86, 77, 69, 60, 52, 43, 35, 26 ], 26 => [ 103, 94, 86, 77, 69, 60, 52, 43, 35 ], 31 => [ 95, 79, 63, 47 ], 35 => [ 103, 94, 86, 77, 69, 60, 52, 43 ], 43 => [ 103, 94, 86, 77, 69, 60, 52 ], 47 => [ 95, 79, 63 ], 52 => [ 103, 94, 86, 77, 69, 60 ], 60 => [ 103, 94, 86, 77, 69 ], 63 => [ 95, 79 ], 69 => [ 103, 94, 86, 77 ], 77 => [ 103, 94, 86 ], 79 => [ 95 ], 86 => [ 103, 94 ], 94 => [ 103 ], 104 => [ 110, 109, 108, 107, 106, 105 ], 105 => [ 110, 109, 108, 107, 106 ], 106 => [ 110, 109, 108, 107 ], 107 => [ 110, 109, 108 ], 108 => [ 110, 109 ], 109 => [ 110 ], 126 => [ 119 ] },
	{  0 => [ 96, 80, 64, 48, 32, 16 ],  7 => [ 104, 97, 89, 82, 74, 67, 59, 52, 44, 37, 29, 22, 14 ], 14 => [ 104, 97, 89, 82, 74, 67, 59, 52, 44, 37, 29, 22 ], 16 => [ 96, 80, 64, 48, 32 ], 22 => [ 104, 97, 89, 82, 74, 67, 59, 52, 44, 37, 29 ], 29 => [ 104, 97, 89, 82, 74, 67, 59, 52, 44, 37 ], 32 => [ 96, 80, 64, 48 ], 37 => [ 104, 97, 89, 82, 74, 67, 59, 52, 44 ], 44 => [ 104, 97, 89, 82, 74, 67, 59, 52 ], 48 => [ 96, 80, 64 ], 52 => [ 104, 97, 89, 82, 74, 67, 59 ], 59 => [ 104, 97, 89, 82, 74, 67 ], 64 => [ 96, 80 ], 67 => [ 104, 97, 89, 82, 74 ], 74 => [ 104, 97, 89, 82 ], 80 => [ 96 ], 82 => [ 104, 97, 89 ], 89 => [ 104, 97 ], 97 => [ 104 ], 114 => [ 113 ], 115 => [ 113, 114 ], 116 => [ 113, 114, 115 ], 117 => [ 113, 114, 115, 116 ], 118 => [ 113, 114, 115, 116, 117 ], 119 => [ 113, 114, 115, 116, 117, 118 ] },
	{  1 => [ 97, 81, 65, 49, 33, 17 ], 15 => [ 105, 98, 90, 83, 75, 68, 60, 53, 45, 38, 30, 23 ], 17 => [ 97, 81, 65, 49, 33 ], 23 => [ 105, 98, 90, 83, 75, 68, 60, 53, 45, 38, 30 ], 30 => [ 105, 98, 90, 83, 75, 68, 60, 53, 45, 38 ], 33 => [ 97, 81, 65, 49 ], 38 => [ 105, 98, 90, 83, 75, 68, 60, 53, 45 ], 45 => [ 105, 98, 90, 83, 75, 68, 60, 53 ], 49 => [ 97, 81, 65 ], 53 => [ 105, 98, 90, 83, 75, 68, 60 ], 60 => [ 105, 98, 90, 83, 75, 68 ], 65 => [ 97, 81 ], 68 => [ 105, 98, 90, 83, 75 ], 75 => [ 105, 98, 90, 83 ], 81 => [ 97 ], 83 => [ 105, 98, 90 ], 90 => [ 105, 98 ], 96 => [ 104 ], 98 => [ 105 ], 115 => [ 114 ], 116 => [ 114, 115 ], 117 => [ 114, 115, 116 ], 118 => [ 114, 115, 116, 117 ], 119 => [ 114, 115, 116, 117, 118 ] },
	{  2 => [ 98, 82, 66, 50, 34, 18 ], 18 => [ 98, 82, 66, 50, 34 ], 31 => [ 106, 99, 91, 84, 76, 69, 61, 54, 46, 39 ], 34 => [ 98, 82, 66, 50 ], 39 => [ 106, 99, 91, 84, 76, 69, 61, 54, 46 ], 46 => [ 106, 99, 91, 84, 76, 69, 61, 54 ], 50 => [ 98, 82, 66 ], 54 => [ 106, 99, 91, 84, 76, 69, 61 ], 61 => [ 106, 99, 91, 84, 76, 69 ], 66 => [ 98, 82 ], 69 => [ 106, 99, 91, 84, 76 ], 76 => [ 106, 99, 91, 84 ], 80 => [ 105, 97, 88 ], 82 => [ 98 ], 84 => [ 106, 99, 91 ], 88 => [ 105, 97 ], 91 => [ 106, 99 ], 97 => [ 105 ], 99 => [ 106 ], 112 => [ 113 ], 116 => [ 115 ], 117 => [ 115, 116 ], 118 => [ 115, 116, 117 ], 119 => [ 115, 116, 117, 118 ] },
	{  3 => [ 99, 83, 67, 51, 35, 19 ], 19 => [ 99, 83, 67, 51, 35 ], 35 => [ 99, 83, 67, 51 ], 47 => [ 107, 100, 92, 85, 77, 70, 62, 55 ], 51 => [ 99, 83, 67 ], 55 => [ 107, 100, 92, 85, 77, 70, 62 ], 62 => [ 107, 100, 92, 85, 77, 70 ], 64 => [ 106, 98, 89, 81, 72 ], 67 => [ 99, 83 ], 70 => [ 107, 100, 92, 85, 77 ], 72 => [ 106, 98, 89, 81 ], 77 => [ 107, 100, 92, 85 ], 81 => [ 106, 98, 89 ], 83 => [ 99 ], 85 => [ 107, 100, 92 ], 89 => [ 106, 98 ], 92 => [ 107, 100 ], 98 => [ 106 ], 100 => [ 107 ], 112 => [ 114, 113 ], 113 => [ 114 ], 117 => [ 116 ], 118 => [ 116, 117 ], 119 => [ 116, 117, 118 ] },
	{  4 => [ 100, 84, 68, 52, 36, 20 ], 20 => [ 100, 84, 68, 52, 36 ], 36 => [ 100, 84, 68, 52 ], 48 => [ 107, 99, 90, 82, 73, 65, 56 ], 52 => [ 100, 84, 68 ], 56 => [ 107, 99, 90, 82, 73, 65 ], 63 => [ 108, 101, 93, 86, 78, 71 ], 65 => [ 107, 99, 90, 82, 73 ], 68 => [ 100, 84 ], 71 => [ 108, 101, 93, 86, 78 ], 73 => [ 107, 99, 90, 82 ], 78 => [ 108, 101, 93, 86 ], 82 => [ 107, 99, 90 ], 84 => [ 100 ], 86 => [ 108, 101, 93 ], 90 => [ 107, 99 ], 93 => [ 108, 101 ], 99 => [ 107 ], 101 => [ 108 ], 112 => [ 115, 114, 113 ], 113 => [ 115, 114 ], 114 => [ 115 ], 118 => [ 117 ], 119 => [ 117, 118 ] },
	{  5 => [ 101, 85, 69, 53, 37, 21 ], 21 => [ 101, 85, 69, 53, 37 ], 32 => [ 108, 100, 91, 83, 74, 66, 57, 49, 40 ], 37 => [ 101, 85, 69, 53 ], 40 => [ 108, 100, 91, 83, 74, 66, 57, 49 ], 49 => [ 108, 100, 91, 83, 74, 66, 57 ], 53 => [ 101, 85, 69 ], 57 => [ 108, 100, 91, 83, 74, 66 ], 66 => [ 108, 100, 91, 83, 74 ], 69 => [ 101, 85 ], 74 => [ 108, 100, 91, 83 ], 79 => [ 109, 102, 94, 87 ], 83 => [ 108, 100, 91 ], 85 => [ 101 ], 87 => [ 109, 102, 94 ], 91 => [ 108, 100 ], 94 => [ 109, 102 ], 100 => [ 108 ], 102 => [ 109 ], 112 => [ 116, 115, 114, 113 ], 113 => [ 116, 115, 114 ], 114 => [ 116, 115 ], 115 => [ 116 ], 119 => [ 118 ] },
	{  6 => [ 102, 86, 70, 54, 38, 22 ], 16 => [ 109, 101, 92, 84, 75, 67, 58, 50, 41, 33, 24 ], 22 => [ 102, 86, 70, 54, 38 ], 24 => [ 109, 101, 92, 84, 75, 67, 58, 50, 41, 33 ], 33 => [ 109, 101, 92, 84, 75, 67, 58, 50, 41 ], 38 => [ 102, 86, 70, 54 ], 41 => [ 109, 101, 92, 84, 75, 67, 58, 50 ], 50 => [ 109, 101, 92, 84, 75, 67, 58 ], 54 => [ 102, 86, 70 ], 58 => [ 109, 101, 92, 84, 75, 67 ], 67 => [ 109, 101, 92, 84, 75 ], 70 => [ 102, 86 ], 75 => [ 109, 101, 92, 84 ], 84 => [ 109, 101, 92 ], 86 => [ 102 ], 92 => [ 109, 101 ], 95 => [ 110, 103 ], 101 => [ 109 ], 103 => [ 110 ], 112 => [ 117, 116, 115, 114, 113 ], 113 => [ 117, 116, 115, 114 ], 114 => [ 117, 116, 115 ], 115 => [ 117, 116 ], 116 => [ 117 ] },
	{  0 => [ 110, 102, 93, 85, 76, 68, 59, 51, 42, 34, 25, 17,  8 ],  7 => [ 103, 87, 71, 55, 39, 23 ],  8 => [ 110, 102, 93, 85, 76, 68, 59, 51, 42, 34, 25, 17 ], 17 => [ 110, 102, 93, 85, 76, 68, 59, 51, 42, 34, 25 ], 23 => [ 103, 87, 71, 55, 39 ], 25 => [ 110, 102, 93, 85, 76, 68, 59, 51, 42, 34 ], 34 => [ 110, 102, 93, 85, 76, 68, 59, 51, 42 ], 39 => [ 103, 87, 71, 55 ], 42 => [ 110, 102, 93, 85, 76, 68, 59, 51 ], 51 => [ 110, 102, 93, 85, 76, 68, 59 ], 55 => [ 103, 87, 71 ], 59 => [ 110, 102, 93, 85, 76, 68 ], 68 => [ 110, 102, 93, 85, 76 ], 71 => [ 103, 87 ], 76 => [ 110, 102, 93, 85 ], 85 => [ 110, 102, 93 ], 87 => [ 103 ], 93 => [ 110, 102 ], 102 => [ 110 ], 112 => [ 118, 117, 116, 115, 114, 113 ], 113 => [ 118, 117, 116, 115, 114 ], 114 => [ 118, 117, 116, 115 ], 115 => [ 118, 117, 116 ], 116 => [ 118, 117 ], 117 => [ 118 ] },
	{  8 => [ 104, 88, 72, 56, 40, 24 ], 15 => [ 113, 105, 98, 90, 83, 75, 68, 60, 53, 45, 38, 30, 23 ], 23 => [ 113, 105, 98, 90, 83, 75, 68, 60, 53, 45, 38, 30 ], 24 => [ 104, 88, 72, 56, 40 ], 30 => [ 113, 105, 98, 90, 83, 75, 68, 60, 53, 45, 38 ], 38 => [ 113, 105, 98, 90, 83, 75, 68, 60, 53, 45 ], 40 => [ 104, 88, 72, 56 ], 45 => [ 113, 105, 98, 90, 83, 75, 68, 60, 53 ], 53 => [ 113, 105, 98, 90, 83, 75, 68, 60 ], 56 => [ 104, 88, 72 ], 60 => [ 113, 105, 98, 90, 83, 75, 68 ], 68 => [ 113, 105, 98, 90, 83, 75 ], 72 => [ 104, 88 ], 75 => [ 113, 105, 98, 90, 83 ], 83 => [ 113, 105, 98, 90 ], 88 => [ 104 ], 90 => [ 113, 105, 98 ], 98 => [ 113, 105 ], 105 => [ 113 ], 122 => [ 121 ], 123 => [ 121, 122 ], 124 => [ 121, 122, 123 ], 125 => [ 121, 122, 123, 124 ], 126 => [ 121, 122, 123, 124, 125 ], 127 => [ 121, 122, 123, 124, 125, 126 ] },
	{  9 => [ 105, 89, 73, 57, 41, 25 ], 25 => [ 105, 89, 73, 57, 41 ], 31 => [ 114, 106, 99, 91, 84, 76, 69, 61, 54, 46, 39 ], 39 => [ 114, 106, 99, 91, 84, 76, 69, 61, 54, 46 ], 41 => [ 105, 89, 73, 57 ], 46 => [ 114, 106, 99, 91, 84, 76, 69, 61, 54 ], 54 => [ 114, 106, 99, 91, 84, 76, 69, 61 ], 57 => [ 105, 89, 73 ], 61 => [ 114, 106, 99, 91, 84, 76, 69 ], 69 => [ 114, 106, 99, 91, 84, 76 ], 73 => [ 105, 89 ], 76 => [ 114, 106, 99, 91, 84 ], 84 => [ 114, 106, 99, 91 ], 89 => [ 105 ], 91 => [ 114, 106, 99 ], 96 => [ 113, 104 ], 99 => [ 114, 106 ], 104 => [ 113 ], 106 => [ 114 ], 123 => [ 122 ], 124 => [ 122, 123 ], 125 => [ 122, 123, 124 ], 126 => [ 122, 123, 124, 125 ], 127 => [ 122, 123, 124, 125, 126 ] },
	{ 10 => [ 106, 90, 74, 58, 42, 26 ], 26 => [ 106, 90, 74, 58, 42 ], 42 => [ 106, 90, 74, 58 ], 47 => [ 115, 107, 100, 92, 85, 77, 70, 62, 55 ], 55 => [ 115, 107, 100, 92, 85, 77, 70, 62 ], 58 => [ 106, 90, 74 ], 62 => [ 115, 107, 100, 92, 85, 77, 70 ], 70 => [ 115, 107, 100, 92, 85, 77 ], 74 => [ 106, 90 ], 77 => [ 115, 107, 100, 92, 85 ], 80 => [ 114, 105, 97, 88 ], 85 => [ 115, 107, 100, 92 ], 88 => [ 114, 105, 97 ], 90 => [ 106 ], 92 => [ 115, 107, 100 ], 97 => [ 114, 105 ], 100 => [ 115, 107 ], 105 => [ 114 ], 107 => [ 115 ], 120 => [ 121 ], 124 => [ 123 ], 125 => [ 123, 124 ], 126 => [ 123, 124, 125 ], 127 => [ 123, 124, 125, 126 ] },
	{ 11 => [ 107, 91, 75, 59, 43, 27 ], 27 => [ 107, 91, 75, 59, 43 ], 43 => [ 107, 91, 75, 59 ], 59 => [ 107, 91, 75 ], 63 => [ 116, 108, 101, 93, 86, 78, 71 ], 64 => [ 115, 106, 98, 89, 81, 72 ], 71 => [ 116, 108, 101, 93, 86, 78 ], 72 => [ 115, 106, 98, 89, 81 ], 75 => [ 107, 91 ], 78 => [ 116, 108, 101, 93, 86 ], 81 => [ 115, 106, 98, 89 ], 86 => [ 116, 108, 101, 93 ], 89 => [ 115, 106, 98 ], 91 => [ 107 ], 93 => [ 116, 108, 101 ], 98 => [ 115, 106 ], 101 => [ 116, 108 ], 106 => [ 115 ], 108 => [ 116 ], 120 => [ 122, 121 ], 121 => [ 122 ], 125 => [ 124 ], 126 => [ 124, 125 ], 127 => [ 124, 125, 126 ] },
	{ 12 => [ 108, 92, 76, 60, 44, 28 ], 28 => [ 108, 92, 76, 60, 44 ], 44 => [ 108, 92, 76, 60 ], 48 => [ 116, 107, 99, 90, 82, 73, 65, 56 ], 56 => [ 116, 107, 99, 90, 82, 73, 65 ], 60 => [ 108, 92, 76 ], 65 => [ 116, 107, 99, 90, 82, 73 ], 73 => [ 116, 107, 99, 90, 82 ], 76 => [ 108, 92 ], 79 => [ 117, 109, 102, 94, 87 ], 82 => [ 116, 107, 99, 90 ], 87 => [ 117, 109, 102, 94 ], 90 => [ 116, 107, 99 ], 92 => [ 108 ], 94 => [ 117, 109, 102 ], 99 => [ 116, 107 ], 102 => [ 117, 109 ], 107 => [ 116 ], 109 => [ 117 ], 120 => [ 123, 122, 121 ], 121 => [ 123, 122 ], 122 => [ 123 ], 126 => [ 125 ], 127 => [ 125, 126 ] },
	{ 13 => [ 109, 93, 77, 61, 45, 29 ], 29 => [ 109, 93, 77, 61, 45 ], 32 => [ 117, 108, 100, 91, 83, 74, 66, 57, 49, 40 ], 40 => [ 117, 108, 100, 91, 83, 74, 66, 57, 49 ], 45 => [ 109, 93, 77, 61 ], 49 => [ 117, 108, 100, 91, 83, 74, 66, 57 ], 57 => [ 117, 108, 100, 91, 83, 74, 66 ], 61 => [ 109, 93, 77 ], 66 => [ 117, 108, 100, 91, 83, 74 ], 74 => [ 117, 108, 100, 91, 83 ], 77 => [ 109, 93 ], 83 => [ 117, 108, 100, 91 ], 91 => [ 117, 108, 100 ], 93 => [ 109 ], 95 => [ 118, 110, 103 ], 100 => [ 117, 108 ], 103 => [ 118, 110 ], 108 => [ 117 ], 110 => [ 118 ], 120 => [ 124, 123, 122, 121 ], 121 => [ 124, 123, 122 ], 122 => [ 124, 123 ], 123 => [ 124 ], 127 => [ 126 ] },
	{ 14 => [ 110, 94, 78, 62, 46, 30 ], 16 => [ 118, 109, 101, 92, 84, 75, 67, 58, 50, 41, 33, 24 ], 24 => [ 118, 109, 101, 92, 84, 75, 67, 58, 50, 41, 33 ], 30 => [ 110, 94, 78, 62, 46 ], 33 => [ 118, 109, 101, 92, 84, 75, 67, 58, 50, 41 ], 41 => [ 118, 109, 101, 92, 84, 75, 67, 58, 50 ], 46 => [ 110, 94, 78, 62 ], 50 => [ 118, 109, 101, 92, 84, 75, 67, 58 ], 58 => [ 118, 109, 101, 92, 84, 75, 67 ], 62 => [ 110, 94, 78 ], 67 => [ 118, 109, 101, 92, 84, 75 ], 75 => [ 118, 109, 101, 92, 84 ], 78 => [ 110, 94 ], 84 => [ 118, 109, 101, 92 ], 92 => [ 118, 109, 101 ], 94 => [ 110 ], 101 => [ 118, 109 ], 109 => [ 118 ], 111 => [ 119 ], 120 => [ 125, 124, 123, 122, 121 ], 121 => [ 125, 124, 123, 122 ], 122 => [ 125, 124, 123 ], 123 => [ 125, 124 ], 124 => [ 125 ] },
	{  0 => [ 119, 110, 102, 93, 85, 76, 68, 59, 51, 42, 34, 25, 17,  8 ],  8 => [ 119, 110, 102, 93, 85, 76, 68, 59, 51, 42, 34, 25, 17 ], 15 => [ 111, 95, 79, 63, 47, 31 ], 17 => [ 119, 110, 102, 93, 85, 76, 68, 59, 51, 42, 34, 25 ], 25 => [ 119, 110, 102, 93, 85, 76, 68, 59, 51, 42, 34 ], 31 => [ 111, 95, 79, 63, 47 ], 34 => [ 119, 110, 102, 93, 85, 76, 68, 59, 51, 42 ], 42 => [ 119, 110, 102, 93, 85, 76, 68, 59, 51 ], 47 => [ 111, 95, 79, 63 ], 51 => [ 119, 110, 102, 93, 85, 76, 68, 59 ], 59 => [ 119, 110, 102, 93, 85, 76, 68 ], 63 => [ 111, 95, 79 ], 68 => [ 119, 110, 102, 93, 85, 76 ], 76 => [ 119, 110, 102, 93, 85 ], 79 => [ 111, 95 ], 85 => [ 119, 110, 102, 93 ], 93 => [ 119, 110, 102 ], 95 => [ 111 ], 102 => [ 119, 110 ], 110 => [ 119 ], 120 => [ 126, 125, 124, 123, 122, 121 ], 121 => [ 126, 125, 124, 123, 122 ], 122 => [ 126, 125, 124, 123 ], 123 => [ 126, 125, 124 ], 124 => [ 126, 125 ], 125 => [ 126 ] },
];

1;
