# 007 [![Build Status](https://secure.travis-ci.org/masak/007.svg?branch=master)](http://travis-ci.org/masak/007)

* [tutorial](http://masak.github.io/007/)
* [roadmap](https://github.com/masak/007/blob/master/ROADMAP.md)

----

*Prague, Czech Republic. Around two o'clock at night.*

A single car pulls up to the section headquarters. Section chief JOHN DRYDEN gets out and looks around him before getting into the empty building.

He takes one of the glass elevators up to his office. A silence hangs over the elevator as it rises up to his floor. The England-born station chief is wearing a western suit and tie; only the fur cap gives him a slightly slavic look. An LED digital display quietly counts up the floor numbers: 3, 4, 5, 6...

The upper floor is all polished steel and glass. Dryden's footsteps are the only sounds heard as he heads to his office.

He opens the door. The office is veiled in darkness. Some light from the street is coming in from the outside, casting a few stark shadows. Dryden walks across the room, takes off his ushanka and places it on his desk, turns on a desk light, and... stops, eyes wide.

Someone is already in the office.

When Dryden reviews the past few seconds, he *knows* he saw a flicker of movement from the corner near the door. Also, his peripheral vision must have caught sight in the mirror of a dark figure, sitting in one of the chairs in that corner.

He keeps on staring straight ahead, waiting for the stranger to take the initiative.

"M really doesn't mind you earning a little money on the side, Dryden," says the stranger, who is of course JAMES BOND, our titular character. His calm, deep voice cuts through the silence. "She'd just prefer it if it wasn't selling secrets."

Dryden, having composed himself, turns around, shoots Bond a dark glare and slowly sits down at his desk. As he does so, he surrepetitiously pulls out a desk drawer full of documents, on top of which are a remote control and a handgun. "If the theatrics are supposed to scare me, you have the wrong man, Bond." He pulls off his fine leather gloves. "If M was so sure I was bent, she'd have sent a Double-O." His rising tone on that last "Double-O" makes it abundantly clear that he knows Bond is not one.

Having settled in, Dryden smiles and continues. "Benefits of being Section Chief. I'd know of anyone being promoted to Double-O status, wouldn't I? Your file shows no kills, and it takes..."

"...two," confirms Bond, flatly.

---

*Flashback. The restroom is as bright white as the office was shrouded in darkness.*

Bond kicks a frizzy-haired man into a stall. Following, he punches him, and then they collide, smashing through two more inter-stall dividers. Bond gets in another hit with his elbow before they both tumble out on the floor. They both get up quickly. The man tries to throw a trashcan at Bond, who blocks with a kick.

---

*Office.*

Dryden picks up his gun from the drawer and aims it squarely at Bond, who sits, stolidly expressionless.

"Shame," he says with mock regret and an acerbic smile, "we barely got to know each other." He pulls the trigger.

\**click*\*

Dryden lowers the handgun slightly. Cold, horrible realization slowly dawns in his eyes.

Bond holds up a pistol magazine. "I know where you keep your gun," he states, matter-of-factly. "I suppose that's something."

Dryden has a mild look of dread and despair to him. "True," he says after a while. "How did he die?"

"Your contact?" asks Bond. Dryden nods, minutely. "Not well," admits Bond.

---

*Flashback. Painfully bright restroom.*

Bond knocks THE CONTACT into a wall, making him shatter a ceramic sink on the way down to the floor. Bond picks him up in a stranglehold and shoves him unceremoniously towards another sink, trying to push him down into it.

The contact struggles for his life. Bond keeps a strong hold on him. As the contact is about to lose the power stuggle, he suddenly reaches for a pistol that's lying within reach on the floor. He tries to aim it at Bond, and another power struggle arises around where the contact's right hand is aiming. A shot goes off, and shatters half of a nearby sink. Bond smashes the man's hand into a mirror, making the gun clatter to the floor.

Bond turns on the water and proceeds to drown the man. Notes of intense drama bleed through in the background. The man struggles on, but less and less. After a few seconds, Bond releases his hold of him and he drops lifeless to the floor.

Water keeps on flowing from the sink onto the floor right next to the man, who doesn't get up. The dramatic music subsides.

Bond takes a few heavy breaths. Still looking at his victim, he regains his composure and relaxes noticeably.

---

*Office.*

"Made you feel it, did he?" asks Dryden rhethorically. His brows are furrowed in understanding. Bond looks back, still expressionless.

"Well, you needn't worry", Dryden continues. "The second is..."

"Yes," Bond cuts him off. "Considerably."

...

A thick silence settles in the big office. The two men look at each other.

"Oh, for... I can't believe this!" Dryden manages.

"Something wrong?" inquires Bond, still collected.

"You were supposed to *kill* me there. Right there, before you cut me off! You were supposed to *shoot* me in cold blood and *then* go 'Yes. Considerably.' Not just interrupt me and keep me alive!" Dryden gets up and starts walking around, agitated.

Now Bond looks a trifle concerned. "Are you sure? I mean, that would make you my second kill, yes. But what if I killed a second person on my way here?"

Dryden sighs. "That's possible, of course, but unsatisfactory from a story point of view. Look at the chronological facts: MI6 finds out I sell state secrets, which makes me a traitor. They send you to kill my contact, and then come for me. You sneak into my office, empty my gun, and wait for me. Then we review my sins together, and how you already killed my contact. I even tried to kill *you* as you came out of your flashback. Then I serve you the *perfect* line about how the second kill is easier, and you cut me off before I even have time to say "easier". If you had shot me right there, that would have made *me* your second kill, creating a bit of situational (albeit dark) humor, along with a trademark Bond one-liner."

Now it's Bond's time to furrow his brows. "Oh dear, I believe you're right. That was clearly a missed opportunity. Apologies."

There's another pause.

"I don't suppose I can just kill you now instead?" asks Bond hopefully.

"No, the moment has passed," grumbles Dryden and flops down into his chair, dejected. "Besides, at this point we're already meta, and the situation requires a postmodern solution instead of a straightforward one."

"I'm sorry to cause all this trouble. This *is* my first assignment. Frankly, it's not as easy as it looks."

Another sigh. "I know, I know. Being a field agent is tough. Which is why I opted for a career as highly trusted but unreliable, ultimately dispensable section chief in an East European country instead."

"If you want, you could go out and come back in, and we could do it all over again."

"Look," Dryden begins. "That clearly wouldn't work. You and I know too much, the audience knows too much, and even if we pulled off the scene flawlessly a second time, it just wouldn't *feel* right, you know? It would be like explaining a joke, and *then* telling it!"

Bond nods. "Yes, I suppose so."

Silence.

"Did you know I sat here for three hours?" says Bond suddenly. "My intel told me you were supposed to show up here by 23:00, so I was here waiting before that. I've been sitting so long my legs have gone to sleep."

Dryden pulls a face. "My car broke down. Right in the middle of nowhere. I had to call a towing truck, and then I spent an hour or so at a repair shop."

"Did you try to call your contact to tell him you were running late?"

"No, we try to stay off unencrypted channels. Besides, he's used to waiting. Usually, he has a book with him about postmodernism or compiler construction, so he doesn't mind."

"Good man."

"Yes, he's great." Dryden frowns. "Was great."

"Hm, I wonder," says Bond. "We may not be able to re-do this scene, but maybe the flashback is amenable to modification?"

"Huh. Unorthodox, but worth a shot."

"Ok. Here goes."

---

*Flashback. Bright restroom.*

Bond kicks a frizzy-haired man into a stall.

---

*Office.*

"Yes, it seems to be working," says Bond, brightly.

---

*Flashback. Restroom.*

They fight. Crashing through dividers, ultimately falling together onto the floor again. Bond gets up first. Instead of kicking the man, this time he makes a calm-down motion.

"Did you know that macros allow introspection and modification of program elements from within the program itself?", Bond offers.

The man tries to rise from the floor. "*What?!*", he pants. "Won't that lead to a Russell's paradox situation?" He half runs, half stumbles to the place on the floor where the gun is.

Bond is right after him and kicks the pistol out of his hand. "No, I don't think so.", he muses. He takes the same kind of stranglehold on the agent as he did in the last flashback, and drags him to the nearest sink. "Besides, even `BEGIN` blocks are vulnerable to non-terminating code. It's all about freedom under responsibility."

"But what are macros *good* for?!" shouts the man before he goes under the water tap.

"I told you, they introspect and modify," says Bond between gritted teeth as he drowns the contact.

---

*Office.*

"In a way, *that* was my second kill," muses Bond, "even though technically, it was the same guy twice. And you're right, it was easier. I knew he was going to go for the pistol on the floor, so I could disarm him earlier."

Dryden looks amused. "What was that thing about macros you were talking about?", he inquires.

"Oh, it's a little side project I'm working on. Just a minor thing, exploring the limits of a tree-walking evaluator with the ability to modify the tree using macros at compile time."

"Astounding."

"Oh, not really. There's nothing revolutionary to it at all. But we're hoping it will shed some light on Perl 6 macros."

Another beat of silence passes.

"*You're* involved in the Perl 6 movement?", asks Dryden, incredulous. "Waitwait, have you and Damian Conway ever been in the same room? Did he ask for your autograph? Did you ask for *his* autograph? Or did you just engage in a battle *to the death*, like in 'Highlander'?" Dryden is gaping and wide-eyed, clearly relishing the thought.

"Er, I think we should stay within one franchise here," mumbles Bond, avoiding the sudden questions. "But I want to try the flashback again, I think I can do even better."

---

*Restroom. The tiles on the walls scream bright light.*

"So let me get this straight," says the contact, grunting between punches and blocks as they smash through the dividers again. "The parser produces an abstract syntax tree, as usual. The runtime is so simple that it just runs straight off the AST, which is slow as crap but works for a simple project, I guess." He blocks another blow.

"Right," replies Bond, ramming an elbow into the agent with full force. "The innovation is really that AST fragments are also first-class objects, occurring as values in the program itself. Which is of no use unless you can manage them at compile time and put them back into the program. Macros are a way to do that." They both tumble through a stall door and land hard at the same time. The pistol slides across the stone floor.

They get up, quickly. The man tries to throw a wastebasket at Bond, who kicks it away easily. "So, like a complicated version of Lisp macros, then?", shouts the contact. Bond punches him hard into the wall. The agent shatters a ceramic sink as he falls. While the other is down, Bond calmly walks over to the gun and snatches it from the ground.

"Yes, kind of like Lisp macros. The extra complexity comes from the fact that Lisp doesn't really have any syntactic categories, whereas we do. In Lisp, everything is an expression, if you will. We are trying to have our cake and eat it: C-like syntax, but still with a flexible, AST-based macro system."

"You will never achieve the simplicity of Lisp macros in that way," says the contact, as he slowly gets up.

"True, but we can get quite close. And the aim is not to emulate Lisp slavishly, the aim is to produce a Perlish macro system that can serve Perl users as well as possible," explains Bond. "Someone who reaches for macros is likely to already be a bit of a power user, but even power users appreciate easy things being made easy, and hard things possible."

The contact gets an abstracted look. "But wait, won't there be weird and interesting interactions between AST fragments and lexical scoping?"

"Like you wouldn't believe," says Bond and shoots the contact point-blank.

---

*Office.*

"Interesting," says Bond. "I wonder what Bill Murray would have done in a situation like this? Hold on, let me try something else..."

---

*Restroom.*

The scene fades in smoother this time. The contrasts aren't quite so bright, and the sharp light has dimmed a fraction. Both bond and the contact are busy each in one end of the room, filling the walls with scribbled notes about compilers, ASTs, and various macro transformations.

"Ok, I think I'm getting the hang of Perl 6 macros. They're unorthodox, for sure," says the contact over his shoulder.

"Yes, but the end result feels very Perlish," replies Bond.

"One thing I don't understand though," says the contact. "You mentioned that this whole scene we are in stands in as a kind of metaphor for macro processing. I'm still having trouble processing that this *is* a scene... could you explain again?"

"Ok, look. This is a flashback showing how I killed you. Invoking a flashback in a movie is a little bit like calling a macro in a programming language. Unlike a normal subroutine, the macro doesn't run at the point of the call at runtime; instead it runs at the point of the call at *compile time*. When you do reach that call site at runtime, all you see is the effects of the macro invocation. The macro call itself has already happened. Just like this flashback."

"But you're saying this is your fourth flashback of the same scene. Shouldn't all flashbacks be the same? Isn't it, like, a paradox that they're not?"

"Not really. The same macro can be invoked from many different call sites with different inputs. Even if there are no differing inputs, the macro is just code, and can execute differently each time on a whim."

"So, in a sense, we're in a bubble. This whole flashback is taking place in the actual time-line's past. Nothing we do here will have any real consequence."

"Oh, don't say that," drawls Bond, smirking wryly. "A macro can still have pretty far-reaching consequences, up to and including stopping execution. So it might be possible for us to crash the universe from within here if we try hard enough."

"Let's not do that."

"Agreed."

The two men look around the restroom, admiring their work. Advanced schematics and comments in sharp black marker pen cover the walls, from floor to ceiling. Some of the mirrors are covered with writings as well.

"I don't feel like killing you anymore," offers Bond. "I'm having far too much fun discussing macros with you. If I kill you, I'll have to start over."

"Fair enough," says the contact. "But how do you imagine we'll ever get out of this flashback?"

Before Bond can answer, Dryden enters and shoots the contact.

---

*Office.*

"What did you to that for!?" shouts Bond.

"You had been in there for days," growls Dryden. "I needed to extract you so we can finish this README."

"I thought this was the pre-title sequence of a movie," mumbles Bond.

"Anyway. While you were getting lost in your flashback, I looked over that language of yours. I'm intrigued! I need to think of a use for macros so I can try it out!" Dryden gets a distant look.

"Well, the language itself is only a toy," confesses Bond. "A bit like the trinkets Q division tends to come up with. But we are hopeful about the lessons we will learn from building this."

Dryden nods, sympathetically. "I understand fully. The Perl 6 macros have been a long way coming. You do a first implementation of macros in this fast-moving toy language. The second..."

Bond takes swift aim, and pulls the trigger. The silencer makes the gun emit a professional kind of \**PEW*\* sound.

There's a quick shot of the view from Dryden's perspective as he tumbles backwards in his chair. A photo on his desk shows wife and daughter. He hits the floor on his back, dead.

"Yes," says Bond to no-one in particular, smirking dryly as he secures his gun and stows it in his trenchcoat. "Considerably."

The Bond theme plays, brass instruments blaring.
