#!/usr/bin/perl

package eBay::API::XML::Call::SendInvoice::SendInvoiceRequestType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. SendInvoiceRequestType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::SendInvoice::SendInvoiceRequestType

=head1 DESCRIPTION

Enables a seller to send an invoice to a buyer involved in the transaction.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::SendInvoice::SendInvoiceRequestType inherits from the L<eBay::API::XML::RequestDataType> class

=cut

use eBay::API::XML::RequestDataType;
our @ISA = ("eBay::API::XML::RequestDataType");

use eBay::API::XML::DataType::AmountType;
use eBay::API::XML::DataType::InternationalShippingServiceOptionsType;
use eBay::API::XML::DataType::ItemIDType;
use eBay::API::XML::DataType::OrderIDType;
use eBay::API::XML::DataType::SalesTaxType;
use eBay::API::XML::DataType::ShippingServiceOptionsType;
use eBay::API::XML::DataType::Enum::BuyerPaymentMethodCodeType;
use eBay::API::XML::DataType::Enum::InsuranceOptionCodeType;


my @gaProperties = ( [ 'CODCost', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'CheckoutInstructions', 'xs:string', '', '', '' ]
	, [ 'EmailCopyToSeller', 'xs:boolean', '', '', '' ]
	, [ 'InsuranceFee', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'InsuranceOption', 'ns:InsuranceOptionCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::InsuranceOptionCodeType', '' ]
	, [ 'InternationalShippingServiceOptions', 'ns:InternationalShippingServiceOptionsType', '1'
	     ,'eBay::API::XML::DataType::InternationalShippingServiceOptionsType', '1' ]
	, [ 'ItemID', 'ns:ItemIDType', ''
	     ,'eBay::API::XML::DataType::ItemIDType', '1' ]
	, [ 'OrderID', 'ns:OrderIDType', ''
	     ,'eBay::API::XML::DataType::OrderIDType', '1' ]
	, [ 'PayPalEmailAddress', 'xs:string', '', '', '' ]
	, [ 'PaymentMethods', 'ns:BuyerPaymentMethodCodeType', '1'
	     ,'eBay::API::XML::DataType::Enum::BuyerPaymentMethodCodeType', '' ]
	, [ 'SalesTax', 'ns:SalesTaxType', ''
	     ,'eBay::API::XML::DataType::SalesTaxType', '1' ]
	, [ 'ShippingServiceOptions', 'ns:ShippingServiceOptionsType', '1'
	     ,'eBay::API::XML::DataType::ShippingServiceOptionsType', '1' ]
	, [ 'TransactionID', 'xs:string', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::RequestDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::RequestDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setCODCost()

Italy site (site ID 101) only.
Enables you to specify the cash-on-delivery (COD) cost, for COD shipping.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=CODInShippingDetails
Title: Specifying the Cash on Delivery Option in Shipping Details

  RequiredInput: No
#    Argument: 'ns:AmountType'

=cut

sub setCODCost {
  my $self = shift;
  $self->{'CODCost'} = shift
}

=head2 getCODCost()

#    Returns: 'ns:AmountType'

=cut

sub getCODCost {
  my $self = shift;
  return $self->_getDataTypeInstance( 'CODCost'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setCheckoutInstructions()

Seller's Payment instructions/message to the buyer and return policy.
Default is null.

MaxLength: 500

  RequiredInput: No
#    Argument: 'xs:string'

=cut

sub setCheckoutInstructions {
  my $self = shift;
  $self->{'CheckoutInstructions'} = shift
}

=head2 getCheckoutInstructions()

#    Returns: 'xs:string'

=cut

sub getCheckoutInstructions {
  my $self = shift;
  return $self->{'CheckoutInstructions'};
}


=head2 setEmailCopyToSeller()

Specifies whether the seller wishes to be copied on the invoice email that
will be sent to the buyer. Default will be true.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut

sub setEmailCopyToSeller {
  my $self = shift;
  $self->{'EmailCopyToSeller'} = shift
}

=head2 isEmailCopyToSeller()

#    Returns: 'xs:boolean'

=cut

sub isEmailCopyToSeller {
  my $self = shift;
  return $self->{'EmailCopyToSeller'};
}


=head2 setInsuranceFee()

Insurance cost, as set by seller, if ShippingType = 1.
Specify if InsuranceOption is optional or required. Must
be greater than zero value if a value of Optional or Required is passed in
InsuranceOption. Value specified should be the total cost of insuring the
item.<br>
<br>
Not applicable to invoices for digital listings.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ShippingGettingCosts
Title: Determining Shipping Costs for a Listing
Default: 0.0

  RequiredInput: No
#    Argument: 'ns:AmountType'

=cut

sub setInsuranceFee {
  my $self = shift;
  $self->{'InsuranceFee'} = shift
}

=head2 getInsuranceFee()

#    Returns: 'ns:AmountType'

=cut

sub getInsuranceFee {
  my $self = shift;
  return $self->_getDataTypeInstance( 'InsuranceFee'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setInsuranceOption()

Specifies whether insurance fee is required. An InsuranceOption value of
IncludedInShippingHandling cannot be used if the item will use calculated
shipping. Some shipping carriers automatically include shipping insurance
for qualifying items.<br>
<br>
Not applicable to invoices for digital listings.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ShippingGettingCosts
Title: Determining Shipping Costs for a Listing

  RequiredInput: No
  AllValuesExcept: NotOfferedOnSite
#    Argument: 'ns:InsuranceOptionCodeType'

=cut

sub setInsuranceOption {
  my $self = shift;
  $self->{'InsuranceOption'} = shift
}

=head2 getInsuranceOption()

#    Returns: 'ns:InsuranceOptionCodeType'

=cut

sub getInsuranceOption {
  my $self = shift;
  return $self->{'InsuranceOption'};
}


=head2 setInternationalShippingServiceOptions()

If the buyer's shipping address is international, use this to offer up to
three shipping services, and omit all domestic ShippingServiceOptions. Any
shipping insurance cost specified should be the same for all services
offered.
<br><br>
Not applicable to invoices for digital listings.

  RequiredInput: No
#    Argument: reference to an array  
                      of 'ns:InternationalShippingServiceOptionsType'

=cut

sub setInternationalShippingServiceOptions {
  my $self = shift;
  $self->{'InternationalShippingServiceOptions'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getInternationalShippingServiceOptions()

#    Returns: reference to an array  
                      of 'ns:InternationalShippingServiceOptionsType'

=cut

sub getInternationalShippingServiceOptions {
  my $self = shift;
  return $self->_getDataTypeArray('InternationalShippingServiceOptions');
}


=head2 setItemID()

Item ID. If OrderID is not provided, both ItemID and
TransactionID must be provided.

MaxLength: 19 (Note: The eBay database specifies 38. Currently, Item IDs are usually 9 to 12 digits)

  RequiredInput: Conditionally
#    Argument: 'ns:ItemIDType'

=cut

sub setItemID {
  my $self = shift;
  $self->{'ItemID'} = shift
}

=head2 getItemID()

#    Returns: 'ns:ItemIDType'

=cut

sub getItemID {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ItemID'
		,'eBay::API::XML::DataType::ItemIDType');
}


=head2 setOrderID()

Unique ID for a multi-item order. Either this OrderID must
be specified or ItemID plus TransactionID must be specified.
If OrderID is specified, ItemID and
TransactionID are ignored if present in the same request. Changes to the
checkout status are applied to the specified order as a whole
(and thus to the child transactions associated with the order).

  RequiredInput: Conditionally
#    Argument: 'ns:OrderIDType'

=cut

sub setOrderID {
  my $self = shift;
  $self->{'OrderID'} = shift
}

=head2 getOrderID()

#    Returns: 'ns:OrderIDType'

=cut

sub getOrderID {
  my $self = shift;
  return $self->_getDataTypeInstance( 'OrderID'
		,'eBay::API::XML::DataType::OrderIDType');
}


=head2 setPayPalEmailAddress()

Provide PayPal email address if the payment method added is PayPal.
For digital listings, this must be an email address associated with
a verified PayPal Premier or Business account.

  RequiredInput: No
#    Argument: 'xs:string'

=cut

sub setPayPalEmailAddress {
  my $self = shift;
  $self->{'PayPalEmailAddress'} = shift
}

=head2 getPayPalEmailAddress()

#    Returns: 'xs:string'

=cut

sub getPayPalEmailAddress {
  my $self = shift;
  return $self->{'PayPalEmailAddress'};
}


=head2 setPaymentMethods()

Optional ability for the seller to add certain payment methods on
transaction if they were not originally specified on the item.  Valid
values are PayPal in the US, and MoneyXferAcceptedInCheckout (CIP+) in
Germany.

  RequiredInput: No
#    Argument: reference to an array  
                      of 'ns:BuyerPaymentMethodCodeType'

=cut

sub setPaymentMethods {
  my $self = shift;
  $self->{'PaymentMethods'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getPaymentMethods()

#    Returns: reference to an array  
                      of 'ns:BuyerPaymentMethodCodeType'

=cut

sub getPaymentMethods {
  my $self = shift;
  return $self->_getDataTypeArray('PaymentMethods');
}


=head2 setSalesTax()

The details of the sales tax added to the invoice.

  RequiredInput: No
#    Argument: 'ns:SalesTaxType'

=cut

sub setSalesTax {
  my $self = shift;
  $self->{'SalesTax'} = shift
}

=head2 getSalesTax()

#    Returns: 'ns:SalesTaxType'

=cut

sub getSalesTax {
  my $self = shift;
  return $self->_getDataTypeInstance( 'SalesTax'
		,'eBay::API::XML::DataType::SalesTaxType');
}


=head2 setShippingServiceOptions()

If the buyer's shipping address is domestic, use this to offer up to
three shipping services, and omit all InternationalShippingServiceOptions. Any
shipping insurance cost specified should be the same for all services
offered.
<br><br>
Not applicable to invoices for digital listings.

  RequiredInput: No
#    Argument: reference to an array  
                      of 'ns:ShippingServiceOptionsType'

=cut

sub setShippingServiceOptions {
  my $self = shift;
  $self->{'ShippingServiceOptions'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getShippingServiceOptions()

#    Returns: reference to an array  
                      of 'ns:ShippingServiceOptionsType'

=cut

sub getShippingServiceOptions {
  my $self = shift;
  return $self->_getDataTypeArray('ShippingServiceOptions');
}


=head2 setTransactionID()

ID for the transaction with which the item was sold.
If OrderID is not provided, both ItemID and
TransactionID must be provided.
For Chinese auctions, the value passed in the TransactionId
argument must be 0 or the call will fail with an error.
Call GetItemTransactions or GetSellerTransactions to
determine the correct transaction ID.

MaxLength: 19 (Note: The eBay database specifies 38. Currently, transaction IDs are usually 9 to 12 digits.)

  RequiredInput: Conditionally
#    Argument: 'xs:string'

=cut

sub setTransactionID {
  my $self = shift;
  $self->{'TransactionID'} = shift
}

=head2 getTransactionID()

#    Returns: 'xs:string'

=cut

sub getTransactionID {
  my $self = shift;
  return $self->{'TransactionID'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
