#! /usr/bin/env false

use v6.c;

unit class I18n::Simple::Template;

multi method parse (
	Str:D $input,
	%context,
	--> Str
) {
	my Bool $in-var = False;
	my Str $buffer = "";
	my Str $output = "";
	my @chars = $input.comb;

	while @chars.shift -> $char {
		if ($char eq "\$" && @chars.shift eq "(" && !$in-var) {
			$in-var++;

			next;
		}

		if ($char eq ")" && $in-var) {
			$in-var--;

			$output ~= %context{$buffer};
			$buffer = "";

			next;
		}

		if ($in-var) {
			$buffer ~= $char;

			next;
		}

		$output ~= $char;
	}

	$output;
}

=begin pod

=NAME    I18n::Simple::Template
=AUTHOR  Patrick Spek <p.spek@tyil.work>
=VERSION 0.1.0

=head1 Synopsis

=head1 Description

=head1 Examples

=head1 See also

=end pod

# vim: ft=perl6 noet
