# -*- cperl -*-
# ABSTRACT: LaTeX elementlist object


use strict;
use warnings;
package SpeL::Object::ElementList;

use parent 'Exporter';
use Carp;

use SpeL::Object::Element;
use SpeL::Object::MathGroup;
use SpeL::Object::MathEnvironmentSimple;

use SpeL::I18n;

#use Data::Dumper;


sub new {
  my $class = shift;
  my ( $self ) = @_;
  $self = {} unless $self;
  bless $self, $class;
}


sub read {
  my $self = shift;
  my ( $level ) = @_;

  # say STDERR Data::Dumper->Dump( [ $self ], [ 'self' ] );

  return join( ' ',
	       map { $_->read( $level + 1 ) } @{$self->{Element}} );
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

SpeL::Object::ElementList - LaTeX elementlist object

=head1 VERSION

version 20240617.1739

=head1 METHODS

=head2 new()

We keep the default method, as the object is generated by the parser.

=head2 read( level )

returns a string with the spoken version of the node

=over 4

=item level: parsing level

=back

=head1 SYNOPSYS

Represents a LaTeX elementlist

=head1 AUTHOR

Walter Daems <wdaems@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2024 by Walter Daems.

This is free software, licensed under:

  The GNU General Public License, Version 3, June 2007

=head1 CONTRIBUTOR

=for stopwords Paul Levrie

Paul Levrie

=cut
