#!/usr/bin/perl
# Create CGI requests from HTTP::Requests, specifically the sort of
# requests that come from POE::Component::Server::HTTP.
use warnings;
use strict;
use POE;
use POE::Component::Server::HTTP;
use CGI ":standard";
use URI::Escape;
#urlencode
use HTML::Entities;



# Start an HTTP server.  Run it until it's done, typically forever,
# and then exit the program.
POE::Component::Server::HTTP->new(
  Port           => 8002,
  ContentHandler => {
    '/'      => \&root_handler,
    '/post/' => \&post_handler,
  }
);
POE::Kernel->run();
exit 0;

# Handle root-level requests.  Populate the HTTP response with a CGI
# form.
sub root_handler {
  my ($request, $response) = @_;
  $response->code(RC_OK);
  $response->content(
    start_html("Sample Form")
      . start_form(
      -method  => "post",
      -action  => "/post/",
    # -enctype => "multipart/form-data",
      -enctype => "application/x-www-form-urlencoded;charset=utf-8",
      )
      . br()
      . "index: "
      . textfield("index")
      . br()
      . "command: "
      . textfield("command")
      . "arg: "
      . textfield("arg")
      . submit("submit", "submit")
      . end_form()
      . end_html()
  );
  return RC_OK;
}


sub post_handler {
  my ($request, $response) = @_;

  # This code creates a CGI query.
  my $q;
  if ($request->method() eq 'POST') {
    $q = new CGI($request->content);
  }
  else {
    $request->uri() =~ /\?(.+$)/;
    if (defined($1)) {
      $q = new CGI($1);
    }
    else {
      $q = new CGI;
    }
  }

  # The rest of this handler displays the values encapsulated by the
  # object.
  $response->code(RC_OK);
my $rand=rand();
my @mall;


my $am;
my $dm;
$index=$q->param("index");
$command=$q->param("command");
$arg=$q->param("arg");
#print "amdm $am $dm\n";

$index=decode_entities($index);
$command=decode_entities($command);
$arg=decode_entities($arg);

open(FD,">/tmp/$rand");
print FD $index,"\n";
print FD $command,"\n";
print FD $command,"\n";
close FD;
my $res;
$res=`./client_whoosh.pl /tmp/$rand`;
print "res =$res\n";
print "/tmp/$rand\n";
$response->content($res);
#  $response->content(start_html("Posted Values") 
# 	. $res
#      . "u = "
#      . $q->param("u")
#      . br()
#      . "n= "
#      . $q->param("n")
#      . br()
#      . "w= "
#      . $q->param("w")
#      . br()
#      . "s= "
#      . $q->param("s")

#      . end_html());
print "m:", $q->param("m"),"\n";
print "d:", $q->param("d"),"\n";
  return RC_OK;
}

