/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jdk8;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.sis.internal.jdk8.Consumer;
import org.apache.sis.internal.jdk8.IteratorSpliterator;
import org.apache.sis.internal.jdk8.Spliterator;
import org.apache.sis.internal.jdk8.StreamSupport;

public final class Stream<T>
implements AutoCloseable {
    private final Spliterator<T> it;
    private final List<Runnable> closeHandlers = new LinkedList<Runnable>();

    Stream(Spliterator<T> spliterator) {
        this.it = spliterator;
    }

    public static <T> Stream<T> create(Iterable<T> iterable) {
        if (iterable != null) {
            return StreamSupport.stream(new IteratorSpliterator<T>(iterable.iterator()), false);
        }
        return null;
    }

    public void forEachOrdered(Consumer<? super T> consumer) {
        Iterator<T> iterator = this.iterator();
        while (iterator.hasNext()) {
            consumer.accept(iterator.next());
        }
    }

    public Iterator<T> iterator() {
        return new Iter();
    }

    public Stream<T> onClose(Runnable runnable) {
        this.closeHandlers.add(runnable);
        return this;
    }

    @Override
    public void close() {
        for (Runnable runnable : this.closeHandlers) {
            runnable.run();
        }
    }

    private final class Iter
    implements Iterator<T>,
    Consumer<T> {
        private byte status;
        private T next;

        private Iter() {
        }

        @Override
        public void accept(T t) {
            this.next = t;
            this.status = 1;
        }

        @Override
        public boolean hasNext() {
            if (this.status == 0 && !Stream.this.it.tryAdvance(this)) {
                this.status = (byte)2;
            }
            return this.status == 1;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object t = this.next;
            this.next = null;
            this.status = 0;
            return t;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

