package Net::SMTP::Verify::Result;

use Moose;

our $VERSION = '1.00'; # VERSION
# ABSTRACT: address verification result for a recipient

has 'address' => ( is => 'rw', isa => 'Str', required => 1 );
has 'host' => ( is => 'rw', isa => 'Maybe[Str]' );

has 'has_starttls' => ( is => 'rw', isa => 'Maybe[Bool]' );
has 'has_tlsa' => ( is => 'rw', isa => 'Maybe[Bool]' );

has 'smtp_message' => ( is => 'rw', isa => 'Maybe[Str]' );
has 'smtp_code' => ( is => 'rw', isa => 'Maybe[Int]' );

has 'error' => ( is => 'rw', isa => 'Maybe[Str]' );

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Net::SMTP::Verify::Result - address verification result for a recipient

=head1 VERSION

version 1.00

=head1 AUTHOR

Markus Benning <ich@markusbenning.de>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2015 by Markus Benning <ich@markusbenning.de>.

This is free software, licensed under:

  The GNU General Public License, Version 2, June 1991

=cut
