# NAME

Lingua::FR::Numbers::Ordinate - Go from cardinal number (4) to ordinal ("4ème")

# VERSION

Version 0.04

# SYNOPSIS

    use Lingua::FR::Numbers::Ordinate;
    use utf8::all;

    print Lingua::FR::Numbers::Ordinate::ordinate(4), "\n";

# DESCRIPTION

Translate from cardinal numbers (1, 2, 3) to ordinal numbers (1er, 2ème, 3ème)
and vice versa.

# SUBROUTINES/METHODS

## ordinate

Translate a given number into the ordinal form.

# AUTHOR

Nigel Horne, `<njh at bandsman.co.uk>`

# BUGS

It's up to you do add an e to a feminine use of ordinate(1);

# SEE ALSO

[Lingua::EN::Numbers::Ordinate](https://metacpan.org/pod/Lingua%3A%3AEN%3A%3ANumbers%3A%3AOrdinate)

# SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc Lingua::FR::Numbers::Ordinate

You can also look for information at:

- RT: CPAN's request tracker

    [http://rt.cpan.org/NoAuth/Bugs.html?Dist=Lingua-FR-Numbers-Ordinate](http://rt.cpan.org/NoAuth/Bugs.html?Dist=Lingua-FR-Numbers-Ordinate)

- CPAN Ratings

    [http://cpanratings.perl.org/d/Lingua-FR-Numbers-Ordinate](http://cpanratings.perl.org/d/Lingua-FR-Numbers-Ordinate)

- Search CPAN

    [http://search.cpan.org/dist/Lingua-FR-Numbers-Ordinate/](http://search.cpan.org/dist/Lingua-FR-Numbers-Ordinate/)

# LICENSE AND COPYRIGHT

Copyright 2020-2021 Nigel Horne

This program is released under the following licence: GPL2
