#!perl -wT
use strict;

use Test::More;

use lib 't';
use TestBounceParser;

# Test an issue reported by Chris Dragon, where a bounce generated by
# the IIS SMTP service generates bounces with 2 "\n"s between
# recipients, causing MBP to only "see" one report.

check_report(
    't/corpus/iis-multiple-bounce.msg',
    is_bounce => 1,
    addresses => [
        qw(bounced1@example.net bounced2@example.net bounced3@example.net bounced4@example.net)
    ]
);

done_testing;

