use 5.010;
use strict;
use warnings;

use Test::More;

BEGIN { use_ok("Lingua::EN::BioLemmatizer", "biolemma") };

# commented out tests below are ones that pass with the proprietary
# BioLexicon loaded, but not otherwise.  The exact parts of speech
# given are also those returned when the BioLexicon is actually loaded,
# so we only compare the base lemma returned, not its POS tag, so that
# people can use this without needing the proprietary database.

my $penn_tags = <<END_OF_PENN_TAGS;

    &/CC > and cc NUPOS
    and/CC > and cc NUPOS

    a/DT > a dt NUPOS
    an/DT > a dt NUPOS

    fed/VBP > feed VBD PennPOS
    led/VBP > lead VBD PennPOS
    bred/VBP > breed VBD PennPOS
    used/VBP > use VBD PennPOS
    added/VBP > add VBD PennPOS
    aimed/VBP > aim VBD PennPOS
    baked/VBP > bake vvn NUPOS
    based/VBP > base vvd NUPOS
    boxed/VBP > box vvn NUPOS
    cited/VBP > cite vvd NUPOS
    dosed/VBP > dose vvd NUPOS
    dried/VBP > dry VBD PennPOS
    famed/VBP > fame vvn NUPOS
    fixed/VBP > fix vvd NUPOS
    freed/VBP > free vvd NUPOS
    gated/VBP > gate VBD PennPOS
    lysed/VBP > lyse VBD PennPOS
    mixed/VBP > mix VBD PennPOS
    muted/VBP > mute VBP PennPOS
    named/VBP > name VBD PennPOS
    noted/VBP > note VBD PennPOS
    sized/VBP > size vvn NUPOS

    walking/VBG > walk VBG PennPOS
    reaffirmed/VBP > reaffirm VBP PennPOS
    leaving/VBG > leave VBG PennPOS
    supplying/VBG > supply VBG PennPOS
    unlisted/VBP > unlist VBP PennPOS
    interpreting/VBG > interpret VBG PennPOS
    sophisticated/VBP > sophisticate VBP PennPOS
    identifying/VBG > identify VBG PennPOS
    linked/VBP > link VBD PennPOS
    hybridizing/VBG > hybridize VBG PennPOS
    compromised/VBP > compromise VBD PennPOS
    metabolizing/VBG > metabolize VBG PennPOS
    querying/VBG > query VBG PennPOS
    diagnosed/VBP > diagnose VBD PennPOS
    stranded/VBP > strand VBD PennPOS
    feeding/VBG > feed VBG PennPOS
    diluted/VBP > dilute VBD PennPOS
    folded/VBP > fold VBD PennPOS
    misaligned/VBP > misalign VBP PennPOS
    specialized/VBP > specialize VBP PennPOS
    unclassified/VBP > unclassify VBP PennPOS
    remaining/VBG > remain VBG PennPOS
    treating/VBG > treat VBG PennPOS
    conferred/VBP > confer VBD PennPOS
  ##ligating/VBG > ligate VBG PennPOS
    ordered/VBP > order VBD PennPOS
    engineered/VBP > engineer VBP PennPOS
    branching/VBG > branch VBG PennPOS
    citrated/VBP > citrate VBP PennPOS
    buffering/VBG > buffer VBG PennPOS
    overexpressed/VBP > overexpress VBD PennPOS
    stopped/VBP > stop VBD PennPOS
    immunosuppressed/VBP > immunosuppress VBP PennPOS
    supporting/VBG > support VBG PennPOS
    depleting/VBG > deplete VBG PennPOS
    developed/VBP > develop VBD PennPOS
    scanning/VBG > scan VBG PennPOS
    termed/VBP > term vvd NUPOS
    measuring/VBG > measure VBG PennPOS
    quenched/VBP > quench VBD PennPOS
    duplicated/VBP > duplicate VBD PennPOS
    annealing/VBG > anneal VBG PennPOS
    tailed/VBP > tail VBP PennPOS
    achieved/VBP > achieve VBD PennPOS
    germinated/VBP > germinate VBD PennPOS
    epoxidizing/VBG > epoxidize VBG PennPOS
    changed/VBP > change VBD PennPOS
    deleted/VBP > delete VBD PennPOS
    lacked/VBP > lack VBD PennPOS
    unexplained/VBP > unexplain VBP PennPOS

    drier/JJR > dry jc NUPOS
  ##fewer/JJR > few JJR PennPOS
    later/JJR > late jc NUPOS
    lower/JJR > low JJR PennPOS
    newer/JJR > new JJR PennPOS
    older/JJR > old JJR PennPOS
    wider/JJR > wide JJR PennPOS
    beater/JJR > beat JJR PennPOS
    bigger/JJR > big JJR PennPOS
  ##closer/JJR > close JJR PennPOS
    deeper/JJR > deep JJR PennPOS
    easier/JJR > easy JJR PennPOS
    faster/JJR > fast JJR PennPOS
    better/JJR > good jc NUPOS
    higher/JJR > high JJR PennPOS
    larger/JJR > large JJR PennPOS
    lesser/JJR > less JJR PennPOS
    longer/JJR > long JJR PennPOS
    nearer/JJR > near JJR PennPOS
    poorer/JJR > poor JJR PennPOS
    slower/JJR > slow JJR PennPOS
    weaker/JJR > weak jc NUPOS
    broader/JJR > broad JJR PennPOS
    earlier/JJR > early JJR PennPOS
  ##greater/JJR > great JJR PennPOS
    manager/JJR > manage JJR PennPOS
    sharper/JJR > sharp jc NUPOS
    shorter/JJR > short JJR PennPOS
  ##smaller/JJR > small JJR PennPOS
    stiffer/JJR > stiff JJR PennPOS
    tighter/JJR > tight jc NUPOS
    brighter/JJR > bright jc NUPOS
    narrower/JJR > narrow jc NUPOS
    stronger/JJR > strong JJR PennPOS
    conformer/JJR > conform JJR PennPOS

    best/JJS > good JJS PennPOS
    least/JJS > little JJS PennPOS
  ##lowest/JJS > low JJS PennPOS
    oldest/JJS > old JJS PennPOS
  ##closest/JJS > close JJS PennPOS
    fastest/JJS > fast JJS PennPOS
    fittest/JJS > fit js NUPOS
    harvest/JJS > harv JJS PennPOS
    highest/JJS > high JJS PennPOS
    largest/JJS > large JJS PennPOS
    longest/JJS > long JJS PennPOS
    nearest/JJS > near JJS PennPOS
  ##earliest/JJS > early JJS PennPOS
  ##greatest/JJS > great JJS PennPOS
    shortest/JJS > short JJS PennPOS
    simplest/JJS > simple js NUPOS
  ##smallest/JJS > small JJS PennPOS
    strongest/JJS > strong JJS PennPOS

    could/MD > can vmd NUPOS
    might/MD > may vmd NUPOS
    would/MD > will vmd NUPOS
    should/MD > shall vmd NUPOS

    arising/VBG > arise VBG PennPOS
    assessing/VBG > assess VBG PennPOS
    beginning/VBG > begin VBG PennPOS
    cannulating/VBG > cannulat VBG PennPOS
    carrying/VBG > carry VBG PennPOS
    cloacae/NN > cloaca NNS PennPOS
    correcting/VBG > correct vvg NUPOS
    denaturing/VBG > denature VBG PennPOS
    detecting/VBG > detect VBG PennPOS
    expanding/VBG > expand VBG PennPOS
    extrapolating/VBG > extrapolate VBG PennPOS
    focusing/VBG > focus VBG PennPOS
    functioning/VBG > function VBG PennPOS
    gassing/VBG > gas VBG PennPOS
    generating/VBG > generate VBG PennPOS
    genosubtyping/VBG > genosubtyp VBG PennPOS
    genotyping/VBG > genotype VBG PennPOS
    hyphae/NN > hypha NNS PennPOS
    incorporating/VBG > incorporate VBG PennPOS
    interrupting/VBG > interrupt VBG PennPOS
    invading/VBG > invade VBG PennPOS
    larvae/NN > larva NNS PennPOS
    leaking/VBG > leak VBG PennPOS
    limiting/VBG > limit VBG PennPOS
    matching/VBG > match VBG PennPOS
    media/NN > medium NNS PennPOS
    missing/VBG > miss vvg NUPOS
    moving/VBG > move VBG PennPOS
    passing/VBG > pass VBG PennPOS
    pipetting/VBG > pipet VBG PennPOS
    presuming/VBG > presume vvg NUPOS
    producing/VBG > produce VBG PennPOS
    promising/VBG > promise VBG PennPOS
    pulling/VBG > pull vvg NUPOS
    recognizing/VBG > recognize VBG PennPOS
    relying/VBG > rely VBG PennPOS
    sabotaging/VBG > sabotage VBG PennPOS
    scaffolding/VBG > scaffold VBG PennPOS
    scrambling/VBG > scramble VBG PennPOS
    screening/VBG > screen VBG PennPOS
    serosubtyping/VBG > serosubtyp VBG PennPOS
    serving/VBG > serve VBG PennPOS
    setting/VBG > set VBG PennPOS
    shadowing/VBG > shadow vvg NUPOS
    subtracting/VBG > subtract VBG PennPOS
    testing/VBG > test VBG PennPOS
    titrating/VBG > titrate VBG PennPOS
    tubing/VBG > tube VBG PennPOS
    updating/VBG > update VBG PennPOS

    acidovorans/NNS > acidovoran NNS PennPOS
    amounts/NNS > amount NNS PennPOS
    antisera/NNS > antiserum NNS PennPOS
    bars/NNS > bar NNS PennPOS
    biologists/NNS > biologist NNS PennPOS
    bovines/NNS > bovine NNS PennPOS
    chimeras/NNS > chimera NNS PennPOS
    chordates/NNS > chordate NNS PennPOS
    cocci/NNS > coccus NNS PennPOS
    considerations/NNS > consideration NNS PennPOS
    constituents/NNS > constituent NNS PennPOS
    coordinates/NNS > coordinate NNS PennPOS
    couplings/NNS > coupling NNS PennPOS
    datasets/NNS > dataset NNS PennPOS
    efficacies/NNS > efficacy NNS PennPOS
    efficiencies/NNS > efficiency NNS PennPOS
    endoprostheses/NNS > endoprosthese NNS PennPOS
    exhibits/NNS > exhibit NNS PennPOS
    exoenzymes/NNS > exoenzyme NNS PennPOS
    extremities/NNS > extremity NNS PennPOS
    fractions/NNS > fraction NNS PennPOS
    habitats/NNS > habitat NNS PennPOS
    hybridizes/NNS > hybridiz NNS PennPOS
    implications/NNS > implication NNS PennPOS
    intricacies/NNS > intricacy n2 NUPOS
    materials/NNS > material NNS PennPOS
    methanogens/NNS > methanogen NNS PennPOS
    microprocessors/NNS > microprocessor NNS PennPOS
    molluscs/NNS > mollusc NNS PennPOS
    nerves/NNS > nerve NNS PennPOS
    ohms/NNS > ohm NNS PennPOS
    peptides/NNS > peptide NNS PennPOS
    phagosomes/NNS > phagosome NNS PennPOS
    physiologies/NNS > physiology NNS PennPOS
    pieces/NNS > piece NNS PennPOS
    polypeptides/NNS > polypeptide NNS PennPOS
    positives/NNS > positive NNS PennPOS
    practitioners/NNS > practitioner NNS PennPOS
    ramifications/NNS > ramification n2 NUPOS
    reducers/NNS > reducer NNS PennPOS
    salinities/NNS > salinity NNS PennPOS
    salts/NNS > salt NNS PennPOS
    scans/NNS > scan NNS PennPOS
    signals/NNS > signal NNS PennPOS
    stems/NNS > stem NNS PennPOS
    sterols/NNS > sterol NNS PennPOS
    stoppers/NNS > stopper NNS PennPOS
    theories/NNS > theory NNS PennPOS
    traits/NNS > trait NNS PennPOS
    variances/NNS > variance NNS PennPOS

    us/PRP > we pno12 NUPOS
    mine/PRP > i png11 NUPOS
    them/PRP > they pno32 NUPOS
    ours/PRP > we png12 NUPOS

    aerobically/RB > aerobic av-j NUPOS
    allosterically/RB > allosteric av-j NUPOS
    alternatively/RB > alternative RB PennPOS
    apically/RB > apical RB PennPOS
    appropriately/RB > appropriate RB PennPOS
    axenically/RB > axenical RB PennPOS
    biologically/RB > biological RB PennPOS
    catalytically/RB > catalytic av-j NUPOS
    causally/RB > causal RB PennPOS
    concurrently/RB > concurrent RB PennPOS
    consecutively/RB > consecutive RB PennPOS
    cyclically/RB > cyclical RB PennPOS
    dependently/RB > dependent RB PennPOS
    developmentally/RB > developmental RB PennPOS
    differentially/RB > differential RB PennPOS
    divergently/RB > divergent RB PennPOS
    enzymatically/RB > enzymatic av-j NUPOS
    evolutionarily/RB > evolutionary RB PennPOS
    expectedly/RB > expected RB PennPOS
    experimentally/RB > experimental RB PennPOS
    graphically/RB > graphical RB PennPOS
    intrinsically/RB > intrinsic av-j NUPOS
    kinetically/RB > kinetic av-j NUPOS
    markedly/RB > marked RB PennPOS
    metabolically/RB > metabolic av-j NUPOS
    morphologically/RB > morphological RB PennPOS
    multiply/RB > multip RB PennPOS
    operationally/RB > operational RB PennPOS
    preferentially/RB > preferential RB PennPOS
    productively/RB > productive RB PennPOS
    reductively/RB > reductive RB PennPOS
    sequentially/RB > sequential RB PennPOS
    serially/RB > serial RB PennPOS
    spectrophotometrically/RB > spectrophotometric av-j NUPOS
    structurally/RB > structural RB PennPOS
    subclinically/RB > subclinical RB PennPOS
    terminally/RB > terminal RB PennPOS
    undisputedly/RB > undisputed RB PennPOS
    uniquely/RB > unique RB PennPOS
    univariately/RB > univariate RB PennPOS

  ##better/RBR > well RBR PennPOS

  ##most/RBS > much RBS PennPOS
    best/RBS > well RBS PennPOS

    wrote/VB > write vvd NUPOS
    outgrew/VB > outgrow VBD PennPOS
    colonise/VB > colonise VBP PennPOS
    degassed/VB > degas VBD PennPOS
    hydrolyze/VB > hydrolyze VBP PennPOS
    solubilize/VB > solubilize VBP PennPOS
    characterise/VB > characterise VBP PennPOS

    abrogated/VBD > abrogate VBD PennPOS
    accomplished/VBD > accomplish vvd NUPOS
    accounted/VBD > account VBD PennPOS
    adjusted/VBD > adjust VBD PennPOS
    annealed/VBD > anneal VBD PennPOS
    assembled/VBD > assemble VBD PennPOS
    boiled/VBD > boil vvd NUPOS
    catalyzed/VBD > catalyze VBD PennPOS
    caused/VBD > cause VBD PennPOS
    coinfected/VBD > coinfect VBD PennPOS
    collected/VBD > collect VBD PennPOS
    colonized/VBD > colonize VBD PennPOS
    considered/VBD > consider VBD PennPOS
    crippled/VBD > cripple vvn NUPOS
    crossed/VBD > cross VBD PennPOS
    detected/VBD > detect VBD PennPOS
    directed/VBD > direct VBD PennPOS
    exploited/VBD > exploit VBD PennPOS
    focused/VBD > focus VBD PennPOS
    grew/VBD > grow VBD PennPOS
    hosted/VBD > host VBD PennPOS
    infected/VBD > infect VBD PennPOS
    influenced/VBD > influence VBD PennPOS
    joined/VBD > join VBD PennPOS
    led/VBD > lead VBD PennPOS
    ligated/VBD > ligate VBD PennPOS
    linked/VBD > link VBD PennPOS
    mutated/VBD > mutate VBD PennPOS
    passed/VBD > pass VBD PennPOS
    possessed/VBD > possess VBD PennPOS
    presented/VBD > present VBD PennPOS
  ##pretreated/VBD > pretreat VBD PennPOS
  ##reconstituted/VBD > reconstitute VBD PennPOS
    reflected/VBD > reflect VBD PennPOS
    refused/VBD > refuse vvd NUPOS
    replaced/VBD > replace VBD PennPOS
    resuspended/VBD > resuspend VBD PennPOS
    scattered/VBD > scatter VBD PennPOS
    started/VBD > start VBD PennPOS
    stimulated/VBD > stimulate VBD PennPOS
    suited/VBD > suit vvd NUPOS
    suspected/VBD > suspect vvd NUPOS
    suspended/VBD > suspend vvd NUPOS
    thought/VBD > think VBD PennPOS
    took/VBD > take VBD PennPOS
    treated/VBD > treat VBD PennPOS
    unexpected/VBD > unexpect VBD PennPOS
    utilized/VBD > utilize VBD PennPOS
    vented/VBD > vent vvd NUPOS
    visualized/VBD > visualize VBD PennPOS

    activating/VBG > activate VBG PennPOS
    allowing/VBG > allow VBG PennPOS
    annealing/VBG > anneal VBG PennPOS
    augmenting/VBG > augment VBG PennPOS
    closing/VBG > close VBG PennPOS
    concerning/VBG > concern VBG PennPOS
    conflicting/VBG > conflict VBG PennPOS
    containing/VBG > contain VBG PennPOS
    declining/VBG > decline VBG PennPOS
    decreasing/VBG > decrease VBG PennPOS
    degrading/VBG > degrade VBG PennPOS
    depicting/VBG > depict vvg NUPOS
    differentiating/VBG > differentiate VBG PennPOS
    exhibiting/VBG > exhibit VBG PennPOS
    exposing/VBG > expose VBG PennPOS
    extending/VBG > extend VBG PennPOS
    footprinting/VBG > footprint VBG PennPOS
    forming/VBG > form VBG PennPOS
    governs/VBG > govern VBZ PennPOS
    growing/VBG > grow VBG PennPOS
    hydrolyzing/VBG > hydrolyze VBG PennPOS
    impairing/VBG > impair VBG PennPOS
    improving/VBG > improve VBG PennPOS
    including/VBG > include VBG PennPOS
    limiting/VBG > limit VBG PennPOS
    missing/VBG > miss vvg NUPOS
    modulating/VBG > modulate VBG PennPOS
    nursing/VBG > nurse VBG PennPOS
    omitting/VBG > omit vvg NUPOS
    oxidizing/VBG > oxidize VBG PennPOS
    poising/VBG > poise vvg NUPOS
    providing/VBG > provide VBG PennPOS
    releasing/VBG > release VBG PennPOS
    removing/VBG > remove VBG PennPOS
    replicating/VBG > replicate VBG PennPOS
    resolving/VBG > resolve VBG PennPOS
    rising/VBG > rise VBG PennPOS
    ruling/VBG > rule VBG PennPOS
    running/VBG > run VBG PennPOS
    scoring/VBG > score VBG PennPOS
    showing/VBG > show VBG PennPOS
    smoking/VBG > smoke VBG PennPOS
    spreading/VBG > spread VBG PennPOS
    stirring/VBG > stir vvg NUPOS
    stretching/VBG > stretch VBG PennPOS
    supporting/VBG > support VBG PennPOS
    taking/VBG > take VBG PennPOS
    training/VBG > train VBG PennPOS
    verifying/VBG > verify VBG PennPOS
    working/VBG > work VBG PennPOS

    accredited/VBN > accredit vvn NUPOS
    allowed/VBN > allow VBN PennPOS
    altered/VBN > alter VBN PennPOS
    applied/VBN > apply VBN PennPOS
    assisted/VBN > assist VBN PennPOS
    autophosphorylated/VBN > autophosphorylate VBN PennPOS
    biotyped/VBN > biotype VBN PennPOS
    buried/VBN > bury VBN PennPOS
    catalysed/VBN > catalyse VBN PennPOS
    cleared/VBN > clear VBN PennPOS
    conducted/VBN > conduct VBN PennPOS
    covered/VBN > cover VBN PennPOS
    credited/VBN > credit vvn NUPOS
    decoupled/VBN > decouple VBN PennPOS
    delayed/VBN > delay VBN PennPOS
    examined/VBN > examine VBN PennPOS
    exploited/VBN > exploit VBN PennPOS
    fed/VBN > feed VBN PennPOS
    ground/VBN > grind vvn NUPOS
    guessed/VBN > guess vvn NUPOS
    illuminated/VBN > illuminate vvn NUPOS
    immobilized/VBN > immobilize VBN PennPOS
    inactivated/VBN > inactivate VBN PennPOS
    indicated/VBN > indicate VBN PennPOS
    ingested/VBN > ingest VBN PennPOS
    interrupted/VBN > interrupt VBN PennPOS
    investigated/VBN > investigate VBN PennPOS
    left/VBN > leave VBN PennPOS
    mimicked/VBN > mimic VBN PennPOS
    missed/VBN > miss vvn NUPOS
    obstructed/VBN > obstruct VBN PennPOS
    overproduced/VBN > overproduce VBN PennPOS
    packed/VBN > pack VBN PennPOS
    plotted/VBN > plot VBN PennPOS
    precipitated/VBN > precipitate VBN PennPOS
    proposed/VBN > propose VBN PennPOS
    reached/VBN > reach VBN PennPOS
    rearranged/VBN > rearrange VBN PennPOS
    recapitulated/VBN > recapitulate vvn NUPOS
    reconstructed/VBN > reconstruct VBN PennPOS
    registered/VBN > register VBN PennPOS
    removed/VBN > remove VBN PennPOS
    retarded/VBN > retard VBN PennPOS
    rotated/VBN > rotate VBN PennPOS
    sized/VBN > size vvn NUPOS
    superimposed/VBN > superimpose VBN PennPOS
    superposed/VBN > superpose VBN PennPOS
    synergized/VBN > synergize VBN PennPOS
    titrated/VBN > titrate VBN PennPOS
    transferred/VBN > transfer VBN PennPOS

    am/VBP > be vbm NUPOS
    are/VBP > be vbb NUPOS
    ate/VBP > eat vvd NUPOS
    bent/VBP > bend VBD PennPOS
  ##fell/VBP > fall VBP PennPOS
    chose/VBP > choose VBD PennPOS
    spans/VBP > span VBZ PennPOS
    wrote/VBP > write vvd NUPOS
    governs/VBP > govern VBZ PennPOS
    colonise/VBP > colonise VBP PennPOS
    decouples/VBP > decouple VBP PennPOS
    hydrolyze/VBP > hydrolyze VBP PennPOS
    synergize/VBP > synergize VBP PennPOS
    solubilize/VBP > solubilize VBP PennPOS
    acidovorans/VBP > acidovoran VBP PennPOS
    strengthens/VBP > strengthen VBZ PennPOS

    alternates/VBZ > alternate VBZ PennPOS
    assumes/VBZ > assume VBZ PennPOS
    attains/VBZ > attain VBZ PennPOS
    causes/VBZ > cause VBZ PennPOS
    coelutes/VBZ > coelute VBZ PennPOS
    cointegrates/VBZ > cointegrate VBZ PennPOS
    colicins/VBZ > colicin VBZ PennPOS
    compensates/VBZ > compensate VBZ PennPOS
    complements/VBZ > complement VBZ PennPOS
    considers/VBZ > consider VBZ PennPOS
    contains/VBZ > contain VBZ PennPOS
    correlates/VBZ > correlate VBZ PennPOS
    disappears/VBZ > disappear VBZ PennPOS
    divergences/VBZ > divergence VBZ PennPOS
    does/VBZ > do vdz NUPOS
    enters/VBZ > enter VBZ PennPOS
    facilitates/VBZ > facilitate VBZ PennPOS
    functions/VBZ > function VBZ PennPOS
    guarantees/VBZ > guarantee VBZ PennPOS
    has/VBZ > have vdz NUPOS
    implicates/VBZ > implicate VBZ PennPOS
    invokes/VBZ > invoke vvz NUPOS
    is/VBZ > be vbz NUPOS
    isolates/VBZ > isolate VBZ PennPOS
    lanes/VBZ > lane VBZ PennPOS
    lends/VBZ > lend vvz NUPOS
    mimics/VBZ > mimic VBZ PennPOS
    overcomes/VBZ > overcome VBZ PennPOS
    overlooks/VBZ > overlook vvz NUPOS
    partners/VBZ > partner VBZ PennPOS
    produces/VBZ > produce VBZ PennPOS
    reaches/VBZ > reach VBZ PennPOS
    recognizes/VBZ > recognize VBZ PennPOS
    reductases/VBZ > reductase VBZ PennPOS
    relates/VBZ > relate VBZ PennPOS
    remains/VBZ > remain VBZ PennPOS
    resides/VBZ > reside VBZ PennPOS
    rounds/VBZ > round vvz NUPOS
    searches/VBZ > search VBZ PennPOS
    selects/VBZ > select VBZ PennPOS
    siderophores/VBZ > siderophore VBZ PennPOS
    slides/VBZ > slide VBZ PennPOS
    spirals/VBZ > spiral VBZ PennPOS
    squares/VBZ > square VBZ PennPOS
    stages/VBZ > stage VBZ PennPOS
    stands/VBZ > stand vvz NUPOS
    stops/VBZ > stop VBZ PennPOS
    succeeds/VBZ > succeed vvz NUPOS
    summarizes/VBZ > summarize VBZ PennPOS
    underlines/VBZ > underline VBZ PennPOS
    vanishes/VBZ > vanish vvz NUPOS
    warrants/VBZ > warrant VBZ PennPOS

END_OF_PENN_TAGS

$penn_tags =~ s/#.*//g;

while ($penn_tags =~ /(\S+)\/([A-Z]+) > (\S+)/g) {
    my($word, $tag, $retval) = ($1, $2, $3);
    my($lemma, $ltag, $ltype) = split " ", biolemma($word, $tag);
    is $lemma, $retval, "Penn tagged: $word/$tag";
} 

done_testing();

__END__
