/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.recognition;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.tika.config.Field;
import org.apache.tika.config.Initializable;
import org.apache.tika.config.InitializableProblemHandler;
import org.apache.tika.config.Param;
import org.apache.tika.exception.TikaConfigException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.captioning.CaptionObject;
import org.apache.tika.parser.recognition.ObjectRecogniser;
import org.apache.tika.parser.recognition.RecognisedObject;
import org.apache.tika.sax.XHTMLContentHandler;
import org.apache.tika.utils.AnnotationUtils;
import org.apache.tika.utils.ServiceLoaderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ObjectRecognitionParser
extends AbstractParser
implements Initializable {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectRecognitionParser.class);
    public static final String MD_KEY_OBJ_REC = "OBJECT";
    public static final String MD_KEY_IMG_CAP = "CAPTION";
    public static final String MD_REC_IMPL_KEY = ObjectRecognitionParser.class.getPackage().getName() + ".object.rec.impl";
    private static final Comparator<RecognisedObject> DESC_CONFIDENCE_SORTER = new Comparator<RecognisedObject>(){

        @Override
        public int compare(RecognisedObject o1, RecognisedObject o2) {
            return Double.compare(o2.getConfidence(), o1.getConfidence());
        }
    };
    private ObjectRecogniser recogniser;

    @Field(name="class")
    public void setRecogniser(String recogniserClass) {
        this.recogniser = (ObjectRecogniser)ServiceLoaderUtils.newInstance(recogniserClass);
    }

    @Override
    public void initialize(Map<String, Param> params) throws TikaConfigException {
        AnnotationUtils.assignFieldParams(this.recogniser, params);
        this.recogniser.initialize(params);
        LOG.info("Recogniser = {}", (Object)this.recogniser.getClass().getName());
        LOG.info("Recogniser Available = {}", (Object)this.recogniser.isAvailable());
    }

    @Override
    public void checkInitialization(InitializableProblemHandler handler) throws TikaConfigException {
    }

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return this.recogniser.isAvailable() ? this.recogniser.getSupportedMimes() : Collections.emptySet();
    }

    @Override
    public synchronized void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        if (!this.recogniser.isAvailable()) {
            LOG.warn("{} is not available for service", (Object)this.recogniser.getClass());
            return;
        }
        metadata.set(MD_REC_IMPL_KEY, this.recogniser.getClass().getName());
        long start = System.currentTimeMillis();
        List<? extends RecognisedObject> objects = this.recogniser.recognise(stream, handler, metadata, context);
        LOG.debug("Found {} objects", (Object)(objects != null ? objects.size() : 0));
        LOG.info("Time taken {}ms", (Object)(System.currentTimeMillis() - start));
        if (objects != null && !objects.isEmpty()) {
            ArrayList<RecognisedObject> acceptedObjects = new ArrayList<RecognisedObject>();
            ArrayList<String> xhtmlIds = new ArrayList<String>();
            String xhtmlStartVal = null;
            int count = 0;
            Collections.sort(objects, DESC_CONFIDENCE_SORTER);
            for (RecognisedObject recognisedObject : objects) {
                String labelAndConfidence;
                if (recognisedObject instanceof CaptionObject) {
                    if (xhtmlStartVal == null) {
                        xhtmlStartVal = "captions";
                    }
                    labelAndConfidence = String.format(Locale.ENGLISH, "%s (%.5f)", recognisedObject.getLabel(), recognisedObject.getConfidence());
                    metadata.add(MD_KEY_IMG_CAP, labelAndConfidence);
                    xhtmlIds.add(String.valueOf(count++));
                } else {
                    if (xhtmlStartVal == null) {
                        xhtmlStartVal = "objects";
                    }
                    labelAndConfidence = String.format(Locale.ENGLISH, "%s (%.5f)", recognisedObject.getLabel(), recognisedObject.getConfidence());
                    metadata.add(MD_KEY_OBJ_REC, labelAndConfidence);
                    xhtmlIds.add(recognisedObject.getId());
                }
                LOG.info("Add {}", (Object)recognisedObject);
                acceptedObjects.add(recognisedObject);
            }
            XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
            xhtml.startDocument();
            xhtml.startElement("ol", "id", xhtmlStartVal);
            count = 0;
            for (RecognisedObject object : acceptedObjects) {
                xhtml.startElement("li", "id", (String)xhtmlIds.get(count++));
                String text = String.format(Locale.ENGLISH, " %s [%s](confidence = %f)", object.getLabel(), object.getLabelLang(), object.getConfidence());
                xhtml.characters(text);
                xhtml.endElement("li");
            }
            xhtml.endElement("ol");
            xhtml.endDocument();
        } else {
            LOG.warn("NO objects");
            metadata.add("no.objects", Boolean.TRUE.toString());
        }
    }
}

