/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.THashSet;
import gnu.trove.TObjectHash;
import gnu.trove.TObjectHashIterator;
import gnu.trove.TObjectProcedure;
import gnu.trove.ToObjectArrayProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class THashSet
extends TObjectHash
implements Set,
Serializable {
    public boolean add(Object obj) {
        int index = this.insertionIndex(obj);
        if (index < 0) {
            return false;
        }
        Object old = this._set[index];
        this._set[index] = obj;
        this.postInsertHook(old == null);
        return true;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Set)) {
            return false;
        }
        Set that = (Set)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.containsAll((Collection)that);
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        Object[] oldSet = this._set;
        this._set = new Object[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldSet[i] == null || oldSet[i] == TObjectHash.REMOVED) continue;
            Object o = oldSet[i];
            int index = this.insertionIndex(o);
            this._set[index] = o;
        }
    }

    public Object[] toArray() {
        Object[] result = new Object[this.size()];
        this.forEach(new ToObjectArrayProcedure(result));
        return result;
    }

    public Object[] toArray(Object[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        this.forEach(new ToObjectArrayProcedure(a));
        Iterator it = this.iterator();
        int i = 0;
        while (i < size) {
            a[i] = it.next();
            ++i;
        }
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    public void clear() {
        super.clear();
        Object[] set = this._set;
        int i = set.length;
        while (i-- > 0) {
            set[i] = null;
        }
    }

    public boolean remove(Object obj) {
        int index = this.index(obj);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    public Iterator iterator() {
        return new TObjectHashIterator(this);
    }

    public boolean containsAll(Collection collection) {
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            if (this.contains(i.next())) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(Collection collection) {
        boolean changed = false;
        int size = collection.size();
        this.ensureCapacity(size);
        Iterator it = collection.iterator();
        while (size-- > 0) {
            if (!this.add(it.next())) continue;
            changed = true;
        }
        return changed;
    }

    public boolean removeAll(Collection collection) {
        boolean changed = false;
        int size = collection.size();
        Iterator it = collection.iterator();
        while (size-- > 0) {
            if (!this.remove(it.next())) continue;
            changed = true;
        }
        return changed;
    }

    public boolean retainAll(Collection collection) {
        boolean changed = false;
        int size = this.size();
        Iterator it = this.iterator();
        while (size-- > 0) {
            if (collection.contains(it.next())) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    private final void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this._size);
        class WriteProcedure
        implements TObjectProcedure {
            IOException e;
            private final /* synthetic */ THashSet this$0;
            private final /* synthetic */ ObjectOutputStream val$stream;

            public boolean execute(Object value) {
                try {
                    this.val$stream.writeObject(value);
                }
                catch (IOException ioe) {
                    this.e = ioe;
                    return false;
                }
                return true;
            }

            /* synthetic */ WriteProcedure(THashSet this$0, ObjectOutputStream val$stream) {
                this.val$stream = val$stream;
                this.this$0 = this$0;
                this.constructor$0(this$0);
            }

            private final void constructor$0(THashSet tHashSet) {
            }
        }
        WriteProcedure writeProcedure = new WriteProcedure(this, stream);
        if (!this.forEach(writeProcedure)) {
            throw writeProcedure.e;
        }
    }

    private final void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size = stream.readInt();
        this.setUp(size);
        while (size-- > 0) {
            Object val = stream.readObject();
            this.add(val);
        }
    }

    public THashSet() {
    }

    public THashSet(int initialCapacity) {
        super(initialCapacity);
    }

    public THashSet(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public THashSet(Collection collection) {
        this(collection.size());
        this.addAll(collection);
    }
}

