#
#
#

use Test::Simple tests => 4;

use Games::Maze;

my $correct_make = 
q(:  :--:--:--:--:--:--:--:--:--:--:--:  
|     |                             |  
:  :  :  :--:--:--:--:--:--:--:--:  :  
|  |  |  |     |     |     |     |  |  
:  :  :  :  :  :  :  :  :  :  :  :  :  
|  |  |  |  |  |  |  |  |  |  |  |  |  
:  :  :  :  :  :  :  :  :  :  :  :  :  
|  |  |  |  |  |  |  |  |  |  |  |  |  
:  :  :  :  :  :  :  :  :  :  :  :  :  
|  |  |  |  |  |  |  |  |  |  |  |  |  
:  :  :  :  :  :  :  :  :  :  :  :  :  
|  |  |  |  |  |  |  |  |  |  |  |  |  
:--:  :  :  :  :  :  :  :  :  :  :  :  
|f    |     |     |     |     |  |f |  
:--:--:--:--:--:--:--:--:--:--:--:--:  

:--:--:--:--:--:--:--:--:--:--:--:--:  
|     |     |     |     |     |     |  
:  :  :  :  :  :  :  :  :  :  :  :  :  
|  |  |  |  |  |  |  |  |  |  |  |  |  
:  :  :  :  :  :  :  :  :  :  :  :  :  
|  |  |  |  |  |  |  |  |  |  |  |  |  
:  :  :  :  :  :  :  :  :  :  :  :  :  
|  |  |  |  |  |  |  |  |  |  |  |  |  
:  :  :  :  :  :  :  :  :  :  :  :  :  
|  |  |  |  |  |  |  |  |  |  |  |  |  
:  :  :  :  :  :  :  :  :  :  :  :  :  
|  |  |  |  |  |  |  |  |  |  |  |  |  
:  :  :  :  :  :  :  :  :  :  :  :  :  
|b |     |     |     |     |     |c |  
:--:--:--:--:--:--:--:--:--:--:--:--:  

:--:--:--:--:--:--:--:--:--:--:--:--:  
|     |     |     |     |     |     |  
:  :  :  :  :  :  :  :  :  :  :  :  :  
|  |  |  |  |  |  |  |  |  |  |  |  |  
:  :  :  :  :  :  :  :  :  :  :  :  :  
|  |  |  |  |  |  |  |  |  |  |  |  |  
:  :  :  :  :  :  :  :  :  :  :  :  :  
|  |  |  |  |  |  |  |  |  |  |  |  |  
:  :  :  :  :  :  :  :  :  :  :  :  :  
|  |  |  |  |  |  |  |  |  |  |  |  |  
:  :  :  :  :  :  :  :  :  :  :  :  :  
|  |  |  |  |  |  |  |  |  |  |  |  |  
:  :  :  :  :  :  :  :  :  :  :  :  :  
|c |     |     |     |     |     |  |  
:--:--:--:--:--:--:--:--:--:--:--:  :  
);

my $correct_solve = 
q(:  :--:--:--:--:--:--:--:--:--:--:--:  
| *  *|                             |  
:  :  :  :--:--:--:--:--:--:--:--:  :  
|  | *|  |     |     |     |     |  |  
:  :  :  :  :  :  :  :  :  :  :  :  :  
|  | *|  |  |  |  |  |  |  |  |  |  |  
:  :  :  :  :  :  :  :  :  :  :  :  :  
|  | *|  |  |  |  |  |  |  |  |  |  |  
:  :  :  :  :  :  :  :  :  :  :  :  :  
|  | *|  |  |  |  |  |  |  |  |  |  |  
:  :  :  :  :  :  :  :  :  :  :  :  :  
|  | *|  |  |  |  |  |  |  |  |  |  |  
:--:  :  :  :  :  :  :  :  :  :  :  :  
|f*  *|     |     |     |     |  |f |  
:--:--:--:--:--:--:--:--:--:--:--:--:  

:--:--:--:--:--:--:--:--:--:--:--:--:  
|     |     |     |     |     |     |  
:  :  :  :  :  :  :  :  :  :  :  :  :  
|  |  |  |  |  |  |  |  |  |  |  |  |  
:  :  :  :  :  :  :  :  :  :  :  :  :  
|  |  |  |  |  |  |  |  |  |  |  |  |  
:  :  :  :  :  :  :  :  :  :  :  :  :  
|  |  |  |  |  |  |  |  |  |  |  |  |  
:  :  :  :  :  :  :  :  :  :  :  :  :  
|  |  |  |  |  |  |  |  |  |  |  |  |  
:  :  :  :  :  :  :  :  :  :  :  :  :  
|  |  |  |  |  |  |  |  |  |  |  |  |  
:  :  :  :  :  :  :  :  :  :  :  :  :  
|b*|     |     |     |     |     |c |  
:--:--:--:--:--:--:--:--:--:--:--:--:  

:--:--:--:--:--:--:--:--:--:--:--:--:  
| *  *| *  *| *  *| *  *| *  *| *  *|  
:  :  :  :  :  :  :  :  :  :  :  :  :  
| *| *| *| *| *| *| *| *| *| *| *| *|  
:  :  :  :  :  :  :  :  :  :  :  :  :  
| *| *| *| *| *| *| *| *| *| *| *| *|  
:  :  :  :  :  :  :  :  :  :  :  :  :  
| *| *| *| *| *| *| *| *| *| *| *| *|  
:  :  :  :  :  :  :  :  :  :  :  :  :  
| *| *| *| *| *| *| *| *| *| *| *| *|  
:  :  :  :  :  :  :  :  :  :  :  :  :  
| *| *| *| *| *| *| *| *| *| *| *| *|  
:  :  :  :  :  :  :  :  :  :  :  :  :  
|c*| *  *| *  *| *  *| *  *| *  *| *|  
:--:--:--:--:--:--:--:--:--:--:--:  :  
);

my $correct_hex =
q( 0085 00a5 0085 0085 0085 0085 0085 0085 0085 0085 0085 0085 0085 00a5
 00a5 80a1 8024 00a0 0084 0084 0084 0084 0084 0084 0084 0084 0024 00a1
 00a5 0021 8021 0021 00a0 0024 00a0 0024 00a0 0024 00a0 0024 0021 00a1
 00a5 0021 8021 0021 0021 0021 0021 0021 0021 0021 0021 0021 0021 00a1
 00a5 0021 8021 0021 0021 0021 0021 0021 0021 0021 0021 0021 0021 00a1
 00a5 0021 8021 0021 0021 0021 0021 0021 0021 0021 0021 0021 0021 00a1
 00a5 0001 8021 0021 0021 0021 0021 0021 0021 0021 0021 0021 0021 00a1
 00a5 8280 8005 0081 0005 0081 0005 0081 0005 0081 0005 0001 0201 00a1
 00a5 00a5 00a5 00a5 00a5 00a5 00a5 00a5 00a5 00a5 00a5 00a5 00a5 00a5

 0085 0085 0085 0085 0085 0085 0085 0085 0085 0085 0085 0085 0085 00a5
 00a5 00a0 0024 00a0 0024 00a0 0024 00a0 0024 00a0 0024 00a0 0024 00a1
 00a5 0021 0021 0021 0021 0021 0021 0021 0021 0021 0021 0021 0021 00a1
 00a5 0021 0021 0021 0021 0021 0021 0021 0021 0021 0021 0021 0021 00a1
 00a5 0021 0021 0021 0021 0021 0021 0021 0021 0021 0021 0021 0021 00a1
 00a5 0021 0021 0021 0021 0021 0021 0021 0021 0021 0021 0021 0021 00a1
 00a5 0021 0021 0021 0021 0021 0021 0021 0021 0021 0021 0021 0021 00a1
 00a5 8211 0081 0005 0081 0005 0081 0005 0081 0005 0081 0005 0011 00a1
 00a5 00a5 00a5 00a5 00a5 00a5 00a5 00a5 00a5 00a5 00a5 00a5 00a5 00a5

 0085 0085 0085 0085 0085 0085 0085 0085 0085 0085 0085 0085 0085 00a5
 00a5 80a0 8024 80a0 8024 80a0 8024 80a0 8024 80a0 8024 80a0 8024 00a1
 00a5 8021 8021 8021 8021 8021 8021 8021 8021 8021 8021 8021 8021 00a1
 00a5 8021 8021 8021 8021 8021 8021 8021 8021 8021 8021 8021 8021 00a1
 00a5 8021 8021 8021 8021 8021 8021 8021 8021 8021 8021 8021 8021 00a1
 00a5 8021 8021 8021 8021 8021 8021 8021 8021 8021 8021 8021 8021 00a1
 00a5 8021 8021 8021 8021 8021 8021 8021 8021 8021 8021 8021 8021 00a1
 00a5 8011 8081 8005 8081 8005 8081 8005 8081 8005 8081 8005 8021 00a1
 00a5 00a5 00a5 00a5 00a5 00a5 00a5 00a5 00a5 00a5 00a5 00a5 00a5 00a5
);

my $minos = Games::Maze->new(
		dimensions => [12, 7, 3],
		entry => [1,1,1], exit => [12,7,3],
		start => [1,6,1], fn_choosedir => \&first_dir
		);

$minos->make();
my $maze_form = $minos->to_ascii();
ok(($maze_form eq $correct_make), "->make() check");

$minos->solve();
$maze_form = $minos->to_ascii();
ok(($maze_form eq $correct_solve), "->solve() check");

$maze_form = $minos->to_hex_dump();
ok(($maze_form eq $correct_hex), "->to_hex_dump() check");

$minos->unsolve();
$maze_form = $minos->to_ascii();
ok(($maze_form eq $correct_make), "->unsolve() check");

exit(0);

sub first_dir
{
	return ${$_[0]}[0];
}
