package File::Path;
use Carp;
use File::Basename();
use DirHandle();
use Exporter();
use strict;
use vars qw( $VERSION @ISA @EXPORT );
$VERSION = "1.0401";
@ISA=qw( Exporter );
@EXPORT=qw( mkpath rmtree );
my$Is_VMS=$^O eq 'VMS';
my$force_writeable=($^O eq 'os2'||$^O eq 'dos'||$^O eq 'MSWin32'||$^O eq 'amigaos');
sub mkpath{my($paths,$verbose,$mode)=@_;
local($")="/";
$mode=0777 unless defined($mode);
$paths=[$paths]unless ref$paths;
my(@created,$path);
foreach$path(@$paths){$path.='/' if$^O eq 'os2' and$path=~/^\w:$/;
next if-d$path;
$path=VMS::Filespec::unixify($path)if$Is_VMS;
my$parent=File::Basename::dirname($path);
if(not$Is_VMS or$parent!~m:/[^/]+/000000/?:){push(@created,mkpath($parent,$verbose,$mode))unless(-d$parent);}print"mkdir $path\n" if$verbose;
unless(mkdir($path,$mode)){my$e=$!;
croak"mkdir $path: $e" unless-d$path;}push(@created,$path);}@created;}sub rmtree{my($roots,$verbose,$safe)=@_;
my(@files);
my($count)=0;
$roots=[$roots]unless ref$roots;
$verbose||=0;
$safe||=0;
my($root);
foreach$root(@{$roots}){$root=~s#/$##;
(undef,undef,my$rp)=lstat$root or next;
$rp&=07777;
if(-d _){chmod(0777,($Is_VMS?VMS::Filespec::fileify($root):$root))or carp"Can't make directory $root read+writeable: $!" unless$safe;
my$d=DirHandle->new($root)or carp"Can't read $root: $!";
@files=$d->read;
$d->close;
@files=reverse@files if$Is_VMS;
($root=VMS::Filespec::unixify($root))=~s#\.dir$## if$Is_VMS;
@files=map("$root/$_",grep$_!~/^\.{1,2}$/,@files);
$count+=rmtree(\@files,$verbose,$safe);
if($safe&&($Is_VMS?!&VMS::Filespec::candelete($root):!-w$root)){print"skipped $root\n" if$verbose;
next;}chmod 0777,$root or carp"Can't make directory $root writeable: $!" if$force_writeable;
print"rmdir $root\n" if$verbose;
if(rmdir$root){++$count;}else{carp"Can't remove directory $root: $!";
chmod($rp,($Is_VMS?VMS::Filespec::fileify($root):$root))or carp("and can't restore permissions to ".sprintf("0%o",$rp)."\n");}}else{if($safe&&($Is_VMS?!&VMS::Filespec::candelete($root):!-w$root)){print"skipped $root\n" if$verbose;
next;}chmod 0666,$root or carp"Can't make file $root writeable: $!" if$force_writeable;
print"unlink $root\n" if$verbose;
for(;;){unless(unlink$root){carp"Can't unlink file $root: $!";
if($force_writeable){chmod$rp,$root or carp("and can't restore permissions to ".sprintf("0%o",$rp)."\n");}last;} ++$count;
last unless$Is_VMS&&lstat$root;}}}$count;}1;
