package Google::Ads::AdWords::v201306::OperationStream;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201306' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %scopingEntityId_of :ATTR(:get<scopingEntityId>);
my %operations_of :ATTR(:get<operations>);

__PACKAGE__->_factory(
    [ qw(        scopingEntityId
        operations

    ) ],
    {
        'scopingEntityId' => \%scopingEntityId_of,
        'operations' => \%operations_of,
    },
    {
        'scopingEntityId' => 'Google::Ads::AdWords::v201306::EntityId',
        'operations' => 'Google::Ads::AdWords::v201306::Operation',
    },
    {

        'scopingEntityId' => 'scopingEntityId',
        'operations' => 'operations',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201306::OperationStream

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
OperationStream from the namespace https://adwords.google.com/api/adwords/cm/v201306.

A stream of AdWords API mutate operations that must be performed serially. Further, this operation stream must be processed serially with all other operation streams in a bulk mutate job that specify the same scoping entity. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * scopingEntityId


=item * operations




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

