#!/usr/bin/perl

package eBay::API::XML::DataType::ContextSearchAssetType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ContextSearchAssetType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::ContextSearchAssetType

=head1 DESCRIPTION

Score and rank for a keyword identified for a web page.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::ContextSearchAssetType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::CategoryType;


my @gaProperties = ( [ 'Category', 'ns:CategoryType', ''
	     ,'eBay::API::XML::DataType::CategoryType', '1' ]
	, [ 'Keyword', 'xs:string', '', '', '' ]
	, [ 'Ranking', 'xs:int', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setCategory()

The eBay category in which the keyword is used.

#    Argument: 'ns:CategoryType'

=cut

sub setCategory {
  my $self = shift;
  $self->{'Category'} = shift
}

=head2 getCategory()

  Calls: GetContextualKeywords
  Returned: Always

#    Returns: 'ns:CategoryType'

=cut

sub getCategory {
  my $self = shift;
  return $self->_getDataTypeInstance( 'Category'
		,'eBay::API::XML::DataType::CategoryType');
}


=head2 setKeyword()

The keyword.

MaxLength: 64

#    Argument: 'xs:string'

=cut

sub setKeyword {
  my $self = shift;
  $self->{'Keyword'} = shift
}

=head2 getKeyword()

  Calls: GetContextualKeywords
  Returned: Always

#    Returns: 'xs:string'

=cut

sub getKeyword {
  my $self = shift;
  return $self->{'Keyword'};
}


=head2 setRanking()

The ranking of this keyword and category relative to
other keywords and categories (when scores are sorted).

Max: 2147483647
Min: 1

#    Argument: 'xs:int'

=cut

sub setRanking {
  my $self = shift;
  $self->{'Ranking'} = shift
}

=head2 getRanking()

  Calls: GetContextualKeywords
  Returned: Always

#    Returns: 'xs:int'

=cut

sub getRanking {
  my $self = shift;
  return $self->{'Ranking'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
