# Generated by default/object.tt
package Paws::AccessAnalyzer::PolicyGeneration;
  use Moose;
  has CompletedOn => (is => 'ro', isa => 'Str', request_name => 'completedOn', traits => ['NameInRequest']);
  has JobId => (is => 'ro', isa => 'Str', request_name => 'jobId', traits => ['NameInRequest'], required => 1);
  has PrincipalArn => (is => 'ro', isa => 'Str', request_name => 'principalArn', traits => ['NameInRequest'], required => 1);
  has StartedOn => (is => 'ro', isa => 'Str', request_name => 'startedOn', traits => ['NameInRequest'], required => 1);
  has Status => (is => 'ro', isa => 'Str', request_name => 'status', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AccessAnalyzer::PolicyGeneration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AccessAnalyzer::PolicyGeneration object:

  $service_obj->Method(Att1 => { CompletedOn => $value, ..., Status => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AccessAnalyzer::PolicyGeneration object:

  $result = $service_obj->Method(...);
  $result->Att1->CompletedOn

=head1 DESCRIPTION

Contains details about the policy generation status and properties.

=head1 ATTRIBUTES


=head2 CompletedOn => Str

A timestamp of when the policy generation was completed.


=head2 B<REQUIRED> JobId => Str

The C<JobId> that is returned by the C<StartPolicyGeneration>
operation. The C<JobId> can be used with C<GetGeneratedPolicy> to
retrieve the generated policies or used with C<CancelPolicyGeneration>
to cancel the policy generation request.


=head2 B<REQUIRED> PrincipalArn => Str

The ARN of the IAM entity (user or role) for which you are generating a
policy.


=head2 B<REQUIRED> StartedOn => Str

A timestamp of when the policy generation started.


=head2 B<REQUIRED> Status => Str

The status of the policy generation request.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AccessAnalyzer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

