/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph;

import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.geom.Box;
import net.sourceforge.plantuml.geom.LineSegmentInt;
import net.sourceforge.plantuml.geom.PolylineBreakeable;

public class GeneralPathFactory {
    private final LinkType linkType;

    public GeneralPathFactory(LinkType linkType) {
        this.linkType = linkType;
    }

    public Shape getLink(PolylineBreakeable polylineBreakeable, Box box, Box box2) {
        LineSegmentInt lineSegmentInt = new LineSegmentInt(box.getCenterX(), box.getCenterY(), box2.getCenterX(), box2.getCenterY());
        assert (box.intersect(lineSegmentInt).length == 1);
        assert (box2.intersect(lineSegmentInt).length == 1);
        GeneralPath generalPath = polylineBreakeable.asGeneralPath();
        return generalPath;
    }

    private void addSymbol(GeneralPath generalPath, Point2D.Double double_, LineSegmentInt lineSegmentInt, Point2D.Double double_2, LineSegmentInt lineSegmentInt2) {
    }

    private void addSymbolDiamond(GeneralPath generalPath, Point2D.Double double_, LineSegmentInt lineSegmentInt) {
        Polygon polygon = new Polygon();
        polygon.addPoint(0, 0);
        polygon.addPoint(-10, 6);
        polygon.addPoint(-20, 0);
        polygon.addPoint(-10, -6);
        this.appendAndRotate(generalPath, double_, lineSegmentInt, polygon);
    }

    private void addSymbolDiamondInv(GeneralPath generalPath, Point2D.Double double_, LineSegmentInt lineSegmentInt) {
        Polygon polygon = new Polygon();
        polygon.addPoint(0, 0);
        polygon.addPoint(10, 6);
        polygon.addPoint(20, 0);
        polygon.addPoint(10, -6);
        this.appendAndRotate(generalPath, double_, lineSegmentInt, polygon);
    }

    private void addSymbolNavasocInv(GeneralPath generalPath, Point2D.Double double_, LineSegmentInt lineSegmentInt) {
        Polygon polygon = new Polygon();
        polygon.addPoint(0, 0);
        polygon.addPoint(13, -8);
        polygon.addPoint(6, 0);
        polygon.addPoint(13, 8);
        this.appendAndRotate(generalPath, double_, lineSegmentInt, polygon);
    }

    private void addSymbolNavasoc(GeneralPath generalPath, Point2D.Double double_, LineSegmentInt lineSegmentInt) {
        Polygon polygon = new Polygon();
        polygon.addPoint(0, 0);
        polygon.addPoint(-13, -8);
        polygon.addPoint(-6, 0);
        polygon.addPoint(-13, 8);
        this.appendAndRotate(generalPath, double_, lineSegmentInt, polygon);
    }

    private void addSymbolExtends(GeneralPath generalPath, Point2D.Double double_, LineSegmentInt lineSegmentInt) {
        Polygon polygon = new Polygon();
        polygon.addPoint(0, 0);
        polygon.addPoint(25, 7);
        polygon.addPoint(25, -7);
        this.appendAndRotate(generalPath, double_, lineSegmentInt, polygon);
    }

    private void addSymbolExtendsInv(GeneralPath generalPath, Point2D.Double double_, LineSegmentInt lineSegmentInt) {
        Polygon polygon = new Polygon();
        polygon.addPoint(0, 0);
        polygon.addPoint(-25, 7);
        polygon.addPoint(-25, -7);
        this.appendAndRotate(generalPath, double_, lineSegmentInt, polygon);
    }

    private void appendAndRotate(GeneralPath generalPath, Point2D.Double double_, LineSegmentInt lineSegmentInt, Shape shape) {
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(double_.x, double_.y);
        double d = lineSegmentInt.getAngle();
        affineTransform.rotate(d);
        Shape shape2 = affineTransform.createTransformedShape(shape);
        generalPath.append(shape2, false);
    }
}

