/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.functions.Count;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.wrapper.VirtualNode;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.HexBinaryValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SingletonItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Value<T extends Item>
implements ValueRepresentation<T> {
    public static final int INDETERMINATE_ORDERING = Integer.MIN_VALUE;

    public static <T extends Item> Value<T> asValue(ValueRepresentation<T> val) {
        if (val instanceof Value) {
            return (Value)val;
        }
        return new SingletonItem<Item>((Item)val);
    }

    public static int getSequenceLength(ValueRepresentation val) throws XPathException {
        if (val instanceof Value) {
            return ((Value)val).getLength();
        }
        return 1;
    }

    public static Item asItem(ValueRepresentation value) throws XPathException {
        if (value instanceof Item) {
            return (Item)value;
        }
        return ((Value)value).asItem();
    }

    public Item asItem() throws XPathException {
        SequenceIterator<T> iter = this.iterate();
        T item = iter.next();
        if (item == null) {
            return null;
        }
        if (iter.next() != null) {
            throw new XPathException("Attempting to access a sequence as a singleton item");
        }
        return item;
    }

    public static Value fromItem(Item item) {
        if (item == null) {
            return EmptySequence.getInstance();
        }
        if (item instanceof AtomicValue) {
            return (AtomicValue)item;
        }
        return new SingletonItem<Item>(item);
    }

    public static <T extends Item> SequenceIterator<T> asIterator(ValueRepresentation<T> val) throws XPathException {
        if (val instanceof Value) {
            return ((Value)val).iterate();
        }
        return SingletonIterator.makeIterator((Item)val);
    }

    public static SequenceIterator getIterator(ValueRepresentation val) throws XPathException {
        if (val instanceof Value) {
            return ((Value)val).iterate();
        }
        return SingletonIterator.makeIterator((Item)val);
    }

    public abstract SequenceIterator<T> iterate() throws XPathException;

    @Override
    public CharSequence getStringValueCS() throws XPathException {
        return this.getStringValue();
    }

    public CharSequence getCanonicalLexicalRepresentation() {
        try {
            return this.getStringValueCS();
        }
        catch (XPathException err) {
            throw new IllegalStateException("Failed to get canonical lexical representation: " + err.getMessage());
        }
    }

    public ItemType getItemType(TypeHierarchy th) {
        return AnyItemType.getInstance();
    }

    public int getCardinality() {
        try {
            SequenceIterator<T> iter = this.iterate();
            T next = iter.next();
            if (next == null) {
                return 8192;
            }
            if (iter.next() != null) {
                return 49152;
            }
            return 16384;
        }
        catch (XPathException err) {
            return 57344;
        }
    }

    public T itemAt(int n) throws XPathException {
        T item;
        if (n < 0) {
            return null;
        }
        int i = 0;
        SequenceIterator<T> iter = this.iterate();
        do {
            if ((item = iter.next()) != null) continue;
            return null;
        } while (i++ != n);
        return item;
    }

    public int getLength() throws XPathException {
        return Count.count(this.iterate());
    }

    public void process(XPathContext context) throws XPathException {
        T it;
        SequenceIterator<T> iter = this.iterate();
        SequenceReceiver out = context.getReceiver();
        while ((it = iter.next()) != null) {
            out.append((Item)it, 0, 2);
        }
    }

    @Override
    public String getStringValue() throws XPathException {
        FastStringBuffer sb = new FastStringBuffer(64);
        SequenceIterator<T> iter = this.iterate();
        T item = iter.next();
        if (item != null) {
            while (true) {
                sb.append(item.getStringValueCS());
                item = iter.next();
                if (item == null) break;
                sb.append(' ');
            }
        }
        return sb.toString();
    }

    public boolean effectiveBooleanValue() throws XPathException {
        return ExpressionTool.effectiveBooleanValue(this.iterate());
    }

    public Comparable getSchemaComparable() {
        return new ValueSchemaComparable();
    }

    public boolean equals(Object obj) {
        throw new UnsupportedOperationException("Value.equals()");
    }

    public int hashCode() {
        return 42;
    }

    public boolean isIdentical(Value v) {
        try {
            T m1;
            T m0;
            boolean a1;
            boolean a0;
            SequenceIterator<T> i0 = this.iterate();
            SequenceIterator<T> i1 = v.iterate();
            do {
                m0 = i0.next();
                m1 = i1.next();
                if (m0 == null && m1 == null) {
                    return true;
                }
                if (m0 == null || m1 == null) {
                    return false;
                }
                boolean n0 = m0 instanceof NodeInfo;
                boolean n1 = m1 instanceof NodeInfo;
                if (n0 != n1) {
                    return false;
                }
                if (n0 && n1 && !((NodeInfo)m0).isSameNodeInfo((NodeInfo)m1)) {
                    return false;
                }
                a0 = m0 instanceof AtomicValue;
                a1 = m1 instanceof AtomicValue;
                if (!a0 || !a1 || ((AtomicValue)m0).isIdentical((AtomicValue)m1)) continue;
                return false;
            } while (a0 && a1 || m0 == m1);
            return false;
        }
        catch (XPathException err) {
            return false;
        }
    }

    public void checkPermittedContents(SchemaType parentType, StaticContext env, boolean whole) throws XPathException {
    }

    public Value reduce() throws XPathException {
        return this;
    }

    public static Object convertToJava(Item item) throws XPathException {
        if (item instanceof NodeInfo) {
            Object node = item;
            while (node instanceof VirtualNode) {
                node = ((VirtualNode)node).getRealNode();
            }
            return node;
        }
        if (item instanceof FunctionItem) {
            return item;
        }
        if (item instanceof ObjectValue) {
            return ((ObjectValue)item).getObject();
        }
        AtomicValue value = (AtomicValue)item;
        switch (value.getItemType(null).getPrimitiveType()) {
            case 513: 
            case 518: 
            case 529: 
            case 631: {
                return value.getStringValue();
            }
            case 514: {
                return ((BooleanValue)value).getBooleanValue() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 515: {
                return ((DecimalValue)value).getDecimalValue();
            }
            case 533: {
                return ((NumericValue)value).longValue();
            }
            case 517: {
                return ((DoubleValue)value).getDoubleValue();
            }
            case 516: {
                return Float.valueOf(((FloatValue)value).getFloatValue());
            }
            case 519: {
                return ((DateTimeValue)value).getCalendar().getTime();
            }
            case 521: {
                return ((DateValue)value).getCalendar().getTime();
            }
            case 520: {
                return value.getStringValue();
            }
            case 528: {
                return ((Base64BinaryValue)value).getBinaryValue();
            }
            case 527: {
                return ((HexBinaryValue)value).getBinaryValue();
            }
        }
        return item;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValueSchemaComparable
    implements Comparable<ValueSchemaComparable> {
        private ValueSchemaComparable() {
        }

        public Value getValue() {
            return Value.this;
        }

        @Override
        public int compareTo(ValueSchemaComparable obj) {
            try {
                Object item2;
                Object item1;
                int c;
                SequenceIterator iter1 = this.getValue().iterate();
                SequenceIterator iter2 = obj.getValue().iterate();
                do {
                    item1 = iter1.next();
                    item2 = iter2.next();
                    if (item1 == null && item2 == null) {
                        return 0;
                    }
                    if (item1 == null) {
                        return -1;
                    }
                    if (item2 == null) {
                        return 1;
                    }
                    if (item1 instanceof AtomicValue && item2 instanceof AtomicValue) continue;
                    throw new UnsupportedOperationException("Sequences containing nodes or function items are not schema-comparable");
                } while ((c = ((AtomicValue)item1).getSchemaComparable().compareTo(((AtomicValue)item2).getSchemaComparable())) == 0);
                return c;
            }
            catch (XPathException e) {
                throw new AssertionError((Object)("Failure comparing schema values: " + e.getMessage()));
            }
        }

        public boolean equals(Object obj) {
            return ValueSchemaComparable.class.isAssignableFrom(obj.getClass()) && this.compareTo((ValueSchemaComparable)obj) == 0;
        }

        public int hashCode() {
            try {
                int hash = 107189858;
                SequenceIterator iter = this.getValue().iterate();
                while (true) {
                    Object item;
                    if ((item = iter.next()) == null) {
                        return hash;
                    }
                    if (!(item instanceof AtomicValue)) continue;
                    hash ^= ((AtomicValue)item).getSchemaComparable().hashCode();
                }
            }
            catch (XPathException e) {
                return 0;
            }
        }
    }
}

