/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Value;

public final class ShareableSequence
extends Value {
    private List list;
    private int end;
    private ItemType itemType = null;

    public ShareableSequence(List list) {
        this.list = list;
        this.end = list.size();
    }

    public static ShareableSequence makeShareableSequence(Value baseVal, SequenceIterator iter) throws XPathException {
        Object i;
        if (baseVal instanceof ShareableSequence && ((ShareableSequence)baseVal).isShareable()) {
            Object i2;
            List list = ((ShareableSequence)baseVal).getList();
            while ((i2 = iter.next()) != null) {
                list.add(i2);
            }
            return new ShareableSequence(list);
        }
        ArrayList list = new ArrayList(20);
        SequenceIterator baseIter = baseVal.iterate();
        while ((i = baseIter.next()) != null) {
            list.add(i);
        }
        while ((i = iter.next()) != null) {
            list.add(i);
        }
        return new ShareableSequence(list);
    }

    public boolean isShareable() {
        return this.list.size() == this.end;
    }

    public List getList() {
        return this.list;
    }

    public Value simplify() {
        int n = this.getLength();
        if (n == 0) {
            return EmptySequence.getInstance();
        }
        if (n == 1) {
            return Value.asValue(this.itemAt(0));
        }
        return this;
    }

    public Value reduce() {
        return this.simplify();
    }

    public int getLength() {
        return this.end;
    }

    public int getCardinality() {
        switch (this.end) {
            case 0: {
                return 8192;
            }
            case 1: {
                return 16384;
            }
        }
        return 49152;
    }

    public ItemType getItemType(TypeHierarchy th) {
        if (this.itemType != null) {
            return this.itemType;
        }
        if (this.end == 0) {
            this.itemType = AnyItemType.getInstance();
        } else if (th == null) {
            int i;
            for (i = 0; i < this.end; ++i) {
                if (!(this.itemAt(i) instanceof NodeInfo)) continue;
                return this.getItemType(((NodeInfo)this.itemAt(i)).getConfiguration().getTypeHierarchy());
            }
            this.itemType = Type.getItemType(this.itemAt(0), null);
            for (i = 1; i < this.end; ++i) {
                if (this.itemType == AnyItemType.getInstance()) {
                    return this.itemType;
                }
                this.itemType = Type.getCommonSuperType(this.itemType, Type.getItemType(this.itemAt(i), th));
            }
        } else {
            this.itemType = Type.getItemType(this.itemAt(0), th);
            for (int i = 1; i < this.end; ++i) {
                if (this.itemType == AnyItemType.getInstance()) {
                    return this.itemType;
                }
                this.itemType = Type.getCommonSuperType(this.itemType, Type.getItemType(this.itemAt(i), th), th);
            }
        }
        return this.itemType;
    }

    public Item itemAt(int n) {
        if (n < 0 || n >= this.getLength()) {
            return null;
        }
        return (Item)this.list.get(n);
    }

    public SequenceIterator iterate() {
        return new ListIterator(this.list, this.end);
    }

    public boolean effectiveBooleanValue() throws XPathException {
        int len = this.getLength();
        if (len == 0) {
            return false;
        }
        if (this.itemAt(0) instanceof NodeInfo) {
            return true;
        }
        if (len > 1) {
            return ExpressionTool.effectiveBooleanValue(this.iterate());
        }
        return ((AtomicValue)this.itemAt(0)).effectiveBooleanValue();
    }

    public String toString() {
        FastStringBuffer fsb = new FastStringBuffer(64);
        fsb.append('(');
        for (int i = 0; i < this.end; ++i) {
            fsb.append(this.list.get(i).toString());
            if (i == this.end - 1) continue;
            fsb.append(", ");
        }
        fsb.append(')');
        return fsb.toString();
    }
}

