/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.Iterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.LocalParam;
import net.sf.saxon.expr.instruct.LocalParamSetter;
import net.sf.saxon.expr.instruct.Procedure;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.TailCallReturner;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.RuleTarget;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;

public class Template
extends Procedure
implements RuleTarget {
    private Pattern matchPattern;
    private StructuredQName templateName;
    private boolean hasRequiredParams;
    private boolean bodyIsTailCallReturner;
    private SequenceType requiredType;
    private boolean streamable;

    public Template() {
        this.setHostLanguage(50);
    }

    public void setTemplateName(StructuredQName templateName) {
        this.templateName = templateName;
    }

    public void setMatchPattern(Pattern pattern) {
        this.matchPattern = pattern;
    }

    public Pattern getMatchPattern() {
        return this.matchPattern;
    }

    public void setBody(Expression body) {
        super.setBody(body);
        this.bodyIsTailCallReturner = body instanceof TailCallReturner;
    }

    public StructuredQName getTemplateName() {
        return this.templateName;
    }

    public StructuredQName getObjectName() {
        return this.templateName;
    }

    public void setHasRequiredParams(boolean has) {
        this.hasRequiredParams = has;
    }

    public boolean hasRequiredParams() {
        return this.hasRequiredParams;
    }

    public void setRequiredType(SequenceType type) {
        this.requiredType = type;
    }

    public SequenceType getRequiredType() {
        if (this.requiredType == null) {
            return SequenceType.ANY_SEQUENCE;
        }
        return this.requiredType;
    }

    public void setStreamable(boolean streamable) {
        this.streamable = streamable;
    }

    public boolean isStreamable() {
        return this.streamable;
    }

    public LocalParam getLocalParam(int id) {
        Iterator<Expression> iter = this.body.iterateSubExpressions();
        while (iter.hasNext()) {
            Expression child = iter.next();
            if (!(child instanceof LocalParamSetter) || ((LocalParamSetter)child).getBinding().getParameterId() != id) continue;
            return ((LocalParamSetter)child).getBinding();
        }
        return null;
    }

    public void apply(XPathContextMajor context) throws XPathException {
        for (TailCall tc = this.applyLeavingTail(context); tc != null; tc = tc.processLeavingTail()) {
        }
    }

    public TailCall applyLeavingTail(XPathContextMajor context) throws XPathException {
        if (this.bodyIsTailCallReturner) {
            return ((TailCallReturner)((Object)this.body)).processLeavingTail(context);
        }
        this.body.process(context);
        return null;
    }

    public TailCall expand(XPathContext context) throws XPathException {
        if (this.bodyIsTailCallReturner) {
            return ((TailCallReturner)((Object)this.body)).processLeavingTail(context);
        }
        if (this.body != null) {
            this.body.process(context);
        }
        return null;
    }

    public int getConstructType() {
        return 2008;
    }

    public void explain(ExpressionPresenter presenter) {
        presenter.emitAttribute("line", this.getLineNumber() + "");
        presenter.emitAttribute("module", this.getSystemId());
        if (this.getBody() != null) {
            this.getBody().explain(presenter);
        }
    }
}

