package Acme::MetaSyntactic::shou_dou_qi;

use strict;
use warnings;
no  warnings 'syntax';

use Acme::MetaSyntactic::Locale;
our @ISA = qw [Acme::MetaSyntactic::Locale];

our $VERSION = '2012060102';
__PACKAGE__ -> init;

1;

=head1 NAME

Acme::MetaSyntactic::shou_dou_qi - The pieces of the classical Chinese game

=head1 DESCRIPTION

This C<< Acme::MetaSyntactic >> theme lists the names of the classical
Chinese game I<< Shou Dou Qi >>, (E<29555>E<39717>E<26827>), also known
as I<< Jungle >>.

This module is part of the set of C<< Acme::MetaSyntactic >> themes
found in the C<< Acme::MetaSyntactic::Themes::Abigail >> package.

=head1 NOTES

The I<< mouse >> is also known as a I<< rat >>.

For the names in the Chinese local (C<< zh >>), the Chinese names have
been transcribed using the I<< Pinyin >> system; with any tonal marks
removed.

=head1 SEE ALSO

L<Acme::MetaSyntactic>, L<< Acme::MetaSyntactic::Locale >>, and
L<< http://www.chessvariants.org/other.dir/animal.html >>.

=head1 AUTHOR

Abigail, L<< mailto:cpan@abigail.be >>.

=head1 COPYRIGHT and LICENSE

Copyright (C) 2012 by Abigail.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),   
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHOR BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT
OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.


=cut

__DATA__
# default
en
# names en
elephant lion  tiger  leopard  wolf dog  cat mouse
# names du
olifant  leeuw tijger luipaard wolf hond kat muis
# names zh
xiang    shi   hu     bao      hang gou  mao shu
