### nth-degree Bezier curve definition

### The NURBS book p. 9 

use parent 'algorithm';

sub new {
	my $class = shift;

	$self = SUPER::new->(@_);
}

### B_{i,n} are Bernstein polynomials, see bernsteinpolynomialsalgorithm.pm
### it uses a simple xyz coordinate list as a point for the bezier curve
### One can use this with a nested list of points

### NOTE for the B. polynomials 0 <= u <= 1, in @Bin for points on the curve
### This function is just 1 collision method.

sub calculate {
	my ($self, @Bin, @Pointxyz) = @_;

	my $p = point->new(0,0,0);
	my $l = length(@Pointxyz); 

	while (--$l >= 0) {
		$p->setx($p->getx + @Bin[$l]*@Pointxyz[0]);
		$p->sety($p->gety + @Bin[$l]*@Pointxyz[1]);
		$p->setz($p->getz + @Bin[$l]*@Pointxyz[2]);
	}

	return $p;
}

### this works somehwat for non-sorted polygons in 3D space
sub calculate_for_z_order {
	my ($self, @Bin, @Pointxyz) = @_;

	my $z = 0;
	my $l = length(@Pointxyz); 

	while (--$l >= 0) {
		$z += @Bin[$l]*@Pointzyz[2];
	}

	return $z;
}

1;
