######## GeoData for Geo::Location::TimeZone - Check main library for copyright.
######## Roughly GMT 3
package Geo::Location::TimeZone::C;
use Class::Singleton;
use Geo::Location::TimeZone;
@ISA = qw(Class::Singleton Geo::Location::TimeZone);
# Coordinates are X,Y, NOT lat,lon
# Output of partial data at 1172109537
my $data = {
	# Longitude 37.5 to 52.5
	"3" => {
		# Grid 3:-6 ; 2 records
		"-6" => {
			"def_z" => "Antartica/South_Pole",
			"112" => {
				"z" => "Etc/GMT+2",
				"c" => "ESRI",
				"s" => "10,2",
				"p" => [[38.0788879394531,-82.5],[37.5294914245605,-82.5],[37.5294914245605,-90],[37.5,-90],[37.5,-82.5],[38.6788864135742,-82.5],[38.0788879394531,-82.5],],
			},
		},
		# Grid 3:-5 ; 1 records
		"-5" => {
			"113" => {
				"z" => "Etc/GMT+2",
				"c" => "ESRI",
				"s" => "10,2",
				"p" => [[38.0788879394531,-67.5],[37.5294914245605,-67.5],[37.5294914245605,-82.5],[37.5,-82.5],[37.5,-67.5],[38.6788864135742,-67.5],[38.0788879394531,-67.5],],
			},
		},
		# Grid 3:-4 ; 2 records
		"-4" => {
			"def_z" => "Antartica/Syowa",
			"114" => {
				"z" => "Etc/GMT+2",
				"c" => "ESRI",
				"s" => "10,2",
				"p" => [[38.0788879394531,-52.5],[37.5294914245605,-52.5],[37.5294914245605,-67.5],[37.5,-67.5],[37.5,-52.5],[38.6788864135742,-52.5],[38.0788879394531,-52.5],],
			},
		},
		# Grid 3:-3 ; 1 records
		"-3" => {
			"115" => {
				"z" => "Etc/GMT+2",
				"c" => "ESRI",
				"s" => "10,2",
				"p" => [[38.0788879394531,-37.5],[37.5294914245605,-37.5],[37.5294914245605,-52.5],[37.5,-52.5],[37.5,-37.5],[38.6788864135742,-37.5],[38.0788879394531,-37.5],],
			},
		},
		# Grid 3:-2 ; 1 records
		"-2" => {
			"116" => {
				"z" => "Etc/GMT+2",
				"c" => "ESRI",
				"s" => "10,2",
				"p" => [[37.5,-22.5],[37.5294914245605,-22.5],[37.5294914245605,-37.5],[37.5,-37.5],[37.5,-34.8219451904297],[37.5,-22.5],],
			},
		},
		# Grid 3:-1 ; 1 records
		"-1" => {
			"117" => {
				"z" => "Africa/Maputo",
				"c" => "ESRI",
				"s" => "10,2",
				"p" => [[37.5,-7.5],[37.5,-11.6892509021331],[37.5266647338867,-11.6625003814697],[37.6630554199219,-11.638334274292],[37.8158264160156,-11.5383338928223],[37.8097152709961,-11.480001449585],[37.8686065673828,-11.3266677856445],[38.0966949462891,-11.256329536438],[38.2797164916992,-11.2883338928223],[38.3777770996094,-11.3772239685059],[38.4917068481445,-11.4153118133545],[38.6552734375,-11.2811126708984],[38.7738876342773,-11.2616672515869],[38.8977737426758,-11.1722240447998],[39.1344375610352,-11.1419448852539],[39.2680511474609,-11.1680555343628],[39.5083312988281,-10.9952793121338],[39.7669372558594,-10.9205570220947],[39.8983306884766,-10.8316669464111],[40.0066604614258,-10.8055572509766],[40.2361068725586,-10.6027793884277],[40.3424987792969,-10.5672225952148],[40.4368133544922,-10.4781742095947],[40.4783325195312,-10.4825000762939],[40.472770690918,-10.5077781677246],[40.521110534668,-10.484167098999],[40.5038833618164,-10.5644445419312],[40.5597152709961,-10.5866680145264],[40.5733261108398,-10.6500015258789],[40.6394424438477,-10.671667098999],[40.6414489746094,-10.6988716125488],[40.7062683105469,-10.8475732803345],[40.713451385498,-11.1743850708008],[40.4788818359375,-11.4055557250977],[40.4247207641602,-11.5541667938232],[40.4580535888672,-11.6058349609375],[40.4241638183594,-11.6497230529785],[40.4755554199219,-11.8202781677246],[40.5161056518555,-11.843334197998],[40.4934158325195,-11.9199571609497],[40.6054916381836,-11.9650182723999],[40.6367225646973,-12.3754787445068],[40.6184425354004,-12.654167175293],[40.5744400024414,-12.6430568695068],[40.5713882446289,-12.6980571746826],[40.6163864135742,-12.7133350372314],[40.6419372558594,-12.7813892364502],[40.5588836669922,-12.7850017547607],[40.5663833618164,-12.8188896179199],[40.5236053466797,-12.8177795410156],[40.5563888549805,-12.8544454574585],[40.5341644287109,-12.904167175293],[40.4766616821289,-12.8841667175293],[40.4099960327148,-12.9619445800781],[40.4897155761719,-13.0275001525879],[40.5016632080078,-12.9444446563721],[40.5972213745117,-12.9733333587646],[40.5599975585938,-13.0786113739014],[40.5680541992188,-13.2622222900391],[40.5283279418945,-13.3025016784668],[40.5663833618164,-13.2850017547607],[40.5652770996094,-13.3663902282715],[40.5911102294922,-13.3747234344482],[40.5258331298828,-13.5152778625488],[40.6005554199219,-13.5708351135254],[40.5374984741211,-13.6452789306641],[40.6499938964844,-14.0169448852539],[40.6383285522461,-14.0791683197021],[40.5966644287109,-14.0872230529785],[40.6227722167969,-14.1255569458008],[40.5305480957031,-14.171667098999],[40.5558319091797,-14.230001449585],[40.5938873291016,-14.2108354568481],[40.5899963378906,-14.2683334350586],[40.6491622924805,-14.1975002288818],[40.7036056518555,-14.182222366333],[40.7447204589844,-14.2747230529785],[40.7286071777344,-14.3430557250977],[40.6691665649414,-14.367223739624],[40.6374969482422,-14.3397235870361],[40.6547164916992,-14.4419460296631],[40.6263885498047,-14.4450016021729],[40.6277770996094,-14.5694446563721],[40.6661071777344,-14.5375003814697],[40.6899948120117,-14.4358348846436],[40.8116607666016,-14.4077777862549],[40.8280487060547,-14.4994449615479],[40.7608261108398,-14.5380573272705],[40.8299942016602,-14.5302791595459],[40.8063888549805,-14.6141681671143],[40.8447189331055,-14.6861114501953],[40.8419418334961,-14.7950000762939],[40.722770690918,-14.8927783966064],[40.6688842773438,-14.9075012207031],[40.6452713012695,-14.8580570220947],[40.6630554199219,-14.9211120605469],[40.7472152709961,-14.9283351898193],[40.7802734375,-14.9866676330566],[40.6599960327148,-14.9872226715088],[40.7088851928711,-15.0783348083496],[40.6452713012695,-15.0827789306641],[40.6016616821289,-15.1338901519775],[40.5288848876953,-15.1327781677246],[40.5144424438477,-15.1872234344482],[40.5780487060547,-15.2027778625488],[40.6272201538086,-15.1550006866455],[40.6847152709961,-15.2497234344482],[40.571662902832,-15.4511127471924],[40.587776184082,-15.4797229766846],[40.543327331543,-15.5341682434082],[40.4966659545898,-15.529167175293],[40.3602752685547,-15.7233333587646],[40.1752777099609,-15.9200000762939],[40.0647201538086,-15.9936122894287],[40.0874938964844,-16.0094451904297],[40.1302719116211,-15.9675006866455],[40.1358261108398,-15.9925003051758],[39.9819145202637,-16.2330379486084],[39.9066734313965,-16.4168033599854],[39.8572158813477,-16.4305572509766],[39.7965087890625,-16.4660682678223],[39.7171669006348,-16.5097484588623],[39.2838821411133,-16.7683334350586],[39.1563873291016,-16.8808364868164],[39.1274948120117,-16.8704223632812],[39.1291656494141,-16.9008369445801],[39.083610534668,-16.9161148071289],[39.1274948120117,-16.9330558776855],[39.0858306884766,-16.9916687011719],[39.0015335083008,-16.9900245666504],[38.8183288574219,-17.0577812194824],[38.709716796875,-17.0636138916016],[38.6644439697266,-17.029167175293],[38.6788864135742,-17.0775032043457],[38.6047210693359,-17.0991668701172],[38.5880508422852,-17.0772247314453],[38.5405502319336,-17.1258354187012],[38.5063858032227,-17.1097259521484],[38.4974975585938,-17.1441688537598],[38.1566619873047,-17.291389465332],[38.1288833618164,-17.178337097168],[38.116943359375,-17.2088890075684],[38.0788879394531,-17.1927795410156],[38.1308288574219,-17.2536125183105],[38.1113815307617,-17.3113899230957],[37.8722152709961,-17.376392364502],[37.5294914245605,-17.5654544830322],[37.5294914245605,-22.5],[37.5,-22.5],[37.5,-11.2525005340576],[37.5,-7.5],],
			},
		},
		# Grid 3:0 ; 1 records
		"0" => {
			"343" => {
				"z" => "Africa/Mogadishu",
				"c" => "ESRI",
				"s" => "20,2",
				"p" => [[37.8097152709961,-7.5],[37.5,-7.5],[37.5,7.5],[52.5,7.5],[52.5,-7.5],[40.4783325195312,-7.5],[37.8097152709961,-7.5],],
			},
		},
		# Grid 3:1 ; 3 records
		"1" => {
			"def_z1" => "45.0366667,12.7794444,Asia/Aden",
			"def_z0" => "43.1480556,11.595,Africa/Djibouti",
			"def_z2" => "38.9333333,15.3333333,Africa/Asmara",
			"118" => {
				"z" => "Etc/GMT+2",
				"c" => "ESRI",
				"s" => "10,2",
				"p" => [[37.5,10.6869430541992],[37.5,7.5],[37.5,22.5],[37.5140647888184,22.5],[37.5140647888184,19.3283081054688],[38.2391166687012,19.3283081054688],[38.24853515625,18.3960075378418],[38.5169219970703,18.2359161376953],[38.6440544128418,18.06640625],[38.6006927490234,17.9948806762695],[38.458610534668,17.8711090087891],[38.3702774047852,17.6661109924316],[38.2766647338867,17.6069412231445],[38.2577743530273,17.5324974060059],[38.1858291625977,17.5622215270996],[38.1336059570312,17.5486106872559],[38.1113815307617,17.4811096191406],[38.0955505371094,17.543888092041],[38.0558319091797,17.5519409179688],[37.9172210693359,17.4474983215332],[37.8188858032227,17.481388092041],[37.7358322143555,17.3766632080078],[37.5124969482422,17.3233299255371],[37.5205764770508,17.19580078125],[37.5,17.1616257894293],[37.5,12.7241649627686],[37.5,10.6869430541992],],
			},
			"520" => {
				"z" => "Etc/GMT+4",
				"c" => "ESRI",
				"s" => "35,5",
				"p" => [[52.5,22.5],[52.5,17.9412312213727],[51.9992904663086,18.9993438720703],[52.5,19.1663170687678],[52.5,22.5],[51.5833282470703,22.5],[52.5,22.5],],
			},
		},
		# Grid 3:2 ; 5 records
		"2" => {
			"119" => {
				"z" => "Etc/GMT+2",
				"c" => "ESRI",
				"s" => "10,2",
				"p" => [[38.0788879394531,22.5],[37.5,22.5],[37.5,37.5],[44.5977856040723,37.5],[44.5885925292969,37.4402618408203],[44.7249908447266,37.3836059570312],[44.8152618408203,37.3052597045898],[44.8219375610352,37.2711029052734],[44.7733154296875,37.2274856567383],[44.7873382568359,37.1497116088867],[44.638053894043,37.1874847412109],[44.4363784790039,37.0630416870117],[44.3511047363281,37.0483245849609],[44.3172149658203,36.9705429077148],[44.2552719116211,36.9866638183594],[44.1933288574219,37.1002655029297],[44.2677688598633,37.1674957275391],[44.2616577148438,37.2419357299805],[44.1163787841797,37.3163757324219],[44.0141525268555,37.3205413818359],[43.9113845825195,37.2241516113281],[43.8344345092773,37.2049865722656],[43.7910995483398,37.23193359375],[43.4947128295898,37.2497177124023],[43.3566589355469,37.3308258056641],[43.2791519165039,37.3161087036133],[43.1497116088867,37.3777694702148],[42.9555435180664,37.3222198486328],[42.7908248901367,37.3847198486328],[42.7266616821289,37.3555526733398],[42.581657409668,37.1527709960938],[42.3556137084961,37.1069259643555],[42.3772277832031,37.0646743774414],[41.8352737426758,36.5988845825195],[41.4030456542969,36.5255508422852],[41.2902755737305,36.3555526733398],[41.2549896240234,36.0549926757812],[41.3780517578125,35.8386077880859],[41.3838806152344,35.6252746582031],[41.2777709960938,35.4955444335938],[41.2152709960938,35.2247085571289],[41.2291564941406,34.7883224487305],[41.0038757324219,34.41943359375],[38.7947006225586,33.3775939941406],[39.086009979248,32.5015106201172],[38.9860191345215,32.4776611328125],[39.0436515808105,32.3040504455566],[39.2599983215332,32.355541229248],[39.3011093139648,32.2363815307617],[39.1967430114746,32.1549415588379],[39.004997253418,32.0055541992188],[37.5,31.6292532087873],[37.5,31.008207780156],[38.0013885498047,30.5041656494141],[37.6674957275391,30.3363876342773],[37.5027770996094,30.0022201538086],[37.5,30.0017171662731],[37.5,24.2149216073864],[37.5140647888184,24.1931838989258],[37.5140647888184,22.5],[38.6788864135742,22.5],[38.0788879394531,22.5],],
			},
			"3" => {
				"z" => "Asia/Tehran",
				"c" => "ESRI",
				"s" => "1,1",
				"p" => [[52.5,28.2336044311523],[52.5,27.4922840774247],[51.5414733886719,27.7537002563477],[51.2965126037598,27.9541244506836],[50.2721214294434,29.1344013214111],[50.0716972351074,29.8247509002686],[49.556812286377,29.9849472045898],[49.3535003662109,30.1392440795898],[49.2282485961914,30.1428756713867],[48.5942687988281,29.9409275054932],[48.5455551147461,29.9630298614502],[48.4533233642578,29.9980506896973],[48.3877716064453,30.1369400024414],[48.4078063964844,30.2112083435059],[48.2796401977539,30.3352813720703],[48.1991958618164,30.325740814209],[48.1604309082031,30.4270820617676],[48.0324935913086,30.491382598877],[48.0363845825195,30.9974937438965],[47.6938781738281,31.0011100769043],[47.6972122192383,31.407772064209],[47.8644409179688,31.7986068725586],[47.7905502319336,31.8599967956543],[47.6897125244141,32.0238800048828],[47.5074996948242,32.1541595458984],[47.5288772583008,32.228874206543],[47.4133224487305,32.3411026000977],[47.4341583251953,32.3977737426758],[47.3561019897461,32.4763793945312],[47.2749938964844,32.4919357299805],[47.1374969482422,32.4630508422852],[46.7394332885742,32.7599945068359],[46.4238815307617,32.9374923706055],[46.1072158813477,32.9674911499023],[46.0974884033203,33.0055541992188],[46.1497192382812,33.0652694702148],[46.0541610717773,33.0880432128906],[46.051383972168,33.1183242797852],[46.1113815307617,33.1127700805664],[46.1994323730469,33.1958236694336],[46.1755523681641,33.2686004638672],[46.0502700805664,33.3777694702148],[46.0064697265625,33.4857788085938],[45.8747100830078,33.4916610717773],[45.948600769043,33.5566558837891],[45.8966598510742,33.6013870239258],[45.9065933227539,33.6365509033203],[45.746940612793,33.5916595458984],[45.7552719116211,33.6336059570312],[45.6888809204102,33.6749954223633],[45.5080490112305,33.9424896240234],[45.4058227539062,33.9710998535156],[45.468879699707,34.0791625976562],[45.5627670288086,34.1405487060547],[45.5469436645508,34.1883239746094],[45.584716796875,34.302490234375],[45.5355529785156,34.3511047363281],[45.4877700805664,34.335823059082],[45.435546875,34.4552688598633],[45.5255508422852,34.5024948120117],[45.5247268676758,34.6032028198242],[45.6147155761719,34.5599899291992],[45.7222137451172,34.5566558837891],[45.7083282470703,34.6591567993164],[45.6511001586914,34.726936340332],[45.6885986328125,34.8152694702148],[45.7661056518555,34.8458251953125],[45.7724914550781,34.914436340332],[45.8677673339844,34.9036026000977],[45.8955459594727,34.9636077880859],[45.8786010742188,35.035270690918],[45.9219360351562,35.0544357299805],[45.9337692260742,35.0987548828125],[46.039436340332,35.0583267211914],[46.1663818359375,35.1072158813477],[46.1533203125,35.1611022949219],[46.1930465698242,35.2111053466797],[46.1191558837891,35.2444381713867],[46.1480484008789,35.2974624633789],[45.9922180175781,35.4811019897461],[46.006103515625,35.5377731323242],[45.9799880981445,35.584716796875],[46.0238800048828,35.5799942016602],[46.0294342041016,35.6877670288086],[46.2686004638672,35.7280426025391],[46.3444366455078,35.8219375610352],[46.1816635131836,35.8041610717773],[46.0874938964844,35.8663864135742],[45.7658309936523,35.8119354248047],[45.6633224487305,35.940544128418],[45.5577697753906,36.0022125244141],[45.5055465698242,36.0205459594727],[45.3491592407227,35.9905471801758],[45.331657409668,36.0141525268555],[45.3683166503906,36.0863723754883],[45.3202667236328,36.1560897827148],[45.319709777832,36.2383193969727],[45.2758255004883,36.2577667236328],[45.3033218383789,36.2808227539062],[45.2730407714844,36.30859375],[45.2791595458984,36.381103515625],[45.2391586303711,36.4313735961914],[45.0941467285156,36.424430847168],[45.0147094726562,36.535270690918],[45.0666656494141,36.680549621582],[45.0127716064453,36.7536087036133],[44.8491516113281,36.7983245849609],[44.9066467285156,36.8883285522461],[44.884162902832,36.9616546630859],[44.9097137451172,37.0238723754883],[44.7849884033203,37.084716796875],[44.7655487060547,37.1169357299805],[44.7873382568359,37.1497116088867],[44.7733154296875,37.2274856567383],[44.8219375610352,37.2711029052734],[44.8152618408203,37.3052597045898],[44.7249908447266,37.3836059570312],[44.5885925292969,37.4402618408203],[44.5977856040723,37.5],[49.4058180922976,37.5],[49.4199905395508,37.4933166503906],[49.8344345092773,37.4510955810547],[49.9249877929688,37.4797058105469],[49.968879699707,37.4538726806641],[49.941650390625,37.444709777832],[50.1913757324219,37.38916015625],[50.3516616821289,37.1211013793945],[51.1011047363281,36.728874206543],[51.9727630615234,36.5799942016602],[52.5,36.6931488869617],[52.5,37.1560974121094],[52.5,28.2336044311523],],
			},
			"345" => {
				"z1" => "47.9783333,29.3697222,Asia/Kuwait",
				"z0" => "44.3938889,33.3386111,Asia/Baghdad",
				"c" => "ESRI",
				"s" => "20,2",
				"p" => [[37.8097152709961,22.5],[37.5140647888184,22.5],[37.5140647888184,24.1931838989258],[37.5,24.2149216073864],[37.5,30.0017171662731],[37.5027770996094,30.0022201538086],[37.6674957275391,30.3363876342773],[38.0013885498047,30.5041656494141],[37.5,31.008207780156],[37.5,31.6292532087873],[39.004997253418,32.0055541992188],[39.1967430114746,32.1549415588379],[39.3011093139648,32.2363815307617],[39.2599983215332,32.355541229248],[39.0436515808105,32.3040504455566],[38.9860191345215,32.4776611328125],[39.086009979248,32.5015106201172],[38.7947006225586,33.3775939941406],[41.0038757324219,34.41943359375],[41.2291564941406,34.7883224487305],[41.2152709960938,35.2247085571289],[41.2777709960938,35.4955444335938],[41.3838806152344,35.6252746582031],[41.3780517578125,35.8386077880859],[41.2549896240234,36.0549926757812],[41.2902755737305,36.3555526733398],[41.4030456542969,36.5255508422852],[41.8352737426758,36.5988845825195],[42.3772277832031,37.0646743774414],[42.3556137084961,37.1069259643555],[42.581657409668,37.1527709960938],[42.7266616821289,37.3555526733398],[42.7908248901367,37.3847198486328],[42.9555435180664,37.3222198486328],[43.1497116088867,37.3777694702148],[43.2791519165039,37.3161087036133],[43.3566589355469,37.3308258056641],[43.4947128295898,37.2497177124023],[43.7910995483398,37.23193359375],[43.8344345092773,37.2049865722656],[43.9113845825195,37.2241516113281],[44.0141525268555,37.3205413818359],[44.1163787841797,37.3163757324219],[44.2616577148438,37.2419357299805],[44.2677688598633,37.1674957275391],[44.1933288574219,37.1002655029297],[44.2552719116211,36.9866638183594],[44.3172149658203,36.9705429077148],[44.3511047363281,37.0483245849609],[44.4363784790039,37.0630416870117],[44.638053894043,37.1874847412109],[44.7873382568359,37.1497116088867],[44.7655487060547,37.1169357299805],[44.7849884033203,37.084716796875],[44.9097137451172,37.0238723754883],[44.884162902832,36.9616546630859],[44.9066467285156,36.8883285522461],[44.8491516113281,36.7983245849609],[45.0127716064453,36.7536087036133],[45.0666656494141,36.680549621582],[45.0147094726562,36.535270690918],[45.0941467285156,36.424430847168],[45.2391586303711,36.4313735961914],[45.2791595458984,36.381103515625],[45.2730407714844,36.30859375],[45.3033218383789,36.2808227539062],[45.2758255004883,36.2577667236328],[45.319709777832,36.2383193969727],[45.3202667236328,36.1560897827148],[45.3683166503906,36.0863723754883],[45.331657409668,36.0141525268555],[45.3491592407227,35.9905471801758],[45.5055465698242,36.0205459594727],[45.5577697753906,36.0022125244141],[45.6633224487305,35.940544128418],[45.7658309936523,35.8119354248047],[46.0874938964844,35.8663864135742],[46.1816635131836,35.8041610717773],[46.3444366455078,35.8219375610352],[46.2686004638672,35.7280426025391],[46.0294342041016,35.6877670288086],[46.0238800048828,35.5799942016602],[45.9799880981445,35.584716796875],[46.006103515625,35.5377731323242],[45.9922180175781,35.4811019897461],[46.1480484008789,35.2974624633789],[46.1191558837891,35.2444381713867],[46.1930465698242,35.2111053466797],[46.1533203125,35.1611022949219],[46.1663818359375,35.1072158813477],[46.039436340332,35.0583267211914],[45.9337692260742,35.0987548828125],[45.9219360351562,35.0544357299805],[45.8786010742188,35.035270690918],[45.8955459594727,34.9636077880859],[45.8677673339844,34.9036026000977],[45.7724914550781,34.914436340332],[45.7661056518555,34.8458251953125],[45.6885986328125,34.8152694702148],[45.6511001586914,34.726936340332],[45.7083282470703,34.6591567993164],[45.7222137451172,34.5566558837891],[45.6147155761719,34.5599899291992],[45.5247268676758,34.6032028198242],[45.5255508422852,34.5024948120117],[45.435546875,34.4552688598633],[45.4877700805664,34.335823059082],[45.5355529785156,34.3511047363281],[45.584716796875,34.302490234375],[45.5469436645508,34.1883239746094],[45.5627670288086,34.1405487060547],[45.468879699707,34.0791625976562],[45.4058227539062,33.9710998535156],[45.5080490112305,33.9424896240234],[45.6888809204102,33.6749954223633],[45.7552719116211,33.6336059570312],[45.746940612793,33.5916595458984],[45.9065933227539,33.6365509033203],[45.8966598510742,33.6013870239258],[45.948600769043,33.5566558837891],[45.8747100830078,33.4916610717773],[46.0064697265625,33.4857788085938],[46.0502700805664,33.3777694702148],[46.1755523681641,33.2686004638672],[46.1994323730469,33.1958236694336],[46.1113815307617,33.1127700805664],[46.051383972168,33.1183242797852],[46.0541610717773,33.0880432128906],[46.1497192382812,33.0652694702148],[46.0974884033203,33.0055541992188],[46.1072158813477,32.9674911499023],[46.4238815307617,32.9374923706055],[46.7394332885742,32.7599945068359],[47.1374969482422,32.4630508422852],[47.2749938964844,32.4919357299805],[47.3561019897461,32.4763793945312],[47.4341583251953,32.3977737426758],[47.4133224487305,32.3411026000977],[47.5288772583008,32.228874206543],[47.5074996948242,32.1541595458984],[47.6897125244141,32.0238800048828],[47.7905502319336,31.8599967956543],[47.8644409179688,31.7986068725586],[47.6972122192383,31.407772064209],[47.6938781738281,31.0011100769043],[48.0363845825195,30.9974937438965],[48.0324935913086,30.491382598877],[48.1604309082031,30.4270820617676],[48.1991958618164,30.325740814209],[48.2796401977539,30.3352813720703],[48.4078063964844,30.2112083435059],[48.3877716064453,30.1369400024414],[48.4533233642578,29.9980506896973],[48.5455551147461,29.9630298614502],[48.5942687988281,29.9409275054932],[49.2282485961914,30.1428756713867],[49.3535003662109,30.1392440795898],[49.556812286377,29.9849472045898],[50.0716972351074,29.8247509002686],[50.2721214294434,29.1344013214111],[51.2965126037598,27.9541244506836],[51.5414733886719,27.7537002563477],[52.5,27.4922840774247],[52.5,24.1070107381133],[52.3308258056641,23.9997215270996],[52.0805511474609,23.9555549621582],[51.9430541992188,23.9927749633789],[51.9255523681641,23.954719543457],[51.7987289428711,24.0163307189941],[51.7758331298828,24.275276184082],[51.7438888549805,24.2863883972168],[51.7088851928711,24.2147216796875],[51.6722183227539,24.2724990844727],[51.6355514526367,24.2097206115723],[51.6222152709961,24.3447189331055],[51.5913848876953,24.3783302307129],[51.584228515625,24.2604656219482],[51.5833282470703,24.1166591644287],[52.5,23.0370318589848],[52.5,22.5],[40.4783325195312,22.5],[37.8097152709961,22.5],],
			},
			"521" => {
				"z" => "Etc/GMT+4",
				"c" => "ESRI",
				"s" => "35,5",
				"p" => [[52.5,25.2594413757324],[52.5,22.5],[52.5,23.0370318589848],[51.5833282470703,24.1166591644287],[51.584228515625,24.2604656219482],[51.5913848876953,24.3783302307129],[51.6222152709961,24.3447189331055],[51.6355514526367,24.2097206115723],[51.6722183227539,24.2724990844727],[51.7088851928711,24.2147216796875],[51.7438888549805,24.2863883972168],[51.7758331298828,24.275276184082],[51.7987289428711,24.0163307189941],[51.9255523681641,23.954719543457],[51.9430541992188,23.9927749633789],[52.0805511474609,23.9555549621582],[52.3308258056641,23.9997215270996],[52.5,24.1070107381133],[52.5,25.0344429016113],[52.5,25.2594413757324],],
			},
			"568" => {
				"z" => "Etc/GMT+5",
				"c" => "ESRI",
				"s" => "37,2",
				"p" => [[52.4874954223633,37.5],[52.5,37.5],[52.5,36.6931488869617],[51.9727630615234,36.5799942016602],[51.1011047363281,36.728874206543],[50.3516616821289,37.1211013793945],[50.1913757324219,37.38916015625],[49.941650390625,37.444709777832],[49.968879699707,37.4538726806641],[49.9249877929688,37.4797058105469],[49.8344345092773,37.4510955810547],[49.4199905395508,37.4933166503906],[49.4058180922976,37.5],[48.5936050415039,37.5],[52.4874954223633,37.5],],
			},
		},
		# Grid 3:3 ; 6 records
		"3" => {
			"120" => {
				"z" => "Etc/GMT+2",
				"c" => "ESRI",
				"s" => "10,2",
				"p" => [[37.5,49.0911026000977],[37.5,50.3494011258769],[37.6236038208008,50.3052673339844],[37.6052703857422,50.2166595458984],[37.7330474853516,50.0877685546875],[37.9252700805664,50.0247116088867],[38.013053894043,49.9013824462891],[38.1852645874023,49.9511032104492],[38.1841583251953,50.065544128418],[38.3077697753906,50.0738830566406],[38.3760986328125,49.9874954223633],[38.4988784790039,49.9519348144531],[38.686653137207,49.978874206543],[38.6960983276367,49.927490234375],[38.88916015625,49.868049621582],[38.9452667236328,49.8074951171875],[39.0691604614258,49.8177719116211],[39.1837387084961,49.8804092407227],[39.2736053466797,49.7519378662109],[39.5808258056641,49.7308197021484],[39.6397171020508,49.6155471801758],[39.7969436645508,49.5530471801758],[39.9216613769531,49.565544128418],[40.004997253418,49.6144409179688],[40.139762878418,49.6010513305664],[40.1411056518555,49.5591583251953],[40.0744400024414,49.5269393920898],[40.0530471801758,49.4783248901367],[40.1797180175781,49.3269424438477],[40.1669387817383,49.2486038208008],[39.9663848876953,49.1238784790039],[39.9388809204102,49.0549926757812],[39.6991577148438,49.0227661132812],[39.6944351196289,48.9730453491211],[39.7672119140625,48.9038772583008],[39.9705429077148,48.859992980957],[40.0302734375,48.8961029052734],[40.07666015625,48.8749923706055],[39.9852676391602,48.7913818359375],[39.8038787841797,48.8177719116211],[39.7272109985352,48.7622146606445],[39.6569366455078,48.6166610717773],[39.6696624755859,48.5876388549805],[39.8533248901367,48.5547103881836],[39.8669357299805,48.5002746582031],[39.8383255004883,48.4838790893555],[39.921516418457,48.3683929443359],[39.8380432128906,48.3124923706055],[39.9127655029297,48.2777709960938],[40.0124969482422,48.2847213745117],[40.0024948120117,48.243049621582],[39.9327621459961,48.2133255004883],[39.8483200073242,48.1130523681641],[39.8685913085938,48.0408325195312],[39.7760925292969,48.0263824462891],[39.8199844360352,47.9697036743164],[39.79638671875,47.8572158813477],[39.723876953125,47.8183288574219],[39.3452606201172,47.8530426025391],[39.1363754272461,47.8338775634766],[39.0381698608398,47.8657989501953],[38.8383255004883,47.8527755737305],[38.7505416870117,47.6838684082031],[38.6913757324219,47.6941528320312],[38.6058197021484,47.6380386352539],[38.3394317626953,47.6013793945312],[38.2808227539062,47.506103515625],[38.2855529785156,47.3961029052734],[38.2080459594727,47.3191528320312],[38.3191528320312,47.2783279418945],[38.2161026000977,47.194709777832],[38.2358245849609,47.1094284057617],[37.6413726806641,46.733585357666],[37.5,46.541318757267],[37.5,41.0458400830133],[37.5372085571289,41.0280456542969],[37.6077728271484,41.0477676391602],[37.6874847412109,41.1372146606445],[37.7063827514648,41.1122207641602],[37.7894439697266,41.1155548095703],[37.7936096191406,41.0455474853516],[37.8924865722656,40.9827728271484],[38.2774887084961,40.950553894043],[38.3613815307617,40.9094314575195],[38.5235977172852,40.9208297729492],[38.6255416870117,40.9730529785156],[38.7099914550781,40.9499969482422],[38.8161087036133,41.0099945068359],[39.1630477905273,41.0824966430664],[39.2786026000977,41.0497207641602],[39.4210968017578,41.1094436645508],[39.646110534668,41.0016555786133],[39.7333297729492,41.0138778686523],[39.8772125244141,40.9538879394531],[39.9977645874023,40.9758148193359],[40.1285934448242,40.9163818359375],[40.4580459594727,41.0424957275391],[40.5433197021484,41.0291595458984],[40.8330535888672,41.1949844360352],[40.9311065673828,41.1874847412109],[41.3874969482422,41.373046875],[41.5315589904785,41.5238761901855],[41.6516647338867,41.4827728271484],[41.722770690918,41.4955444335938],[41.7230529785156,41.4705429077148],[41.8333206176758,41.4283218383789],[41.9680404663086,41.519157409668],[42.0502777099609,41.4905548095703],[42.182487487793,41.5074996948242],[42.4722137451172,41.4333267211914],[42.5108184814453,41.4433288574219],[42.597770690918,41.5830535888672],[42.8274917602539,41.5849914550781],[42.7883224487305,41.5086059570312],[42.8472137451172,41.4730529785156],[42.8927688598633,41.5069427490234],[43.0397186279297,41.3741607666016],[43.207763671875,41.3069305419922],[43.1236038208008,41.2552719116211],[43.1994323730469,41.2552719116211],[43.236930847168,41.176383972168],[43.3497085571289,41.2019348144531],[43.4258193969727,41.1852645874023],[43.4747085571289,41.1399917602539],[43.4607696533203,41.1129608154297],[43.4791564941406,41.0252685546875],[43.5994338989258,40.9924926757812],[43.6716537475586,40.9280548095703],[43.6861038208008,40.8419418334961],[43.7519378662109,40.7399978637695],[43.7536087036133,40.6758193969727],[43.6530456542969,40.531379699707],[43.5541534423828,40.4710998535156],[43.6202697753906,40.41943359375],[43.5941619873047,40.3374938964844],[43.6799926757812,40.2644348144531],[43.6722106933594,40.2197189331055],[43.7216567993164,40.1633224487305],[43.6577758789062,40.1397094726562],[43.6574935913086,40.1085968017578],[43.9338836669922,40.0136108398438],[44.2799987792969,40.0460968017578],[44.3472137451172,40.0238876342773],[44.4877777099609,39.9627685546875],[44.5908279418945,39.8330535888672],[44.6955413818359,39.7899856567383],[44.7788619995117,39.7063827514648],[44.8130416870117,39.6308135986328],[44.6058197021484,39.7805404663086],[44.4710845947266,39.6988677978516],[44.4160995483398,39.4252624511719],[44.3155364990234,39.3874969482422],[44.2005386352539,39.4169387817383],[44.0341567993164,39.3849945068359],[44.095817565918,39.2913818359375],[44.0983276367188,39.2063827514648],[44.2158279418945,39.1408309936523],[44.1883239746094,39.0830535888672],[44.2049865722656,39.0416564941406],[44.159423828125,39.0022125244141],[44.2080459594727,38.8958206176758],[44.3033218383789,38.8344345092773],[44.2608184814453,38.7216567993164],[44.2827606201172,38.6977615356445],[44.2633285522461,38.6663818359375],[44.3138809204102,38.6377716064453],[44.3069305419922,38.3883285522461],[44.3808135986328,38.3697128295898],[44.4347076416016,38.3955459594727],[44.4841537475586,38.3455429077148],[44.4047088623047,38.2716598510742],[44.3877716064453,38.1658248901367],[44.2641525268555,38.0141525268555],[44.2239685058594,37.8991508483887],[44.3933258056641,37.8630447387695],[44.4191589355469,37.8177719116211],[44.4519348144531,37.8177719116211],[44.4560928344727,37.7747116088867],[44.5269317626953,37.7855529785156],[44.618049621582,37.7277679443359],[44.5580368041992,37.6480407714844],[44.6136016845703,37.6027755737305],[44.5977856040723,37.5],[37.5,37.5],[37.5,39.6447219848633],[37.5,49.0911026000977],],
			},
			"330" => {
				"z" => "Asia/Kamchatka",
				"c" => "ESRI",
				"s" => "20,1",
				"p" => [[52.2516632080078,52.5],[45.9838575070369,52.5],[45.9713745117188,52.4958267211914],[46.0163879394531,52.4577713012695],[45.9752655029297,52.4361038208008],[45.9808197021484,52.4072113037109],[45.7180480957031,52.4588851928711],[45.7287977386885,52.5],[45.5811689294296,52.5],[45.5269393920898,52.4816589355469],[45.5163879394531,52.4344329833984],[45.4419326782227,52.4005432128906],[45.1113815307617,52.4111022949219],[45.0691604614258,52.3777694702148],[45.1013870239258,52.3333282470703],[45.0505447387695,52.3172149658203],[44.9733200073242,52.3733215332031],[44.9055480957031,52.3766555786133],[44.8674926757812,52.4466552734375],[44.6648941040039,52.4793548583984],[44.6319105505272,52.5],[44.5239398173704,52.5],[44.539436340332,52.4863815307617],[44.5144424438477,52.4591598510742],[44.5436096191406,52.4294357299805],[44.4108200073242,52.4130477905273],[44.38916015625,52.3683242797852],[44.3333282470703,52.3480453491211],[44.3463821411133,52.3161010742188],[44.0552673339844,52.3460998535156],[43.7774887084961,52.4347152709961],[43.3405456542969,52.3911056518555],[43.3086013793945,52.4455413818359],[43.1902694702148,52.4666595458984],[43.1227645874023,52.4019317626953],[43.0797958374023,52.4028701782227],[43.009162902832,52.363883972168],[42.9252700805664,52.3749923706055],[42.9222183227539,52.3052673339844],[42.7533264160156,52.1858215332031],[42.7474899291992,52.0802764892578],[42.8111038208008,52.0102767944336],[42.7030487060547,51.98193359375],[42.676383972168,51.839714050293],[42.4866561889648,51.6930465698242],[42.5147171020508,51.6238784790039],[42.4895095825195,51.6078872680664],[42.8616638183594,51.3816604614258],[42.8394317626953,51.3166656494141],[42.9122085571289,51.2408294677734],[42.8730773925781,51.2314224243164],[42.6844329833984,51.2369384765625],[42.5672149658203,51.1652679443359],[42.4188842773438,51.1722183227539],[42.2672119140625,51.1316604614258],[42.098876953125,51.1474914550781],[41.9633255004883,51.2086029052734],[41.8685989379883,51.1938781738281],[41.7285995483398,51.0172119140625],[41.4119338989258,50.9036026000977],[41.3777694702148,50.8766555786133],[41.3827667236328,50.8302764892578],[41.156379699707,50.7763824462891],[41.3277740478516,50.7191543579102],[41.4074935913086,50.6194381713867],[41.5283279418945,50.6016616821289],[41.5241622924805,50.568603515625],[41.4547119140625,50.551383972168],[41.4174957275391,50.5052719116211],[41.5124969482422,50.381103515625],[41.3622055053711,50.2262878417969],[41.4822082519531,50.0902709960938],[41.5911026000977,50.0552673339844],[41.5827713012695,50.004997253418],[41.6136093139648,49.9636077880859],[41.8661041259766,49.9077682495117],[42.177490234375,49.6908264160156],[42.1127700805664,49.5258255004883],[42.0736083984375,49.5105514526367],[42.0497207641602,49.4049911499023],[42.0969390869141,49.2922210693359],[42.0319366455078,49.2663879394531],[42.0769424438477,49.1997146606445],[42.0644378662109,49.1538772583008],[42.3444366455078,49.1524887084961],[42.3927688598633,49.0497207641602],[42.4838790893555,49.0447158813477],[42.6636047363281,48.9677658081055],[42.6624908447266,48.8886032104492],[42.7461013793945,48.8063812255859],[42.6502685546875,48.7052688598633],[42.70166015625,48.618049621582],[42.6305465698242,48.5469436645508],[42.2766571044922,48.4986038208008],[42.0724945068359,48.4088821411133],[42.1519317626953,48.2822113037109],[42.0449981689453,48.259162902832],[42.1027755737305,48.1638793945312],[42.0511016845703,48.1297149658203],[42.0219345092773,48.0302734375],[42.2755508422852,48.013053894043],[42.3263854980469,48.0477752685547],[42.4986038208008,48.0105514526367],[42.7285995483398,47.8555526733398],[42.9397125244141,47.5136108398438],[42.9877624511719,47.5138778686523],[43.0591506958008,47.5763778686523],[43.1355438232422,47.575553894043],[43.1599807739258,47.4824905395508],[43.2249908447266,47.4497146606445],[43.5583267211914,47.4897155761719],[43.6533126831055,47.4422149658203],[43.7317733764648,47.4765548706055],[43.6294326782227,47.5591506958008],[43.7058258056641,47.6844329833984],[43.8413696289062,47.7574996948242],[43.9749908447266,47.7663879394531],[44.04443359375,47.8241577148438],[44.0158309936523,47.863883972168],[44.0658187866211,47.9108123779297],[44.3891525268555,47.8683166503906],[44.386100769043,47.9141464233398],[44.4677658081055,47.9785995483398],[44.4663772583008,48.0408325195312],[44.3230438232422,48.0599899291992],[44.3094329833984,48.2599945068359],[44.5358200073242,48.2063827514648],[44.5497131347656,48.0583267211914],[44.6122055053711,48.0566558837891],[44.6441497802734,48.0916595458984],[44.800537109375,48.052490234375],[44.9422073364258,48.1438827514648],[44.9247131347656,48.1991577148438],[44.956657409668,48.2119369506836],[45.1274871826172,48.1130523681641],[45.3008193969727,48.0976715087891],[45.3949890136719,48.0983276367188],[45.5519256591797,47.9919357299805],[45.7136001586914,48.0374984741211],[45.7416610717773,48.0022201538086],[45.7066497802734,47.9319305419922],[45.7197036743164,47.8652725219727],[45.7855529785156,47.8130416870117],[45.8291625976562,47.7230377197266],[45.9072036743164,47.7122116088867],[45.9380416870117,47.6288757324219],[46.0888748168945,47.5169296264648],[46.2966537475586,47.4366455078125],[46.3885955810547,47.4444274902344],[46.6808166503906,47.6324844360352],[46.8305435180664,47.5760955810547],[46.5238723754883,47.4349899291992],[46.5155487060547,47.3919296264648],[46.79638671875,46.9963836669922],[46.9277725219727,46.9783248901367],[46.9908218383789,46.8508224487305],[47.1272125244141,46.8583297729492],[47.2277679443359,46.7408218383789],[47.140266418457,46.6963806152344],[47.1497116088867,46.6683197021484],[46.998046875,46.6336059570312],[46.9133148193359,46.5552597045898],[46.9491577148438,46.5394287109375],[46.9619369506836,46.428596496582],[46.660270690918,46.4280395507812],[46.4783248901367,46.2755508422852],[46.8666534423828,46.248046875],[46.8336029052734,46.0727615356445],[47.0908279418945,46.1185989379883],[47.1749877929688,46.1055526733398],[47.1091537475586,46.0077667236328],[47.0410995483398,45.9697036743164],[46.8930435180664,45.5747146606445],[47.2936096191406,45.6436004638672],[47.3597106933594,45.6894226074219],[47.4674835205078,45.6394348144531],[47.4861907958984,45.5714569091797],[47.5433197021484,45.5052719116211],[47.5016555786133,45.47998046875],[47.4861068725586,45.4186019897461],[47.3780364990234,45.411376953125],[47.4627685546875,45.3808135986328],[47.3855438232422,45.2952728271484],[47.3760986328125,45.1819305419922],[47.2919387817383,45.1808166503906],[47.1991577148438,44.9685897827148],[47.1485977172852,44.9269409179688],[47.0972137451172,44.9497146606445],[47.1166534423828,44.8622055053711],[47.075553894043,44.7827606201172],[46.9916534423828,44.9219284057617],[47.0094375610352,44.8211059570312],[46.9594345092773,44.7638778686523],[46.7124938964844,44.6477737426758],[46.7244338989258,44.5447158813477],[46.6797103881836,44.5230407714844],[46.6999969482422,44.442756652832],[46.7602767944336,44.3919296264648],[47.0122146606445,44.3608245849609],[47.0924835205078,44.2402725219727],[47.1585998535156,44.2005386352539],[47.2055435180664,44.2185897827148],[47.4795150756836,44.4864120483398],[47.5321960449219,44.5000686645508],[47.8073081970215,43.9869155883789],[47.6983184814453,43.8688735961914],[47.5849838256836,43.7222137451172],[47.4872055053711,43.4563827514648],[47.4883193969727,43.2936096191406],[47.5724945068359,43.3305435180664],[47.5883255004883,43.2969436645508],[47.4833297729492,43.207763671875],[47.4622116088867,43.0191497802734],[47.6969375610352,42.8663787841797],[47.7383193969727,42.6338806152344],[47.8594284057617,42.593879699707],[47.9449844360352,42.4624938964844],[48.1177597045898,42.3263778686523],[48.303596496582,42.0974807739258],[48.3866577148438,41.926383972168],[48.5447158813477,41.8802719116211],[48.5839538574219,41.8357696533203],[48.4713745117188,41.7235946655273],[48.3997116088867,41.5891494750977],[48.2313766479492,41.5024948120117],[48.0744323730469,41.4677658081055],[48.0227584838867,41.361930847168],[47.9624938964844,41.3594284057617],[47.908317565918,41.2908325195312],[47.9199905395508,41.2263717651367],[47.7669296264648,41.1960906982422],[47.6597137451172,41.2355499267578],[47.571662902832,41.2110977172852],[47.5219345092773,41.2541656494141],[47.2855529785156,41.3122024536133],[47.2588806152344,41.4247055053711],[47.1605377197266,41.5611038208008],[47.0430526733398,41.5583267211914],[46.9255447387695,41.7177658081055],[46.7708206176758,41.7966537475586],[46.7608184814453,41.863883972168],[46.5916595458984,41.7922134399414],[46.5666656494141,41.8077697753906],[46.5683288574219,41.8824844360352],[46.4517517089844,41.8970565795898],[46.3941497802734,41.9405364990234],[46.3199844360352,41.9388809204102],[46.2399826049805,42.0013885498047],[46.1038818359375,41.9941558837891],[46.0780487060547,42.0341567993164],[46.0108184814453,42.0430526733398],[45.9605407714844,42.0238723754883],[45.910270690918,42.1049957275391],[45.6474838256836,42.2047119140625],[45.7602767944336,42.477912902832],[45.5527725219727,42.5502624511719],[45.3516616821289,42.529426574707],[45.1713714599609,42.7008285522461],[45.0530395507812,42.6941528320312],[44.9274826049805,42.7619323730469],[44.8549957275391,42.7433166503906],[44.8038787841797,42.6172027587891],[44.6844329833984,42.7394256591797],[44.5497207641602,42.7594375610352],[44.2866516113281,42.7127685546875],[44.220817565918,42.6369323730469],[44.053596496582,42.618049621582],[43.9610977172852,42.5577697753906],[43.7355499267578,42.6391525268555],[43.8360977172852,42.7277679443359],[43.8272094726562,42.7513885498047],[43.6708297729492,42.7910995483398],[43.560546875,42.8608245849609],[43.2008285522461,42.9363708496094],[43.0108184814453,43.0566558837891],[43.0211029052734,43.1044387817383],[42.8572158813477,43.1774826049805],[42.7010955810547,43.182487487793],[42.6258239746094,43.1430435180664],[42.4152679443359,43.2391586303711],[42.1811065673828,43.2355499267578],[42.0577697753906,43.1861038208008],[41.9397125244141,43.2174835205078],[41.5897064208984,43.2227554321289],[41.3933258056641,43.3460998535156],[41.295539855957,43.3360977172852],[41.1680526733398,43.3872146606445],[41.0441589355469,43.3749847412109],[40.6847076416016,43.5458297729492],[40.5430526733398,43.5086059570312],[40.2533874511719,43.58251953125],[40.1266555786133,43.5722198486328],[40.0774917602539,43.5469436645508],[40.0029678344727,43.379264831543],[40.2247085571289,43.3144378662109],[40.3263778686523,43.1419296264648],[40.3847198486328,43.1655426025391],[40.5866546630859,43.0824966430664],[40.8435974121094,43.0677719116211],[40.9327697753906,42.9722137451172],[41.0327606201172,42.9730377197266],[41.1558227539062,42.7891616821289],[41.220817565918,42.7986068725586],[41.4613723754883,42.7080459594727],[41.5533218383789,42.3858184814453],[41.6327667236328,42.2719345092773],[41.6616516113281,42.12109375],[41.7624969482422,41.9922103881836],[41.7747268676758,41.885627746582],[41.7302627563477,41.7255477905273],[41.5315589904785,41.5238761901855],[41.3874969482422,41.373046875],[40.9311065673828,41.1874847412109],[40.8330535888672,41.1949844360352],[40.5433197021484,41.0291595458984],[40.4580459594727,41.0424957275391],[40.1285934448242,40.9163818359375],[39.9977645874023,40.9758148193359],[39.8772125244141,40.9538879394531],[39.7333297729492,41.0138778686523],[39.646110534668,41.0016555786133],[39.4210968017578,41.1094436645508],[39.2786026000977,41.0497207641602],[39.1630477905273,41.0824966430664],[38.8161087036133,41.0099945068359],[38.7099914550781,40.9499969482422],[38.6255416870117,40.9730529785156],[38.5235977172852,40.9208297729492],[38.3613815307617,40.9094314575195],[38.2774887084961,40.950553894043],[37.8924865722656,40.9827728271484],[37.7936096191406,41.0455474853516],[37.7894439697266,41.1155548095703],[37.7063827514648,41.1122207641602],[37.6874847412109,41.1372146606445],[37.6077728271484,41.0477676391602],[37.5372085571289,41.0280456542969],[37.5,41.0458400830133],[37.5,46.541318757267],[37.6413726806641,46.733585357666],[38.2358245849609,47.1094284057617],[38.2161026000977,47.194709777832],[38.3191528320312,47.2783279418945],[38.2080459594727,47.3191528320312],[38.2855529785156,47.3961029052734],[38.2808227539062,47.506103515625],[38.3394317626953,47.6013793945312],[38.6058197021484,47.6380386352539],[38.6913757324219,47.6941528320312],[38.7505416870117,47.6838684082031],[38.8383255004883,47.8527755737305],[39.0381698608398,47.8657989501953],[39.1363754272461,47.8338775634766],[39.3452606201172,47.8530426025391],[39.723876953125,47.8183288574219],[39.79638671875,47.8572158813477],[39.8199844360352,47.9697036743164],[39.7760925292969,48.0263824462891],[39.8685913085938,48.0408325195312],[39.8483200073242,48.1130523681641],[39.9327621459961,48.2133255004883],[40.0024948120117,48.243049621582],[40.0124969482422,48.2847213745117],[39.9127655029297,48.2777709960938],[39.8380432128906,48.3124923706055],[39.921516418457,48.3683929443359],[39.8383255004883,48.4838790893555],[39.8669357299805,48.5002746582031],[39.8533248901367,48.5547103881836],[39.6696624755859,48.5876388549805],[39.6569366455078,48.6166610717773],[39.7272109985352,48.7622146606445],[39.8038787841797,48.8177719116211],[39.9852676391602,48.7913818359375],[40.07666015625,48.8749923706055],[40.0302734375,48.8961029052734],[39.9705429077148,48.859992980957],[39.7672119140625,48.9038772583008],[39.6944351196289,48.9730453491211],[39.6991577148438,49.0227661132812],[39.9388809204102,49.0549926757812],[39.9663848876953,49.1238784790039],[40.1669387817383,49.2486038208008],[40.1797180175781,49.3269424438477],[40.0530471801758,49.4783248901367],[40.0744400024414,49.5269393920898],[40.1411056518555,49.5591583251953],[40.139762878418,49.6010513305664],[40.004997253418,49.6144409179688],[39.9216613769531,49.565544128418],[39.7969436645508,49.5530471801758],[39.6397171020508,49.6155471801758],[39.5808258056641,49.7308197021484],[39.2736053466797,49.7519378662109],[39.1837387084961,49.8804092407227],[39.0691604614258,49.8177719116211],[38.9452667236328,49.8074951171875],[38.88916015625,49.868049621582],[38.6960983276367,49.927490234375],[38.686653137207,49.978874206543],[38.4988784790039,49.9519348144531],[38.3760986328125,49.9874954223633],[38.3077697753906,50.0738830566406],[38.1841583251953,50.065544128418],[38.1852645874023,49.9511032104492],[38.013053894043,49.9013824462891],[37.9252700805664,50.0247116088867],[37.7330474853516,50.0877685546875],[37.6052703857422,50.2166595458984],[37.6236038208008,50.3052673339844],[37.5,50.3494011258769],[37.5,52.5],[46.7080459594727,52.5],[52.2516632080078,52.5],],
			},
			"4" => {
				"z" => "Asia/Tehran",
				"c" => "ESRI",
				"s" => "1,1",
				"p" => [[52.5,37.6361083984375],[52.5,37.5],[44.5977856040723,37.5],[44.6136016845703,37.6027755737305],[44.5580368041992,37.6480407714844],[44.618049621582,37.7277679443359],[44.5269317626953,37.7855529785156],[44.4560928344727,37.7747116088867],[44.4519348144531,37.8177719116211],[44.4191589355469,37.8177719116211],[44.3933258056641,37.8630447387695],[44.2239685058594,37.8991508483887],[44.2641525268555,38.0141525268555],[44.3877716064453,38.1658248901367],[44.4047088623047,38.2716598510742],[44.4841537475586,38.3455429077148],[44.4347076416016,38.3955459594727],[44.3808135986328,38.3697128295898],[44.3069305419922,38.3883285522461],[44.3138809204102,38.6377716064453],[44.2633285522461,38.6663818359375],[44.2827606201172,38.6977615356445],[44.2608184814453,38.7216567993164],[44.3033218383789,38.8344345092773],[44.2080459594727,38.8958206176758],[44.159423828125,39.0022125244141],[44.2049865722656,39.0416564941406],[44.1883239746094,39.0830535888672],[44.2158279418945,39.1408309936523],[44.0983276367188,39.2063827514648],[44.095817565918,39.2913818359375],[44.0341567993164,39.3849945068359],[44.2005386352539,39.4169387817383],[44.3155364990234,39.3874969482422],[44.4160995483398,39.4252624511719],[44.4710845947266,39.6988677978516],[44.6058197021484,39.7805404663086],[44.8130416870117,39.6308135986328],[44.8885955810547,39.6058197021484],[44.9502716064453,39.4358215332031],[45.0630416870117,39.373046875],[45.1305465698242,39.2855529785156],[45.1419296264648,39.2174835205078],[45.3099899291992,39.1983184814453],[45.4349899291992,39.0511016845703],[45.4394226074219,38.998046875],[45.8719329833984,38.8799896240234],[46.0563735961914,38.8783187866211],[46.1782455444336,38.8411483764648],[46.3547058105469,38.9105377197266],[46.5403747558594,38.8755874633789],[46.8383255004883,39.1552658081055],[46.9488677978516,39.154426574707],[47.0255508422852,39.1894226074219],[47.0997085571289,39.3044357299805],[47.2922134399414,39.3769378662109],[47.3916625976562,39.4705429077148],[47.533332824707,39.5088806152344],[47.8066558837891,39.6772155761719],[47.930549621582,39.68359375],[47.9766616821289,39.7192306518555],[48.3597869873047,39.3852157592773],[48.1891555786133,39.3333206176758],[48.1199798583984,39.2636108398438],[48.1349945068359,39.2088775634766],[48.2938766479492,39.1124877929688],[48.327766418457,39.0516586303711],[48.3124847412109,39.0077667236328],[48.0713806152344,38.9513778686523],[48.0141525268555,38.9058227539062],[48.0208206176758,38.8355407714844],[48.2438735961914,38.7277679443359],[48.2436065673828,38.6672058105469],[48.327766418457,38.6033248901367],[48.4419326782227,38.6216506958008],[48.4541625976562,38.5647125244141],[48.623046875,38.395263671875],[48.7894287109375,38.4477615356445],[48.8882827758789,38.4424057006836],[48.8694305419922,38.3005447387695],[48.941650390625,37.9074935913086],[48.9977645874023,37.7636108398438],[49.1024856567383,37.6430435180664],[49.4058180922976,37.5],[52.5,37.5],[52.5,38.283332824707],[52.5,37.6361083984375],],
			},
			"517" => {
				"z" => "Europe/Volgograd",
				"c" => "ESRI",
				"s" => "35,3",
				"p" => [[50.2622146606445,52.5],[51.4984527156074,52.5],[51.563606262207,52.4358215332031],[51.4638824462891,52.4136047363281],[51.4716567993164,52.3658294677734],[51.4069366455078,52.3491592407227],[51.4080429077148,52.2541656494141],[51.4574966430664,52.2277679443359],[51.4124908447266,52.089714050293],[50.7733001708984,51.7691802978516],[50.7586059570312,51.7197113037109],[50.813606262207,51.6480484008789],[50.810546875,51.5916595458984],[50.6827697753906,51.5730514526367],[50.7174911499023,51.6224899291992],[50.6027755737305,51.6399917602539],[50.5947113037109,51.589714050293],[50.5436096191406,51.5672149658203],[50.5488815307617,51.4685974121094],[50.3847198486328,51.4252700805664],[50.397216796875,51.3997192382812],[50.3544387817383,51.378044128418],[50.3633270263672,51.3169403076172],[49.9680480957031,51.2260971069336],[49.8041610717773,51.1102752685547],[49.4619369506836,51.1241607666016],[49.3644409179688,50.9797134399414],[49.4408264160156,50.9058227539062],[49.4258270263672,50.8513870239258],[49.1583251953125,50.7927703857422],[49.0308227539062,50.6880416870117],[48.8302764892578,50.5966567993164],[48.5936050415039,50.6483306884766],[48.5955429077148,50.6224899291992],[48.6974868774414,50.5919342041016],[48.7227630615234,50.3530502319336],[48.8111038208008,50.1941528320312],[48.7911071777344,50.1236038208008],[48.8797149658203,50.1016616821289],[48.9169387817383,50.0341644287109],[48.7969436645508,49.9419326782227],[48.4508285522461,49.8169403076172],[48.3322143554688,49.8788757324219],[48.2516632080078,49.8697128295898],[48.2488784790039,49.9088821411133],[48.1655426025391,49.9661026000977],[48.1105499267578,50.0986022949219],[47.7608261108398,50.3752670288086],[47.5997161865234,50.460823059082],[47.4463958740234,50.376953125],[47.4160995483398,50.3319396972656],[47.3166656494141,50.2944412231445],[47.3427658081055,50.2419357299805],[47.2805480957031,50.1822128295898],[47.3566589355469,50.0902709960938],[47.302490234375,50.0319366455078],[47.1883239746094,49.9441528320312],[46.9294357299805,49.8636093139648],[46.7958297729492,49.339714050293],[47.0261001586914,49.2361068725586],[47.0627670288086,49.1427688598633],[46.9544372558594,49.013053894043],[46.7788772583008,48.936653137207],[46.4991607666016,48.4174957275391],[47.1227645874023,48.2716598510742],[47.1333312988281,48.2424926757812],[47.0963745117188,48.2099914550781],[47.1383209228516,48.1699905395508],[47.1222076416016,48.1022186279297],[47.2149887084961,48.0708312988281],[47.0624847412109,47.99609375],[47.1827697753906,47.8741607666016],[47.1366577148438,47.8224945068359],[47.3833236694336,47.6888809204102],[47.4358215332031,47.8435974121094],[47.6913757324219,47.7658309936523],[48.0647125244141,47.7797088623047],[48.2044296264648,47.7049865722656],[48.4438705444336,47.4369277954102],[48.5472106933594,47.4172058105469],[48.7210998535156,47.0983276367188],[49.0272064208984,46.7760925292969],[48.9413757324219,46.7041625976562],[48.765266418457,46.6908187866211],[48.7105407714844,46.7597198486328],[48.6033248901367,46.7733154296875],[48.5216598510742,46.743049621582],[48.476203918457,46.6676788330078],[48.5541534423828,46.6438827514648],[48.5839996337891,46.5984268188477],[48.560546875,46.5649948120117],[48.7402725219727,46.5583267211914],[48.8338775634766,46.484992980957],[48.9181289672852,46.4892196655273],[49.222526550293,46.346305847168],[49.3143043518066,46.2573013305664],[49.1889724731445,46.0525894165039],[49.0573692321777,45.9836540222168],[48.994701385498,46.0024566650391],[48.8798141479492,45.9439659118652],[48.7920799255371,45.8290748596191],[48.7294120788574,45.8040084838867],[48.7461204528809,45.6974754333496],[48.3638534545898,45.6494293212891],[48.2050933837891,45.7120971679688],[48.071403503418,45.7183647155762],[48.0150032043457,45.695384979248],[47.9982948303223,45.5199165344238],[47.8165588378906,45.4321823120117],[47.532470703125,45.5303344726562],[47.4861907958984,45.5714569091797],[47.4674835205078,45.6394348144531],[47.3597106933594,45.6894226074219],[47.2936096191406,45.6436004638672],[46.8930435180664,45.5747146606445],[47.0410995483398,45.9697036743164],[47.1091537475586,46.0077667236328],[47.1749877929688,46.1055526733398],[47.0908279418945,46.1185989379883],[46.8336029052734,46.0727615356445],[46.8666534423828,46.248046875],[46.4783248901367,46.2755508422852],[46.660270690918,46.4280395507812],[46.9619369506836,46.428596496582],[46.9491577148438,46.5394287109375],[46.9133148193359,46.5552597045898],[46.998046875,46.6336059570312],[47.1497116088867,46.6683197021484],[47.140266418457,46.6963806152344],[47.2277679443359,46.7408218383789],[47.1272125244141,46.8583297729492],[46.9908218383789,46.8508224487305],[46.9277725219727,46.9783248901367],[46.79638671875,46.9963836669922],[46.5155487060547,47.3919296264648],[46.5238723754883,47.4349899291992],[46.8305435180664,47.5760955810547],[46.6808166503906,47.6324844360352],[46.3885955810547,47.4444274902344],[46.2966537475586,47.4366455078125],[46.0888748168945,47.5169296264648],[45.9380416870117,47.6288757324219],[45.9072036743164,47.7122116088867],[45.8291625976562,47.7230377197266],[45.7855529785156,47.8130416870117],[45.7197036743164,47.8652725219727],[45.7066497802734,47.9319305419922],[45.7416610717773,48.0022201538086],[45.7136001586914,48.0374984741211],[45.5519256591797,47.9919357299805],[45.3949890136719,48.0983276367188],[45.3008193969727,48.0976715087891],[45.1274871826172,48.1130523681641],[44.956657409668,48.2119369506836],[44.9247131347656,48.1991577148438],[44.9422073364258,48.1438827514648],[44.800537109375,48.052490234375],[44.6441497802734,48.0916595458984],[44.6122055053711,48.0566558837891],[44.5497131347656,48.0583267211914],[44.5358200073242,48.2063827514648],[44.3094329833984,48.2599945068359],[44.3230438232422,48.0599899291992],[44.4663772583008,48.0408325195312],[44.4677658081055,47.9785995483398],[44.386100769043,47.9141464233398],[44.3891525268555,47.8683166503906],[44.0658187866211,47.9108123779297],[44.0158309936523,47.863883972168],[44.04443359375,47.8241577148438],[43.9749908447266,47.7663879394531],[43.8413696289062,47.7574996948242],[43.7058258056641,47.6844329833984],[43.6294326782227,47.5591506958008],[43.7317733764648,47.4765548706055],[43.6533126831055,47.4422149658203],[43.5583267211914,47.4897155761719],[43.2249908447266,47.4497146606445],[43.1599807739258,47.4824905395508],[43.1355438232422,47.575553894043],[43.0591506958008,47.5763778686523],[42.9877624511719,47.5138778686523],[42.9397125244141,47.5136108398438],[42.7285995483398,47.8555526733398],[42.4986038208008,48.0105514526367],[42.3263854980469,48.0477752685547],[42.2755508422852,48.013053894043],[42.0219345092773,48.0302734375],[42.0511016845703,48.1297149658203],[42.1027755737305,48.1638793945312],[42.0449981689453,48.259162902832],[42.1519317626953,48.2822113037109],[42.0724945068359,48.4088821411133],[42.2766571044922,48.4986038208008],[42.6305465698242,48.5469436645508],[42.70166015625,48.618049621582],[42.6502685546875,48.7052688598633],[42.7461013793945,48.8063812255859],[42.6624908447266,48.8886032104492],[42.6636047363281,48.9677658081055],[42.4838790893555,49.0447158813477],[42.3927688598633,49.0497207641602],[42.3444366455078,49.1524887084961],[42.0644378662109,49.1538772583008],[42.0769424438477,49.1997146606445],[42.0319366455078,49.2663879394531],[42.0969390869141,49.2922210693359],[42.0497207641602,49.4049911499023],[42.0736083984375,49.5105514526367],[42.1127700805664,49.5258255004883],[42.177490234375,49.6908264160156],[41.8661041259766,49.9077682495117],[41.6136093139648,49.9636077880859],[41.5827713012695,50.004997253418],[41.5911026000977,50.0552673339844],[41.4822082519531,50.0902709960938],[41.3622055053711,50.2262878417969],[41.5124969482422,50.381103515625],[41.4174957275391,50.5052719116211],[41.4547119140625,50.551383972168],[41.5241622924805,50.568603515625],[41.5283279418945,50.6016616821289],[41.4074935913086,50.6194381713867],[41.3277740478516,50.7191543579102],[41.156379699707,50.7763824462891],[41.3827667236328,50.8302764892578],[41.3777694702148,50.8766555786133],[41.4119338989258,50.9036026000977],[41.7285995483398,51.0172119140625],[41.8685989379883,51.1938781738281],[41.9633255004883,51.2086029052734],[42.098876953125,51.1474914550781],[42.2672119140625,51.1316604614258],[42.4188842773438,51.1722183227539],[42.5672149658203,51.1652679443359],[42.6844329833984,51.2369384765625],[42.8730773925781,51.2314224243164],[42.9122085571289,51.2408294677734],[42.8394317626953,51.3166656494141],[42.8616638183594,51.3816604614258],[42.4895095825195,51.6078872680664],[42.5147171020508,51.6238784790039],[42.4866561889648,51.6930465698242],[42.676383972168,51.839714050293],[42.7030487060547,51.98193359375],[42.8111038208008,52.0102767944336],[42.7474899291992,52.0802764892578],[42.7533264160156,52.1858215332031],[42.9222183227539,52.3052673339844],[42.9252700805664,52.3749923706055],[43.009162902832,52.363883972168],[43.0797958374023,52.4028701782227],[43.1227645874023,52.4019317626953],[43.1902694702148,52.4666595458984],[43.3086013793945,52.4455413818359],[43.3405456542969,52.3911056518555],[43.7774887084961,52.4347152709961],[44.0552673339844,52.3460998535156],[44.3463821411133,52.3161010742188],[44.3333282470703,52.3480453491211],[44.38916015625,52.3683242797852],[44.4108200073242,52.4130477905273],[44.5436096191406,52.4294357299805],[44.5144424438477,52.4591598510742],[44.539436340332,52.4863815307617],[44.5239398173704,52.5],[44.6319105505272,52.5],[44.6648941040039,52.4793548583984],[44.8674926757812,52.4466552734375],[44.9055480957031,52.3766555786133],[44.9733200073242,52.3733215332031],[45.0505447387695,52.3172149658203],[45.1013870239258,52.3333282470703],[45.0691604614258,52.3777694702148],[45.1113815307617,52.4111022949219],[45.4419326782227,52.4005432128906],[45.5163879394531,52.4344329833984],[45.5269393920898,52.4816589355469],[45.5811689294296,52.5],[45.7287977386885,52.5],[45.7180480957031,52.4588851928711],[45.9808197021484,52.4072113037109],[45.9752655029297,52.4361038208008],[46.0163879394531,52.4577713012695],[45.9713745117188,52.4958267211914],[45.9838575070369,52.5],[47.9419326782227,52.5],[50.2622146606445,52.5],],
			},
			"519" => {
				"z1" => "44.5136111,40.1811111,Asia/Yerevan",
				"z0" => "49.8822222,40.3952778,Asia/Baku",
				"c" => "ESRI",
				"s" => "35,4",
				"p" => [[46.1782455444336,38.8411483764648],[46.0563735961914,38.8783187866211],[45.8719329833984,38.8799896240234],[45.4394226074219,38.998046875],[45.4349899291992,39.0511016845703],[45.3099899291992,39.1983184814453],[45.1419296264648,39.2174835205078],[45.1305465698242,39.2855529785156],[45.0630416870117,39.373046875],[44.9502716064453,39.4358215332031],[44.8885955810547,39.6058197021484],[44.8130416870117,39.6308135986328],[44.7788619995117,39.7063827514648],[44.6955413818359,39.7899856567383],[44.5908279418945,39.8330535888672],[44.4877777099609,39.9627685546875],[44.3472137451172,40.0238876342773],[44.2799987792969,40.0460968017578],[43.9338836669922,40.0136108398438],[43.6574935913086,40.1085968017578],[43.6577758789062,40.1397094726562],[43.7216567993164,40.1633224487305],[43.6722106933594,40.2197189331055],[43.6799926757812,40.2644348144531],[43.5941619873047,40.3374938964844],[43.6202697753906,40.41943359375],[43.5541534423828,40.4710998535156],[43.6530456542969,40.531379699707],[43.7536087036133,40.6758193969727],[43.7519378662109,40.7399978637695],[43.6861038208008,40.8419418334961],[43.6716537475586,40.9280548095703],[43.5994338989258,40.9924926757812],[43.4791564941406,41.0252685546875],[43.4607696533203,41.1129608154297],[43.4747085571289,41.1399917602539],[43.4258193969727,41.1852645874023],[43.3497085571289,41.2019348144531],[43.236930847168,41.176383972168],[43.1994323730469,41.2552719116211],[43.1236038208008,41.2552719116211],[43.207763671875,41.3069305419922],[43.0397186279297,41.3741607666016],[42.8927688598633,41.5069427490234],[42.8472137451172,41.4730529785156],[42.7883224487305,41.5086059570312],[42.8274917602539,41.5849914550781],[42.597770690918,41.5830535888672],[42.5108184814453,41.4433288574219],[42.4722137451172,41.4333267211914],[42.182487487793,41.5074996948242],[42.0502777099609,41.4905548095703],[41.9680404663086,41.519157409668],[41.8333206176758,41.4283218383789],[41.7230529785156,41.4705429077148],[41.722770690918,41.4955444335938],[41.6516647338867,41.4827728271484],[41.5315589904785,41.5238761901855],[41.7302627563477,41.7255477905273],[41.7747268676758,41.885627746582],[41.7624969482422,41.9922103881836],[41.6616516113281,42.12109375],[41.6327667236328,42.2719345092773],[41.5533218383789,42.3858184814453],[41.4613723754883,42.7080459594727],[41.220817565918,42.7986068725586],[41.1558227539062,42.7891616821289],[41.0327606201172,42.9730377197266],[40.9327697753906,42.9722137451172],[40.8435974121094,43.0677719116211],[40.5866546630859,43.0824966430664],[40.3847198486328,43.1655426025391],[40.3263778686523,43.1419296264648],[40.2247085571289,43.3144378662109],[40.0029678344727,43.379264831543],[40.0774917602539,43.5469436645508],[40.1266555786133,43.5722198486328],[40.2533874511719,43.58251953125],[40.5430526733398,43.5086059570312],[40.6847076416016,43.5458297729492],[41.0441589355469,43.3749847412109],[41.1680526733398,43.3872146606445],[41.295539855957,43.3360977172852],[41.3933258056641,43.3460998535156],[41.5897064208984,43.2227554321289],[41.9397125244141,43.2174835205078],[42.0577697753906,43.1861038208008],[42.1811065673828,43.2355499267578],[42.4152679443359,43.2391586303711],[42.6258239746094,43.1430435180664],[42.7010955810547,43.182487487793],[42.8572158813477,43.1774826049805],[43.0211029052734,43.1044387817383],[43.0108184814453,43.0566558837891],[43.2008285522461,42.9363708496094],[43.560546875,42.8608245849609],[43.6708297729492,42.7910995483398],[43.8272094726562,42.7513885498047],[43.8360977172852,42.7277679443359],[43.7355499267578,42.6391525268555],[43.9610977172852,42.5577697753906],[44.053596496582,42.618049621582],[44.220817565918,42.6369323730469],[44.2866516113281,42.7127685546875],[44.5497207641602,42.7594375610352],[44.6844329833984,42.7394256591797],[44.8038787841797,42.6172027587891],[44.8549957275391,42.7433166503906],[44.9274826049805,42.7619323730469],[45.0530395507812,42.6941528320312],[45.1713714599609,42.7008285522461],[45.3516616821289,42.529426574707],[45.5527725219727,42.5502624511719],[45.7602767944336,42.477912902832],[45.6474838256836,42.2047119140625],[45.910270690918,42.1049957275391],[45.9605407714844,42.0238723754883],[46.0108184814453,42.0430526733398],[46.0780487060547,42.0341567993164],[46.1038818359375,41.9941558837891],[46.2399826049805,42.0013885498047],[46.3199844360352,41.9388809204102],[46.3941497802734,41.9405364990234],[46.4517517089844,41.8970565795898],[46.5683288574219,41.8824844360352],[46.5666656494141,41.8077697753906],[46.5916595458984,41.7922134399414],[46.7608184814453,41.863883972168],[46.7708206176758,41.7966537475586],[46.9255447387695,41.7177658081055],[47.0430526733398,41.5583267211914],[47.1605377197266,41.5611038208008],[47.2588806152344,41.4247055053711],[47.2855529785156,41.3122024536133],[47.5219345092773,41.2541656494141],[47.571662902832,41.2110977172852],[47.6597137451172,41.2355499267578],[47.7669296264648,41.1960906982422],[47.9199905395508,41.2263717651367],[47.908317565918,41.2908325195312],[47.9624938964844,41.3594284057617],[48.0227584838867,41.361930847168],[48.0744323730469,41.4677658081055],[48.2313766479492,41.5024948120117],[48.3997116088867,41.5891494750977],[48.4713745117188,41.7235946655273],[48.5839538574219,41.8357696533203],[48.6777725219727,41.7827606201172],[48.8994369506836,41.5258255004883],[49.0399856567383,41.4141464233398],[49.1405487060547,41.2683258056641],[49.1549835205078,41.1516494750977],[49.2222137451172,41.0183258056641],[49.3980407714844,40.8497085571289],[49.5324935913086,40.7874908447266],[49.5080413818359,40.6930465698242],[49.5280456542969,40.6627655029297],[49.8049926757812,40.5647125244141],[50.0552673339844,40.5844345092773],[50.1249923706055,40.5113830566406],[50.2353591918945,40.4907989501953],[50.3629493713379,40.476734161377],[50.6222839355469,40.3274192810059],[50.6330909729004,40.2989311218262],[50.3932571411133,40.226879119873],[50.2624969482422,40.3291625976562],[50.1241607666016,40.3583297729492],[49.9805374145508,40.3199844360352],[49.8780364990234,40.3627624511719],[49.8247146606445,40.2849884033203],[49.571662902832,40.2127685546875],[49.4880447387695,40.1505355834961],[49.4958267211914,40.0905456542969],[49.4249877929688,40.0538787841797],[49.483039855957,39.9894256591797],[49.4210968017578,39.9308166503906],[49.4444274902344,39.8685989379883],[49.3933258056641,39.7783279418945],[49.4241638183594,39.7063827514648],[49.3188858032227,39.6249847412109],[49.2808227539062,39.5005416870117],[49.4136047363281,39.3838806152344],[49.4033126831055,39.3180465698242],[49.363883972168,39.3449935913086],[49.4080429077148,39.2877655029297],[49.3130416870117,39.3413696289062],[49.2580413818359,39.3194427490234],[49.2019348144531,39.0247116088867],[49.1280364990234,38.9733123779297],[49.0602645874023,38.966926574707],[49.0516586303711,39.0013885498047],[49.1269378662109,39.0299835205078],[49.1447067260742,39.0974807739258],[49.0672149658203,39.1077728271484],[49.0383224487305,39.1822128295898],[48.9555435180664,39.1652679443359],[48.9330444335938,38.9513778686523],[48.8908309936523,38.8808135986328],[48.8299865722656,38.8594284057617],[48.8666534423828,38.7458267211914],[48.8882827758789,38.4424057006836],[48.7894287109375,38.4477615356445],[48.623046875,38.395263671875],[48.4541625976562,38.5647125244141],[48.4419326782227,38.6216506958008],[48.327766418457,38.6033248901367],[48.2436065673828,38.6672058105469],[48.2438735961914,38.7277679443359],[48.0208206176758,38.8355407714844],[48.0141525268555,38.9058227539062],[48.0713806152344,38.9513778686523],[48.3124847412109,39.0077667236328],[48.327766418457,39.0516586303711],[48.2938766479492,39.1124877929688],[48.1349945068359,39.2088775634766],[48.1199798583984,39.2636108398438],[48.1891555786133,39.3333206176758],[48.3597869873047,39.3852157592773],[47.9766616821289,39.7192306518555],[47.930549621582,39.68359375],[47.8066558837891,39.6772155761719],[47.533332824707,39.5088806152344],[47.3916625976562,39.4705429077148],[47.2922134399414,39.3769378662109],[47.0997085571289,39.3044357299805],[47.0255508422852,39.1894226074219],[46.9488677978516,39.154426574707],[46.8383255004883,39.1552658081055],[46.5403747558594,38.8755874633789],[46.3547058105469,38.9105377197266],[46.1782455444336,38.8411483764648],],
			},
			"569" => {
				"z" => "Etc/GMT+5",
				"c" => "ESRI",
				"s" => "37,2",
				"p" => [[52.5,51.2488784790039],[52.5,37.5],[49.4058180922976,37.5],[49.1024856567383,37.6430435180664],[48.9977645874023,37.7636108398438],[48.941650390625,37.9074935913086],[48.8694305419922,38.3005447387695],[48.8882827758789,38.4424057006836],[48.8666534423828,38.7458267211914],[48.8299865722656,38.8594284057617],[48.8908309936523,38.8808135986328],[48.9330444335938,38.9513778686523],[48.9555435180664,39.1652679443359],[49.0383224487305,39.1822128295898],[49.0672149658203,39.1077728271484],[49.1447067260742,39.0974807739258],[49.1269378662109,39.0299835205078],[49.0516586303711,39.0013885498047],[49.0602645874023,38.966926574707],[49.1280364990234,38.9733123779297],[49.2019348144531,39.0247116088867],[49.2580413818359,39.3194427490234],[49.3130416870117,39.3413696289062],[49.4080429077148,39.2877655029297],[49.363883972168,39.3449935913086],[49.4033126831055,39.3180465698242],[49.4136047363281,39.3838806152344],[49.2808227539062,39.5005416870117],[49.3188858032227,39.6249847412109],[49.4241638183594,39.7063827514648],[49.3933258056641,39.7783279418945],[49.4444274902344,39.8685989379883],[49.4210968017578,39.9308166503906],[49.483039855957,39.9894256591797],[49.4249877929688,40.0538787841797],[49.4958267211914,40.0905456542969],[49.4880447387695,40.1505355834961],[49.571662902832,40.2127685546875],[49.8247146606445,40.2849884033203],[49.8780364990234,40.3627624511719],[49.9805374145508,40.3199844360352],[50.1241607666016,40.3583297729492],[50.2624969482422,40.3291625976562],[50.3932571411133,40.226879119873],[50.6330909729004,40.2989311218262],[50.6222839355469,40.3274192810059],[50.3629493713379,40.476734161377],[50.2353591918945,40.4907989501953],[50.1249923706055,40.5113830566406],[50.0552673339844,40.5844345092773],[49.8049926757812,40.5647125244141],[49.5280456542969,40.6627655029297],[49.5080413818359,40.6930465698242],[49.5324935913086,40.7874908447266],[49.3980407714844,40.8497085571289],[49.2222137451172,41.0183258056641],[49.1549835205078,41.1516494750977],[49.1405487060547,41.2683258056641],[49.0399856567383,41.4141464233398],[48.8994369506836,41.5258255004883],[48.6777725219727,41.7827606201172],[48.5839538574219,41.8357696533203],[48.5447158813477,41.8802719116211],[48.3866577148438,41.926383972168],[48.303596496582,42.0974807739258],[48.1177597045898,42.3263778686523],[47.9449844360352,42.4624938964844],[47.8594284057617,42.593879699707],[47.7383193969727,42.6338806152344],[47.6969375610352,42.8663787841797],[47.4622116088867,43.0191497802734],[47.4833297729492,43.207763671875],[47.5883255004883,43.2969436645508],[47.5724945068359,43.3305435180664],[47.4883193969727,43.2936096191406],[47.4872055053711,43.4563827514648],[47.5849838256836,43.7222137451172],[47.6983184814453,43.8688735961914],[47.8073081970215,43.9869155883789],[47.5321960449219,44.5000686645508],[47.4795150756836,44.4864120483398],[47.2055435180664,44.2185897827148],[47.1585998535156,44.2005386352539],[47.0924835205078,44.2402725219727],[47.0122146606445,44.3608245849609],[46.7602767944336,44.3919296264648],[46.6999969482422,44.442756652832],[46.6797103881836,44.5230407714844],[46.7244338989258,44.5447158813477],[46.7124938964844,44.6477737426758],[46.9594345092773,44.7638778686523],[47.0094375610352,44.8211059570312],[46.9916534423828,44.9219284057617],[47.075553894043,44.7827606201172],[47.1166534423828,44.8622055053711],[47.0972137451172,44.9497146606445],[47.1485977172852,44.9269409179688],[47.1991577148438,44.9685897827148],[47.2919387817383,45.1808166503906],[47.3760986328125,45.1819305419922],[47.3855438232422,45.2952728271484],[47.4627685546875,45.3808135986328],[47.3780364990234,45.411376953125],[47.4861068725586,45.4186019897461],[47.5016555786133,45.47998046875],[47.5433197021484,45.5052719116211],[47.4861907958984,45.5714569091797],[47.532470703125,45.5303344726562],[47.8165588378906,45.4321823120117],[47.9982948303223,45.5199165344238],[48.0150032043457,45.695384979248],[48.071403503418,45.7183647155762],[48.2050933837891,45.7120971679688],[48.3638534545898,45.6494293212891],[48.7461204528809,45.6974754333496],[48.7294120788574,45.8040084838867],[48.7920799255371,45.8290748596191],[48.8798141479492,45.9439659118652],[48.994701385498,46.0024566650391],[49.0573692321777,45.9836540222168],[49.1889724731445,46.0525894165039],[49.3143043518066,46.2573013305664],[49.222526550293,46.346305847168],[48.9181289672852,46.4892196655273],[48.8338775634766,46.484992980957],[48.7402725219727,46.5583267211914],[48.560546875,46.5649948120117],[48.5839996337891,46.5984268188477],[48.5541534423828,46.6438827514648],[48.476203918457,46.6676788330078],[48.5216598510742,46.743049621582],[48.6033248901367,46.7733154296875],[48.7105407714844,46.7597198486328],[48.765266418457,46.6908187866211],[48.9413757324219,46.7041625976562],[49.0272064208984,46.7760925292969],[48.7210998535156,47.0983276367188],[48.5472106933594,47.4172058105469],[48.4438705444336,47.4369277954102],[48.2044296264648,47.7049865722656],[48.0647125244141,47.7797088623047],[47.6913757324219,47.7658309936523],[47.4358215332031,47.8435974121094],[47.3833236694336,47.6888809204102],[47.1366577148438,47.8224945068359],[47.1827697753906,47.8741607666016],[47.0624847412109,47.99609375],[47.2149887084961,48.0708312988281],[47.1222076416016,48.1022186279297],[47.1383209228516,48.1699905395508],[47.0963745117188,48.2099914550781],[47.1333312988281,48.2424926757812],[47.1227645874023,48.2716598510742],[46.4991607666016,48.4174957275391],[46.7788772583008,48.936653137207],[46.9544372558594,49.013053894043],[47.0627670288086,49.1427688598633],[47.0261001586914,49.2361068725586],[46.7958297729492,49.339714050293],[46.9294357299805,49.8636093139648],[47.1883239746094,49.9441528320312],[47.302490234375,50.0319366455078],[47.3566589355469,50.0902709960938],[47.2805480957031,50.1822128295898],[47.3427658081055,50.2419357299805],[47.3166656494141,50.2944412231445],[47.4160995483398,50.3319396972656],[47.4463958740234,50.376953125],[47.5997161865234,50.460823059082],[47.7608261108398,50.3752670288086],[48.1105499267578,50.0986022949219],[48.1655426025391,49.9661026000977],[48.2488784790039,49.9088821411133],[48.2516632080078,49.8697128295898],[48.3322143554688,49.8788757324219],[48.4508285522461,49.8169403076172],[48.7969436645508,49.9419326782227],[48.9169387817383,50.0341644287109],[48.8797149658203,50.1016616821289],[48.7911071777344,50.1236038208008],[48.8111038208008,50.1941528320312],[48.7227630615234,50.3530502319336],[48.6974868774414,50.5919342041016],[48.5955429077148,50.6224899291992],[48.5936050415039,50.6483306884766],[48.8302764892578,50.5966567993164],[49.0308227539062,50.6880416870117],[49.1583251953125,50.7927703857422],[49.4258270263672,50.8513870239258],[49.4408264160156,50.9058227539062],[49.3644409179688,50.9797134399414],[49.4619369506836,51.1241607666016],[49.8041610717773,51.1102752685547],[49.9680480957031,51.2260971069336],[50.3633270263672,51.3169403076172],[50.3544387817383,51.378044128418],[50.397216796875,51.3997192382812],[50.3847198486328,51.4252700805664],[50.5488815307617,51.4685974121094],[50.5436096191406,51.5672149658203],[50.5947113037109,51.589714050293],[50.6027755737305,51.6399917602539],[50.7174911499023,51.6224899291992],[50.6827697753906,51.5730514526367],[50.810546875,51.5916595458984],[50.813606262207,51.6480484008789],[50.7586059570312,51.7197113037109],[50.7733001708984,51.7691802978516],[51.4124908447266,52.089714050293],[51.4574966430664,52.2277679443359],[51.4080429077148,52.2541656494141],[51.4069366455078,52.3491592407227],[51.4716567993164,52.3658294677734],[51.4638824462891,52.4136047363281],[51.563606262207,52.4358215332031],[51.4984527156074,52.5],[52.5,52.5],[52.5,51.2488784790039],],
			},
		},
		# Grid 3:4 ; 4 records
		"4" => {
			"331" => {
				"z1" => "45.4666667,54.7333333,Asia/Kamchatka",
				"z0" => "38.2166667,55.7166667,Asia/Kamchatka",
				"z2" => "37.6155556,55.7522222,Europe/Moscow",
				"z3" => "38.9166667,58.6166667,Asia/Kamchatka",
				"c" => "ESRI",
				"s" => "20,1",
				"p" => [[52.5,61.5447158813477],[52.5,60.9742026367824],[52.4291610717773,60.9813766479492],[52.3433227539062,60.8349914550781],[51.8877716064453,60.8766555786133],[51.773323059082,60.5969390869141],[52.1547088623047,60.5455474853516],[52.1249923706055,60.4702682495117],[52.3430480957031,60.4463806152344],[52.347770690918,60.3733215332031],[52.2981567382812,60.2417068481445],[52.0827713012695,60.3169403076172],[52.0088882446289,60.3036041259766],[51.8999938964844,60.2444381713867],[51.7999954223633,60.1108245849609],[51.5322113037109,59.9472122192383],[51.4133224487305,59.9416580200195],[51.343879699707,60.0183258056641],[51.0711059570312,60.0616607666016],[50.8286056518555,59.8627700805664],[50.4033203125,59.8444366455078],[50.2788772583008,59.8069381713867],[50.2374954223633,59.7527770996094],[49.9966583251953,59.7788772583008],[49.9519348144531,59.7472152709961],[50.0563812255859,59.6874923706055],[49.8536071777344,59.6636047363281],[49.8327713012695,59.6369400024414],[49.7872161865234,59.5005493164062],[49.8288803100586,59.4811019897461],[49.7955474853516,59.3838806152344],[49.8241653442383,59.3705444335938],[49.7955474853516,59.2222137451172],[49.5933227539062,59.2177658081055],[49.5086059570312,59.2461013793945],[49.5449981689453,59.3930511474609],[49.3419342041016,59.4191589355469],[49.3086013793945,59.4669342041016],[49.1477737426758,59.5088882446289],[49.0341644287109,59.4844360351562],[49.0855484008789,59.6555480957031],[48.5099945068359,59.7038803100586],[48.4591598510742,60.1941528320312],[48.7049942016602,60.3047103881836],[48.763053894043,60.3649978637695],[48.6758270263672,60.406379699707],[48.5413818359375,60.4111022949219],[48.6177673339844,60.4333267211914],[48.5041656494141,60.4827651977539],[48.5111083984375,60.5119400024414],[48.4811019897461,60.5249938964844],[48.5399932861328,60.5591583251953],[48.5391616821289,60.5999984741211],[48.4192428588867,60.8538589477539],[47.9874954223633,60.8866577148438],[47.9599914550781,61.0097198486328],[47.8813781738281,60.9983291625977],[47.5941543579102,61.0588836669922],[47.2283248901367,61.0644378662109],[47.1972122192383,61.0599899291992],[47.1913757324219,60.9961013793945],[47.1074981689453,60.9619369506836],[47.0802764892578,60.8622131347656],[47.0431365966797,60.8538589477539],[47.0872116088867,60.8202743530273],[46.9527740478516,60.6552658081055],[47.0238800048828,60.6469421386719],[47.0174942016602,60.6024932861328],[47.0616607666016,60.57666015625],[46.8566589355469,60.5152740478516],[46.878044128418,60.4816589355469],[46.8044357299805,60.3874969482422],[46.8319396972656,60.3797149658203],[46.8130493164062,60.3227691650391],[46.7449951171875,60.2563858032227],[46.4308242797852,60.2738800048828],[46.2949981689453,60.2424926757812],[46.3530502319336,60.209716796875],[46.3641586303711,60.1211013793945],[46.6061019897461,60.0652694702148],[46.8313827514648,60.0730514526367],[46.8963851928711,60.1258239746094],[47.0369415283203,60.1183242797852],[46.9208297729492,59.8466567993164],[46.9230499267578,59.7844390869141],[47.123046875,59.7613830566406],[47.1430511474609,59.7133255004883],[47.1135177612305,59.6113815307617],[47.0563812255859,59.3786010742188],[47.2524948120117,59.3555526733398],[47.2233200073242,59.2260971069336],[47.3944396972656,59.147216796875],[47.4449920654297,59.1674957275391],[47.4513854980469,59.1269378662109],[47.5763854980469,59.0602722167969],[47.5508270263672,58.9886016845703],[47.6116638183594,58.9149932861328],[47.4677658081055,58.884162902832],[47.4530487060547,58.922492980957],[47.3072128295898,58.9166641235352],[47.2811050415039,58.902214050293],[47.3038787841797,58.8572158813477],[47.2802734375,58.8194427490234],[47.3249969482422,58.8008270263672],[47.2649993896484,58.7541656494141],[47.1133270263672,58.7724914550781],[47.0041656494141,58.6958236694336],[47.006103515625,58.6224899291992],[46.5841598510742,58.5580444335938],[46.5902709960938,58.5183258056641],[46.5497207641602,58.4766540527344],[46.5916595458984,58.4319381713867],[46.411376953125,58.363883972168],[46.4811019897461,58.3322143554688],[46.410270690918,58.3080444335938],[46.4149932861328,58.2105484008789],[46.3552703857422,58.1872100830078],[46.3097152709961,58.1105499267578],[46.3413238525391,58.0747375488281],[46.4497146606445,58.0174942016602],[46.5230484008789,58.0388870239258],[47.3866577148438,58.023323059082],[47.4561004638672,57.9855499267578],[47.7008285522461,57.9636077880859],[47.7702713012695,57.9002685546875],[47.5611038208008,57.802490234375],[47.5508270263672,57.7649993896484],[47.5802764892578,57.7463836669922],[47.5286026000977,57.7030487060547],[47.5488815307617,57.6636047363281],[47.5263824462891,57.5841598510742],[47.4866561889648,57.584716796875],[47.4710998535156,57.5286026000977],[47.2502746582031,57.5708312988281],[47.0308227539062,57.493049621582],[46.7444381713867,57.523323059082],[46.7972183227539,57.456657409668],[46.7047119140625,57.4255523681641],[46.6897125244141,57.3908309936523],[46.7538833618164,57.3799896240234],[46.6761016845703,57.3499984741211],[46.7205429077148,57.2944412231445],[46.7897186279297,57.289436340332],[46.8088836669922,57.2358245849609],[46.851936340332,57.2344360351562],[46.8344345092773,57.1997146606445],[46.7263793945312,57.1999969482422],[46.7652740478516,57.1438827514648],[46.7680511474609,57.0297164916992],[46.7080459594727,57.0163879394531],[46.7538833618164,56.9741592407227],[46.7150955200195,56.9663391113281],[46.7447128295898,56.9547119140625],[46.7158279418945,56.9372100830078],[46.944709777832,56.9483261108398],[47.1327667236328,56.9169387817383],[47.1819381713867,56.8480453491211],[47.1227645874023,56.8374938964844],[47.1708297729492,56.8086013793945],[47.4244384765625,56.8808212280273],[47.5024948120117,56.8513870239258],[47.5113830566406,56.9066543579102],[47.6172103881836,56.9760971069336],[47.6891555786133,57.0124969482422],[47.7697143554688,57.0097198486328],[47.7336044311523,57.0552673339844],[47.7849960327148,57.0572128295898],[47.8308258056641,57.0041656494141],[47.9166641235352,56.9766540527344],[47.9311065673828,57.0094375610352],[47.9719314575195,56.973876953125],[47.9869384765625,57.0144424438477],[48.13916015625,56.9983291625977],[48.2086029052734,57.027214050293],[48.1630477905273,57.079719543457],[48.2488784790039,57.1066589355469],[48.1922149658203,57.1247100830078],[48.3077697753906,57.1686019897461],[48.4511032104492,57.1205444335938],[48.5694427490234,57.172492980957],[48.8355484008789,57.164436340332],[48.8663864135742,57.1224899291992],[48.8458251953125,57.0886001586914],[48.9547119140625,57.0855484008789],[48.998046875,57.1188812255859],[49.0119400024414,57.1933212280273],[49.0461044311523,57.2011032104492],[49.0063858032227,57.2333297729492],[49.0161056518555,57.2830505371094],[49.1833267211914,57.3313827514648],[49.2280426025391,57.2888870239258],[49.1436080932617,57.1597137451172],[49.2313766479492,57.131103515625],[49.2683258056641,57.0436096191406],[49.4191589355469,57.0219345092773],[49.4124908447266,57.0530471801758],[49.7119369506836,57.0736083984375],[49.7249908447266,56.9911041259766],[49.7619400024414,56.9649963378906],[49.7158279418945,56.9336013793945],[49.7572174072266,56.9141540527344],[49.7344360351562,56.8966598510742],[50.0144424438477,56.8672103881836],[50.0708312988281,56.8308258056641],[50.0611038208008,56.7936096191406],[50.1016616821289,56.7941589355469],[50.0722045898438,56.6226654052734],[50.1619338989258,56.6149978637695],[50.2213745117188,56.6608200073242],[50.2983322143555,56.6399917602539],[50.3230514526367,56.6544342041016],[50.3030471801758,56.676383972168],[50.347770690918,56.6736068725586],[50.4136047363281,56.628044128418],[50.4233245849609,56.5852661132812],[50.4933242797852,56.6163864135742],[50.4499969482422,56.5447158813477],[50.5697174072266,56.4024887084961],[50.631103515625,56.4052658081055],[50.5863800048828,56.3544387817383],[50.7330474853516,56.3299942016602],[50.785270690918,56.3563842773438],[50.7624969482422,56.3994369506836],[50.7849960327148,56.4155426025391],[50.8513870239258,56.3902740478516],[50.8738784790039,56.32666015625],[50.9069366455078,56.3158264160156],[50.9016571044922,56.2794342041016],[50.8611068725586,56.2780456542969],[50.8394317626953,56.2411041259766],[51.0763854980469,56.1249923706055],[51.1074981689453,56.1513824462891],[51.2049942016602,56.1394348144531],[51.2230453491211,56.0991592407227],[51.3147125244141,56.0697174072266],[51.3619384765625,56.1305465698242],[51.4366683959961,56.1444396972656],[51.6536026000977,56.1344375610352],[51.489990234375,56.0788803100586],[51.3972091674805,55.9921875],[51.4302749633789,55.9272155761719],[51.6427688598633,55.9605484008789],[51.6894302368164,55.9327697753906],[51.7297134399414,55.959716796875],[51.7888870239258,55.8838806152344],[51.960823059082,55.9791564941406],[52.0374984741211,55.9591598510742],[52.0563812255859,55.8949966430664],[52.1691589355469,55.8930511474609],[52.2516632080078,55.9580459594727],[52.2041625976562,56.0044403076172],[52.2461013793945,56.0669403076172],[52.1869354248047,56.0552673339844],[52.2047119140625,56.0841598510742],[52.436653137207,56.0283279418945],[52.4847183227539,56.0369415283203],[52.4466552734375,56.063606262207],[52.4677658081055,56.0774917602539],[52.5,56.0672230086259],[52.5,54.3968998314337],[52.4941558837891,54.3999938964844],[52.5,54.4341163177229],[52.5,54.4532270265692],[52.4394302368164,54.478874206543],[52.3791580200195,54.414436340332],[52.3505477905273,54.4233245849609],[52.363883972168,54.4591598510742],[52.209716796875,54.4430465698242],[52.1999969482422,54.406379699707],[52.1049957275391,54.4005432128906],[52.1202697753906,54.3511047363281],[52.0852661132812,54.3394317626953],[52.0199890136719,54.436653137207],[51.9327697753906,54.4363784790039],[51.9272155761719,54.5361099243164],[51.6797180175781,54.5616607666016],[51.523323059082,54.6463851928711],[51.4938812255859,54.5952682495117],[51.3938827514648,54.5930480957031],[51.3955459594727,54.6772155761719],[51.281379699707,54.6369400024414],[51.1811065673828,54.6463851928711],[51.0936050415039,54.5486068725586],[51.0097198486328,54.5516586303711],[50.9927673339844,54.4991607666016],[51.0172119140625,54.4791564941406],[50.9361038208008,54.3399887084961],[50.7030487060547,54.4283294677734],[50.5186004638672,54.3263854980469],[50.4716567993164,54.4233245849609],[50.4294357299805,54.427490234375],[50.3888854980469,54.488883972168],[50.2766571044922,54.440544128418],[50.2252655029297,54.5036087036133],[50.0768814086914,54.5166702270508],[50.1255493164062,54.48193359375],[50.1172103881836,54.4302749633789],[50.2111053466797,54.4216613769531],[50.1994323730469,54.384162902832],[50.2622146606445,54.289436340332],[50.2030487060547,54.1402740478516],[50.2255477905273,54.0791625976562],[50.1974868774414,54.0372161865234],[49.9744338989258,53.9613800048828],[49.9536056518555,53.9052658081055],[50.0530471801758,53.8685989379883],[50.0377731323242,53.8252716064453],[49.8572158813477,53.8336029052734],[49.8380432128906,53.8908309936523],[49.618049621582,53.8113784790039],[49.6091613769531,53.8549957275391],[49.422492980957,53.8708267211914],[49.3430480957031,53.869987487793],[49.3169403076172,53.8333282470703],[49.0369415283203,53.8594360351562],[48.8633270263672,53.7127685546875],[48.4722137451172,53.7708282470703],[48.513053894043,53.6963806152344],[48.6033248901367,53.6694412231445],[48.4460983276367,53.6660995483398],[48.4269409179688,53.6291580200195],[48.3563842773438,53.6711044311523],[48.3141555786133,53.6558227539062],[48.3549957275391,53.6016616821289],[48.4408264160156,53.5813827514648],[48.3766555786133,53.5427703857422],[48.3783264160156,53.4713745117188],[48.2361068725586,53.4588851928711],[48.2224884033203,53.4244384765625],[48.1663818359375,53.4824905395508],[48.0485229492188,53.4777069091797],[48.0036087036133,53.4066543579102],[47.9419326782227,53.3758239746094],[48.0933227539062,53.2619400024414],[48.1313781738281,53.1688842773438],[48.2122116088867,53.1458282470703],[48.1447143554688,53.0591583251953],[48.2236022949219,52.9972152709961],[48.2694396972656,53.0577697753906],[48.3688812255859,53.0663833618164],[48.3183288574219,52.9855499267578],[48.5105667114258,52.9779891967773],[48.5780487060547,52.935546875],[48.5869369506836,52.8685989379883],[48.4300689697266,52.7805480957031],[48.2888870239258,52.8108215332031],[48.1094360351562,52.801383972168],[47.984992980957,52.7472152709961],[48.0874938964844,52.73193359375],[48.0786056518555,52.7055511474609],[47.9252700805664,52.6660995483398],[47.9002685546875,52.7222137451172],[47.8597183227539,52.7316589355469],[47.7730484008789,52.6797180175781],[47.7811050415039,52.6291580200195],[47.7247085571289,52.5791625976562],[47.5563812255859,52.6183242797852],[47.4383239746094,52.5672149658203],[47.2061004638672,52.5666656494141],[47.1536026000977,52.609992980957],[47.068603515625,52.5663833618164],[46.9460983276367,52.6383285522461],[46.8307723999023,52.6164016723633],[46.6169357299805,52.6611022949219],[46.613883972168,52.7274856567383],[46.5802764892578,52.7324905395508],[46.3999938964844,52.672492980957],[46.2983322143555,52.680549621582],[46.2761001586914,52.618049621582],[46.1533203125,52.601936340332],[46.1458282470703,52.5497207641602],[46.0874938964844,52.5638809204102],[46.0644378662109,52.5269393920898],[45.9838575070369,52.5],[45.7287977386885,52.5],[45.7355499267578,52.5258255004883],[45.6411056518555,52.5202713012695],[45.5811689294296,52.5],[44.6319105505272,52.5],[44.5480499267578,52.552490234375],[44.4936065673828,52.5266571044922],[44.5239398173704,52.5],[37.5,52.5],[37.5,67.5],[52.5,67.5],[52.5,65.0672149658203],[52.5,61.5447158813477],],
			},
			"516" => {
				"z" => "Etc/GMT+4",
				"c" => "ESRI",
				"s" => "35,2",
				"p" => [[52.5,57.5180511474609],[52.5,56.0672230086259],[52.4677658081055,56.0774917602539],[52.4466552734375,56.063606262207],[52.4847183227539,56.0369415283203],[52.436653137207,56.0283279418945],[52.2047119140625,56.0841598510742],[52.1869354248047,56.0552673339844],[52.2461013793945,56.0669403076172],[52.2041625976562,56.0044403076172],[52.2516632080078,55.9580459594727],[52.1691589355469,55.8930511474609],[52.0563812255859,55.8949966430664],[52.0374984741211,55.9591598510742],[51.960823059082,55.9791564941406],[51.7888870239258,55.8838806152344],[51.7297134399414,55.959716796875],[51.6894302368164,55.9327697753906],[51.6427688598633,55.9605484008789],[51.4302749633789,55.9272155761719],[51.3972091674805,55.9921875],[51.489990234375,56.0788803100586],[51.6536026000977,56.1344375610352],[51.4366683959961,56.1444396972656],[51.3619384765625,56.1305465698242],[51.3147125244141,56.0697174072266],[51.2230453491211,56.0991592407227],[51.2049942016602,56.1394348144531],[51.1074981689453,56.1513824462891],[51.0763854980469,56.1249923706055],[50.8394317626953,56.2411041259766],[50.8611068725586,56.2780456542969],[50.9016571044922,56.2794342041016],[50.9069366455078,56.3158264160156],[50.8738784790039,56.32666015625],[50.8513870239258,56.3902740478516],[50.7849960327148,56.4155426025391],[50.7624969482422,56.3994369506836],[50.785270690918,56.3563842773438],[50.7330474853516,56.3299942016602],[50.5863800048828,56.3544387817383],[50.631103515625,56.4052658081055],[50.5697174072266,56.4024887084961],[50.4499969482422,56.5447158813477],[50.4933242797852,56.6163864135742],[50.4233245849609,56.5852661132812],[50.4136047363281,56.628044128418],[50.347770690918,56.6736068725586],[50.3030471801758,56.676383972168],[50.3230514526367,56.6544342041016],[50.2983322143555,56.6399917602539],[50.2213745117188,56.6608200073242],[50.1619338989258,56.6149978637695],[50.0722045898438,56.6226654052734],[50.1016616821289,56.7941589355469],[50.0611038208008,56.7936096191406],[50.0708312988281,56.8308258056641],[50.0144424438477,56.8672103881836],[49.7344360351562,56.8966598510742],[49.7572174072266,56.9141540527344],[49.7158279418945,56.9336013793945],[49.7619400024414,56.9649963378906],[49.7249908447266,56.9911041259766],[49.7119369506836,57.0736083984375],[49.4124908447266,57.0530471801758],[49.4191589355469,57.0219345092773],[49.2683258056641,57.0436096191406],[49.2313766479492,57.131103515625],[49.1436080932617,57.1597137451172],[49.2280426025391,57.2888870239258],[49.1833267211914,57.3313827514648],[49.0161056518555,57.2830505371094],[49.0063858032227,57.2333297729492],[49.0461044311523,57.2011032104492],[49.0119400024414,57.1933212280273],[48.998046875,57.1188812255859],[48.9547119140625,57.0855484008789],[48.8458251953125,57.0886001586914],[48.8663864135742,57.1224899291992],[48.8355484008789,57.164436340332],[48.5694427490234,57.172492980957],[48.4511032104492,57.1205444335938],[48.3077697753906,57.1686019897461],[48.1922149658203,57.1247100830078],[48.2488784790039,57.1066589355469],[48.1630477905273,57.079719543457],[48.2086029052734,57.027214050293],[48.13916015625,56.9983291625977],[47.9869384765625,57.0144424438477],[47.9719314575195,56.973876953125],[47.9311065673828,57.0094375610352],[47.9166641235352,56.9766540527344],[47.8308258056641,57.0041656494141],[47.7849960327148,57.0572128295898],[47.7336044311523,57.0552673339844],[47.7697143554688,57.0097198486328],[47.6891555786133,57.0124969482422],[47.6172103881836,56.9760971069336],[47.5113830566406,56.9066543579102],[47.5024948120117,56.8513870239258],[47.4244384765625,56.8808212280273],[47.1708297729492,56.8086013793945],[47.1227645874023,56.8374938964844],[47.1819381713867,56.8480453491211],[47.1327667236328,56.9169387817383],[46.944709777832,56.9483261108398],[46.7158279418945,56.9372100830078],[46.7447128295898,56.9547119140625],[46.7150955200195,56.9663391113281],[46.7538833618164,56.9741592407227],[46.7080459594727,57.0163879394531],[46.7680511474609,57.0297164916992],[46.7652740478516,57.1438827514648],[46.7263793945312,57.1999969482422],[46.8344345092773,57.1997146606445],[46.851936340332,57.2344360351562],[46.8088836669922,57.2358245849609],[46.7897186279297,57.289436340332],[46.7205429077148,57.2944412231445],[46.6761016845703,57.3499984741211],[46.7538833618164,57.3799896240234],[46.6897125244141,57.3908309936523],[46.7047119140625,57.4255523681641],[46.7972183227539,57.456657409668],[46.7444381713867,57.523323059082],[47.0308227539062,57.493049621582],[47.2502746582031,57.5708312988281],[47.4710998535156,57.5286026000977],[47.4866561889648,57.584716796875],[47.5263824462891,57.5841598510742],[47.5488815307617,57.6636047363281],[47.5286026000977,57.7030487060547],[47.5802764892578,57.7463836669922],[47.5508270263672,57.7649993896484],[47.5611038208008,57.802490234375],[47.7702713012695,57.9002685546875],[47.7008285522461,57.9636077880859],[47.4561004638672,57.9855499267578],[47.3866577148438,58.023323059082],[46.5230484008789,58.0388870239258],[46.4497146606445,58.0174942016602],[46.3413238525391,58.0747375488281],[46.3097152709961,58.1105499267578],[46.3552703857422,58.1872100830078],[46.4149932861328,58.2105484008789],[46.410270690918,58.3080444335938],[46.4811019897461,58.3322143554688],[46.411376953125,58.363883972168],[46.5916595458984,58.4319381713867],[46.5497207641602,58.4766540527344],[46.5902709960938,58.5183258056641],[46.5841598510742,58.5580444335938],[47.006103515625,58.6224899291992],[47.0041656494141,58.6958236694336],[47.1133270263672,58.7724914550781],[47.2649993896484,58.7541656494141],[47.3249969482422,58.8008270263672],[47.2802734375,58.8194427490234],[47.3038787841797,58.8572158813477],[47.2811050415039,58.902214050293],[47.3072128295898,58.9166641235352],[47.4530487060547,58.922492980957],[47.4677658081055,58.884162902832],[47.6116638183594,58.9149932861328],[47.5508270263672,58.9886016845703],[47.5763854980469,59.0602722167969],[47.4513854980469,59.1269378662109],[47.4449920654297,59.1674957275391],[47.3944396972656,59.147216796875],[47.2233200073242,59.2260971069336],[47.2524948120117,59.3555526733398],[47.0563812255859,59.3786010742188],[47.1135177612305,59.6113815307617],[47.1430511474609,59.7133255004883],[47.123046875,59.7613830566406],[46.9230499267578,59.7844390869141],[46.9208297729492,59.8466567993164],[47.0369415283203,60.1183242797852],[46.8963851928711,60.1258239746094],[46.8313827514648,60.0730514526367],[46.6061019897461,60.0652694702148],[46.3641586303711,60.1211013793945],[46.3530502319336,60.209716796875],[46.2949981689453,60.2424926757812],[46.4308242797852,60.2738800048828],[46.7449951171875,60.2563858032227],[46.8130493164062,60.3227691650391],[46.8319396972656,60.3797149658203],[46.8044357299805,60.3874969482422],[46.878044128418,60.4816589355469],[46.8566589355469,60.5152740478516],[47.0616607666016,60.57666015625],[47.0174942016602,60.6024932861328],[47.0238800048828,60.6469421386719],[46.9527740478516,60.6552658081055],[47.0872116088867,60.8202743530273],[47.0431365966797,60.8538589477539],[47.0802764892578,60.8622131347656],[47.1074981689453,60.9619369506836],[47.1913757324219,60.9961013793945],[47.1972122192383,61.0599899291992],[47.2283248901367,61.0644378662109],[47.5941543579102,61.0588836669922],[47.8813781738281,60.9983291625977],[47.9599914550781,61.0097198486328],[47.9874954223633,60.8866577148438],[48.4192428588867,60.8538589477539],[48.5391616821289,60.5999984741211],[48.5399932861328,60.5591583251953],[48.4811019897461,60.5249938964844],[48.5111083984375,60.5119400024414],[48.5041656494141,60.4827651977539],[48.6177673339844,60.4333267211914],[48.5413818359375,60.4111022949219],[48.6758270263672,60.406379699707],[48.763053894043,60.3649978637695],[48.7049942016602,60.3047103881836],[48.4591598510742,60.1941528320312],[48.5099945068359,59.7038803100586],[49.0855484008789,59.6555480957031],[49.0341644287109,59.4844360351562],[49.1477737426758,59.5088882446289],[49.3086013793945,59.4669342041016],[49.3419342041016,59.4191589355469],[49.5449981689453,59.3930511474609],[49.5086059570312,59.2461013793945],[49.5933227539062,59.2177658081055],[49.7955474853516,59.2222137451172],[49.8241653442383,59.3705444335938],[49.7955474853516,59.3838806152344],[49.8288803100586,59.4811019897461],[49.7872161865234,59.5005493164062],[49.8327713012695,59.6369400024414],[49.8536071777344,59.6636047363281],[50.0563812255859,59.6874923706055],[49.9519348144531,59.7472152709961],[49.9966583251953,59.7788772583008],[50.2374954223633,59.7527770996094],[50.2788772583008,59.8069381713867],[50.4033203125,59.8444366455078],[50.8286056518555,59.8627700805664],[51.0711059570312,60.0616607666016],[51.343879699707,60.0183258056641],[51.4133224487305,59.9416580200195],[51.5322113037109,59.9472122192383],[51.7999954223633,60.1108245849609],[51.8999938964844,60.2444381713867],[52.0088882446289,60.3036041259766],[52.0827713012695,60.3169403076172],[52.2981567382812,60.2417068481445],[52.4272155761719,60.2030487060547],[52.5,60.1975747693231],[52.5,59.1411056518555],[52.5,57.5180511474609],],
			},
			"518" => {
				"z" => "Europe/Samara",
				"c" => "ESRI",
				"s" => "35,3",
				"p" => [[45.7066497802734,52.5],[44.5239398173704,52.5],[44.4936065673828,52.5266571044922],[44.5480499267578,52.552490234375],[44.6319105505272,52.5],[45.5811689294296,52.5],[45.6411056518555,52.5202713012695],[45.7355499267578,52.5258255004883],[45.7287977386885,52.5],[45.9838575070369,52.5],[46.0644378662109,52.5269393920898],[46.0874938964844,52.5638809204102],[46.1458282470703,52.5497207641602],[46.1533203125,52.601936340332],[46.2761001586914,52.618049621582],[46.2983322143555,52.680549621582],[46.3999938964844,52.672492980957],[46.5802764892578,52.7324905395508],[46.613883972168,52.7274856567383],[46.6169357299805,52.6611022949219],[46.8307723999023,52.6164016723633],[46.9460983276367,52.6383285522461],[47.068603515625,52.5663833618164],[47.1536026000977,52.609992980957],[47.2061004638672,52.5666656494141],[47.4383239746094,52.5672149658203],[47.5563812255859,52.6183242797852],[47.7247085571289,52.5791625976562],[47.7811050415039,52.6291580200195],[47.7730484008789,52.6797180175781],[47.8597183227539,52.7316589355469],[47.9002685546875,52.7222137451172],[47.9252700805664,52.6660995483398],[48.0786056518555,52.7055511474609],[48.0874938964844,52.73193359375],[47.984992980957,52.7472152709961],[48.1094360351562,52.801383972168],[48.2888870239258,52.8108215332031],[48.4300689697266,52.7805480957031],[48.5869369506836,52.8685989379883],[48.5780487060547,52.935546875],[48.5105667114258,52.9779891967773],[48.3183288574219,52.9855499267578],[48.3688812255859,53.0663833618164],[48.2694396972656,53.0577697753906],[48.2236022949219,52.9972152709961],[48.1447143554688,53.0591583251953],[48.2122116088867,53.1458282470703],[48.1313781738281,53.1688842773438],[48.0933227539062,53.2619400024414],[47.9419326782227,53.3758239746094],[48.0036087036133,53.4066543579102],[48.0485229492188,53.4777069091797],[48.1663818359375,53.4824905395508],[48.2224884033203,53.4244384765625],[48.2361068725586,53.4588851928711],[48.3783264160156,53.4713745117188],[48.3766555786133,53.5427703857422],[48.4408264160156,53.5813827514648],[48.3549957275391,53.6016616821289],[48.3141555786133,53.6558227539062],[48.3563842773438,53.6711044311523],[48.4269409179688,53.6291580200195],[48.4460983276367,53.6660995483398],[48.6033248901367,53.6694412231445],[48.513053894043,53.6963806152344],[48.4722137451172,53.7708282470703],[48.8633270263672,53.7127685546875],[49.0369415283203,53.8594360351562],[49.3169403076172,53.8333282470703],[49.3430480957031,53.869987487793],[49.422492980957,53.8708267211914],[49.6091613769531,53.8549957275391],[49.618049621582,53.8113784790039],[49.8380432128906,53.8908309936523],[49.8572158813477,53.8336029052734],[50.0377731323242,53.8252716064453],[50.0530471801758,53.8685989379883],[49.9536056518555,53.9052658081055],[49.9744338989258,53.9613800048828],[50.1974868774414,54.0372161865234],[50.2255477905273,54.0791625976562],[50.2030487060547,54.1402740478516],[50.2622146606445,54.289436340332],[50.1994323730469,54.384162902832],[50.2111053466797,54.4216613769531],[50.1172103881836,54.4302749633789],[50.1255493164062,54.48193359375],[50.0768814086914,54.5166702270508],[50.2252655029297,54.5036087036133],[50.2766571044922,54.440544128418],[50.3888854980469,54.488883972168],[50.4294357299805,54.427490234375],[50.4716567993164,54.4233245849609],[50.5186004638672,54.3263854980469],[50.7030487060547,54.4283294677734],[50.9361038208008,54.3399887084961],[51.0172119140625,54.4791564941406],[50.9927673339844,54.4991607666016],[51.0097198486328,54.5516586303711],[51.0936050415039,54.5486068725586],[51.1811065673828,54.6463851928711],[51.281379699707,54.6369400024414],[51.3955459594727,54.6772155761719],[51.3938827514648,54.5930480957031],[51.4938812255859,54.5952682495117],[51.523323059082,54.6463851928711],[51.6797180175781,54.5616607666016],[51.9272155761719,54.5361099243164],[51.9327697753906,54.4363784790039],[52.0199890136719,54.436653137207],[52.0852661132812,54.3394317626953],[52.1202697753906,54.3511047363281],[52.1049957275391,54.4005432128906],[52.1999969482422,54.406379699707],[52.209716796875,54.4430465698242],[52.363883972168,54.4591598510742],[52.3505477905273,54.4233245849609],[52.3791580200195,54.414436340332],[52.4394302368164,54.478874206543],[52.5,54.4532270265692],[52.5,54.4341163177229],[52.4941558837891,54.3999938964844],[52.5,54.3968998314337],[52.5,54.3222587134538],[52.2794342041016,54.3283309936523],[52.1944351196289,54.2972183227539],[52.3460998535156,54.2266540527344],[52.343879699707,54.1719360351562],[52.2583312988281,54.1499938964844],[52.2719345092773,54.113883972168],[52.3980484008789,54.1286010742188],[52.4874954223633,54.0577697753906],[52.3705444335938,53.9760971069336],[52.4141540527344,53.9302749633789],[52.2580490112305,53.6552658081055],[52.1836013793945,53.5569381713867],[52.0916595458984,53.5502700805664],[52.0752716064453,53.5063858032227],[52.1349945068359,53.4491577148438],[52.1380462646484,53.4030456542969],[52.1966552734375,53.3794326782227],[52.13916015625,53.2916641235352],[52.1638793945312,53.2616653442383],[52.1236038208008,53.223876953125],[52.134162902832,53.1749954223633],[52.0547103881836,53.1424942016602],[52.1597137451172,53.0966567993164],[52.0624923706055,53.0783309936523],[52.0538787841797,52.9905471801758],[51.8669357299805,52.9294357299805],[51.8241653442383,52.8738784790039],[51.7280426025391,52.8719329833984],[51.7155456542969,52.8227691650391],[51.7794342041016,52.7958297729492],[51.7336044311523,52.6674957275391],[51.5341644287109,52.6741638183594],[51.5066604614258,52.6327667236328],[51.5505447387695,52.5741653442383],[51.4736022949219,52.579719543457],[51.4708251953125,52.527214050293],[51.4984527156074,52.5],[46.8305435180664,52.5],[45.7066497802734,52.5],],
			},
			"570" => {
				"z" => "Etc/GMT+5",
				"c" => "ESRI",
				"s" => "37,2",
				"p" => [[52.5,59.4197158813477],[52.5,52.5],[51.4984527156074,52.5],[51.4708251953125,52.527214050293],[51.4736022949219,52.579719543457],[51.5505447387695,52.5741653442383],[51.5066604614258,52.6327667236328],[51.5341644287109,52.6741638183594],[51.7336044311523,52.6674957275391],[51.7794342041016,52.7958297729492],[51.7155456542969,52.8227691650391],[51.7280426025391,52.8719329833984],[51.8241653442383,52.8738784790039],[51.8669357299805,52.9294357299805],[52.0538787841797,52.9905471801758],[52.0624923706055,53.0783309936523],[52.1597137451172,53.0966567993164],[52.0547103881836,53.1424942016602],[52.134162902832,53.1749954223633],[52.1236038208008,53.223876953125],[52.1638793945312,53.2616653442383],[52.13916015625,53.2916641235352],[52.1966552734375,53.3794326782227],[52.1380462646484,53.4030456542969],[52.1349945068359,53.4491577148438],[52.0752716064453,53.5063858032227],[52.0916595458984,53.5502700805664],[52.1836013793945,53.5569381713867],[52.2580490112305,53.6552658081055],[52.4141540527344,53.9302749633789],[52.3705444335938,53.9760971069336],[52.4874954223633,54.0577697753906],[52.3980484008789,54.1286010742188],[52.2719345092773,54.113883972168],[52.2583312988281,54.1499938964844],[52.343879699707,54.1719360351562],[52.3460998535156,54.2266540527344],[52.1944351196289,54.2972183227539],[52.2794342041016,54.3283309936523],[52.5,54.3222587134538],[52.5,60.1975747693231],[52.4272155761719,60.2030487060547],[52.2981567382812,60.2417068481445],[52.347770690918,60.3733215332031],[52.3430480957031,60.4463806152344],[52.1249923706055,60.4702682495117],[52.1547088623047,60.5455474853516],[51.773323059082,60.5969390869141],[51.8877716064453,60.8766555786133],[52.3433227539062,60.8349914550781],[52.4291610717773,60.9813766479492],[52.5,60.9742026367824],[52.5,60.8533248901367],[52.5,59.4197158813477],],
			},
		},
		# Grid 3:5 ; 1 records
		"5" => {
			"94" => {
				"z" => "Etc/GMT+2",
				"c" => "ESRI",
				"s" => "10,1",
				"p" => [[37.5,71.1892166137695],[37.5,82.5],[37.5368957519531,82.5],[37.5368957519531,81.4749374389648],[37.5,81.4749374389648],[37.5,78.7119979858398],[37.5944557189941,78.7119979858398],[37.5368957519531,68.8690185546875],[37.5,68.8712287984285],[37.5,71.1892166137695],],
			},
		},
		# Grid 3:6 ; 2 records
		"6" => {
			"def_z" => "Etc/GMT+2",
			"514" => {
				"z" => "Etc/GMT+4",
				"c" => "ESRI",
				"s" => "35,1",
				"p" => [[52.5,82.8151035677391],[52.4965591430664,82.8150863647461],[52.4965591430664,90],[52.5,90],[52.5,82.8151035677391],],
			},
		},
	},
};

# Used by Class::Singleton
sub _new_instance
{
	return shift->_init( @_, data => $data );
}

1;
