use strict;
use warnings;
use utf8;

use FindBin;
use lib ("lib", "$FindBin::Bin/../blib/lib", "$FindBin::Bin/../blib/arch");

use Lingua::RU::Money::XS qw(rur2words);
use Test::Spec;

describe "Convert kopek to word, amount: " => sub {
	it "0.00" => sub { is rur2words(0.00), "00 копеек"; };
	it "0.01" => sub { is rur2words(0.01), "01 копейка"; };
	it "0.02" => sub { is rur2words(0.02), "02 копейки"; };
	it "0.03" => sub { is rur2words(0.03), "03 копейки"; };
	it "0.04" => sub { is rur2words(0.04), "04 копейки"; };
	it "0.05" => sub { is rur2words(0.05), "05 копеек"; };
	it "0.06" => sub { is rur2words(0.06), "06 копеек"; };
	it "0.07" => sub { is rur2words(0.07), "07 копеек"; };
	it "0.08" => sub { is rur2words(0.08), "08 копеек"; };
	it "0.09" => sub { is rur2words(0.09), "09 копеек"; };
	it "0.10" => sub { is rur2words(0.10), "10 копеек"; };
	it "0.11" => sub { is rur2words(0.11), "11 копеек"; };
	it "0.12" => sub { is rur2words(0.12), "12 копеек"; };
	it "0.13" => sub { is rur2words(0.13), "13 копеек"; };
	it "0.14" => sub { is rur2words(0.14), "14 копеек"; };
	it "0.15" => sub { is rur2words(0.15), "15 копеек"; };
	it "0.16" => sub { is rur2words(0.16), "16 копеек"; };
	it "0.17" => sub { is rur2words(0.17), "17 копеек"; };
	it "0.18" => sub { is rur2words(0.18), "18 копеек"; };
	it "0.19" => sub { is rur2words(0.19), "19 копеек"; };
	it "0.20" => sub { is rur2words(0.20), "20 копеек"; };
	it "0.21" => sub { is rur2words(0.21), "21 копейка"; };
	it "0.22" => sub { is rur2words(0.22), "22 копейки"; };
	it "0.23" => sub { is rur2words(0.23), "23 копейки"; };
	it "0.24" => sub { is rur2words(0.24), "24 копейки"; };
	it "0.25" => sub { is rur2words(0.25), "25 копеек"; };
	it "0.26" => sub { is rur2words(0.26), "26 копеек"; };
	it "0.27" => sub { is rur2words(0.27), "27 копеек"; };
	it "0.28" => sub { is rur2words(0.28), "28 копеек"; };
	it "0.29" => sub { is rur2words(0.29), "29 копеек"; };
	it "0.30" => sub { is rur2words(0.30), "30 копеек"; };
	it "0.31" => sub { is rur2words(0.31), "31 копейка"; };
	it "0.32" => sub { is rur2words(0.32), "32 копейки"; };
	it "0.33" => sub { is rur2words(0.33), "33 копейки"; };
	it "0.34" => sub { is rur2words(0.34), "34 копейки"; };
	it "0.35" => sub { is rur2words(0.35), "35 копеек"; };
	it "0.36" => sub { is rur2words(0.36), "36 копеек"; };
	it "0.37" => sub { is rur2words(0.37), "37 копеек"; };
	it "0.38" => sub { is rur2words(0.38), "38 копеек"; };
	it "0.39" => sub { is rur2words(0.39), "39 копеек"; };
	it "0.40" => sub { is rur2words(0.40), "40 копеек"; };
	it "0.41" => sub { is rur2words(0.41), "41 копейка"; };
	it "0.42" => sub { is rur2words(0.42), "42 копейки"; };
	it "0.43" => sub { is rur2words(0.43), "43 копейки"; };
	it "0.44" => sub { is rur2words(0.44), "44 копейки"; };
	it "0.45" => sub { is rur2words(0.45), "45 копеек"; };
	it "0.46" => sub { is rur2words(0.46), "46 копеек"; };
	it "0.47" => sub { is rur2words(0.47), "47 копеек"; };
	it "0.48" => sub { is rur2words(0.48), "48 копеек"; };
	it "0.49" => sub { is rur2words(0.49), "49 копеек"; };
	it "0.50" => sub { is rur2words(0.50), "50 копеек"; };
	it "0.51" => sub { is rur2words(0.51), "51 копейка"; };
	it "0.52" => sub { is rur2words(0.52), "52 копейки"; };
	it "0.53" => sub { is rur2words(0.53), "53 копейки"; };
	it "0.54" => sub { is rur2words(0.54), "54 копейки"; };
	it "0.55" => sub { is rur2words(0.55), "55 копеек"; };
	it "0.56" => sub { is rur2words(0.56), "56 копеек"; };
	it "0.57" => sub { is rur2words(0.57), "57 копеек"; };
	it "0.58" => sub { is rur2words(0.58), "58 копеек"; };
	it "0.59" => sub { is rur2words(0.59), "59 копеек"; };
	it "0.60" => sub { is rur2words(0.60), "60 копеек"; };
	it "0.61" => sub { is rur2words(0.61), "61 копейка"; };
	it "0.62" => sub { is rur2words(0.62), "62 копейки"; };
	it "0.63" => sub { is rur2words(0.63), "63 копейки"; };
	it "0.64" => sub { is rur2words(0.64), "64 копейки"; };
	it "0.65" => sub { is rur2words(0.65), "65 копеек"; };
	it "0.66" => sub { is rur2words(0.66), "66 копеек"; };
	it "0.67" => sub { is rur2words(0.67), "67 копеек"; };
	it "0.68" => sub { is rur2words(0.68), "68 копеек"; };
	it "0.69" => sub { is rur2words(0.69), "69 копеек"; };
	it "0.70" => sub { is rur2words(0.70), "70 копеек"; };
	it "0.71" => sub { is rur2words(0.71), "71 копейка"; };
	it "0.72" => sub { is rur2words(0.72), "72 копейки"; };
	it "0.73" => sub { is rur2words(0.73), "73 копейки"; };
	it "0.74" => sub { is rur2words(0.74), "74 копейки"; };
	it "0.75" => sub { is rur2words(0.75), "75 копеек"; };
	it "0.76" => sub { is rur2words(0.76), "76 копеек"; };
	it "0.77" => sub { is rur2words(0.77), "77 копеек"; };
	it "0.78" => sub { is rur2words(0.78), "78 копеек"; };
	it "0.79" => sub { is rur2words(0.79), "79 копеек"; };
	it "0.80" => sub { is rur2words(0.80), "80 копеек"; };
	it "0.81" => sub { is rur2words(0.81), "81 копейка"; };
	it "0.82" => sub { is rur2words(0.82), "82 копейки"; };
	it "0.83" => sub { is rur2words(0.83), "83 копейки"; };
	it "0.84" => sub { is rur2words(0.84), "84 копейки"; };
	it "0.85" => sub { is rur2words(0.85), "85 копеек"; };
	it "0.86" => sub { is rur2words(0.86), "86 копеек"; };
	it "0.87" => sub { is rur2words(0.87), "87 копеек"; };
	it "0.88" => sub { is rur2words(0.88), "88 копеек"; };
	it "0.89" => sub { is rur2words(0.89), "89 копеек"; };
	it "0.90" => sub { is rur2words(0.90), "90 копеек"; };
	it "0.91" => sub { is rur2words(0.91), "91 копейка"; };
	it "0.92" => sub { is rur2words(0.92), "92 копейки"; };
	it "0.93" => sub { is rur2words(0.93), "93 копейки"; };
	it "0.94" => sub { is rur2words(0.94), "94 копейки"; };
	it "0.95" => sub { is rur2words(0.95), "95 копеек"; };
	it "0.96" => sub { is rur2words(0.96), "96 копеек"; };
	it "0.97" => sub { is rur2words(0.97), "97 копеек"; };
	it "0.98" => sub { is rur2words(0.98), "98 копеек"; };
	it "0.99" => sub { is rur2words(0.99), "99 копеек"; };
};

runtests unless caller;
