/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.maxent;

import edu.stanford.nlp.io.InDataStreamFile;
import edu.stanford.nlp.io.OutDataStreamFile;
import edu.stanford.nlp.maxent.Experiments;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.IntPair;
import java.io.PrintStream;
import java.util.HashMap;

public class Feature {
    public int[] indexedValues;
    public double[] valuesI;
    static Experiments domain;
    protected HashMap<Integer, Double> hashValues;
    public double sum;
    public Index<IntPair> instanceIndex;

    public Feature() {
    }

    public Feature(Experiments e, double[] vals, Index<IntPair> instanceIndex) {
        this.instanceIndex = instanceIndex;
        HashMap<Integer, Double> setNonZeros = new HashMap<Integer, Double>();
        for (int i = 0; i < vals.length; ++i) {
            if (vals[i] == 0.0) continue;
            Integer in = this.indexOf(e.get(i)[0], e.get(i)[1]);
            Object val = setNonZeros.get(in);
            if (val == null) {
                setNonZeros.put(in, new Double(vals[i]));
                continue;
            }
            if ((Double)val == vals[i]) continue;
            System.out.println(" Incorrect function specification");
            System.out.println(" Has two values for one point ");
            System.exit(1);
        }
        Object[] keys = setNonZeros.keySet().toArray();
        this.indexedValues = new int[keys.length];
        this.valuesI = new double[keys.length];
        for (int j = 0; j < keys.length; ++j) {
            this.indexedValues[j] = (Integer)keys[j];
            this.valuesI[j] = (Double)setNonZeros.get(keys[j]);
        }
        domain = e;
    }

    int indexOf(int x, int y) {
        IntPair iP = new IntPair(x, y);
        return this.instanceIndex.indexOf(iP);
    }

    IntPair getPair(int index) {
        return this.instanceIndex.get(index);
    }

    int getXInstance(int index) {
        IntPair iP = this.getPair(index);
        return iP.get(0);
    }

    int getYInstance(int index) {
        IntPair iP = this.getPair(index);
        return iP.get(1);
    }

    public Feature(Experiments e, double[][] vals, Index<IntPair> instanceIndex) {
        this.instanceIndex = instanceIndex;
        domain = e;
        int num = 0;
        for (int x = 0; x < e.xSize; ++x) {
            for (int y = 0; y < e.ySize; ++y) {
                if (vals[x][y] == 0.0) continue;
                ++num;
            }
        }
        this.indexedValues = new int[num];
        this.valuesI = new double[num];
        int current = 0;
        for (int x = 0; x < e.xSize; ++x) {
            for (int y = 0; y < e.ySize; ++y) {
                if (vals[x][y] == 0.0) continue;
                this.indexedValues[current] = this.indexOf(x, y);
                this.valuesI[current] = vals[x][y];
                ++current;
            }
        }
    }

    public Feature(Experiments e, int numElems, Index<IntPair> instanceIndex) {
        this.instanceIndex = instanceIndex;
        domain = e;
        this.indexedValues = new int[numElems];
        this.valuesI = new double[numElems];
    }

    public Feature(Experiments e, int[] indexes, double[] vals, Index<IntPair> instanceIndex) {
        domain = e;
        this.indexedValues = indexes;
        this.valuesI = vals;
        this.instanceIndex = instanceIndex;
    }

    public void print() {
        this.print(System.out);
    }

    public void setValue(int index, int key, double value) {
        this.indexedValues[index] = key;
        this.valuesI[index] = value;
    }

    public void print(PrintStream pf) {
        for (int i = 0; i < this.indexedValues.length; ++i) {
            IntPair iP = this.getPair(this.indexedValues[i]);
            int x = iP.get(0);
            int y = iP.get(1);
            pf.println(x + ", " + y + ' ' + this.valuesI[i]);
        }
    }

    public double getVal(int index) {
        return this.valuesI[index];
    }

    public void setSum() {
        for (int i = 0; i < this.valuesI.length; ++i) {
            this.sum += this.valuesI[i];
        }
    }

    public double sumValues() {
        return this.sum;
    }

    public void save(OutDataStreamFile oF) {
        throw new UnsupportedOperationException();
    }

    public void read(InDataStreamFile inf) {
        throw new UnsupportedOperationException();
    }

    public int len() {
        if (this.indexedValues != null) {
            return this.indexedValues.length;
        }
        return 0;
    }

    public boolean isEmpty() {
        return this.len() == 0;
    }

    public int getX(int index) {
        return this.getXInstance(this.indexedValues[index]);
    }

    public int getY(int index) {
        return this.getYInstance(this.indexedValues[index]);
    }

    public double getVal(int x, int y) {
        Double val = this.hashValues.get(this.indexOf(x, y));
        if (val == null) {
            return 0.0;
        }
        return val;
    }

    public void initHashVals() {
        this.hashValues = new HashMap();
        for (int i = 0; i < this.len(); ++i) {
            int x = this.getX(i);
            int y = this.getY(i);
            Double value = new Double(this.getVal(i));
            this.hashValues.put(this.indexOf(x, y), value);
        }
    }

    public double ftilde() {
        double s = 0.0;
        for (int i = 0; i < this.indexedValues.length; ++i) {
            int x = this.getXInstance(this.indexedValues[i]);
            int y = this.getYInstance(this.indexedValues[i]);
            s += domain.ptildeXY(x, y) * this.getVal(i);
        }
        return s;
    }
}

