/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.crf;

import edu.stanford.nlp.ie.crf.CliquePotentialFunction;
import edu.stanford.nlp.math.ArrayMath;
import edu.stanford.nlp.sequences.SeqClassifierFlags;

public class NonLinearCliquePotentialFunction
implements CliquePotentialFunction {
    double[][] linearWeights;
    double[][] inputLayerWeights;
    double[][] outputLayerWeights;
    SeqClassifierFlags flags;

    private static double sigmoid(double x) {
        return 1.0 / (1.0 + Math.exp(-x));
    }

    public NonLinearCliquePotentialFunction(double[][] linearWeights, double[][] inputLayerWeights, double[][] outputLayerWeights, SeqClassifierFlags flags) {
        this.linearWeights = linearWeights;
        this.inputLayerWeights = inputLayerWeights;
        this.outputLayerWeights = outputLayerWeights;
        this.flags = flags;
    }

    public static double[] hiddenLayerOutput(double[][] inputLayerWeights, int[] nodeCliqueFeatures, SeqClassifierFlags aFlag) {
        int layerOneSize = inputLayerWeights.length;
        double[] layerOne = new double[layerOneSize];
        for (int i = 0; i < layerOneSize; ++i) {
            double[] ws = inputLayerWeights[i];
            double lOneW = 0.0;
            for (int m = 0; m < nodeCliqueFeatures.length; ++m) {
                lOneW += ws[nodeCliqueFeatures[m]];
            }
            layerOne[i] = lOneW;
        }
        double[] hiddenLayer = new double[layerOneSize];
        for (int i = 0; i < layerOneSize; ++i) {
            if (aFlag.useHiddenLayer) {
                if (aFlag.useSigmoid) {
                    hiddenLayer[i] = NonLinearCliquePotentialFunction.sigmoid(layerOne[i]);
                    continue;
                }
                hiddenLayer[i] = Math.tanh(layerOne[i]);
                continue;
            }
            hiddenLayer[i] = layerOne[i];
        }
        return hiddenLayer;
    }

    @Override
    public double computeCliquePotential(int cliqueSize, int labelIndex, int[] cliqueFeatures) {
        double output = 0.0;
        if (cliqueSize > 1) {
            for (int m = 0; m < cliqueFeatures.length; ++m) {
                output += this.linearWeights[cliqueFeatures[m]][labelIndex];
            }
        } else {
            double[] hiddenLayer = NonLinearCliquePotentialFunction.hiddenLayerOutput(this.inputLayerWeights, cliqueFeatures, this.flags);
            int outputLayerSize = this.inputLayerWeights.length / this.outputLayerWeights[0].length;
            if (this.flags.useOutputLayer) {
                double[] outputWs = null;
                outputWs = this.flags.tieOutputLayer ? this.outputLayerWeights[0] : this.outputLayerWeights[labelIndex];
                if (this.flags.softmaxOutputLayer) {
                    outputWs = ArrayMath.softmax(outputWs);
                }
                for (int i = 0; i < this.inputLayerWeights.length; ++i) {
                    if (this.flags.sparseOutputLayer || this.flags.tieOutputLayer) {
                        if (i % outputLayerSize != labelIndex) continue;
                        output += outputWs[i / outputLayerSize] * hiddenLayer[i];
                        continue;
                    }
                    output += outputWs[i] * hiddenLayer[i];
                }
            } else {
                output = hiddenLayer[labelIndex];
            }
        }
        return output;
    }
}

