# vim:set filetype=perl:
# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl 06_buscrifel.t'

#########################

use Test::More tests => 37;
use Carp;

BEGIN { use_ok 'Lingua::Zompist::Barakhinei', 'buscrifel' }

sub form_ok ($$$) {
    # croak 'usage: form_ok($verb, $is, $should)' unless @_ >= 3;
    my($verb, $is, $should) = @_;

    is($is->[0], $should->[0], "I.sg. of $verb");
    is($is->[1], $should->[1], "II.sg. of $verb");
    is($is->[2], $should->[2], "III.sg. of $verb");
    is($is->[3], $should->[3], "I.pl. of $verb");
    is($is->[4], $should->[4], "II.pl. of $verb");
    is($is->[5], $should->[5], "III.pl. of $verb");
}

form_ok('elir',  buscrifel('elir',  1), [ qw( elirka  elirch elirch elirku  elirku  elirkn  ) ]);
form_ok('rikha',  buscrifel('rikha',  2), [ qw( rikhn  rikhn  rikhn  rikhna  rikhnu  rikhnn  ) ]);
form_ok('lel',   buscrifel('lel',   3), [ qw( leln   leln   leln   lelna   lelnu   lelnn   ) ]);
form_ok('bshti', buscrifel('bshti', 4), [ qw( bshtir bshtir bshtri bshtru bshtru bshtrn ) ]);
form_ok('hab',   buscrifel('hab',   5), [ qw( habir   habir   habri   habru   habru   habrn   ) ]);

#form_ok('groch', izhcrifel('groch', 1), [ qw( grochi groch grok   grog  grog  grochn ) ]);
#form_ok('foka',   izhcrifel('foka',   2), [ qw( fochi  fochi  fok   foku   fok   fochn  ) ]);
#form_ok('noch',  izhcrifel('noch',  3), [ qw( nochi  nochi  nog   nogu   nog   nochn  ) ]);
#form_ok('faichi', izhcrifel('faichi', 4), [ qw( faichi faich faok  faich faich faichn ) ]);
#form_ok('klach', izhcrifel('klach', 5), [ qw( klachi klach klach  klach klach klachn ) ]);

form_ok('eza',  buscrifel('eza'), [ qw( shka shk shk shka shku shkn ) ]);

#form_ok('epeza', izhcrifel('epeza'), [ qw( zi   zi   ep zu   z   zn   ) ]);
#form_ok('kedh', izhcrifel('kedh'), [ qw( kedhi kedhi ki kedhu kedh kedhn ) ]);

#form_ok('foli',    izhcrifel('foli'   ), [ qw( ful     ful   fut   folu    folu    foln    ) ]);
#form_ok('lhib',   izhcrifel('lhib'  ), [ qw( lhua    lh   lhu   lhubu   lhubu   ln      ) ]);
#form_ok('nh',     izhcrifel('nh'    ), [ qw( nhe     ni    ni    nheza   nhezu   nh      ) ]);
#form_ok('shkriv', izhcrifel('shkriv'), [ qw( shkriva shkri shkri shkrivu shkrivu shkrivn ) ]);
#form_ok('shtan',  izhcrifel('shtan' ), [ qw( sht    sht  sht  shtana  shtanu  shtn    ) ]);
#form_ok('fli',    izhcrifel('fli'   ), [ qw( fl     fl   fl   flu    flu    fln    ) ]);
#form_ok('hizi',    izhcrifel('hizi'   ), [ qw( huz     hu    hut   hizu    hizu    hizn    ) ]);
#form_ok('oi',      izhcrifel('oi'     ), [ qw( oh      fi    fit   ou      ou      on      ) ]);
