/*
 * Decompiled with CFR 0.152.
 */
package com.drew.lang;

import com.drew.lang.annotations.NotNull;
import java.io.IOException;

public final class BufferBoundsException
extends Exception {
    private static final long serialVersionUID = 2911102837808946396L;

    public BufferBoundsException(@NotNull byte[] buffer, int index, int bytesRequested) {
        super(BufferBoundsException.getMessage(buffer, index, bytesRequested));
    }

    public BufferBoundsException(String message) {
        super(message);
    }

    public BufferBoundsException(String message, IOException innerException) {
        super(message, innerException);
    }

    private static String getMessage(@NotNull byte[] buffer, int index, int bytesRequested) {
        if (index < 0) {
            return String.format("Attempt to read from buffer using a negative index (%s)", index);
        }
        return String.format("Attempt to read %d byte%s from beyond end of buffer (requested index: %d, max index: %d)", bytesRequested, bytesRequested == 1 ? "" : "s", index, buffer.length - 1);
    }
}

