package Net::Amazon::EMR::Configuration;
use Moose;
with 'Net::Amazon::EMR::Role::AttrHash';
use Net::Amazon::EMR::Coercions;

has 'Classification' => ( is => 'ro', 
                          isa => 'Str' );

has 'Configurations' => ( is => 'ro',
                          isa => 'Net::Amazon::EMR::Type::ArrayRefofConfiguration',
                          coerce => 1,
);

has 'Properties' => ( is => 'ro', 
                      isa => 'HashRef' );

__PACKAGE__->meta->make_immutable();

1;

__END__

=head1 NAME

Net::Amazon::EMR::Configuration

=head1 DESCRIPTION

Implements the Configuration data type described at L<http://docs.amazonwebservices.com/ElasticMapReduce/latest/APIReference/API_Configuration.html>.

=head1 AUTHOR

Jon Schutz 

L<http://notes.jschutz.net>

=head1 DOCUMENTATION, LICENSE AND COPYRIGHT

See L<Net::Amazon::EMR>.

=cut
