# Generated by default/object.tt
package Paws::Kendra::ConfluenceSpaceConfiguration;
  use Moose;
  has CrawlArchivedSpaces => (is => 'ro', isa => 'Bool');
  has CrawlPersonalSpaces => (is => 'ro', isa => 'Bool');
  has ExcludeSpaces => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has IncludeSpaces => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has SpaceFieldMappings => (is => 'ro', isa => 'ArrayRef[Paws::Kendra::ConfluenceSpaceToIndexFieldMapping]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Kendra::ConfluenceSpaceConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Kendra::ConfluenceSpaceConfiguration object:

  $service_obj->Method(Att1 => { CrawlArchivedSpaces => $value, ..., SpaceFieldMappings => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Kendra::ConfluenceSpaceConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->CrawlArchivedSpaces

=head1 DESCRIPTION

Specifies the configuration for indexing Confluence spaces.

=head1 ATTRIBUTES


=head2 CrawlArchivedSpaces => Bool

Specifies whether Amazon Kendra should index archived spaces.


=head2 CrawlPersonalSpaces => Bool

Specifies whether Amazon Kendra should index personal spaces. Users can
add restrictions to items in personal spaces. If personal spaces are
indexed, queries without user context information may return restricted
items from a personal space in their results. For more information, see
Filtering on user context
(https://docs.aws.amazon.com/kendra/latest/dg/user-context-filter.html).


=head2 ExcludeSpaces => ArrayRef[Str|Undef]

A list of space keys of Confluence spaces. If you include a key, the
blogs, documents, and attachments in the space are not indexed. If a
space is in both the C<ExcludeSpaces> and the C<IncludeSpaces> list,
the space is excluded.


=head2 IncludeSpaces => ArrayRef[Str|Undef]

A list of space keys for Confluence spaces. If you include a key, the
blogs, documents, and attachments in the space are indexed. Spaces that
aren't in the list aren't indexed. A space in the list must exist.
Otherwise, Amazon Kendra logs an error when the data source is
synchronized. If a space is in both the C<IncludeSpaces> and the
C<ExcludeSpaces> list, the space is excluded.


=head2 SpaceFieldMappings => ArrayRef[L<Paws::Kendra::ConfluenceSpaceToIndexFieldMapping>]

Defines how space metadata fields should be mapped to index fields.
Before you can map a field, you must first create an index field with a
matching type using the console or the C<UpdateIndex> operation.

If you specify the C<SpaceFieldMappings> parameter, you must specify at
least one field mapping.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Kendra>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

