# Generated by default/object.tt
package Paws::Batch::LogConfiguration;
  use Moose;
  has LogDriver => (is => 'ro', isa => 'Str', request_name => 'logDriver', traits => ['NameInRequest'], required => 1);
  has Options => (is => 'ro', isa => 'Paws::Batch::LogConfigurationOptionsMap', request_name => 'options', traits => ['NameInRequest']);
  has SecretOptions => (is => 'ro', isa => 'ArrayRef[Paws::Batch::Secret]', request_name => 'secretOptions', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Batch::LogConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Batch::LogConfiguration object:

  $service_obj->Method(Att1 => { LogDriver => $value, ..., SecretOptions => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Batch::LogConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->LogDriver

=head1 DESCRIPTION

Log configuration options to send to a custom log driver for the
container.

=head1 ATTRIBUTES


=head2 B<REQUIRED> LogDriver => Str

The log driver to use for the container. The valid values listed for
this parameter are log drivers that the Amazon ECS container agent can
communicate with by default.

The supported log drivers are C<awslogs>, C<fluentd>, C<gelf>,
C<json-file>, C<journald>, C<logentries>, C<syslog>, and C<splunk>.

Jobs running on Fargate resources are restricted to the C<awslogs> and
C<splunk> log drivers.

=over

=item awslogs

Specifies the Amazon CloudWatch Logs logging driver. For more
information, see Using the awslogs Log Driver
(https://docs.aws.amazon.com/batch/latest/userguide/using_awslogs.html)
in the I<AWS Batch User Guide> and Amazon CloudWatch Logs logging
driver (https://docs.docker.com/config/containers/logging/awslogs/) in
the Docker documentation.

=item fluentd

Specifies the Fluentd logging driver. For more information, including
usage and options, see Fluentd logging driver
(https://docs.docker.com/config/containers/logging/fluentd/) in the
Docker documentation.

=item gelf

Specifies the Graylog Extended Format (GELF) logging driver. For more
information, including usage and options, see Graylog Extended Format
logging driver
(https://docs.docker.com/config/containers/logging/gelf/) in the Docker
documentation.

=item journald

Specifies the journald logging driver. For more information, including
usage and options, see Journald logging driver
(https://docs.docker.com/config/containers/logging/journald/) in the
Docker documentation.

=item json-file

Specifies the JSON file logging driver. For more information, including
usage and options, see JSON File logging driver
(https://docs.docker.com/config/containers/logging/json-file/) in the
Docker documentation.

=item splunk

Specifies the Splunk logging driver. For more information, including
usage and options, see Splunk logging driver
(https://docs.docker.com/config/containers/logging/splunk/) in the
Docker documentation.

=item syslog

Specifies the syslog logging driver. For more information, including
usage and options, see Syslog logging driver
(https://docs.docker.com/config/containers/logging/syslog/) in the
Docker documentation.

=back

If you have a custom driver that's not listed earlier that you want to
work with the Amazon ECS container agent, you can fork the Amazon ECS
container agent project that's available on GitHub
(https://github.com/aws/amazon-ecs-agent) and customize it to work with
that driver. We encourage you to submit pull requests for changes that
you want to have included. However, Amazon Web Services doesn't
currently support running modified copies of this software.

This parameter requires version 1.18 of the Docker Remote API or
greater on your container instance. To check the Docker Remote API
version on your container instance, log into your container instance
and run the following command: C<sudo docker version | grep "Server API
version">


=head2 Options => L<Paws::Batch::LogConfigurationOptionsMap>

The configuration options to send to the log driver. This parameter
requires version 1.19 of the Docker Remote API or greater on your
container instance. To check the Docker Remote API version on your
container instance, log into your container instance and run the
following command: C<sudo docker version | grep "Server API version">


=head2 SecretOptions => ArrayRef[L<Paws::Batch::Secret>]

The secrets to pass to the log configuration. For more information, see
Specifying Sensitive Data
(https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html)
in the I<AWS Batch User Guide>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Batch>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

