### an aggregatee class for selecting with a rectangle

use parent 'MatrixBitmapAreaSelectorAgg';

use 'GFX-Tools-Buffer::matrix';

sub new {
    my ($class, $x, $y, $width, $height) = @_;

    ### xy offsets are set in the 'selectArea' method
    $self = { x => $x, y => $y, width => $width, height => $height,
	      areas => undef, };

    bless $self, $class;

};

sub selectArea {
  my ($self, $xoffset, $yoffset, $width, $height, $bitmapmatrixobj, $matrixareaobj) = @_;

  my $self->{x} = $xoffset;
  my $self->{y} = $yoffset;
  my $self->{width} = $width;
  my $self->{height} = $height;
  
  my $matrix = $bitmapmatrixobj->getMatrix;
  my $resultmatrix = matrix->new($self->{height}, $self->{width});

  for (my $j = $self->{y}; $j < $self->{y} + $self->{height}; $j++) {
    for (my $i = $self->{x}; $i < $self->{x} + $self->{width}; $i++) {
      $resultmatrix->setAtIndex($j - $self->{height}, $i - $self->{width}, $matrix->indexOf($j, $i));
    }
  }
    
  my $resultobj = MatrixBitmap->new;
  $resultobj->setMatrix($resultmatrix);

  return $resultobj;
}

1;
