use strict;
use warnings;

package Task::BeLike::FLORA;
BEGIN {
  $Task::BeLike::FLORA::AUTHORITY = 'cpan:FLORA';
}
BEGIN {
  $Task::BeLike::FLORA::VERSION = '0.06';
}
# ABSTRACT: Modules FLORA uses


1;

__END__
=pod

=head1 NAME

Task::BeLike::FLORA - Modules FLORA uses

=head1 VERSION

version 0.06

=head1 TASK CONTENTS

=head2 Applications

=head3 L<App::Ack>

=head3 L<App::Metabase::Relayd>

=head3 L<App::Nopaste>

=head3 L<App::Software::License>

=head3 L<App::cpanminus>

=head3 L<App::cpanoutdated>

=head3 L<CPAN::Mini>

=head3 L<CPAN::Mini::Devel>

=head3 L<CPAN::Uploader>

=head2 Optional Dependencies Of Other Modules

=head3 L<CPAN::Reporter>

=head3 L<PadWalker>

=head3 L<Task::SDK::Moose>

=head3 L<Term::ReadLine::Gnu>

=head3 L<Test::Reporter>

=head3 L<Test::Reporter::Transport::Socket>

=head2 Development Tools

=head3 L<Acme::MetaSyntactic>

=head3 L<Carp::Always>

=head3 L<Carp::Always::Color>

=head3 L<Carp::REPL>

=head3 L<Devel::bt>

=head3 L<Devel::Cover>

=head3 L<Devel::NYTProf>

=head3 L<Dist::Zilla>

=head3 L<Dist::Zilla::PluginBundle::FLORA>

=head3 L<Gitalist>

=head3 L<Module::CPANTS::Analyse>

=head3 L<Module::Install> 0.95

=head3 L<Module::Install::AuthorRequires>

=head3 L<Module::Install::AuthorTests>

=head3 L<Module::Install::CheckConflicts>

=head3 L<Module::Install::ExtraTests>

=head3 L<Perl::Tidy>

=head3 L<Perl::Version> 1.010

=head3 L<Pod::Coverage::TrustPod>

=head3 L<Test::Aggregate>

=head3 L<Test::Pod>

=head3 L<Test::Pod::Coverage>

=head3 L<Test::Without::Module>

=head3 L<V>

=head2 Modules I use a lot

=head3 L<Catalyst::Model::KiokuDB>

=head3 L<Data::Visitor>

=head3 L<Email::MIME::Kit>

=head3 L<Email::MIME::Kit::Assembler::Markdown>

=head3 L<Email::MIME::Kit::Renderer::TT>

=head3 L<Email::Sender>

=head3 L<Function::Parameters>

=head3 L<JSON>

=head3 L<List::AllUtils>

=head3 L<Method::Signatures::Simple>

=head3 L<Moose>

=head3 L<Moose::Autobox>

=head3 L<MooseX::Declare>

=head3 L<MooseX::LazyRequire>

=head3 L<MooseX::Types::Common>

=head3 L<MooseX::Types::DateTime>

=head3 L<MooseX::Types::Email>

=head3 L<MooseX::Types::LoadableClass>

=head3 L<MooseX::Types::Path::Class>

=head3 L<MooseX::Types::URI>

=head3 L<Task::Catalyst>

=head3 L<Task::KiokuDB>

=head3 L<Task::Plack>

=head3 L<Test::WWW::Mechanize::Catalyst>

=head1 AUTHOR

Florian Ragwitz <rafl@debian.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2010 by Florian Ragwitz.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

