package Net::Amazon::EMR::Application;
use Moose;
with 'Net::Amazon::EMR::Role::AttrHash';
use Net::Amazon::EMR::Coercions;

has 'AdditionalInfo' => ( is => 'ro', 
                          isa => 'HashRef' );

has 'Args' => ( is => 'ro',
                isa => 'Net::Amazon::EMR::Type::ArrayRefofUnconstrainedStr',
                coerce => 1,
);

has 'Name' => ( is => 'ro', 
                isa => 'Str' );

has 'Version' => ( is => 'ro', 
                   isa => 'Str' );


__PACKAGE__->meta->make_immutable();

1;

__END__

=head1 NAME

Net::Amazon::EMR::Application

=head1 DESCRIPTION

Implements the Application data type described at L<http://docs.amazonwebservices.com/ElasticMapReduce/latest/APIReference/API_Application.html>.

=head1 AUTHOR

Jon Schutz 

L<http://notes.jschutz.net>

=head1 DOCUMENTATION, LICENSE AND COPYRIGHT

See L<Net::Amazon::EMR>.

=cut
