package Bencher::Scenario::Interpreters::Startup;

use strict;
use warnings;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2023-12-06'; # DATE
our $DIST = 'Bencher-Scenario-Interpreters-Startup'; # DIST
our $VERSION = '0.040'; # VERSION

our $scenario = {
    summary => 'Benchmark startup time of various interpreters',
    participants => [
        {name=>'perl (-e)'  , cmdline=>[qw/perl -e1/]},
        {name=>'perl (-E)'  , cmdline=>[qw/perl -E1/]},
        {name=>'bash'       , cmdline=>[qw/bash --norc -c true/]},
        {name=>'ruby'       , cmdline=>[qw/ruby -e1/]},
        {name=>'python'         , cmdline=>[qw/python -c1/]},
        {name=>'python -S'      , cmdline=>[qw/python -S -c1/]},
        {name=>'python -S+exit' , cmdline=>['python', '-S', '-c', 'from os import _exit; _exit(0)']},
        {name=>'python3'        , cmdline=>[qw/python3 -c1/]},
        {name=>'python3 -S'     , cmdline=>[qw/python3 -S -c1/]},
        {name=>'python3 -S+exit', cmdline=>['python3', '-S', '-c', 'from os import _exit; _exit(0)']},
        {name=>'nodejs'     , cmdline=>[qw/nodejs -e 1/]},
    ],
    on_failure => 'skip',
};

1;
# ABSTRACT: Benchmark startup time of various interpreters

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::Interpreters::Startup - Benchmark startup time of various interpreters

=head1 VERSION

This document describes version 0.040 of Bencher::Scenario::Interpreters::Startup (from Perl distribution Bencher-Scenario-Interpreters-Startup), released on 2023-12-06.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m Interpreters::Startup

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 BENCHMARK PARTICIPANTS

=over

=item * perl (-e) (command)

Command line:

 perl -e1



=item * perl (-E) (command)

Command line:

 perl -E1



=item * bash (command)

Command line:

 bash --norc -c true



=item * ruby (command)

Command line:

 ruby -e1



=item * python (command)

Command line:

 python -c1



=item * python -S (command)

Command line:

 python -S -c1



=item * python -S+exit (command)

Command line:

 python -S -c from os import _exit; _exit(0)



=item * python3 (command)

Command line:

 python3 -c1



=item * python3 -S (command)

Command line:

 python3 -S -c1



=item * python3 -S+exit (command)

Command line:

 python3 -S -c from os import _exit; _exit(0)



=item * nodejs (command)

Command line:

 nodejs -e 1



=back

=head1 BENCHMARK SAMPLE RESULTS

=head2 Sample benchmark #1

Run on: perl: I<< v5.38.2 >>, CPU: I<< Intel(R) Core(TM) i5-7200U CPU @ 2.50GHz (2 cores) >>, OS: I<< GNU/Linux Ubuntu version 20.04 >>, OS kernel: I<< Linux version 5.4.0-164-generic >>.

Benchmark command (default options):

 % bencher -m Interpreters::Startup

Result formatted as table:

 #table1#
 +-----------------+-----------+-----------+-----------------------+-----------------------+-----------+---------+
 | participant     | rate (/s) | time (ms) | pct_faster_vs_slowest | pct_slower_vs_fastest |  errors   | samples |
 +-----------------+-----------+-----------+-----------------------+-----------------------+-----------+---------+
 | nodejs          |      2.43 |    411    |                 0.00% |              7668.02% |   0.00013 |      20 |
 | ruby            |     17.6  |     56.8  |               624.78% |               971.78% | 1.4e-05   |      22 |
 | python          |     43.5  |     23    |              1691.48% |               333.61% |   1e-05   |      20 |
 | python3         |     43.6  |     22.9  |              1693.83% |               333.04% |   1e-05   |      20 |
 | python -S+exit  |     71.8  |     13.9  |              2855.98% |               162.79% | 6.6e-06   |      20 |
 | python3 -S+exit |     72    |     13.9  |              2864.00% |               162.08% | 3.9e-06   |      20 |
 | python -S       |     79.3  |     12.6  |              3163.78% |               138.01% | 6.6e-06   |      20 |
 | python3 -S      |     79.7  |     12.6  |              3177.66% |               137.00% | 6.1e-06   |      20 |
 | perl (-E)       |    148    |      6.76 |              5983.30% |                27.69% | 4.4e-06   |      20 |
 | perl (-e)       |    175    |      5.71 |              7110.63% |                 7.73% |   3e-06   |      20 |
 | bash            |    189    |      5.3  |              7668.02% |                 0.00% | 2.3e-06   |      22 |
 +-----------------+-----------+-----------+-----------------------+-----------------------+-----------+---------+


The above result formatted in L<Benchmark.pm|Benchmark> style:

                     Rate  nodejs  ruby  python  python3  python -S+exit  python3 -S+exit  python -S  python3 -S  perl (-E)  perl (-e)  bash 
  nodejs           2.43/s      --  -86%    -94%     -94%            -96%             -96%       -96%        -96%       -98%       -98%  -98% 
  ruby             17.6/s    623%    --    -59%     -59%            -75%             -75%       -77%        -77%       -88%       -89%  -90% 
  python           43.5/s   1686%  146%      --       0%            -39%             -39%       -45%        -45%       -70%       -75%  -76% 
  python3          43.6/s   1694%  148%      0%       --            -39%             -39%       -44%        -44%       -70%       -75%  -76% 
  python -S+exit   71.8/s   2856%  308%     65%      64%              --               0%        -9%         -9%       -51%       -58%  -61% 
  python3 -S+exit    72/s   2856%  308%     65%      64%              0%               --        -9%         -9%       -51%       -58%  -61% 
  python -S        79.3/s   3161%  350%     82%      81%             10%              10%         --          0%       -46%       -54%  -57% 
  python3 -S       79.7/s   3161%  350%     82%      81%             10%              10%         0%          --       -46%       -54%  -57% 
  perl (-E)         148/s   5979%  740%    240%     238%            105%             105%        86%         86%         --       -15%  -21% 
  perl (-e)         175/s   7097%  894%    302%     301%            143%             143%       120%        120%        18%         --   -7% 
  bash              189/s   7654%  971%    333%     332%            162%             162%       137%        137%        27%         7%    -- 
 
 Legends:
   bash: participant=bash
   nodejs: participant=nodejs
   perl (-E): participant=perl (-E)
   perl (-e): participant=perl (-e)
   python: participant=python
   python -S: participant=python -S
   python -S+exit: participant=python -S+exit
   python3: participant=python3
   python3 -S: participant=python3 -S
   python3 -S+exit: participant=python3 -S+exit
   ruby: participant=ruby

To display as an interactive HTML table on a browser, you can add option C<--format html+datatables>.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-Interpreters-Startup>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-Interpreters-Startup>.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2023, 2016, 2015 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-Interpreters-Startup>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
